/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.recognitionnew.task.SnapshotService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.file.model.FileConvertResult;
import kd.imc.rim.file.service.PdfHandleService;
import kd.imc.rim.file.service.einvoicepdf.FullDigitalEInvoicePdfService;
import kd.imc.rim.file.service.einvoicepdf.dto.FullDigitalEInvoice;
import kd.imc.rim.file.service.einvoicepdf.dto.FullDigitalEInvoiceItem;
import kd.imc.rim.file.service.generate.FullDigitalEInvoiceTrainAndAirPdfService;
import kd.imc.rim.file.service.generate.model.FullDigitalEInvoiceAir;
import kd.imc.rim.file.service.generate.model.FullDigitalEInvoiceTrain;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.lang3.StringUtils;

public class FileGenerateTask
implements Callable<JSONObject> {
    private static final Log logger = LogFactory.getLog(FileGenerateTask.class);
    private String serialNo;
    private JSONObject invoiceJson;
    private RequestContext ctx;

    public FileGenerateTask(RequestContext ctx, String serialNo, JSONObject invoiceJson) {
        this.serialNo = serialNo;
        this.invoiceJson = invoiceJson;
        this.ctx = ctx;
    }

    @Override
    public JSONObject call() {
        DynamicObject fileIdDynamicObject;
        JSONObject result;
        block17: {
            boolean issync;
            RequestContext.copyAndSet((RequestContext)this.ctx);
            logger.info("FileGenerateTask coming:{}", (Object)this.serialNo);
            result = ResultContant.createSuccessJSONObject();
            String tenantNo = TenantUtils.getTenantNo();
            if (StringUtils.isEmpty((CharSequence)this.serialNo)) {
                logger.info("FileGenerateTask serialNo is empty:{}", (Object)this.serialNo);
                return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), "FileGenerateTask serialNo is empty");
            }
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)this.serialNo);
            fileIdDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id,original_state,pdf_url,image_url,snapshot_url,tax_pdf_url,tax_ofd_url,tax_xml_url", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
            String snapshotUrl = this.invoiceJson.getString("snapshotUrl");
            if (fileIdDynamicObject == null) {
                fileIdDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
                fileIdDynamicObject.set("tenant_no", (Object)tenantNo);
                fileIdDynamicObject.set("serial_no", (Object)this.serialNo);
                fileIdDynamicObject.set("create_time", (Object)new Date());
                fileIdDynamicObject.set("update_time", (Object)new Date());
            } else {
                if (StringUtils.isEmpty((CharSequence)(fileIdDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fileIdDynamicObject.get("id"), (String)"rim_invoice_file")).getString("pdf_url"))) {
                    fileIdDynamicObject.set("pdf_url", (Object)fileIdDynamicObject.getString("tax_pdf_url"));
                }
                if (StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("ofd_url"))) {
                    fileIdDynamicObject.set("ofd_url", (Object)fileIdDynamicObject.getString("tax_ofd_url"));
                }
                if (StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("xml_url"))) {
                    fileIdDynamicObject.set("xml_url", (Object)fileIdDynamicObject.getString("tax_xml_url"));
                }
            }
            boolean bl = issync = StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("snapshot_url")) || StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("pdf_url"));
            if (!issync) {
                CacheHelper.put("FileCache:" + this.serialNo, JSON.toJSONString(DynamicObjectUtil.dynamicObject2Map(fileIdDynamicObject)), 300);
            }
            String cacheFileType = CacheHelper.get("FileType" + this.serialNo);
            String invoiceTypeStr = this.invoiceJson.getString("invoiceType");
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceTypeStr);
            InvoiceConvertService convertService = InvoiceConvertService.newInstance(invoiceType, null);
            if ("1".equals(cacheFileType)) {
                JSONObject data = new JSONObject();
                Map<String, Object> fileMap = DynamicObjectUtil.dynamicObjectToMap(fileIdDynamicObject);
                convertService.setFileField(data, fileMap);
                return ResultContant.createJSONObject(ErrorType.SUCCESS.getCode(), ResManager.loadKDString((String)"\u6587\u4ef6\u8868\u5df2\u7ecf\u662f\u6e90\u6587\u4ef6", (String)"FileGenerateTask_0", (String)"imc-rim-common", (Object[])new Object[0]), data);
            }
            String fileOriginalState = StringUtils.isEmpty((CharSequence)this.invoiceJson.getString("originalState")) ? "0" : this.invoiceJson.getString("originalState");
            CacheHelper.put("FileType" + this.serialNo, fileOriginalState, 20);
            String fileSnapshotUrl = fileIdDynamicObject.getString("snapshot_url");
            if (StringUtils.isEmpty((CharSequence)snapshotUrl)) {
                if (!StringUtils.isEmpty((CharSequence)fileSnapshotUrl)) {
                    Map<String, Object> fileMap = DynamicObjectUtil.dynamicObjectToMap(fileIdDynamicObject);
                    JSONObject data = new JSONObject();
                    convertService.setFileField(data, fileMap);
                    return ResultContant.createJSONObject(ErrorType.SUCCESS.getCode(), ResManager.loadKDString((String)"\u6587\u4ef6\u8868\u5df2\u7ecf\u5b58\u5728\u5feb\u7167", (String)"FileGenerateTask_1", (String)"imc-rim-common", (Object[])new Object[0]), data);
                }
                try {
                    String pdfUrl = fileIdDynamicObject.getString("pdf_url");
                    String ofdUrl = fileIdDynamicObject.getString("ofd_url");
                    if (!StringUtils.isEmpty((CharSequence)pdfUrl) || !StringUtils.isEmpty((CharSequence)ofdUrl)) {
                        String imageUrl = FileUploadUtils.getInvoiceDir("invoice") + "/" + fileIdDynamicObject.getString("serial_no") + "_snap.jpg";
                        String newPdfUrl = FileUploadUtils.getInvoiceDir("invoice") + "/" + fileIdDynamicObject.getString("serial_no") + "_gen.pdf";
                        SnapshotService service = new SnapshotService();
                        JSONObject createresult = null;
                        JSONObject data = new JSONObject();
                        if (!StringUtils.isEmpty((CharSequence)pdfUrl)) {
                            byte[] fileContent = FileUtils.getAttachmentByte(pdfUrl);
                            createresult = service.createSnapshot(fileContent, "pdf", newPdfUrl, imageUrl);
                            imageUrl = createresult.getString("snapshotUrl");
                            data.put("localUrl", (Object)pdfUrl);
                            data.put("pdfUrl", (Object)pdfUrl);
                            data.put("kdcloudUrl", (Object)pdfUrl);
                            data.put("downloadUrl", (Object)pdfUrl);
                            data.put("fileType", (Object)"1");
                            fileIdDynamicObject.set("original_type", (Object)"1");
                        } else {
                            byte[] fileContent = FileUtils.getAttachmentByte(ofdUrl);
                            createresult = service.createSnapshot(fileContent, "ofd", newPdfUrl, imageUrl);
                            imageUrl = createresult.getString("snapshotUrl");
                            pdfUrl = createresult.getString("pdfUrl");
                            data.put("localUrl", (Object)pdfUrl);
                            data.put("pdfUrl", (Object)pdfUrl);
                            data.put("kdcloudUrl", (Object)pdfUrl);
                            data.put("downloadUrl", (Object)pdfUrl);
                            data.put("fileType", (Object)"1");
                        }
                        if (StringUtils.isNotEmpty((CharSequence)ofdUrl)) {
                            fileIdDynamicObject.set("original_type", (Object)"4");
                        }
                        data.put("snapshotUrl", (Object)imageUrl);
                        this.invoiceJson.put("imageUrl", (Object)imageUrl);
                        this.invoiceJson.put("ofdUrl", (Object)ofdUrl);
                        this.invoiceJson.put("pdfUrl", (Object)pdfUrl);
                        this.invoiceJson.put("snapshotUrl", (Object)imageUrl);
                        fileIdDynamicObject.set("pdf_url", (Object)pdfUrl);
                        fileIdDynamicObject.set("image_url", (Object)imageUrl);
                        fileIdDynamicObject.set("snapshot_url", (Object)imageUrl);
                        fileIdDynamicObject.set("original_state", (Object)"Y");
                        result.put("data", (Object)data);
                        break block17;
                    }
                    FileConvertResult fileConvertResult = this.generatePdf(tenantNo, this.serialNo, invoiceType);
                    if (fileConvertResult != null) {
                        logger.info("\u751f\u6210\u5e95\u8d26\u6570\u636e{},{},{}", new Object[]{this.serialNo, fileConvertResult.getPdfUrl(), fileConvertResult.getImageUrl()});
                        this.invoiceJson.put("imageUrl", (Object)fileConvertResult.getImageUrl());
                        this.invoiceJson.put("ofdUrl", (Object)fileConvertResult.getOfdUrl());
                        this.invoiceJson.put("pdfUrl", (Object)fileConvertResult.getPdfUrl());
                        this.invoiceJson.put("snapshotUrl", (Object)fileConvertResult.getSnapshotUrl());
                        this.invoiceJson.put("localUrl", (Object)fileConvertResult.getPdfUrl());
                        this.invoiceJson.put("kdcloudUrl", (Object)fileConvertResult.getPdfUrl());
                        this.invoiceJson.put("downloadUrl", (Object)fileConvertResult.getPdfUrl());
                        this.invoiceJson.put("originalState", (Object)"2");
                        fileIdDynamicObject.set("original_type", (Object)"1");
                        fileIdDynamicObject.set("pdf_url", (Object)fileConvertResult.getPdfUrl());
                        fileIdDynamicObject.set("image_url", (Object)fileConvertResult.getImageUrl());
                        fileIdDynamicObject.set("snapshot_url", (Object)fileConvertResult.getSnapshotUrl());
                        fileIdDynamicObject.set("original_state", (Object)"2");
                        JSONObject data = new JSONObject();
                        data.put("snapshotUrl", (Object)fileConvertResult.getSnapshotUrl());
                        data.put("localUrl", (Object)fileConvertResult.getPdfUrl());
                        data.put("pdfUrl", (Object)fileConvertResult.getPdfUrl());
                        data.put("kdcloudUrl", (Object)fileConvertResult.getPdfUrl());
                        data.put("downloadUrl", (Object)fileConvertResult.getPdfUrl());
                        data.put("fileType", (Object)"1");
                        result.put("data", (Object)data);
                        break block17;
                    }
                    logger.info("FileGenerateTask fileConvertResult is null:{}", (Object)this.serialNo);
                    return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u751f\u6210\u5e95\u8d26\u6570\u636e\u4e3a\u7a7a", (String)"FileGenerateTask_2", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    logger.error("\u751f\u6210\u5e95\u8d26\u6570\u636e\u5931\u8d25{}", (Object)this.serialNo, (Object)e);
                    logger.info("FileGenerateTask fileConvertResult is fail:{}", (Object)this.serialNo);
                    return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u751f\u6210\u5e95\u8d26\u6570\u636e\u5931\u8d25", (String)"FileGenerateTask_3", (String)"imc-rim-common", (Object[])new Object[0]));
                }
            }
        }
        logger.info("\u4fdd\u5b58\u5e95\u8d26\u56fe\u7247\uff1a{},{},{},{}", new Object[]{this.serialNo, fileIdDynamicObject.getString("snapshot_url"), fileIdDynamicObject.getString("image_url"), fileIdDynamicObject.getString("pdf_url")});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileIdDynamicObject});
        CacheHelper.remove("FileCache:" + this.serialNo);
        CacheHelper.remove("FileType" + this.serialNo);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileConvertResult generatePdf(String tenantId, String serialNo, Long invoiceType) {
        if (InputInvoiceTypeEnum.canGeneratePdf(invoiceType).booleanValue()) {
            try (DLock lock = DLock.create((String)("generatePdfLock" + serialNo), (String)"generatePdfLock");){
                if (lock.tryLock()) {
                    Date date;
                    String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
                    String tenantNo = TenantUtils.getTenantNo();
                    DynamicObject[] detail = InvoiceQueryService.loadBySerialNo(entity, tenantNo, new String[]{serialNo});
                    JSONObject result = null;
                    if (detail != null && detail.length > 0) {
                        Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(detail[0]);
                        InvoiceConvertService convertService = InvoiceConvertService.newInstance(invoiceType);
                        result = convertService.convert(mainMap);
                    } else {
                        logger.info("FileGenerateTask detail length is null or 0:{},{}", (Object)serialNo, (Object)detail);
                        String checkStatus = this.invoiceJson.getString("checkStatus");
                        if ("1".equals(checkStatus)) {
                            Object invoiceDate = this.invoiceJson.get((Object)"invoiceDate");
                            if (invoiceDate instanceof Long) {
                                date = new Date((Long)invoiceDate);
                                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                                String dateString = formatter.format(date);
                                this.invoiceJson.put("invoiceDate", (Object)dateString);
                            }
                            result = this.invoiceJson;
                        }
                    }
                    if (result != null) {
                        FileConvertResult fileConvertResult;
                        PdfHandleService pdfService = new PdfHandleService();
                        JSONArray items = result.getJSONArray("items");
                        if (!(items != null && items.size() != 0 || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType))) {
                            logger.info("\u53d1\u7968\u6570\u636e\u65e0\u660e\u7ec6\uff0c\u4e0d\u751f\u6210\u5e95\u8d26\u6570\u636e:{},{}", (Object)serialNo);
                            date = null;
                            return date;
                        }
                        if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                            date = this.generateEInvoice(result);
                            return date;
                        }
                        if (!InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
                            byte[] pdfByte = pdfService.generate(result);
                            FileConvertResult pdf = FileConvertUtils.convert((byte[])pdfByte, (String)"pdf");
                            logger.info("FileGenerateTask generatePdf is coming:{},{}", (Object)invoiceType, (Object)pdf);
                            fileConvertResult = pdf;
                            return fileConvertResult;
                        }
                        FullDigitalEInvoiceTrainAndAirPdfService service = new FullDigitalEInvoiceTrainAndAirPdfService();
                        result.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType(invoiceType));
                        byte[] elcPdfByte = InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) ? service.createElcAir((FullDigitalEInvoiceAir)JSON.parseObject((String)result.toJSONString(), FullDigitalEInvoiceAir.class)) : service.createElcTrain((FullDigitalEInvoiceTrain)JSON.parseObject((String)result.toJSONString(), FullDigitalEInvoiceTrain.class));
                        fileConvertResult = FileConvertUtils.convert((byte[])elcPdfByte, (String)"pdf");
                        return fileConvertResult;
                    }
                }
            }
            catch (Exception e) {
                logger.info("FileGenerateTask generatePdf is null:{}", (Object)e);
            }
        }
        logger.info("FileGenerateTask generatePdf is null:{}", (Object)invoiceType);
        return null;
    }

    private FileConvertResult generateEInvoice(JSONObject result) {
        FullDigitalEInvoice fullDigitalEInvoice = new FullDigitalEInvoice();
        fullDigitalEInvoice.setInput(true);
        fullDigitalEInvoice.setInvoiceNo(result.getString("invoiceNo"));
        fullDigitalEInvoice.setIssueTime(result.getDate("invoiceDate"));
        fullDigitalEInvoice.setInvoiceType(result.getString("invoiceType"));
        fullDigitalEInvoice.setBuyerName(result.getString("buyerName"));
        fullDigitalEInvoice.setBuyerTaxNo(result.getString("buyerTaxNo"));
        fullDigitalEInvoice.setSalerName(result.getString("salerName"));
        fullDigitalEInvoice.setSalerTaxNo(result.getString("salerTaxNo"));
        fullDigitalEInvoice.setInvoiceAmount(BigDecimalUtil.transDecimal(result.getString("invoiceAmount")));
        fullDigitalEInvoice.setTotalAmount(BigDecimalUtil.transDecimal(result.getString("totalAmount")));
        fullDigitalEInvoice.setTotalTaxAmount(BigDecimalUtil.transDecimal(result.getString("totalTaxAmount")));
        fullDigitalEInvoice.setDrawer(result.getString("drawer"));
        fullDigitalEInvoice.setRemark(result.getString("remark"));
        fullDigitalEInvoice.setSpecialType(result.getString("specialType"));
        JSONArray items = result.getJSONArray("items");
        if (items != null) {
            List fullDigitalEInvoiceItem = JSONObject.parseArray((String)JSON.toJSONString((Object)items), FullDigitalEInvoiceItem.class);
            fullDigitalEInvoice.setItemList(fullDigitalEInvoiceItem);
        }
        FullDigitalEInvoicePdfService service = new FullDigitalEInvoicePdfService();
        try {
            byte[] pdfByte = service.createPdf(fullDigitalEInvoice);
            FileConvertResult pdf = FileConvertUtils.convert((byte[])pdfByte, (String)"pdf");
            logger.info("FileGenerateTask generateEInvoice {}", (Object)pdf);
            return pdf;
        }
        catch (Exception e) {
            logger.info("FileGenerateTask error:{}", (Object)e);
            return null;
        }
    }
}

