/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FileSaveTask
implements Callable<JSONObject> {
    private static final Log logger = LogFactory.getLog(FileSaveTask.class);
    private String serialNo;
    private JSONObject invoiceJson;
    private RequestContext ctx;
    private static final String[] fields = new String[]{"ofd_url", "pdf_url", "image_url", "snapshot_url", "xml_url"};

    public FileSaveTask(RequestContext ctx, String serialNo, JSONObject invoiceJson) {
        this.serialNo = serialNo;
        this.invoiceJson = invoiceJson;
        this.ctx = ctx;
    }

    @Override
    public JSONObject call() {
        String fileType;
        RequestContext.copyAndSet((RequestContext)this.ctx);
        logger.info("FileSaveTask coming:{}", (Object)this.serialNo);
        String isOriginal = this.invoiceJson.getString("isOriginal");
        JSONObject result = new JSONObject();
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)this.serialNo);
        DynamicObject mainDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"invoice_type, original_state,original_time,continuous_no,company_seal,check_status", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        DynamicObject fileIdDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id,original_state,snapshot_url", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        String originalState = "0";
        Map<String, Object> oldMap = null;
        String xmlUrlTemp = this.invoiceJson.getString("xmlUrl");
        String fileHash = this.invoiceJson.getString("fileHash");
        boolean fileExists = false;
        String wxOriginalState = "";
        boolean wxStateFlag = false;
        boolean isAwsFlag = false;
        if (StringUtils.isNotEmpty((CharSequence)this.invoiceJson.getString("awsXmlUrl")) && "xml".equalsIgnoreCase(this.invoiceJson.getString("fileType"))) {
            xmlUrlTemp = this.replaceUrl(this.invoiceJson.getString("awsXmlUrl"));
            Pair<String, String> pair = this.downAndUpload(xmlUrlTemp, "xml", true);
            xmlUrlTemp = "xml".equalsIgnoreCase((String)pair.getRight()) ? (String)pair.getLeft() : "";
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.invoiceJson.getString("originalStateInfo"))) {
                JSONObject info = JSONObject.parseObject((String)this.invoiceJson.getString("originalStateInfo"));
                String prevOriginalState = info.getString("prev_original_state");
                wxOriginalState = info.getString("original_state");
                wxStateFlag = !"1".equals(prevOriginalState) && "1".equals(wxOriginalState);
            }
        }
        catch (Exception info) {
            // empty catch block
        }
        if (fileIdDynamicObject == null) {
            fileIdDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
            fileIdDynamicObject.set("tenant_no", (Object)tenantNo);
            fileIdDynamicObject.set("serial_no", (Object)this.serialNo);
            fileIdDynamicObject.set("create_time", (Object)new Date());
            fileIdDynamicObject.set("update_time", (Object)new Date());
            if (StringUtils.isNotEmpty((CharSequence)xmlUrlTemp)) {
                fileIdDynamicObject.set("original_filename", (Object)this.invoiceJson.getString("fileName"));
                fileIdDynamicObject.set("original_state", (Object)"0");
            }
        } else {
            fileExists = true;
            fileIdDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fileIdDynamicObject.get("id"), (String)"rim_invoice_file");
            oldMap = DynamicObjectUtil.dynamicObject2Map(fileIdDynamicObject);
            fileIdDynamicObject.set("update_time", (Object)new Date());
            if (StringUtils.isEmpty((CharSequence)xmlUrlTemp)) {
                boolean existStateFlag;
                boolean checkFlag;
                String fileState = fileIdDynamicObject.getString("original_state");
                String main_check_status = "";
                if (mainDynamicObject != null) {
                    originalState = mainDynamicObject.getString("original_state");
                    main_check_status = mainDynamicObject.getString("check_status");
                }
                String fileSnapshotUrl = fileIdDynamicObject.getString("snapshot_url");
                String checkStatus = this.invoiceJson.getString("checkStatus");
                boolean bl = checkFlag = !StringUtils.isEmpty((CharSequence)checkStatus) && !"1".equals(checkStatus) && "1".equals(main_check_status);
                if (checkFlag && !StringUtils.isEmpty((CharSequence)fileSnapshotUrl)) {
                    return result;
                }
                boolean bl2 = existStateFlag = mainDynamicObject != null && "1".equals(originalState) && !StringUtils.isEmpty((CharSequence)fileSnapshotUrl);
                if (existStateFlag && !wxStateFlag) {
                    boolean stateFlag_2;
                    boolean stateFlag = "1".equals(fileState);
                    String invoiceOriginalState = this.invoiceJson.getString("originalState");
                    boolean bl3 = stateFlag_2 = !"1".equals(fileState) && (!"1".equals(invoiceOriginalState) || !"true".equals(isOriginal));
                    if (stateFlag || stateFlag_2) {
                        this.invoiceJson.put("originalState", (Object)mainDynamicObject.getString("original_state"));
                        this.invoiceJson.put("originalTime", (Object)DynamicObjectUtil.fieldToString(mainDynamicObject.get("original_time"), "yyyy-MM-dd HH:mm:ss"));
                        this.invoiceJson.put("continuousNo", (Object)mainDynamicObject.getString("continuous_no"));
                        this.invoiceJson.put("companySeal", (Object)mainDynamicObject.getString("company_seal"));
                    }
                    return result;
                }
                fileIdDynamicObject.set("ofd_url", (Object)"");
                fileIdDynamicObject.set("pdf_url", (Object)"");
                fileIdDynamicObject.set("original_type", (Object)"");
            }
        }
        if (StringUtils.isEmpty((CharSequence)(fileType = this.invoiceJson.getString("fileType")))) {
            fileType = "2";
        }
        if (StringUtils.isEmpty((CharSequence)xmlUrlTemp)) {
            boolean flag;
            boolean downFile = !"0".equals(RimConfigUtils.getConfig("down_invoice_file"));
            fileIdDynamicObject.set("rotation_angle", (Object)this.invoiceJson.getBigDecimal("rotationAngle"));
            fileIdDynamicObject.set("region", (Object)this.invoiceJson.getString("region"));
            fileIdDynamicObject.set("pixel", (Object)this.invoiceJson.getString("pixel"));
            if (StringUtils.isNotEmpty((CharSequence)this.invoiceJson.getString("fileName"))) {
                fileIdDynamicObject.set("original_filename", (Object)this.invoiceJson.getString("fileName"));
            } else {
                fileIdDynamicObject.set("original_filename", (Object)this.invoiceJson.getString("originalFileName"));
            }
            if (StringUtils.isEmpty((CharSequence)this.invoiceJson.getString("originalState"))) {
                fileIdDynamicObject.set("original_state", (Object)wxOriginalState);
            } else if ("true".equals(isOriginal) && "1".equals(this.invoiceJson.getString("originalState"))) {
                fileIdDynamicObject.set("original_state", (Object)"1");
            } else {
                fileIdDynamicObject.set("original_state", (Object)"0");
            }
            String kdCloudUrl = this.getKdCloudUrl();
            if (!StringUtils.isEmpty((CharSequence)kdCloudUrl)) {
                isAwsFlag = true;
            }
            if (downFile && fileExists && kdCloudUrl != null && kdCloudUrl.startsWith("http")) {
                boolean isDz;
                boolean bl = isDz = kdCloudUrl.indexOf("/public/pdf/") > 0 || kdCloudUrl.indexOf("/file/") > 0 && kdCloudUrl.indexOf("/pdf/") > 0;
                if (isDz) {
                    logger.info("\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728{}\u5e95\u8d26\u6587\u4ef6{}\u4e0d\u8986\u76d6", (Object)this.serialNo, (Object)kdCloudUrl);
                    return result;
                }
            }
            if (kdCloudUrl != null && kdCloudUrl.startsWith("http")) {
                JSONObject fileInfo = FileUtils.downLoadAndUploadWithFileType(kdCloudUrl, this.serialNo);
                fileType = fileInfo.getString("file_type");
                kdCloudUrl = fileInfo.getString("file_url");
                logger.info("kdcloudurl\u4e0b\u8f7d\u8fd4\u56de\uff1a{}", (Object)fileInfo);
            }
            this.setOfdUrl(fileIdDynamicObject, kdCloudUrl, fileType, downFile);
            this.setPdfUrl(fileIdDynamicObject, kdCloudUrl, fileType, downFile);
            this.setImageUrl(fileIdDynamicObject, kdCloudUrl, "jpg", downFile);
            this.setSnapshotUrl(fileIdDynamicObject, kdCloudUrl, "jpg", downFile);
            this.setXmlUrl(fileIdDynamicObject, kdCloudUrl, fileType, downFile);
            FileSaveTask.setFileType(fileIdDynamicObject, fileType);
            boolean bl = flag = StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("ofd_url")) && StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("pdf_url")) && StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("image_url"));
            if (flag) {
                result.put("errcode", (Object)"0001");
                return result;
            }
        } else {
            fileIdDynamicObject.set("xml_url", (Object)xmlUrlTemp);
        }
        if (!isAwsFlag) {
            FileSaveTask.setFileType(fileIdDynamicObject);
        }
        logger.info("\u4fdd\u5b58\u53d1\u7968\u6587\u4ef6\uff1a{},{},{},{},{}", new Object[]{this.serialNo, fileType, fileIdDynamicObject.getString("snapshot_url"), fileIdDynamicObject.getString("image_url"), fileIdDynamicObject.getString("pdf_url")});
        fileIdDynamicObject.set("file_hash", (Object)fileHash);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileIdDynamicObject});
        Map<String, Object> newMap = DynamicObjectUtil.dynamicObject2Map(fileIdDynamicObject);
        FileSaveTask.saveHis(oldMap, newMap);
        return result;
    }

    public static void saveHis(Map<String, Object> oldMap, Map<String, Object> newMap) {
        if (FileSaveTask.fileChange(oldMap, newMap)) {
            try {
                DynamicObject hisObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file_his");
                DataEntityPropertyCollection typeCollect = hisObject.getDataEntityType().getProperties();
                for (IDataEntityProperty property : typeCollect) {
                    if ("id".equals(property.getName())) continue;
                    hisObject.set(property.getName(), oldMap.get(property.getName()));
                }
                hisObject.set("operate_time", (Object)new Date());
                RequestContext context = RequestContext.get();
                hisObject.set("traceid", (Object)context.getTraceId());
                hisObject.set("creater", (Object)context.getUserId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hisObject});
            }
            catch (Exception e) {
                logger.info("\u4fdd\u5b58\u53d1\u7968\u6587\u4ef6\u5386\u53f2\u62a5\u9519");
            }
        }
    }

    private static boolean fileChange(Map<String, Object> oldMap, Map<String, Object> newMap) {
        if (oldMap != null && newMap != null) {
            for (String field : fields) {
                if (FileSaveTask.fieldEqual(oldMap, newMap, field)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean fieldEqual(Map<String, Object> oldMap, Map<String, Object> newMap, String field) {
        Object val1 = oldMap.get(field);
        Object val2 = newMap.get(field);
        if (val1 == null) {
            val1 = "";
        }
        if (val2 == null) {
            val2 = "";
        }
        return val1.toString().equals(val2.toString());
    }

    public static void setFileType(DynamicObject fileObject) {
        if (!StringUtils.isEmpty((CharSequence)fileObject.getString("ofd_url"))) {
            fileObject.set("original_type", (Object)"4");
        } else if (!StringUtils.isEmpty((CharSequence)fileObject.getString("pdf_url"))) {
            fileObject.set("original_type", (Object)"1");
        } else if (!StringUtils.isEmpty((CharSequence)fileObject.getString("image_url"))) {
            fileObject.set("original_type", (Object)"2");
        } else if (!StringUtils.isEmpty((CharSequence)fileObject.getString("xml_url"))) {
            fileObject.set("original_type", (Object)"9");
        } else {
            fileObject.set("original_type", (Object)"2");
        }
    }

    public static void setFileType(DynamicObject fileObject, String fileType) {
        if (!StringUtils.isEmpty((CharSequence)fileType)) {
            fileType = FileUtils.convertFileTypeNum(fileType);
            fileObject.set("original_type", (Object)fileType);
        }
        if (!StringUtils.isEmpty((CharSequence)fileObject.getString("ofd_url"))) {
            fileObject.set("original_type", (Object)"4");
        } else if (!StringUtils.isEmpty((CharSequence)fileObject.getString("pdf_url"))) {
            fileObject.set("original_type", (Object)"1");
        } else if (!StringUtils.isEmpty((CharSequence)fileObject.getString("image_url"))) {
            fileObject.set("original_type", (Object)"2");
        } else if (!StringUtils.isEmpty((CharSequence)fileObject.getString("xml_url"))) {
            fileObject.set("original_type", (Object)"9");
        } else {
            fileObject.set("original_type", (Object)"2");
        }
    }

    private void setOfdUrl(DynamicObject fileIdDynamicObject, String kdCloudUrl, String fileType, boolean downFile) {
        String ofdUrlTemp = CommonUtils.getJsonValue((Map<String, Object>)this.invoiceJson, String.class, "ofdUrl", "ofdurl");
        if (StringUtils.isNotEmpty((CharSequence)ofdUrlTemp)) {
            fileIdDynamicObject.set("ofd_url", (Object)this.replaceUrl(ofdUrlTemp));
        } else if (StringUtils.isNotEmpty((CharSequence)kdCloudUrl) && ("ofd".equals(fileType) || "4".equals(fileType))) {
            fileIdDynamicObject.set("ofd_url", (Object)kdCloudUrl);
        }
        Pair<String, String> pair = this.downAndUpload(fileIdDynamicObject.getString("ofd_url"), "ofd", downFile);
        if ("ofd".equalsIgnoreCase((String)pair.getRight())) {
            fileIdDynamicObject.set("ofd_url", pair.getLeft());
        } else {
            fileIdDynamicObject.set("ofd_url", (Object)"");
        }
    }

    private void setPdfUrl(DynamicObject fileIdDynamicObject, String kdCloudUrl, String fileType, boolean downFile) {
        String pdfUrlTemp = CommonUtils.getJsonValue((Map<String, Object>)this.invoiceJson, String.class, "pdfUrl", "pdfurl");
        if (StringUtils.isNotEmpty((CharSequence)pdfUrlTemp)) {
            fileIdDynamicObject.set("pdf_url", (Object)this.replaceUrl(pdfUrlTemp));
        } else if (StringUtils.isNotEmpty((CharSequence)kdCloudUrl) && ("pdf".equals(fileType) || "1".equals(fileType) || "pdf".equalsIgnoreCase(FileUtils.getFileType(kdCloudUrl)))) {
            fileIdDynamicObject.set("pdf_url", (Object)kdCloudUrl);
        }
        Pair<String, String> pair = this.downAndUpload(fileIdDynamicObject.getString("pdf_url"), "pdf", downFile);
        if ("pdf".equalsIgnoreCase((String)pair.getRight())) {
            fileIdDynamicObject.set("pdf_url", pair.getLeft());
        } else {
            fileIdDynamicObject.set("pdf_url", (Object)"");
        }
    }

    private void setXmlUrl(DynamicObject fileIdDynamicObject, String kdCloudUrl, String fileType, boolean downFile) {
        String xmlUrlTemp = CommonUtils.getJsonValue((Map<String, Object>)this.invoiceJson, String.class, "awsXmlUrl");
        if (StringUtils.isNotEmpty((CharSequence)xmlUrlTemp)) {
            fileIdDynamicObject.set("xml_url", (Object)this.replaceUrl(xmlUrlTemp));
        } else if (StringUtils.isNotEmpty((CharSequence)kdCloudUrl) && ("xml".equals(fileType) || "9".equals(fileType) || "xml".equalsIgnoreCase(FileUtils.getFileType(kdCloudUrl)))) {
            fileIdDynamicObject.set("xml_url", (Object)kdCloudUrl);
        }
        Pair<String, String> pair = this.downAndUpload(fileIdDynamicObject.getString("xml_url"), "xml", downFile);
        if ("xml".equalsIgnoreCase((String)pair.getRight())) {
            fileIdDynamicObject.set("xml_url", pair.getLeft());
        } else {
            fileIdDynamicObject.set("xml_url", (Object)"");
        }
    }

    private void setImageUrl(DynamicObject fileIdDynamicObject, String kdCloudUrl, String fileType, boolean downFile) {
        String imageUrlTemp = this.invoiceJson.getString("imageUrl");
        if (StringUtils.isNotEmpty((CharSequence)imageUrlTemp)) {
            fileIdDynamicObject.set("image_url", (Object)this.replaceUrl(imageUrlTemp));
        }
    }

    private void setSnapshotUrl(DynamicObject fileIdDynamicObject, String kdCloudUrl, String fileType, boolean downFile) {
        String snapshotUrl = this.invoiceJson.getString("snapshotUrl");
        if (StringUtils.isNotEmpty((CharSequence)snapshotUrl)) {
            snapshotUrl = this.replaceUrl(snapshotUrl);
        }
        Pair<String, String> pair = this.downAndUpload(snapshotUrl, "jpg", downFile);
        snapshotUrl = (String)pair.getLeft();
        fileIdDynamicObject.set("snapshot_url", pair.getLeft());
        if (StringUtils.isEmpty((CharSequence)snapshotUrl)) {
            snapshotUrl = fileIdDynamicObject.getString("image_url");
        }
        fileIdDynamicObject.set("snapshot_url", (Object)snapshotUrl);
        fileIdDynamicObject.set("image_url", (Object)snapshotUrl);
    }

    private String getKdCloudUrl() {
        String kdCloudUrlTemp = this.replaceUrl(this.invoiceJson.getString("kdcloudUrl"));
        if (StringUtils.isEmpty((CharSequence)kdCloudUrlTemp)) {
            kdCloudUrlTemp = this.replaceUrl(this.invoiceJson.getString("localUrl"));
        }
        return kdCloudUrlTemp;
    }

    private Pair<String, String> downAndUpload(String url, String defType, boolean downFile) {
        if (downFile && !StringUtils.isEmpty((CharSequence)url) && url.startsWith("http")) {
            JSONObject fileInfo = FileUtils.downLoadAndUploadWithFileType(url, this.serialNo + "_" + defType);
            String fileType = StringUtils.isEmpty((CharSequence)fileInfo.getString("file_type")) ? defType : fileInfo.getString("file_type");
            return Pair.of((Object)fileInfo.getString("file_url"), (Object)fileType);
        }
        return Pair.of((Object)url, (Object)defType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String replaceUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) return url;
        if (url.startsWith("http")) {
            return url;
        }
        if (url.indexOf(43) <= 0) return url;
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream fileInputStream = service.getInputStream(url);){
            String fileType = FileUtils.getFileType(url);
            String fileName = UUID.randomUUIDZero() + "." + fileType;
            String path = FileUploadUtils.upload(FileUploadUtils.getInvoiceDir("invoice") + fileName, fileName, fileInputStream);
            fileInputStream.close();
            String string = path;
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }
}

