/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task.handle.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MD5;

public class FileHandleAttachDownService
extends FileHandleService {
    private static final Log Logger = LogFactory.getLog(FileHandleAttachDownService.class);

    @Override
    public boolean doBusiness(DynamicObject object) {
        String serialNo = object.getString("serial_no");
        String localUrl = object.getString("download_url");
        String snapshotUrl = object.getString("snapshot_url");
        String expenseId = object.getString("ofd_url");
        String userId = object.getString("xml_url");
        String region = object.getString("region");
        boolean isInvoiceRelation = StringUtils.equals((CharSequence)"invoice", (CharSequence)region);
        if (!StringUtils.isEmpty((CharSequence)localUrl) || !StringUtils.isEmpty((CharSequence)snapshotUrl)) {
            QFilter filter = new QFilter("attach_no", "=", (Object)serialNo);
            List pks = QueryServiceHelper.queryPrimaryKeys((String)"rim_attach", (QFilter[])new QFilter[]{filter}, (String)"id", (int)2);
            String relationType = "1";
            if (isInvoiceRelation) {
                relationType = "3";
            }
            if (pks != null && !pks.isEmpty()) {
                long user;
                Object id = pks.get(0);
                DynamicObject attachSave = BusinessDataServiceHelper.loadSingle(id, (String)"rim_attach");
                if (attachSave != null && (user = DynamicObjectUtil.getDynamicObjectLongValue(attachSave.get("user"))) <= 0L && StringUtils.isNotBlank((CharSequence)userId)) {
                    attachSave.set("user", (Object)Long.valueOf(userId));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachSave});
                }
                String attachId = String.valueOf(id);
                QFilter filter1 = new QFilter("attach_id", "=", (Object)attachId);
                QFilter filter2 = null;
                QFilter filter3 = null;
                if (isInvoiceRelation) {
                    filter2 = new QFilter("relation_id", "=", (Object)expenseId);
                    filter3 = new QFilter("relation_type", "=", (Object)relationType);
                } else {
                    filter2 = new QFilter("expense_id", "=", (Object)expenseId);
                }
                DynamicObject relation = QueryServiceHelper.queryOne((String)"rim_attach_relation", (String)"id", (QFilter[])new QFilter[]{filter1, filter2, filter3});
                if (relation != null) {
                    return true;
                }
                DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
                item.set("relation_type", (Object)relationType);
                item.set("attach_id", (Object)attachId);
                if (isInvoiceRelation) {
                    item.set("relation_id", (Object)expenseId);
                } else {
                    item.set("expense_id", (Object)expenseId);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{item});
                return true;
            }
            JSONObject localObj = FileUtils.downLoadAndUploadWithFileType(localUrl, MD5.md5Hex((String)localUrl));
            String fileType = "";
            if (localObj != null) {
                localUrl = localObj.getString("file_url");
                fileType = localObj.getString("file_type");
            }
            snapshotUrl = FileUtils.downLoadAndUpload(snapshotUrl, MD5.md5Hex((String)snapshotUrl));
            if (StringUtils.isEmpty((CharSequence)localUrl) && StringUtils.isEmpty((CharSequence)snapshotUrl)) {
                return false;
            }
            DynamicObject needSaveAttach = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
            needSaveAttach.set("attach_url", (Object)(StringUtils.isNotEmpty((CharSequence)localUrl) ? localUrl : snapshotUrl));
            needSaveAttach.set("snapshot_url", (Object)snapshotUrl);
            needSaveAttach.set("attach_name", (Object)object.getString("attachment_name"));
            String originalFileName = object.getString("original_file_name");
            if (StringUtils.isEmpty((CharSequence)originalFileName) && StringUtils.isNotEmpty((CharSequence)fileType)) {
                originalFileName = object.getString("attachment_name") + "." + fileType;
            }
            needSaveAttach.set("original_name", (Object)originalFileName);
            needSaveAttach.set("attach_type", (Object)object.getString("file_type"));
            needSaveAttach.set("remark", (Object)object.getString("remark"));
            needSaveAttach.set("attach_no", (Object)serialNo);
            if (StringUtils.isNotBlank((CharSequence)userId)) {
                needSaveAttach.set("user", (Object)Long.valueOf(userId));
            }
            needSaveAttach.set("update_time", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{needSaveAttach});
            if (!StringUtils.isEmpty((CharSequence)expenseId)) {
                DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
                item.set("relation_type", (Object)relationType);
                item.set("attach_id", (Object)String.valueOf(needSaveAttach.getPkValue()));
                if (isInvoiceRelation) {
                    item.set("relation_id", (Object)expenseId);
                } else {
                    item.set("expense_id", (Object)expenseId);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{item});
            }
            return true;
        }
        return true;
    }

    @Override
    public void insert(String fileId, JSONObject object) {
        QFilter filter = new QFilter("id", "=", (Object)fileId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_invoice_file_aws", (String)"id", (QFilter[])new QFilter[]{filter});
        if (obj == null) {
            String userId;
            obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file_aws");
            obj.set("id", (Object)fileId);
            obj.set("serial_no", (Object)object.getString("serialNo"));
            obj.set("download_url", (Object)object.getString("localUrl"));
            obj.set("snapshot_url", (Object)object.getString("snapshotUrl"));
            obj.set("ofd_url", (Object)object.getString("expenseId"));
            String fileType = object.getString("fileType");
            if (StringUtils.isEmpty((CharSequence)fileType)) {
                fileType = object.getString("attachmentType");
            }
            obj.set("file_type", (Object)fileType);
            obj.set("attachment_name", (Object)object.getString("attachmentName"));
            obj.set("remark", (Object)object.getString("remark"));
            obj.set("deal_times", (Object)0);
            obj.set("update_time", (Object)new Date());
            obj.set("status", (Object)"0");
            obj.set("create_time", (Object)new Date());
            obj.set("down_type", (Object)DOWN_TYPE_ATT);
            String relationType = object.getString("relationType");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)relationType)) {
                obj.set("region", (Object)"invoice");
            }
            if (StringUtils.isNotEmpty((CharSequence)(userId = object.getString("userId")))) {
                obj.set("xml_url", (Object)userId);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }
}

