/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task.handle.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.recognitionnew.task.FileSaveTask;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import org.apache.commons.collections.CollectionUtils;

public class FileHandleInvoiceDownService
extends FileHandleService {
    @Override
    public void insert(String fileId, JSONObject object) {
        QFilter filter = new QFilter("id", "=", (Object)fileId);
        DeleteServiceHelper.delete((String)"rim_invoice_file_aws", (QFilter[])new QFilter[]{filter});
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file_aws");
        this.setXmlUrlAndFileType(object);
        obj.set("id", (Object)fileId);
        obj.set("serial_no", (Object)fileId);
        obj.set("deal_times", (Object)0);
        obj.set("update_time", (Object)new Date());
        obj.set("status", (Object)"0");
        obj.set("create_time", (Object)new Date());
        obj.set("ofd_url", (Object)object.getString("ofdUrl"));
        obj.set("snapshot_url", (Object)object.getString("snapshotUrl"));
        String kdcloudUrl = object.getString("kdcloudUrl");
        if (StringUtils.isEmpty((CharSequence)kdcloudUrl) && StringUtils.isEmpty((CharSequence)(kdcloudUrl = object.getString("downloadUrl")))) {
            kdcloudUrl = StringUtils.isEmpty((CharSequence)object.getString("pdfUrl")) ? object.getString("imageUrl") : object.getString("pdfUrl");
        }
        obj.set("download_url", (Object)kdcloudUrl);
        obj.set("file_type", (Object)object.getString("fileType"));
        obj.set("rotation_angle", (Object)object.getBigDecimal("rotationAngle"));
        obj.set("region", (Object)object.getString("region"));
        obj.set("pixel", (Object)object.getString("pixel"));
        obj.set("xml_url", (Object)object.getString("xmlUrl"));
        JSONObject info = new JSONObject();
        if (object.getString("originalState") != null) {
            info.put("original_state", (Object)object.getString("originalState"));
        }
        if (object.getString("prevOriginalState") != null) {
            info.put("prev_original_state", (Object)object.getString("prevOriginalState"));
        }
        if (!info.isEmpty()) {
            obj.set("remark", (Object)info.toJSONString());
        }
        obj.set("down_type", (Object)DOWN_TYPE_DOWN);
        obj.set("attachment_name", (Object)object.getString("originalFileName"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    @Override
    public boolean doBusiness(DynamicObject object) {
        String serialNo = object.getString("serial_no");
        JSONObject json = new JSONObject();
        json.put("fileType", (Object)object.getString("file_type"));
        json.put("kdcloudUrl", (Object)object.getString("download_url"));
        json.put("region", (Object)object.getString("region"));
        json.put("pixel", (Object)object.getString("pixel"));
        json.put("rotationAngle", (Object)object.getString("rotation_angle"));
        json.put("snapshotUrl", (Object)object.getString("snapshot_url"));
        json.put("ofdUrl", (Object)object.getString("ofd_url"));
        json.put("serialNo", (Object)object.getString("serial_no"));
        json.put("originalStateInfo", (Object)object.getString("remark"));
        json.put("originalFileName", (Object)object.getString("attachment_name"));
        json.put("awsXmlUrl", (Object)object.getString("xml_url"));
        FileSaveTask task = new FileSaveTask(RequestContext.get(), serialNo, json);
        JSONObject result = task.call();
        String errorCode = result.getString("errcode");
        return !StringUtils.isNotEmpty((CharSequence)errorCode) || "0000".equals(errorCode);
    }

    private void setXmlUrlAndFileType(JSONObject wxPush) {
        JSONObject latestObj;
        JSONArray invoiceFiles = wxPush.getJSONArray("invoiceFiles");
        if (CollectionUtils.isEmpty((Collection)invoiceFiles)) {
            return;
        }
        ArrayList<Object> filteredList = new ArrayList<Object>();
        for (int i = 0; i < invoiceFiles.size(); ++i) {
            JSONObject obj = invoiceFiles.getJSONObject(i);
            if (obj.getIntValue("resource") != 1) continue;
            filteredList.add(obj);
        }
        ArrayList<JSONObject> xmlList = new ArrayList<JSONObject>();
        for (JSONObject jSONObject : filteredList) {
            if (!"xml".equals(jSONObject.getString("fileExtends"))) continue;
            xmlList.add(jSONObject);
        }
        Collections.sort(xmlList, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                return o2.getString("updateTime").compareTo(o1.getString("updateTime"));
            }
        });
        if (!xmlList.isEmpty()) {
            latestObj = (JSONObject)xmlList.get(0);
            wxPush.put("xmlUrl", (Object)latestObj.getString("url"));
        }
        Collections.sort(filteredList, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                return o2.getString("updateTime").compareTo(o1.getString("updateTime"));
            }
        });
        if (!filteredList.isEmpty()) {
            latestObj = (JSONObject)filteredList.get(0);
            wxPush.put("fileType", (Object)latestObj.getString("fileExtends"));
        }
    }
}

