/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task.handle.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.utils.MD5;
import org.apache.commons.lang3.StringUtils;

public class FileHandleMultiTenantDownService
extends FileHandleService {
    private static final Log logger = LogFactory.getLog(FileHandleMultiTenantDownService.class);
    private static String[] invoiceUrls = new String[]{"localUrl", "snapshotUrl", "pdfUrl", "pdfurl", "downloadUrl", "xmlUrl", "imageUrl", "snapshotUrl", "xbrlUrl"};

    public void insert(JSONArray invoiceList) {
        Set<String> urlList = this.getUrl(invoiceList, invoiceUrls);
        if (!urlList.isEmpty()) {
            this.insert(urlList);
            FileHandleService.startDownAwsFile("0");
        }
    }

    public void insert(Set<String> fileUrls) {
        HashSet fileIdList = new HashSet(fileUrls.size());
        fileUrls.forEach(url -> {
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                fileIdList.add(MD5.md5Hex((String)url));
            }
        });
        if (fileIdList.isEmpty()) {
            return;
        }
        QFilter filter1 = new QFilter("id", "in", fileIdList);
        QFilter filter2 = new QFilter("down_type", "=", (Object)DOWN_TYPE_TENANT);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"rim_invoice_file_aws", (String)"id,status", (QFilter[])new QFilter[]{filter1, filter2});
        HashSet<String> existsFile = new HashSet<String>(8);
        HashSet<String> deleteFile = new HashSet<String>(8);
        for (DynamicObject obj : list) {
            if ("0".equals(obj.getString("status"))) {
                existsFile.add(obj.getString("id"));
                continue;
            }
            deleteFile.add(obj.getString("id"));
        }
        if (!deleteFile.isEmpty()) {
            DeleteServiceHelper.delete((String)"rim_invoice_file_aws", (QFilter[])new QFilter("id", "in", deleteFile).toArray());
        }
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(8);
        for (String url2 : fileUrls) {
            String fileId = MD5.md5Hex((String)url2);
            if (!StringUtils.isNotEmpty((CharSequence)url2) || !existsFile.add(fileId)) continue;
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file_aws");
            obj.set("id", (Object)fileId);
            obj.set("serial_no", (Object)fileId);
            obj.set("deal_times", (Object)0);
            obj.set("update_time", (Object)new Date());
            obj.set("status", (Object)"0");
            obj.set("create_time", (Object)new Date());
            obj.set("download_url", (Object)url2);
            obj.set("down_type", (Object)DOWN_TYPE_TENANT);
            addList.add(obj);
        }
        if (!addList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
        }
    }

    private Set<String> getUrl(JSONArray result, String[] urlKeys) {
        HashSet<String> urlList = new HashSet<String>(8);
        if (result != null) {
            for (int i = 0; i < result.size(); ++i) {
                JSONObject object = result.getJSONObject(i);
                for (String type : urlKeys) {
                    String url = object.getString(type);
                    if (!StringUtils.isNotEmpty((CharSequence)url)) continue;
                    urlList.add(url);
                }
            }
        }
        return urlList;
    }

    public JSONObject convertInvoiceUrl(JSONObject result) {
        if (result == null) {
            return result;
        }
        JSONObject data = result.getJSONObject("data");
        JSONArray cover = data.getJSONArray("cover");
        JSONArray allInvoice = data.getJSONArray("allInvoice");
        JSONArray attachment = data.getJSONArray("attachment");
        Set<String> fileList = this.getUrl(allInvoice, invoiceUrls);
        Set<String> attachList = this.getUrl(attachment, invoiceUrls);
        if (!attachList.isEmpty()) {
            fileList.addAll(attachList);
        }
        logger.info("\u83b7\u53d6\u672c\u5730\u6587\u4ef61:{}", fileList);
        MultiTenantService multiTenantService = new MultiTenantService();
        Map fileMap = multiTenantService.queryLocalUrl(fileList, true);
        logger.info("\u83b7\u53d6\u672c\u5730\u6587\u4ef62:{}", fileList);
        this.convertUrl(allInvoice, fileMap, invoiceUrls);
        this.convertUrl(data.getJSONArray("allInvoice"), fileMap, invoiceUrls);
        this.convertUrl(data.getJSONArray("electronicInvoice"), fileMap, invoiceUrls);
        this.convertUrl(data.getJSONArray("paperInvoice"), fileMap, invoiceUrls);
        this.convertUrl(data.getJSONArray("overSeaInvoice"), fileMap, invoiceUrls);
        this.convertUrl(attachment, fileMap, invoiceUrls);
        Set<String> coverfileList = this.getUrl(cover, invoiceUrls);
        Map coverfileMap = multiTenantService.queryLocalUrl(coverfileList, true);
        this.convertUrl(cover, coverfileMap, invoiceUrls);
        return result;
    }

    public JSONArray convertInvoiceUrl(JSONArray array) {
        if (array != null) {
            Set<String> fileList = this.getUrl(array, invoiceUrls);
            MultiTenantService multiTenantService = new MultiTenantService();
            Map fileMap = multiTenantService.queryLocalUrl(fileList, true);
            this.convertUrl(array, fileMap, invoiceUrls);
        }
        return array;
    }

    private JSONArray convertUrl(JSONArray arry, Map<String, String> fileMap, String[] keys) {
        if (arry != null) {
            for (int i = 0; i < arry.size(); ++i) {
                JSONObject invoice = arry.getJSONObject(i);
                for (String urlkey : keys) {
                    String keyValue = invoice.getString(urlkey);
                    if (!StringUtils.isNotEmpty((CharSequence)keyValue) || fileMap.get(keyValue) == null) continue;
                    invoice.put(urlkey, (Object)fileMap.get(keyValue));
                }
            }
        }
        return arry;
    }

    @Override
    public boolean doBusiness(DynamicObject object) {
        MultiTenantService service = new MultiTenantService();
        String url = service.getLocalUrl(object.getString("download_url"));
        return StringUtils.isNotEmpty((CharSequence)url);
    }

    @Override
    public void insert(String fileId, JSONObject object) {
    }
}

