/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recorded;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.invoice.deduction.AutoDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.Sets;

public class AutoRecordedService {
    private static Log LOGGER = LogFactory.getLog(AutoRecordedService.class);
    private static Set<String> needTaxPeriodSet = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "12", "23"});
    private static final int DEFAULT_SIZE = 500;

    public void AutoRecorded(DynamicObject config, Long orgId, String taxNo) {
        String dkType = DeductionConstant.getDkType(taxNo);
        try {
            if (StringUtils.isEmpty((CharSequence)taxNo) || Objects.equals(orgId, Long.valueOf("0"))) {
                LOGGER.info("\u7a0e\u53f7\u6216\u8005\u7ec4\u7ec7id\u4e3a\u7a7a,{}-{}", (Object)taxNo, (Object)orgId);
                return;
            }
            DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle(dkType);
            if (deductService == null) {
                LOGGER.info("\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef");
                return;
            }
            String taxperiodStr = deductService.syncGetTaxperiod(taxNo);
            Date taxperiod = null;
            if (StringUtils.isNotEmpty((CharSequence)taxperiodStr)) {
                taxperiod = DateUtils.stringToDate(taxperiodStr, "yyyyMM");
            } else {
                LOGGER.info("\u83b7\u53d6\u5f53\u524d\u5c5e\u671f\u9519\u8bef{}", (Object)taxNo);
            }
            int queryInvoiceSize = RimConfigUtils.getPageSizeFromConfig(500, "rim_recorded", "query_invoice_size");
            if (queryInvoiceSize <= 0) {
                queryInvoiceSize = 500;
            }
            this.startRecord(config, taxperiod, orgId, taxNo, queryInvoiceSize);
        }
        catch (Exception e) {
            LOGGER.info("autoDeductSelectError" + taxNo, (Object)e);
        }
    }

    public void startRecord(DynamicObject config, Date taxperiod, Long orgId, String taxNo, int queryInvoiceSize) {
        DynamicObjectCollection invoiceList;
        String stopTask = ImcConfigUtil.getValue("rim_recorded", "force_stop_task");
        int i = 0;
        int maxTimes = RimConfigUtils.getPageSizeFromConfig(200, "rim_recorded", "record_max_query_times");
        while (!"1".equals(stopTask) && ++i <= maxTimes && !kd.bos.orm.util.CollectionUtils.isEmpty((Collection)(invoiceList = this.queryInvoiceByConfig(config, taxperiod, orgId, taxNo, queryInvoiceSize)))) {
            this.invokeRecord(invoiceList, config, taxNo, orgId);
            if (invoiceList.size() == queryInvoiceSize) continue;
            break;
        }
    }

    private void invokeRecord(DynamicObjectCollection invoiceList, DynamicObject config, String taxNo, Long orgId) {
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)invoiceList)) {
            String dkType = DeductionConstant.getDkType(taxNo);
            DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle(dkType);
            String opereateType = "recorded_commit";
            JSONObject recordedParam = RecordedConstant.createRecordedParamNew(invoiceList, opereateType, "1", config);
            if (recordedParam != null) {
                for (Map.Entry entry : recordedParam.entrySet()) {
                    JSONArray invoices;
                    JSONObject configObj;
                    String taxNoPram = (String)entry.getKey();
                    if (StringUtils.isBlank((CharSequence)taxNoPram) || (configObj = recordedParam.getJSONObject(taxNoPram)) == null || CollectionUtils.isEmpty((Collection)(invoices = configObj.getJSONArray("invoices")))) continue;
                    ArrayList<JSONObject> invoiceSuccessList = new ArrayList<JSONObject>(1);
                    JSONArray invoicesFail = new JSONArray();
                    for (int i = 0; i < invoices.size(); ++i) {
                        JSONObject jsonObject = invoices.getJSONObject(i);
                        JSONObject checkResult = deductService.checkRecordedInvoiceParam(jsonObject, opereateType);
                        if (!ResultContant.isSuccess(checkResult).booleanValue()) continue;
                        invoiceSuccessList.add(jsonObject);
                    }
                    if (CollectionUtils.isEmpty(invoiceSuccessList)) {
                        LOGGER.info("\u5fc5\u586b\u6027\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u4e0d\u5b58\u5728\u9700\u8981\u8c03\u7528\u7a0e\u5c40\u5165\u8d26\u7684\u53d1\u7968\u6570\u636e:{}");
                        continue;
                    }
                    JSONObject param = new JSONObject();
                    param.put("taxNo", (Object)taxNo);
                    param.put("operateType", (Object)opereateType);
                    param.put("orgId", (Object)orgId);
                    param.put("selectOperaTypeAuto", (Object)"2");
                    if ("5".equals(dkType)) {
                        param.put("dktype", (Object)"5");
                        param.put("invoiceSuccessList", invoiceSuccessList);
                        try {
                            this.batchRecordedInvoices(param);
                        }
                        catch (Exception e) {
                            LOGGER.info("\u81ea\u52a8\u5165\u5e10\u9519\u8bef", (Object)e);
                        }
                        continue;
                    }
                    if (!"4".equals(dkType)) continue;
                    Map<String, List<JSONObject>> taxRecordedPurposeMap = invoiceSuccessList.stream().collect(Collectors.groupingBy(t -> t.getString("nextEntryMarkStatus")));
                    for (Map.Entry<String, List<JSONObject>> etaxEntry : taxRecordedPurposeMap.entrySet()) {
                        JSONObject paramNewEtax = new JSONObject();
                        paramNewEtax.putAll((Map)param);
                        paramNewEtax.put("dktype", (Object)"4");
                        paramNewEtax.put("invoiceSuccessList", etaxEntry.getValue());
                        paramNewEtax.put("nextEntryMarkStatus", (Object)etaxEntry.getKey());
                        try {
                            this.batchRecordedInvoices(paramNewEtax);
                        }
                        catch (Exception e) {
                            LOGGER.info("\u81ea\u52a8\u5165\u5e10\u9519\u8bef", (Object)e);
                        }
                    }
                }
            } else {
                LOGGER.info("\u81ea\u52a8\u5165\u8d26\uff0c\u7ec4\u88c5\u5165\u8d26\u53c2\u6570\uff0c\u6784\u5efa\u7684\u53d1\u7968\u6570\u636e\u4e3a\u7a7a\uff0c \u7a0e\u53f7\uff1a{}" + taxNo);
            }
        }
    }

    private void batchRecordedInvoices(JSONObject param) {
        String taxNo = param.getString("taxNo");
        String dktype = DeductionConstant.getDkType(taxNo);
        RecordedConstant recordedConstant = new RecordedConstant();
        String opereateType = "recorded_commit";
        DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle(dktype);
        List invoiceList = (List)param.get((Object)"invoiceSuccessList");
        if (invoiceList.size() > deductService.maxSizeRecorded) {
            List lists = ListUtils.splitList(invoiceList, deductService.maxSizeRecorded);
            for (List list : lists) {
                JSONObject paramSplit = new JSONObject();
                paramSplit.putAll((Map)param);
                paramSplit.put("invoices", list);
                JSONObject result = deductService.recordedCommit(paramSplit);
                if (result == null) {
                    result = new JSONObject();
                    result.put("errcode", (Object)"2002");
                    result.put("description", (Object)ErrorType.PARAM_ERROR.getName());
                }
                if (!ResultContant.isSuccess(result).booleanValue()) continue;
                paramSplit.put("result", (Object)result);
                recordedConstant.dealInvoiceSuccess(paramSplit, opereateType);
            }
        } else {
            param.put("invoices", (Object)invoiceList);
            JSONObject result = deductService.recordedCommit(param);
            if (result == null) {
                result = new JSONObject();
                result.put("errcode", (Object)"2002");
                result.put("description", (Object)ErrorType.PARAM_ERROR.getName());
            }
            if (ResultContant.isSuccess(result).booleanValue()) {
                param.put("result", (Object)result);
                recordedConstant.dealInvoiceSuccess(param, opereateType);
            }
        }
    }

    public DynamicObjectCollection queryInvoiceByConfig(DynamicObject config, Date taxperiod, Long orgId, String taxno, int queryInvoiceSize) {
        String periodConfig;
        String invovicestatus;
        String receipttype;
        String invoiceresouce;
        List<Long> orgList = TenantUtils.queryChildOrgIdList(taxno);
        if (orgList != null && !orgList.isEmpty() && orgId != null && !orgList.contains(orgId)) {
            orgList.add(orgId);
        }
        String deductionFlag = config.getString("deduction_flag");
        List<String> deductionFlagList = null;
        if (StringUtils.isNotEmpty((CharSequence)deductionFlag) && !deductionFlag.contains("-1")) {
            deductionFlagList = CommonUtils.getMultiValues(deductionFlag);
        }
        Set<Object> serialNos = Sets.newHashSet((Object[])new String[0]);
        DynamicObjectCollection businessbill = config.getDynamicObjectCollection("businessbill");
        ArrayList expenseTypeNumbers = Lists.newArrayList();
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)businessbill)) {
            for (DynamicObject dynamicObject : businessbill) {
                DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
                expenseTypeNumbers.add(fbasedataid.getString("number"));
            }
            AutoDeductSelectService autoDeductSelectService = new AutoDeductSelectService();
            serialNos = autoDeductSelectService.getExpenseSerialNos(orgList, expenseTypeNumbers, new ArrayList<String>());
            if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)serialNos)) {
                LOGGER.info("\u6ca1\u6709\u5355\u636e\u6570\u636e,\u4e0d\u62b5\u6263{}", (Object)taxno);
                return null;
            }
        }
        ArrayList filters = Lists.newArrayList();
        if (!kd.bos.orm.util.CollectionUtils.isEmpty(orgList)) {
            filters.add(new QFilter("org", "in", (Object)orgList.toArray()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(invoiceresouce = config.getString("invoiceresouce"))) && !invoiceresouce.contains("-1")) {
            filters.add(new QFilter("collect_type", "in", CommonUtils.getMultiValues(invoiceresouce)));
        }
        String invoicetype = config.getString("invoicetype");
        ArrayList recordedInvoiceTypes = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)invoicetype) && !invoicetype.contains("-1")) {
            List<String> values = CommonUtils.getMultiValues(invoicetype);
            for (String value : values) {
                Long longType;
                if ("00".equals(value) || !InputInvoiceTypeEnum.isVatType(longType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(value))) continue;
                recordedInvoiceTypes.add(longType);
            }
        } else {
            Collections.addAll(recordedInvoiceTypes, InputInvoiceTypeEnum.getTaxRecordedTypes());
        }
        filters.add(new QFilter("invoice_type", "in", (Object)recordedInvoiceTypes.toArray()));
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)serialNos)) {
            filters.add(new QFilter("serial_no", "in", (Object)serialNos.toArray()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(receipttype = config.getString("receipttype"))) && !receipttype.contains("-1")) {
            filters.add(new QFilter("original_state", "in", CommonUtils.getMultiValues(receipttype)));
        }
        String authenticateFlag = config.getString("authenticate_flag");
        List<String> authenticateFlagList = null;
        if (StringUtils.isNotEmpty((CharSequence)authenticateFlag) && !authenticateFlag.contains("-1")) {
            authenticateFlagList = CommonUtils.getMultiValues(authenticateFlag);
        }
        if (!kd.bos.orm.util.CollectionUtils.isEmpty(authenticateFlagList)) {
            filters.add(new QFilter("authenticate_flag", "in", (Object)authenticateFlagList.toArray()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(invovicestatus = config.getString("invovicestatus"))) && !invovicestatus.contains("-1")) {
            filters.add(new QFilter("expense_status", "in", CommonUtils.getMultiValues(invovicestatus)));
        }
        String checkStatus = config.getString("check_status");
        QFilter checkFilter = new QFilter("check_status", "in", (Object)CheckContant.getSuccessStatus());
        if (StringUtils.isNotEmpty((CharSequence)checkStatus) && !checkStatus.contains("-1")) {
            checkFilter = new QFilter("check_status", "in", CommonUtils.getMultiValues(checkStatus));
        }
        filters.add(checkFilter);
        if (!kd.bos.orm.util.CollectionUtils.isEmpty(deductionFlagList)) {
            filters.add(new QFilter("deduction_flag", "in", (Object)deductionFlagList.toArray()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(periodConfig = config.getString("preiod")))) {
            periodConfig = periodConfig.replace(",", "").trim();
            LOGGER.info("\u6309\u6240\u5c5e\u7a0e\u671f{}", (Object)periodConfig);
            if (needTaxPeriodSet.contains(periodConfig) && this.checkTaxperiod(taxperiod)) {
                LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0c \u5f53\u524d\u7a0e\u671f\u4e3a\u7a7a", (Object)taxno);
                return null;
            }
            if ("1".equals(periodConfig)) {
                filters.add(new QFilter("account_date", "<", (Object)taxperiod));
            } else if ("2".equals(periodConfig)) {
                filters.add(new QFilter("account_date", ">=", (Object)taxperiod));
                filters.add(new QFilter("account_date", "<", (Object)DateUtils.addMonth(taxperiod, 1)));
            } else if ("3".equals(periodConfig)) {
                filters.add(new QFilter("account_date", ">=", (Object)DateUtils.addMonth(taxperiod, 1)));
            } else if ("12".equals(periodConfig)) {
                filters.add(new QFilter("account_date", "<", (Object)DateUtils.addMonth(taxperiod, 1)));
            } else if ("23".equals(periodConfig)) {
                filters.add(new QFilter("account_date", ">=", (Object)taxperiod));
            }
        }
        QFilter taxnoFilter = new QFilter("buyer_tax_no", "=", (Object)taxno);
        filters.add(taxnoFilter);
        filters.add(new QFilter("invoice_status", "=", (Object)"0"));
        filters.add(new QFilter("delete", "=", (Object)"1"));
        filters.add(new QFilter("tax_recorded_status", "in", (Object)RecordedConstant.getNotRecordedStatus()));
        List<QFilter> ekFilterList = EkServiceFactory.getInvoiceSelectService().getAutoRecordedQFilter(config);
        if (ekFilterList != null && !ekFilterList.isEmpty()) {
            filters.addAll(ekFilterList);
        }
        Date now = new Date();
        filters.add(new QFilter("invoice_date", ">=", (Object)DateUtils.addYear(now, -1)));
        filters.add(new QFilter("invoice_date", "<", (Object)DateUtils.addDay(now, 1)));
        LOGGER.info("\u67e5\u8be2\u6761\u4ef6\uff1a" + ((Object)filters).toString());
        DynamicObjectCollection vatInvoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time,tax_recorded_period,account_date,ext_info", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"createtime asc", (int)queryInvoiceSize);
        vatInvoiceCollection.removeIf(s -> InvoiceSaveConstant.isMatchFromExtInfo(s, InvoiceSaveConstant.EXT_AUTO_RZ_FLAG));
        return vatInvoiceCollection;
    }

    private boolean checkTaxperiod(Date taxperiod) {
        return taxperiod == null;
    }
}

