/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class TrainEleSaveService
extends InvoiceSaveService {
    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        String recognitionImplStr = RimConfigUtils.getConfig("rim_recog_check", "rimpl");
        boolean isAwsRecognition = kd.bos.util.StringUtils.isEmpty((String)recognitionImplStr) || "kd.imc.rim.common.invoice.recognitionnew.impl.AwsRecognitionService".equals(recognitionImplStr);
        boolean isConvertPlace = "1".equals(RimConfigUtils.getConfig("rim_recog_check", "convertplace"));
        if (isAwsRecognition && isConvertPlace) {
            InvoiceCollectService collectService = new InvoiceCollectService();
            collectService.convertPlace(invoiceJson);
        }
        super.setMainFieldValue(invoiceJson, dynamicObject);
        String invoiceStatus = invoiceJson.getString("invoiceStatus");
        if (kd.bos.util.StringUtils.isEmpty((String)invoiceStatus)) {
            invoiceStatus = "0";
        }
        dynamicObject.set("invoice_status", (Object)invoiceStatus);
        dynamicObject.set("buyer_name", (Object)this.getJSONValue(invoiceJson, String.class, "purchaserName", "buyerName"));
        dynamicObject.set("buyer_tax_no", (Object)this.getJSONValue(invoiceJson, String.class, "purchaserUnifiedSocialCreditCode", "buyerTaxNo"));
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), this.getJSONValue(invoiceJson, String.class, "sellerName", "salerName"))) {
            dynamicObject.set("saler_name", (Object)this.getJSONValue(invoiceJson, String.class, "sellerName", "salerName"));
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), this.getJSONValue(invoiceJson, String.class, "sellerUnifiedSocialCreditCode", "salerTaxNo"))) {
            dynamicObject.set("saler_tax_no", (Object)this.getJSONValue(invoiceJson, String.class, "sellerUnifiedSocialCreditCode", "salerTaxNo"));
        }
    }

    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), dynamicObject);
        dynamicObject.set("invoice_unit", (Object)invoiceJson.getString("invoiceUnit"));
        dynamicObject.set("invoice_unit_code", (Object)invoiceJson.getString("invoiceUnitCode"));
        JSONArray items = invoiceJson.getJSONArray("items");
        if (!CollectionUtils.isEmpty((Collection)items)) {
            for (int j = 0; j < items.size(); ++j) {
                JSONObject jsonObject = items.getJSONObject(j);
                String productName = jsonObject.getString("goodsName");
                if (!kd.bos.util.StringUtils.isNotEmpty((String)productName)) continue;
                if (productName.contains("\u9000\u7968\u8d39")) {
                    invoiceJson.put("businessType", (Object)"\u9000");
                    break;
                }
                if (!productName.contains("\u7968\u4ef7")) continue;
                invoiceJson.put("businessType", (Object)"\u552e");
                break;
            }
        }
        String businessType = this.getJSONValue(invoiceJson, String.class, "businessType", "typeOfBusiness");
        if (CollectTypeEnum.PC_SHUIPAN.getCode().equals(invoiceJson.getString("collect_type")) && kd.bos.util.StringUtils.isEmpty((String)businessType)) {
            businessType = dynamicObject.getString("business_type");
        }
        if ("\u552e".equals(businessType)) {
            businessType = "1";
        }
        if ("\u9000".equals(businessType)) {
            businessType = "2";
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), businessType)) {
            dynamicObject.set("business_type", (Object)businessType);
        }
        dynamicObject.set("departure_station", (Object)this.getJSONValue(invoiceJson, String.class, "departureStation", "stationGetOn"));
        dynamicObject.set("departure_station_phonics", (Object)invoiceJson.getString("departureStationPhonics"));
        dynamicObject.set("destination_station", (Object)this.getJSONValue(invoiceJson, String.class, "destinationStation", "stationGetOff"));
        dynamicObject.set("destin_station_phonics", (Object)invoiceJson.getString("destinationStationPhonics"));
        dynamicObject.set("train_num", (Object)invoiceJson.getString("trainNum"));
        dynamicObject.set("travel_date", (Object)invoiceJson.getDate("trainTime"));
        dynamicObject.set("departure_time", (Object)invoiceJson.getString("departureTime"));
        dynamicObject.set("ticket_type", (Object)invoiceJson.getString("ticketType"));
        dynamicObject.set("air_condi_characteristics", (Object)invoiceJson.getString("airConditCharacteristics"));
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("seatLevel"))) {
            dynamicObject.set("seat_level", (Object)invoiceJson.getString("seatLevel"));
        }
        dynamicObject.set("carriage", (Object)invoiceJson.getString("carriage"));
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), this.getJSONValue(invoiceJson, String.class, "seat"))) {
            dynamicObject.set("seat", (Object)this.getJSONValue(invoiceJson, String.class, "seat"));
        }
        dynamicObject.set("discount_mark", (Object)invoiceJson.getString("discountMark"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getBigDecimal("totalAmount"));
        dynamicObject.set("amount_refunded", (Object)invoiceJson.getBigDecimal("amountRefunded"));
        dynamicObject.set("original_ticket_fare", (Object)invoiceJson.getBigDecimal("originalTicketFare"));
        dynamicObject.set("ori_ticket_departurest", (Object)invoiceJson.getString("originalTicketDepartureStation"));
        dynamicObject.set("ori_ticket_destination", (Object)invoiceJson.getString("originalTicketDestinationStation"));
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), this.getJSONValue(invoiceJson, String.class, "eleTicketNumber", "electronicTicketNum"))) {
            dynamicObject.set("ele_ticket_number", (Object)this.getJSONValue(invoiceJson, String.class, "eleTicketNumber", "electronicTicketNum"));
        }
        dynamicObject.set("id_number", (Object)this.getJSONValue(invoiceJson, String.class, "idNumber", "customerIdentityNum", "customeridentityNum"));
        dynamicObject.set("passenger_name", (Object)invoiceJson.getString("passengerName"));
        dynamicObject.set("detail_amount", (Object)invoiceJson.getBigDecimal("invoiceAmount"));
        dynamicObject.set("tax_rate", (Object)invoiceJson.getBigDecimal("taxRate"));
        dynamicObject.set("tax_amount", (Object)this.getJSONValue(invoiceJson, BigDecimal.class, "taxAmount", "totalTaxAmount"));
        dynamicObject.set("purchaser_name", (Object)this.getJSONStringValue(invoiceJson, "buyerName", "purchaserName"));
        dynamicObject.set("purch_unifie_soc_cre_code", (Object)this.getJSONValue(invoiceJson, String.class, "purchaserUnifiedSocialCreditCode", "buyerTaxNo"));
        dynamicObject.set("purchaser_addr_phone_num", (Object)invoiceJson.getString("purchaserAddressPhoneNum"));
        dynamicObject.set("purc_deposit_bank_acc", (Object)invoiceJson.getString("purchaserDepositBankAccNum"));
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), this.getJSONValue(invoiceJson, String.class, "sellerName", "salerName"))) {
            dynamicObject.set("seller_name", (Object)this.getJSONValue(invoiceJson, String.class, "sellerName", "salerName"));
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), this.getJSONValue(invoiceJson, String.class, "sellerUnifiedSocialCreditCode", "salerTaxNo"))) {
            dynamicObject.set("seller_unif_soc_cre_code", (Object)this.getJSONValue(invoiceJson, String.class, "sellerUnifiedSocialCreditCode", "salerTaxNo"));
        }
        dynamicObject.set("seller_addr_phone_num", (Object)invoiceJson.getString("sellerAddressPhoneNum"));
        dynamicObject.set("seller_deposit_bank_acc", (Object)invoiceJson.getString("sellerDepositBankAndAccountNum"));
        dynamicObject.set("original_invoice_no", (Object)invoiceJson.getString("originalInvoiceNo"));
        dynamicObject.set("remark", (Object)StringUtils.substring((String)invoiceJson.getString("remark"), (int)0, (int)300));
        String invoiceStatus = invoiceJson.getString("invoiceStatus");
        if (kd.bos.util.StringUtils.isEmpty((String)invoiceStatus)) {
            invoiceStatus = "0";
        }
        dynamicObject.set("invoice_status", (Object)invoiceStatus);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dynamicObject.getString("tax_recorded_status"))) {
            dynamicObject.set("tax_recorded_status", (Object)"01");
        }
        dynamicObject.set("drawer", (Object)invoiceJson.getString("drawer"));
        dynamicObject.set("remitter", (Object)invoiceJson.getString("remitter"));
        dynamicObject.set("payee", (Object)invoiceJson.getString("payee"));
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        String invoiceNo = invoiceJson.getString("invoiceNo");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceNoFilter});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invoiceDynamicObject;
    }
}

