/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.verify;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.constant.VerifyConstant;
import kd.imc.rim.common.invoice.verify.dto.VerifyItem;
import kd.imc.rim.common.invoice.verify.dto.VerifyQFilter;
import kd.imc.rim.common.invoice.verify.dto.VerifyResultDto;
import kd.imc.rim.common.service.InvoiceCollectEditService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.ScriptUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.tuple.Pair;

public class VerifyService {
    private static Log LOGGER = LogFactory.getLog(VerifyService.class);

    public static VerifyResultDto compare(VerifyItem item, Map<String, Object> param, Map<String, Object> invoiceMap) {
        List filterList = item.getFilterList();
        StringBuilder resutSb = new StringBuilder();
        String result = "false";
        Object invoiceValue = null;
        Object compareValue = null;
        JSONObject config = VerifyService.getVerfifyConfig(param);
        String ignore_special_char = config.getString("ignore_special_char") == null ? "" : config.getString("ignore_special_char");
        List<String> ignoreSpecialChar = Arrays.stream(ignore_special_char.split(",")).filter(f -> !"".equals(f)).collect(Collectors.toList());
        if (filterList.size() == 1) {
            VerifyQFilter filter = (VerifyQFilter)filterList.get(0);
            invoiceValue = VerifyService.getInvoiceValue(filter.getFilterName(), invoiceMap, filter.getProperty(), ignoreSpecialChar);
            compareValue = filter.getValue();
            if ("word_like".equals(filter.getCp())) {
                Pair<Boolean, String> pair = VerifyService.compareLike(invoiceValue, compareValue);
                result = ((Boolean)pair.getLeft()).toString();
                compareValue = pair.getRight();
            } else {
                result = VerifyService.compare(invoiceValue, filter.getCp(), compareValue, invoiceMap).toString();
            }
        } else if ("black_list".equals(item.getConfigType())) {
            ArrayList compareResult = new ArrayList(filterList.size());
            Object invoiceValueSalerName = invoiceMap.get("saler_name");
            for (VerifyQFilter filter : filterList) {
                invoiceValue = VerifyService.getInvoiceValue(filter.getFilterName(), invoiceMap, filter.getProperty());
                compareValue = filter.getValue();
                compareResult.add(VerifyService.compare(invoiceValue, filter.getCp(), compareValue, invoiceMap).toString());
            }
            result = "false";
            if (compareResult.contains("true")) {
                result = "true";
                invoiceValue = invoiceValueSalerName + " " + invoiceValue;
            }
        } else {
            for (VerifyQFilter filter : filterList) {
                if (StringUtils.isNotEmpty((CharSequence)filter.getLeftBracket())) {
                    resutSb.append(filter.getLeftBracket());
                }
                invoiceValue = VerifyService.getInvoiceValue(filter.getFilterName(), invoiceMap, filter.getProperty());
                compareValue = filter.getValue();
                resutSb.append(VerifyService.compare(invoiceValue, filter.getCp(), compareValue, invoiceMap));
                if (StringUtils.isNotEmpty((CharSequence)filter.getRightBracket())) {
                    resutSb.append(filter.getRightBracket());
                }
                if ("0".equals(filter.getLogic())) {
                    resutSb.append("&&");
                }
                if (!"1".equals(filter.getLogic())) continue;
                resutSb.append("||");
            }
            String resutlStr = resutSb.toString();
            if (resutlStr.endsWith("&&") || resutlStr.endsWith("||")) {
                resutlStr = resutlStr.substring(0, resutlStr.length() - 2);
            }
            try {
                LOGGER.info("compare_scriptEngine:" + resutlStr);
                result = ScriptUtils.eval((String)resutlStr).toString();
            }
            catch (Exception e) {
                LOGGER.error("compare\u5f02\u5e38:" + resutlStr + e);
                result = "false";
            }
        }
        result = VerifyService.secondCompare(result, item, invoiceMap);
        if ("filetype_config".equals(item.getConfigType()) || "e_rec_check_compare".equals(item.getConfigType())) {
            result = "true";
        }
        if ("true".equals(result)) {
            VerifyResultDto dto = new VerifyResultDto(item.getConfigType(), item.getConfig());
            dto.setKey(item.getKey());
            if ("buyer_name".equals(item.getConfigType()) && StringUtils.isNotBlank((Object)param.get("originalBuyerName"))) {
                compareValue = param.get("originalBuyerName");
            }
            VerifyService.setMsg(dto, invoiceValue, VerifyService.dealCompareValue(item, compareValue), invoiceMap);
            if ("repeat_expense".equals(item.getConfigType())) {
                Boolean flag = VerifyService.queryExpenseNum(param, invoiceMap, dto);
                if (!flag.booleanValue()) {
                    return null;
                }
            } else if ("custom_config".equals(item.getConfigType()) || "filetype_config".equals(item.getConfigType()) || "e_rec_check_compare".equals(item.getConfigType())) {
                dto.setName(item.getName());
                dto.setMsg(item.getMsg());
            }
            return dto;
        }
        return null;
    }

    private static String secondCompare(String firstResult, VerifyItem item, Map<String, Object> invoiceMap) {
        if ("buyer_name_and_tax_no".equals(item.getConfigType())) {
            try {
                Object nameKey = VerifyService.getInvoiceValue("buyer_name_and_tax_no", invoiceMap, "");
                if (item.getExtParam() != null && nameKey != null) {
                    Map usedNameMap = (Map)item.getExtParam();
                    Object invoiceDate = invoiceMap.get("invoice_date");
                    Date date = (Date)usedNameMap.get(nameKey);
                    if (date == null || invoiceDate == null) {
                        return firstResult;
                    }
                    if (date.compareTo((Date)invoiceDate) >= 0) {
                        return firstResult;
                    }
                    return "true";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return firstResult;
    }

    private static Object dealCompareValue(VerifyItem item, Object compareValue) {
        if (item.getExtParam() != null && "buyer_name_and_tax_no".equals(item.getConfigType())) {
            ArrayList<String> newList = new ArrayList<String>(8);
            List nameList = (List)compareValue;
            Map usedNameMap = (Map)item.getExtParam();
            for (String name : nameList) {
                if (usedNameMap.containsKey(name)) continue;
                newList.add(name);
            }
            return newList;
        }
        return compareValue;
    }

    public static JSONArray verifySequenceNo(Map<String, Object> customParam, JSONArray dataJson) {
        String serialNo;
        JSONObject invoice;
        int i;
        JSONObject invoiceMap = new JSONObject(dataJson.size());
        for (i = 0; i < dataJson.size(); ++i) {
            invoice = dataJson.getJSONObject(i);
            serialNo = StringUtils.trimToEmpty((String)VerifyService.verifySequenceNoGetValue(invoice, "serialNo", "serial_no"));
            invoiceMap.put(serialNo, (Object)invoice);
        }
        invoiceMap = VerifyService.verifySequenceNo(customParam, invoiceMap);
        for (i = 0; i < dataJson.size(); ++i) {
            invoice = dataJson.getJSONObject(i);
            serialNo = StringUtils.trimToEmpty((String)VerifyService.verifySequenceNoGetValue(invoice, "serialNo", "serial_no"));
            dataJson.set(i, invoiceMap.get((Object)serialNo));
        }
        return dataJson;
    }

    private static String verifySequenceNoGetValue(JSONObject invoice, String key1, String key2) {
        String val = invoice.getString(key1);
        if (StringUtils.isEmpty((CharSequence)val) || "null".equals(val)) {
            val = invoice.getString(key2);
        }
        if (!StringUtils.isEmpty((CharSequence)val) && val.length() > 2 && "invoiceType".equals(key1)) {
            return InputInvoiceTypeEnum.getAwsType(val);
        }
        return val;
    }

    public static JSONObject verifySequenceNo(Map<String, Object> customParam, JSONObject dataJson) {
        JSONObject config = VerifyService.getVerfifyConfig(customParam);
        if (config != null) {
            String configValue = config.getString("sequence_no");
            String seqinvoiceType = config.getString("sequence_type");
            if (StringUtils.isNotEmpty((CharSequence)seqinvoiceType) && StringUtils.isNotEmpty((CharSequence)configValue) && !"3".equals(configValue)) {
                Integer seqinvoiceSize = config.getInteger("sequence_size");
                if (seqinvoiceSize == null) {
                    seqinvoiceSize = 1;
                }
                Iterator it = dataJson.keySet().iterator();
                ArrayList existInvoiceList = new ArrayList(dataJson.size());
                ArrayList<Map> afterFirstCheckInvoiceList = new ArrayList<Map>(dataJson.size());
                HashMap<String, String> existMap = new HashMap<String, String>(dataJson.size());
                while (it.hasNext()) {
                    String serialNo = (String)it.next();
                    JSONObject invoice = dataJson.getJSONObject(serialNo);
                    if ("1".equals(invoice.getString("notInDB"))) continue;
                    String invoiceCode = StringUtils.trimToEmpty((String)VerifyService.verifySequenceNoGetValue(invoice, "invoiceCode", "invoice_code"));
                    String string = VerifyService.verifySequenceNoGetValue(invoice, "invoiceNo", "invoice_no");
                    String invoiceType = VerifyService.verifySequenceNoGetValue(invoice, "invoiceType", "invoice_type");
                    if (seqinvoiceType.indexOf(String.format(",%s,", invoiceType)) < 0) continue;
                    HashMap<String, Object> invoiceInfo = new HashMap<String, Object>(8);
                    String invoiceKey = invoiceType + (String)invoiceCode + string;
                    invoiceInfo.put("invoiceCode", invoiceCode);
                    invoiceInfo.put("invoiceNo", string);
                    invoiceInfo.put("invoiceType", invoiceType);
                    invoiceInfo.put("invoiceKey", invoiceKey);
                    invoiceInfo.put("serialNo", serialNo);
                    List<String> list = VerifyService.getSequenceNoList(string, seqinvoiceSize);
                    if (list == null || list.isEmpty()) continue;
                    invoiceInfo.put("seqNoList", list);
                    existInvoiceList.add(invoiceInfo);
                    existMap.put(invoiceKey, serialNo);
                }
                HashMap<String, List<String>> queryInvoiceMap = new HashMap<String, List<String>>(dataJson.size());
                HashMap<String, List<Map<String, String>>> seqInvoiceMap = new HashMap<String, List<Map<String, String>>>(dataJson.size());
                for (Map map : existInvoiceList) {
                    VerifyService.setVerifySequenceNoResult(map, configValue, existMap, dataJson, seqInvoiceMap, "1");
                    List seqNolist = (List)map.get("seqNoList");
                    String code = map.get("invoiceType").toString() + '|' + map.get("invoiceCode");
                    ArrayList list = (ArrayList)queryInvoiceMap.get(code);
                    if (list == null) {
                        list = new ArrayList(seqNolist.size());
                    }
                    list.addAll(seqNolist);
                    queryInvoiceMap.put(code, list);
                    afterFirstCheckInvoiceList.add(map);
                }
                if (!afterFirstCheckInvoiceList.isEmpty()) {
                    Map<String, String> invocieMap = VerifyService.querySequenceNo(queryInvoiceMap);
                    for (Map map : afterFirstCheckInvoiceList) {
                        VerifyService.setVerifySequenceNoResult(map, configValue, invocieMap, dataJson, seqInvoiceMap, "2");
                    }
                }
                VerifyService.setVerifySequenceNoResultMsg(customParam, dataJson, seqInvoiceMap, configValue);
            }
        }
        return dataJson;
    }

    private static Map<String, String> querySerialExpense(Map<String, List<Map<String, String>>> seqInvoiceMap, Map<String, Object> customParam) {
        ArrayList<String> seqNoList = new ArrayList<String>(seqInvoiceMap.size());
        for (Map.Entry<String, List<Map<String, String>>> entry : seqInvoiceMap.entrySet()) {
            List<Map<String, String>> mapList = entry.getValue();
            for (Map<String, String> map : mapList) {
                if (!"2".equals(map.get("seqType"))) continue;
                seqNoList.add(map.get("serialNo"));
            }
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(seqNoList.size());
        if (!seqNoList.isEmpty()) {
            QFilter filter = new QFilter("serial_no", "in", seqNoList);
            QFilter statusfilter = new QFilter("status", "in", (Object)ExpenseConstant.getUsedStatus());
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_num,expense_id,status,serial_no,reimbursingid,resource", (QFilter[])new QFilter[]{filter, statusfilter});
            String billId = String.valueOf(customParam.get("billId"));
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                HashMap expenseMap = new HashMap(collection.size());
                for (DynamicObject expense : collection) {
                    String serialNo = expense.getString("serial_no");
                    LinkedHashSet<String> list = (LinkedHashSet<String>)expenseMap.get(serialNo);
                    if (list == null) {
                        list = new LinkedHashSet<String>(4);
                    }
                    String expenseId = expense.getString("expense_id");
                    String reimbursingid = expense.getString("reimbursingid");
                    String resource = expense.getString("resource");
                    if ("aws".equals(resource) && billId.equals(reimbursingid) || billId.equals(expenseId)) continue;
                    list.add(expense.getString("expense_num"));
                    expenseMap.put(serialNo, list);
                }
                for (Map.Entry entry : expenseMap.entrySet()) {
                    resultMap.put((String)entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue()));
                }
            }
        }
        return resultMap;
    }

    public static Map<String, Map<String, Object>> queryExpenseInfo(List<String> serialNoList, Map<String, BigDecimal> invoiceTotalMap, Map<String, Object> param) {
        HashMap<String, Map<String, Object>> expenseMap = new HashMap<String, Map<String, Object>>(serialNoList.size());
        if (serialNoList != null && !serialNoList.isEmpty()) {
            String billId = StringUtils.trimToEmpty((String)((String)param.get("billId")));
            if (StringUtils.isBlank((CharSequence)billId)) {
                VerifyService.getCalCulateResult(serialNoList, invoiceTotalMap, expenseMap);
                return expenseMap;
            }
            QFilter filter = new QFilter("serial_no", "in", serialNoList);
            QFilter statusfilter = new QFilter("status", "in", (Object)ExpenseConstant.getUsedStatus());
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_num,expense_id,status,entityid,expense_amount,serial_no,reimbursingid,resource,use_type,groupid", (QFilter[])new QFilter[]{filter, statusfilter}, (String)"id desc");
            HashSet<String> expenseIdSet = new HashSet<String>(8);
            collection.forEach(expense -> expenseIdSet.add(expense.getString("expense_id")));
            Map<String, Map<String, String>> userMap = VerifyService.queryExpenseUser(expenseIdSet);
            List relevanceExpenseId = (List)param.get("relevanceExpenseId");
            HashSet ignoreExpenseSet = new HashSet(8);
            if (relevanceExpenseId != null) {
                relevanceExpenseId.forEach(t -> {
                    if (t != null) {
                        ignoreExpenseSet.add(t.toString());
                    }
                });
            }
            for (DynamicObject expense2 : collection) {
                ArrayList<Map<String, Object>> billList;
                String expenseId = expense2.getString("expense_id");
                String expenseNum = expense2.getString("expense_num");
                String reimbursingid = expense2.getString("reimbursingid");
                String resource = expense2.getString("resource");
                if ("aws".equals(resource) && StringUtils.equals((CharSequence)billId, (CharSequence)reimbursingid) || billId.equals(expenseId) || ignoreExpenseSet.contains(expenseId)) continue;
                String serialNo = expense2.getString("serial_no");
                HashMap<String, Serializable> map = (HashMap<String, Serializable>)expenseMap.get(serialNo);
                if (map == null) {
                    map = new HashMap<String, Serializable>(4);
                }
                if ((billList = (ArrayList<Map<String, Object>>)map.get("expenseBillList")) == null) {
                    billList = new ArrayList<Map<String, Object>>(2);
                }
                Map<String, Object> expenseRelationMap = DynamicObjectUtil.dynamicObject2Map(expense2);
                Map<String, String> userInfo = userMap.get(expenseId + expenseNum);
                if (userInfo != null) {
                    expenseRelationMap.put("showUserName", userInfo.get("showUserName"));
                }
                billList.add(expenseRelationMap);
                map.put("expenseBillList", billList);
                BigDecimal expenseAmount = expense2.getBigDecimal("expense_amount");
                BigDecimal totalAmount = invoiceTotalMap.get(serialNo);
                BigDecimal totalUsedAmount = (BigDecimal)map.get("usedAmount");
                if (totalUsedAmount == null) {
                    totalUsedAmount = BigDecimal.ZERO;
                }
                if (totalAmount == null) {
                    totalAmount = BigDecimal.ZERO;
                }
                totalUsedAmount = 1 == expense2.getInt("use_type") ? totalUsedAmount.add(expenseAmount) : totalAmount;
                if (totalAmount.abs().compareTo(totalUsedAmount.abs()) >= 0) {
                    map.put("usedAmount", totalUsedAmount);
                    map.put("availableAmount", totalAmount.subtract(totalUsedAmount));
                } else {
                    map.put("usedAmount", BigDecimal.ZERO);
                    map.put("availableAmount", BigDecimal.ZERO);
                }
                expenseMap.put(serialNo, map);
            }
        }
        VerifyService.getCalCulateResult(serialNoList, invoiceTotalMap, expenseMap);
        return expenseMap;
    }

    private static void getCalCulateResult(List<String> serialNoList, Map<String, BigDecimal> invoiceTotalMap, Map<String, Map<String, Object>> expenseMap) {
        for (String serialNo : serialNoList) {
            Map<String, Object> map = expenseMap.get(serialNo);
            if (map != null) continue;
            map = new HashMap<String, Object>(4);
            BigDecimal totalAmount = invoiceTotalMap.get(serialNo);
            map.put("usedAmount", BigDecimal.ZERO);
            map.put("availableAmount", totalAmount);
            expenseMap.put(serialNo, map);
        }
    }

    private static Map<String, Map<String, String>> queryExpenseUser(Set<String> expenseIdSet) {
        HashMap<String, Map<String, String>> expenseUserMap = new HashMap<String, Map<String, String>>(expenseIdSet.size());
        if (expenseIdSet.size() < 1) {
            return expenseUserMap;
        }
        String showAllName = ImcConfigUtil.getValue("rim_config", "show_all_name");
        QFilter expenseIdFilte = new QFilter("expense_id", "in", expenseIdSet);
        DynamicObjectCollection expenseInfoCollect = QueryServiceHelper.query((String)"rim_expense", (String)"expense_id,expense_num,creator_id,creator_name", (QFilter[])new QFilter[]{expenseIdFilte});
        List creatorIds = expenseInfoCollect.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getString("creator_id"))).map(v -> Long.parseLong(v.getString("creator_id"))).collect(Collectors.toList());
        List creatorUserInfoList = UserServiceHelper.get(creatorIds);
        Map<Object, Object> userIdNameMap = null;
        userIdNameMap = !CollectionUtils.isEmpty((Collection)creatorUserInfoList) ? creatorUserInfoList.stream().collect(Collectors.toMap(v -> (Long)v.get("id"), v -> (OrmLocaleValue)v.get("name"))) : new HashMap(1);
        for (DynamicObject obj : expenseInfoCollect) {
            String expenseUserName;
            HashMap<String, String> expenseMap = new HashMap<String, String>();
            String expenseId = obj.getString("expense_id");
            String expenseNum = obj.getString("expense_num");
            String creatorName = obj.getString("creator_name");
            String creator_id = obj.getString("creator_id");
            Long userId = BigDecimalUtil.transDecimal(creator_id).longValue();
            expenseMap.put("userId", userId.toString());
            OrmLocaleValue val = (OrmLocaleValue)userIdNameMap.get(userId);
            if (StringUtils.isNotBlank((CharSequence)creatorName)) {
                expenseUserName = VerifyService.getExpenseUser(showAllName, creatorName);
                expenseMap.put("userName", creatorName);
                expenseMap.put("showUserName", expenseUserName);
            } else if (val != null) {
                expenseUserName = VerifyService.getExpenseUser(showAllName, val.getLocaleValue());
                expenseMap.put("userName", val.getLocaleValue());
                expenseMap.put("showUserName", expenseUserName);
            } else {
                expenseMap.put("userName", "");
                expenseMap.put("showUserName", "");
            }
            expenseUserMap.put(expenseId + expenseNum, expenseMap);
        }
        return expenseUserMap;
    }

    private static Map<String, String> querySequenceNo(Map<String, List<String>> queryInvoiceMap) {
        long start = System.currentTimeMillis();
        HashMap<String, String> invocieMap = new HashMap<String, String>(16);
        String selectSql = "select fserial_no,finvoice_code,finvoice_no,finvoice_type from t_rim_invoice where fdelete='1' and fexpense_status in('30','60','65','70') and (";
        StringBuilder whereSql = new StringBuilder();
        whereSql.append(selectSql);
        int i = 0;
        int dbTimes = 0;
        for (Map.Entry<String, List<String>> entry : queryInvoiceMap.entrySet()) {
            int splitIndex = entry.getKey().indexOf(124);
            String invoiceTypeAws = entry.getKey().substring(0, splitIndex);
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceTypeAws);
            String invoiceCode = entry.getKey().substring(splitIndex + 1);
            if (i > 0) {
                whereSql.append(" or ");
            }
            whereSql.append(" ( finvoice_type=").append(invoiceType);
            whereSql.append(" and finvoice_code='").append(StringUtils.isEmpty((CharSequence)invoiceCode) ? Character.valueOf(' ') : invoiceCode).append("'");
            whereSql.append(" and finvoice_no in(").append(DBUtils.getSqlCondition(entry.getValue())).append("))");
            if ((i += entry.getValue().size()) <= 30) continue;
            whereSql.append(')');
            List<Map<String, Object>> queryList = DBUtils.query(whereSql.toString());
            for (Map<String, Object> invoice : queryList) {
                invocieMap.put(InputInvoiceTypeEnum.getAwsType(invoice.get("FINVOICE_TYPE")) + StringUtils.trimToEmpty((String)((String)invoice.get("FINVOICE_CODE"))) + invoice.get("FINVOICE_NO"), (String)invoice.get("FSERIAL_NO"));
            }
            i = 0;
            whereSql = new StringBuilder();
            whereSql.append(selectSql);
            ++dbTimes;
        }
        if (i > 0) {
            whereSql.append(')');
            List<Map<String, Object>> queryList = DBUtils.query(whereSql.toString());
            for (Map<String, Object> invoice : queryList) {
                invocieMap.put(InputInvoiceTypeEnum.getAwsType(invoice.get("FINVOICE_TYPE")) + StringUtils.trimToEmpty((String)((String)invoice.get("FINVOICE_CODE"))) + invoice.get("FINVOICE_NO"), (String)invoice.get("FSERIAL_NO"));
            }
            ++dbTimes;
        }
        LOGGER.info("\u8fde\u53f7\u5224\u65ad\u67e5\u8be2\u6b21\u6570{},\u8017\u65f6{}", (Object)dbTimes, (Object)(System.currentTimeMillis() - start));
        return invocieMap;
    }

    private static boolean setVerifySequenceNoResult(Map<String, Object> invoiceInfo, String configValue, Map<String, String> existMap, JSONObject dataJson, Map<String, List<Map<String, String>>> seqInvoiceMap, String seqType) {
        List seqNolist = (List)invoiceInfo.get("seqNoList");
        boolean isSeq = false;
        String serialNo = (String)invoiceInfo.get("serialNo");
        ArrayList seqList = new ArrayList(seqNolist.size());
        for (String no : seqNolist) {
            String invoiceCode = invoiceInfo.get("invoiceCode").toString();
            String sqno = existMap.get(invoiceInfo.get("invoiceType").toString() + invoiceCode + no);
            if (sqno == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("serialNo", sqno);
            map.put("invoiceCode", invoiceCode);
            map.put("invoiceNo", no);
            map.put("seqType", seqType);
            seqList.add(map);
            isSeq = true;
        }
        if (!seqList.isEmpty()) {
            List<Map<String, String>> exist = seqInvoiceMap.get(serialNo);
            if (exist != null) {
                exist.addAll(seqList);
                seqInvoiceMap.put(serialNo, exist);
            } else {
                seqInvoiceMap.put(serialNo, seqList);
            }
        }
        return isSeq;
    }

    private static void setVerifySequenceNoResultMsg(Map<String, Object> customParam, JSONObject dataJson, Map<String, List<Map<String, String>>> seqInvoiceMap, String configValue) {
        Map<String, String> expenseMap = VerifyService.querySerialExpense(seqInvoiceMap, customParam);
        for (String serialNo : dataJson.keySet()) {
            JSONObject invoice = dataJson.getJSONObject(serialNo);
            if ("1".equals(invoice.getString("notInDB"))) continue;
            String level = invoice.getString("errorLevel");
            if (StringUtils.isEmpty((CharSequence)level)) {
                level = "3";
            }
            JSONArray array = invoice.getJSONArray("verifyResult");
            int index = -1;
            if (!CollectionUtils.isEmpty((Collection)array)) {
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject verifyResult = array.getJSONObject(i);
                    if (!"sequence_no".equals(verifyResult.getString("configType"))) continue;
                    index = i;
                    break;
                }
            }
            List<Map<String, String>> seqList = seqInvoiceMap.get(serialNo);
            boolean isseq = false;
            if (seqList != null) {
                VerifyResultDto dto = new VerifyResultDto("sequence_no", configValue, "sequenceNum");
                VerifyService.setMsg(dto, null, null, new HashMap<String, Object>(1));
                StringBuilder msg1 = new StringBuilder();
                StringBuilder msg2 = new StringBuilder();
                ArrayList<JSONObject> array1 = new ArrayList<JSONObject>(4);
                int idx = 0;
                for (Map<String, String> map : seqList) {
                    JSONObject json;
                    String expenseNo;
                    if ("1".equals(map.get("seqType"))) {
                        if (msg1.length() < 1) {
                            msg1.append(ResManager.loadKDString((String)"\u672c\u5355\u5185\u5b58\u5728\u8fde\u53f7\u53d1\u7968\uff1a  ", (String)"VerifyService_0", (String)"imc-rim-common", (Object[])new Object[0])).append(map.get("invoiceNo"));
                        } else {
                            msg1.append(',').append(map.get("invoiceNo"));
                        }
                        isseq = true;
                    }
                    if (!"2".equals(map.get("seqType")) || StringUtils.isEmpty((CharSequence)(expenseNo = expenseMap.get(map.get("serialNo"))))) continue;
                    if (array1.size() == 0) {
                        json = new JSONObject();
                        json.put("msg", (Object)ResManager.loadKDString((String)"\u5176\u4ed6\u5355\u636e\u5b58\u5728\u8fde\u53f7\u53d1\u7968\uff1a", (String)"VerifyService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                        array1.add(json);
                        msg2.append(ResManager.loadKDString((String)"\u5176\u4ed6\u5355\u636e\u5b58\u5728\u8fde\u53f7\u53d1\u7968\uff1a", (String)"VerifyService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                    json = new JSONObject();
                    StringBuilder mm = new StringBuilder();
                    String msg = String.format(ResManager.loadKDString((String)" %1$s.\u53d1\u7968%2$s,\u5355\u636e(%3$s)", (String)"VerifyService_54", (String)"imc-rim-common", (Object[])new Object[0]), ++idx, map.get("invoiceNo"), expenseNo);
                    mm.append(msg);
                    msg2.append((CharSequence)mm);
                    json.put("msg", (Object)mm.toString());
                    array1.add(json);
                    isseq = true;
                }
                if (msg1.length() > 10) {
                    JSONObject json = new JSONObject();
                    json.put("msg", (Object)msg1.toString());
                    array1.add(0, json);
                }
                if (isseq) {
                    String mmsg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u8fde\u53f7,%1$s%2$s", (String)"VerifyService_55", (String)"imc-rim-common", (Object[])new Object[0]), msg1.toString(), msg2.toString());
                    dto.setMsg(mmsg);
                    dto.setHtmlMsg(VerifyService.getResultHtmlByJsonItem(array1));
                    array.set(index, (Object)dto);
                } else if (index > -1) {
                    array.remove(index);
                }
            } else if (index > -1) {
                array.remove(index);
            }
            if (!CollectionUtils.isEmpty((Collection)array)) {
                level = "3";
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject verifyResult = array.getJSONObject(i);
                    String config = verifyResult.getString("config");
                    if (Integer.parseInt(config) >= Integer.parseInt(level)) continue;
                    level = config;
                }
            }
            invoice.put("errorLevel", (Object)level);
            invoice.put("verifyResult", (Object)array);
            invoice.put("validateMessage", (Object)VerifyService.getResultMsg(array));
            invoice.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(array));
        }
    }

    public static JSONObject getVerfifyConfig(Map<String, Object> param) {
        Object id = VerifyService.getConfigId(param);
        JSONObject config = new JSONObject();
        if (id != null) {
            String fileTypeConfig;
            String customConfig;
            DynamicObjectCollection sensitiveWordsList;
            DynamicObjectCollection blackList;
            DynamicObject configObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"rim_verify");
            String base_config = configObject.getString("base_config");
            if (StringUtils.isNotEmpty((CharSequence)base_config)) {
                JSONObject json = JSONObject.parseObject((String)base_config);
                config.putAll((Map)json);
            }
            if (!CollectionUtils.isEmpty((Collection)(blackList = QueryServiceHelper.query((String)"bdm_blacklist_config", (String)"number,name", (QFilter[])new QFilter[0])))) {
                ArrayList<String> blackListWords = new ArrayList<String>(blackList.size());
                ArrayList<String> blackListTaxnos = new ArrayList<String>(blackList.size());
                for (DynamicObject blackListObj : blackList) {
                    blackListWords.add(VerifyService.trimBlackListSpecialSymbol(blackListObj.getString("name")));
                    blackListTaxnos.add(blackListObj.getString("number"));
                }
                config.put("black_list_value", blackListWords);
                config.put("black_list_taxno", blackListTaxnos);
            }
            if (!CollectionUtils.isEmpty((Collection)(sensitiveWordsList = QueryServiceHelper.query((String)"bdm_sensitive_wordlist", (String)"name", (QFilter[])new QFilter[0])))) {
                ArrayList<String> sensitiveWords = new ArrayList<String>(sensitiveWordsList.size());
                for (DynamicObject sensitiveWord : sensitiveWordsList) {
                    sensitiveWords.add(sensitiveWord.getString("name"));
                }
                config.put("sensitive_word_value", sensitiveWords);
            }
            if (StringUtils.isNotEmpty((CharSequence)(customConfig = configObject.getString("custom_config_tag")))) {
                config.put("custom_config", (Object)customConfig);
            }
            if (StringUtils.isNotEmpty((CharSequence)(fileTypeConfig = configObject.getString("filetype_config_tag")))) {
                config.put("filetype_config", (Object)fileTypeConfig);
            }
        } else {
            config.put("repeat_expense", (Object)"0");
            config.put("buyer_name", (Object)"0");
            config.put("buyer_tax_no", (Object)"0");
            config.put("check_status", (Object)"0");
        }
        return config;
    }

    private static Object getConfigId(Map<String, Object> param) {
        QFilter filter = new QFilter("scope", "=", (Object)"1");
        QFilter statusfilter = new QFilter("status", "=", (Object)"1");
        BigDecimal bigDecimal = BigDecimalUtil.transDecimal(param.get("orgId"));
        Long orgId = null;
        orgId = bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? Long.valueOf(bigDecimal.longValue()) : Long.valueOf(RequestContext.get().getOrgId());
        filter = filter.or(new QFilter("org_entry.org", "=", (Object)orgId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_verify", (String)"id,scope,org_entry.org as org,bill_type", (QFilter[])new QFilter[]{statusfilter, filter});
        Object id = null;
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            String paramBillType = "," + param.get("billType") + ",";
            Integer level = 0;
            for (DynamicObject obj : collection) {
                String configBillType = null;
                configBillType = StringUtils.isEmpty((CharSequence)obj.getString("bill_type")) ? "" : "," + obj.getString("bill_type") + ",";
                String scope = obj.getString("scope");
                Integer templevel = VerifyService.getLevel(scope, configBillType, paramBillType, orgId, DynamicObjectUtil.getDynamicObjectLongValue(obj.get("org")));
                if (templevel <= level) continue;
                id = obj.get("id");
                level = templevel;
            }
            if (id == null) {
                id = ((DynamicObject)collection.get(0)).get("id");
            }
        }
        LOGGER.info("\u83b7\u53d6\u5408\u89c4\u6027\u6821\u9a8c\u89c4\u5219\u7ec4\u7ec7:{},\u5355\u636e\u7c7b\u578b:{},\u89c4\u5219:{}", new Object[]{orgId, param.get("billType"), id});
        return id;
    }

    private static Integer getLevel(String scope, String configBillType, String paramBillType, Object configOrg, Object paramOrg) {
        if ("1".equals(scope)) {
            if (StringUtils.isEmpty((CharSequence)configBillType)) {
                return 13;
            }
            if (StringUtils.isNotEmpty((CharSequence)paramBillType) && configBillType.indexOf(paramBillType) >= 0) {
                return 15;
            }
            return 10;
        }
        if (paramOrg.equals(configOrg)) {
            if (StringUtils.isEmpty((CharSequence)configBillType)) {
                return 23;
            }
            if (StringUtils.isNotEmpty((CharSequence)paramBillType) && configBillType.indexOf(paramBillType) >= 0) {
                return 25;
            }
            return 9;
        }
        return 1;
    }

    public static List<VerifyItem> getVerifyItem(JSONObject config, Map<String, Object> param, Map<String, Object> invoiceMap) {
        boolean typeFlag;
        boolean defaultFlag;
        ArrayList<VerifyItem> list = new ArrayList<VerifyItem>(16);
        Set keySet = config.keySet();
        Iterator it = keySet.iterator();
        Long invoiceType = (Long)invoiceMap.get("invoice_type");
        Date currentDate = new Date();
        boolean isMulNameAndTax = false;
        boolean isMulSalerNameAndTax = false;
        Map<String, Date> usedNameMap = null;
        String name_invoice_type = config.getString("name_invoice_type") == null ? "" : config.getString("name_invoice_type");
        String taxno_invoice_type = config.getString("taxno_invoice_type") == null ? "" : config.getString("taxno_invoice_type");
        String ignore_special_char = config.getString("ignore_special_char") == null ? "" : config.getString("ignore_special_char");
        List nameInvoiceType = Arrays.stream(name_invoice_type.split(",")).filter(f -> !"".equals(f)).collect(Collectors.toList());
        List<String> ignoreSpecialChar = Arrays.stream(ignore_special_char.split(",")).filter(f -> !"".equals(f)).collect(Collectors.toList());
        List taxnoInvoiceType = Arrays.stream(taxno_invoice_type.split(",")).filter(f -> !"".equals(f)).collect(Collectors.toList());
        boolean bl = defaultFlag = InputInvoiceTypeEnum.needCheck(invoiceType) != false && !InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType);
        if (nameInvoiceType.size() == 0 && taxnoInvoiceType.size() == 0) {
            typeFlag = defaultFlag;
        } else {
            boolean bl2 = typeFlag = nameInvoiceType.contains(InputInvoiceTypeEnum.getAwsType(invoiceType)) || taxnoInvoiceType.contains(InputInvoiceTypeEnum.getAwsType(invoiceType));
        }
        while (it.hasNext()) {
            Object endExpneseDate;
            VerifyQFilter filter;
            Boolean personFlag;
            String verifyType = (String)it.next();
            String configValue = config.getString(verifyType);
            VerifyItem item = new VerifyItem(verifyType, configValue);
            if (("buyer_name".equals(verifyType) || "buyer_tax_no".equals(verifyType)) && (personFlag = (Boolean)invoiceMap.get("personFlag")) != null && !personFlag.booleanValue() && typeFlag && !isMulNameAndTax) {
                List<Object> buyerName = VerifyService.changeToList(param.get("buyer_name"), ignoreSpecialChar);
                List<Object> buyerTaxNo = VerifyService.changeToList(param.get("buyer_tax_no"));
                if (usedNameMap == null) {
                    usedNameMap = VerifyService.queryUsedName(buyerTaxNo, buyerName, ignoreSpecialChar);
                }
                if (buyerName.size() > 1 || buyerTaxNo.size() > 1) {
                    isMulNameAndTax = true;
                }
                if (!usedNameMap.isEmpty()) {
                    isMulNameAndTax = true;
                }
                if (isMulNameAndTax) {
                    List<String> buyerNameAndTaxNoList = VerifyService.concatNameAndTaxNo(VerifyService.trimCompanyName(param.get("buyer_name"), ignoreSpecialChar), VerifyService.trimCompanyName(param.get("buyer_tax_no")));
                    for (Map.Entry<String, Date> entry : usedNameMap.entrySet()) {
                        buyerNameAndTaxNoList.add(entry.getKey());
                    }
                    item.setConfigType("buyer_name_and_tax_no");
                    String configBuyerTaxNoLevel = config.getString("buyer_tax_no");
                    String configBuyerNameLevel = config.getString("buyer_name");
                    ArrayList levelList = Lists.newArrayList((Object[])new String[]{"0", "1", "2", "3"});
                    Iterator iterator = levelList.iterator();
                    while (iterator.hasNext()) {
                        String level = (String)iterator.next();
                        if (!StringUtils.equals((CharSequence)configBuyerTaxNoLevel, (CharSequence)level) && !StringUtils.equals((CharSequence)configBuyerNameLevel, (CharSequence)level)) continue;
                        item.setConfig(level);
                        break;
                    }
                    VerifyQFilter filter2 = new VerifyQFilter("buyer_name_and_tax_no", CompareTypeEnum.NOTIN.getId(), buyerNameAndTaxNoList);
                    filter2.setFilterName("buyer_name_and_tax_no");
                    item.addFilter(filter2);
                    item.setExtParam(usedNameMap);
                } else if ("buyer_name".equals(verifyType)) {
                    if (nameInvoiceType.size() == 0 && defaultFlag || nameInvoiceType.contains(InputInvoiceTypeEnum.getAwsType(invoiceType))) {
                        VerifyQFilter filter3 = new VerifyQFilter("buyer_name", CompareTypeEnum.NOTIN.getId(), VerifyService.trimCompanyName(param.get("buyer_name"), ignoreSpecialChar));
                        filter3.setFilterName("buyer_name");
                        item.addFilter(filter3);
                    }
                } else if ("buyer_tax_no".equals(verifyType) && (taxnoInvoiceType.size() == 0 && defaultFlag || taxnoInvoiceType.contains(InputInvoiceTypeEnum.getAwsType(invoiceType)))) {
                    VerifyQFilter filter4 = new VerifyQFilter("buyer_tax_no", CompareTypeEnum.NOTIN.getId(), VerifyService.trimCompanyName(param.get("buyer_tax_no")));
                    filter4.setFilterName("buyer_tax_no");
                    item.addFilter(filter4);
                }
            }
            if (InputInvoiceTypeEnum.needCheck(invoiceType).booleanValue()) {
                if ("check_status".equals(verifyType)) {
                    item.addFilter(new VerifyQFilter("check_status", CompareTypeEnum.NOTIN.getId(), (Object)CheckContant.getSuccessStatus()));
                } else if ("invalid_invoice".equals(verifyType)) {
                    item.addFilter(new VerifyQFilter("invoice_status", CompareTypeEnum.EQUAL.getId(), (Object)"2"));
                } else if ("red_invoice".equals(verifyType)) {
                    item.addFilter(new VerifyQFilter("invoice_status", CompareTypeEnum.IN.getId(), (Object)new String[]{"3", "8", "7", "6"}));
                } else if ("black_list".equals(verifyType)) {
                    VerifyQFilter blackListName = new VerifyQFilter("saler_name", CompareTypeEnum.IN.getId(), config.get((Object)"black_list_value"));
                    blackListName.setFilterName("saler_name");
                    item.addFilter(blackListName);
                    item.addFilter(new VerifyQFilter("saler_tax_no", CompareTypeEnum.IN.getId(), config.get((Object)"black_list_taxno")));
                } else if ("tax_blacklist".equals(verifyType)) {
                    String taxBlackList = (String)invoiceMap.get("tax_blacklist");
                    if (StringUtils.isNotBlank((CharSequence)taxBlackList)) {
                        item.addFilter(new VerifyQFilter("tax_blacklist", CompareTypeEnum.ISNOTNULL.getId(), (Object)"1"));
                    }
                } else if ("original_state".equals(verifyType)) {
                    String invoiceCode = (String)invoiceMap.get("invoice_code");
                    String invoiceNo = (String)invoiceMap.get("invoice_no");
                    boolean isBlockChainType = InvoiceConvertUtils.isBlockChainType(invoiceCode, invoiceNo);
                    boolean isYunnanChainType = InvoiceConvertUtils.isYunNanBlockchain(invoiceCode, invoiceNo);
                    if (InputInvoiceTypeEnum.isCheckOriginalFile(invoiceType)) {
                        if (!isBlockChainType && !isYunnanChainType) {
                            item.addFilter(new VerifyQFilter("original_state", CompareTypeEnum.NOTEQUAL.getId(), (Object)"1"));
                        }
                    } else if (InputInvoiceTypeEnum.isEleByAwsType(InputInvoiceTypeEnum.getAwsType(invoiceType)).booleanValue()) {
                        continue;
                    }
                } else if ("sensitive_word".equals(verifyType)) {
                    item.addFilter(new VerifyQFilter("items.goods_name", "word_like", config.get((Object)"sensitive_word_value")));
                } else if (!(!"saler_name".equals(verifyType) && !"saler_tax_no".equals(verifyType) || InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType) || isMulSalerNameAndTax)) {
                    VerifyQFilter filter5;
                    List<Object> salerName = VerifyService.changeToList(param.get("saler_name"));
                    List<Object> salerTaxNo = VerifyService.changeToList(param.get("saler_tax_no"));
                    if (salerName.size() > 1 || salerTaxNo.size() > 1) {
                        isMulSalerNameAndTax = true;
                    }
                    if (isMulSalerNameAndTax) {
                        List<String> salerNameAndTaxNoList = VerifyService.concatNameAndTaxNo(VerifyService.trimCompanyName(param.get("saler_name")), VerifyService.trimCompanyName(param.get("saler_tax_no")));
                        item.setConfigType("saler_name_and_tax_no");
                        String configSalerTaxNoLevel = config.getString("saler_tax_no");
                        String configSalerNameLevel = config.getString("saler_name");
                        ArrayList levelList = Lists.newArrayList((Object[])new String[]{"0", "1", "2", "3"});
                        for (String level : levelList) {
                            if (!StringUtils.equals((CharSequence)configSalerTaxNoLevel, (CharSequence)level) && !StringUtils.equals((CharSequence)configSalerNameLevel, (CharSequence)level)) continue;
                            item.setConfig(level);
                            break;
                        }
                        filter = new VerifyQFilter("saler_name_and_tax_no", CompareTypeEnum.NOTIN.getId(), salerNameAndTaxNoList);
                        filter.setFilterName("saler_name_and_tax_no");
                        item.addFilter(filter);
                    } else if ("saler_name".equals(verifyType)) {
                        filter5 = new VerifyQFilter("saler_name", CompareTypeEnum.NOTIN.getId(), VerifyService.trimCompanyName(param.get("saler_name"), ignoreSpecialChar));
                        filter5.setFilterName("saler_name");
                        item.addFilter(filter5);
                    } else if ("saler_tax_no".equals(verifyType)) {
                        filter5 = new VerifyQFilter("saler_tax_no", CompareTypeEnum.NOTIN.getId(), VerifyService.trimCompanyName(param.get("saler_tax_no")));
                        filter5.setFilterName("saler_tax_no");
                        item.addFilter(filter5);
                    }
                }
            } else if ("modify_invoice".equals(verifyType)) {
                item.addFilter(new VerifyQFilter("is_revise", CompareTypeEnum.EQUAL.getId(), (Object)"1"));
            }
            if (InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType)) {
                Map<String, String> addrPhoneAccout;
                String taxNo = (String)param.get("taxNo");
                long orgId = 0L;
                Object orgIdObj = param.get("orgId");
                orgId = orgIdObj instanceof String && orgIdObj != null && StringUtils.isNotBlank((CharSequence)orgIdObj.toString()) ? Long.parseLong(orgIdObj.toString()) : (orgIdObj instanceof Long && orgIdObj != null && (Long)orgIdObj != 0L ? ((Long)orgIdObj).longValue() : RequestContext.get().getOrgId());
                if ("buyer_account".equals(verifyType)) {
                    addrPhoneAccout = StringUtils.isNotBlank((CharSequence)taxNo) ? TenantUtils.getDefaultAddrPhoneAccoutByTaxNo(taxNo) : TenantUtils.getDefaultAddrPhoneAccoutByOrgId(orgId);
                    String openuserbank = addrPhoneAccout != null ? addrPhoneAccout.get("openuserbank") : "";
                    filter = new VerifyQFilter("buyer_account", CompareTypeEnum.NOTIN.getId(), (Object)VerifyService.replaceSpace(openuserbank));
                    filter.setFilterName("buyer_account");
                    item.addFilter(filter);
                } else if ("buyer_address_phone".equals(verifyType)) {
                    addrPhoneAccout = StringUtils.isNotBlank((CharSequence)taxNo) ? TenantUtils.getDefaultAddrPhoneAccoutByTaxNo(taxNo) : TenantUtils.getDefaultAddrPhoneAccoutByOrgId(orgId);
                    String invoiceaddr = addrPhoneAccout != null ? addrPhoneAccout.get("invoiceaddr") : "";
                    filter = new VerifyQFilter("buyer_address_phone", CompareTypeEnum.NOTIN.getId(), (Object)VerifyService.replaceSpace(invoiceaddr));
                    filter.setFilterName("buyer_address_phone");
                    item.addFilter(filter);
                }
            }
            if ("person_invoice".equals(verifyType)) {
                item.addFilter(new VerifyQFilter("personFlag", CompareTypeEnum.EQUAL.getId(), (Object)Boolean.TRUE));
            }
            if ("company_seal".equals(verifyType) && InvoiceConvertUtils.isCompanySealInvoice(invoiceType)) {
                item.addFilter(new VerifyQFilter("company_seal", CompareTypeEnum.EQUAL.getId(), (Object)"0"));
            }
            if ("repeat_expense".equals(verifyType)) {
                item.addFilter(new VerifyQFilter("availableAmount", CompareTypeEnum.EQUAL.getId(), (Object)0L));
            }
            if ("continuous_no".equals(verifyType)) {
                item.addFilter(new VerifyQFilter("continuous_no", CompareTypeEnum.EQUAL.getId(), (Object)"1"));
            }
            if ("deadline_date".equals(verifyType) || "expense_next_year".equals(verifyType) || "next_year_month".equals(verifyType)) {
                String deadLine = config.getString("expense_deadline");
                Date invoiceDate = (Date)invoiceMap.get("invoice_date");
                Date expenseDate = (Date)param.get("expenseDate");
                if (expenseDate == null) {
                    expenseDate = new Date();
                }
                if (invoiceDate != null && VerifyConstant.needVerify(deadLine).booleanValue() && !InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
                    String nextYear;
                    item.setConfig(deadLine);
                    BigDecimal date = BigDecimalUtil.transDecimal(config.getString("deadline_date"));
                    Date lastDate = DateUtils.addDay(expenseDate, 0 - date.intValue());
                    if ("deadline_date".equals(verifyType) && currentDate.compareTo(lastDate) > 0) {
                        item.addFilter(new VerifyQFilter("invoice_date", CompareTypeEnum.LESSOREQUAL.getId(), (Object)lastDate));
                    } else if ("expense_next_year".equals(verifyType)) {
                        nextYear = config.getString("expense_next_year");
                        Date firstDate = DateUtils.getFirstDateOfYear(expenseDate);
                        if ("0".equals(nextYear)) {
                            item.addFilter(new VerifyQFilter("invoice_date", CompareTypeEnum.LESS.getId(), (Object)firstDate));
                        }
                    } else if ("next_year_month".equals(verifyType)) {
                        nextYear = config.getString("expense_next_year");
                        int newYearMon = BigDecimalUtil.transDecimal(config.getString("next_year_month")).intValue();
                        if ("1".equals(nextYear)) {
                            try {
                                int invoiceMonth = BigDecimalUtil.transDecimal(DateUtils.format(invoiceDate, "yyyy")).intValue();
                                int expenseMonth = BigDecimalUtil.transDecimal(DateUtils.format(expenseDate, "yyyy")).intValue();
                                if (invoiceMonth < expenseMonth && ((Date)(endExpneseDate = DateUtils.addMonth(DateUtils.getFirstDateOfYear(invoiceDate), 12 + newYearMon))).compareTo(expenseDate) <= 0) {
                                    item.addFilter(new VerifyQFilter("invoice_date", CompareTypeEnum.GREATEROREQUAL.getId(), (Object)DateUtils.stringToDate("1970-01-01")));
                                }
                            }
                            catch (Exception invoiceMonth) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if ("custom_config".equals(verifyType)) {
                JSONArray custArray = JSONArray.parseArray((String)configValue);
                for (int i = 0; i < custArray.size(); ++i) {
                    JSONObject custom = custArray.getJSONObject(i);
                    String level = custom.getString("custom_level");
                    String customConfig = custom.getString("custom_config");
                    if (!StringUtils.isNotEmpty((CharSequence)customConfig) || !VerifyConstant.needVerify(level).booleanValue()) continue;
                    VerifyItem custItem = new VerifyItem(verifyType, level);
                    custItem.setName(custom.getString("custom_name"));
                    custItem.setMsg(custom.getString("custom_name"));
                    custItem.setKey("verify_ext_" + i);
                    String customInvoiceType = custom.getString("custom_invoice_type");
                    if (StringUtils.isNotEmpty((CharSequence)customInvoiceType)) {
                        ArrayList<Long> invoiceTypeList = new ArrayList<Long>(8);
                        String[] strs = customInvoiceType.split(",");
                        endExpneseDate = strs;
                        int n = ((String[])endExpneseDate).length;
                        for (int j = 0; j < n; ++j) {
                            Object str = endExpneseDate[j];
                            Long type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)str);
                            if (type <= 0L) continue;
                            invoiceTypeList.add(type);
                        }
                        if (!invoiceTypeList.isEmpty()) {
                            VerifyQFilter filter6 = new VerifyQFilter("invoice_type", CompareTypeEnum.IN.getId(), invoiceTypeList);
                            filter6.setLogic("0");
                            custItem.addFilter(filter6);
                        }
                    }
                    FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)customConfig, FilterCondition.class);
                    List listFilterRow = filterCondition.getFilterRow();
                    int size = listFilterRow.size();
                    int index = 0;
                    for (SimpleFilterRow row : listFilterRow) {
                        String fieldName = row.getFieldName();
                        if ("tax_recorded_status".equals(fieldName) && !Arrays.asList(InputInvoiceTypeEnum.getTaxRecordedTypes()).contains(invoiceType)) {
                            fieldName = "";
                        }
                        if ("authenticate_flag".equals(fieldName)) {
                            if (Arrays.asList(InputInvoiceTypeEnum.getTransportTypes()).contains(invoiceType)) {
                                fieldName = "transport_deduction";
                            } else if (!Arrays.asList(InputInvoiceTypeEnum.getDeductionTypes()).contains(invoiceType)) {
                                fieldName = "";
                            }
                        }
                        if ("seat_grade".equals(fieldName)) {
                            fieldName = VerifyService.getTrainSeatGradeByInvoiceType(invoiceType);
                        } else if ("seat_grade_name".equals(fieldName)) {
                            fieldName = VerifyService.getAirSeatGradeNameByInvoiceType(invoiceType);
                        }
                        VerifyQFilter rowFilter = new VerifyQFilter();
                        if (++index == 1) {
                            rowFilter.setLeftBracket(StringUtils.trimToEmpty((String)row.getLeftBracket()) + "(");
                        } else {
                            rowFilter.setLeftBracket(row.getLeftBracket());
                        }
                        if (index == size) {
                            rowFilter.setRightBracket(StringUtils.trimToEmpty((String)row.getRightBracket()) + ")");
                        } else {
                            rowFilter.setRightBracket(row.getRightBracket());
                        }
                        rowFilter.setLogic(row.getLogic());
                        List filterValueList = row.getValue();
                        if (filterValueList != null) {
                            ArrayList<Object> filterValues = new ArrayList<Object>(filterValueList.size());
                            for (FilterValue value : filterValueList) {
                                if ("transport_deduction".equals(fieldName) && !"0".equals(value.getValue()) && !"1".equals(value.getValue()) && !"2".equals(value.getValue())) continue;
                                filterValues.add(value.getValue());
                            }
                            if (filterValues.isEmpty()) {
                                fieldName = "";
                            }
                            rowFilter.setValue(filterValues);
                        }
                        rowFilter.setProperty(fieldName);
                        rowFilter.setCp(row.getCompareType());
                        custItem.addFilter(rowFilter);
                    }
                    list.add(custItem);
                }
                continue;
            }
            if ("filetype_config".equals(verifyType)) {
                JSONArray fileTypeConfigArray = JSONArray.parseArray((String)configValue);
                String thisTimeFileType = VerifyService.getThisTimeFileType(invoiceMap);
                for (int i = 0; i < fileTypeConfigArray.size(); ++i) {
                    String[] type1;
                    List collect;
                    String fileType;
                    JSONObject fileTypeConfig = fileTypeConfigArray.getJSONObject(i);
                    String invoiceTypeConfig = fileTypeConfig.getString("file_invoice_type");
                    String fileCustomLevel = fileTypeConfig.getString("file_custom_level");
                    if ("3".equals(fileCustomLevel) || !StringUtils.isNotEmpty((CharSequence)invoiceTypeConfig)) continue;
                    String[] type0 = invoiceTypeConfig.split(",");
                    String awsType = InputInvoiceTypeEnum.getAwsType(invoiceType);
                    if (!Arrays.asList(type0).contains(awsType) || !StringUtils.isNotEmpty((CharSequence)(fileType = fileTypeConfig.getString("file_type"))) || !(collect = Arrays.stream(type1 = fileType.split(",")).filter(f -> !"".equals(f)).collect(Collectors.toList())).contains(thisTimeFileType.toLowerCase())) continue;
                    VerifyItem fileItem = new VerifyItem(verifyType, fileCustomLevel);
                    fileItem.setName(fileTypeConfig.getString("file_custom_name"));
                    fileItem.setMsg(fileTypeConfig.getString("file_custom_name"));
                    fileItem.setKey("verify_filetype_" + i);
                    list.add(fileItem);
                }
                continue;
            }
            if ("e_rec_check_compare".equals(verifyType) && (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType))) {
                String level = config.getString("e_rec_check_compare");
                String compareResult = VerifyService.getThisTimeCompareResult(invoiceMap);
                if (!StringUtils.isNotEmpty((CharSequence)compareResult) || "3".equals(level)) continue;
                VerifyItem fileItem = new VerifyItem(verifyType, level);
                fileItem.setName(ResManager.loadKDString((String)"\u6570\u7535\u4e13\u666e\u53d1\u7968\u7968\u9762\u5173\u952e\u4fe1\u606f\u6bd4\u5bf9", (String)"VerifyService_73", (String)"imc-rim-common", (Object[])new Object[0]));
                fileItem.setMsg(String.format(ResManager.loadKDString((String)"\u5bf9\u6bd4\u53d1\u7968\u6587\u4ef6\u8bc6\u522b\u89e3\u6790\u7ed3\u679c\u548c\u7a0e\u5c40\u67e5\u9a8c\u7ed3\u679c\u7591\u4f3c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5173\u6ce8\u53d1\u7968\u6587\u4ef6\u662f\u5426\u5f02\u5e38\uff0c\u4e0d\u4e00\u81f4\u5b57\u6bb5:[%1$s]", (String)"VerifyService_74", (String)"imc-rim-common", (Object[])new Object[0]), compareResult));
                fileItem.setKey("e_rec_check_compare");
                list.add(fileItem);
                continue;
            }
            if (!VerifyConstant.needVerify(item.getConfig()).booleanValue() || item.getFilterList().isEmpty() && StringUtils.isEmpty((CharSequence)item.getMsg())) continue;
            list.add(item);
        }
        return list;
    }

    private static String getAirSeatGradeNameByInvoiceType(Long invoiceType) {
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            return "seatgrade_name";
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
            return "seat_grade_name";
        }
        return "";
    }

    private static String getTrainSeatGradeByInvoiceType(Long invoiceType) {
        if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
            return "seat_level";
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            return "seat_grade";
        }
        return "";
    }

    private static String getThisTimeCompareResult(Map<String, Object> invoiceMap) {
        String checkStatus = (String)invoiceMap.get("check_status");
        String compareResult = "";
        if ("2".equals(checkStatus)) {
            return null;
        }
        Object ext_info = invoiceMap.get("ext_info");
        if (ext_info != null) {
            JSONObject extObject = null;
            try {
                extObject = JSONObject.parseObject((String)ext_info.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (extObject != null) {
                compareResult = extObject.getString(InvoiceSaveConstant.EXT_EINVOICE_COMPARE_RESULT);
            }
        }
        return compareResult;
    }

    private static String getThisTimeFileType(Map<String, Object> invoiceMap) {
        boolean isExcel;
        Object ext_info;
        Object uncheckTag;
        String checkStatus = (String)invoiceMap.get("check_status");
        String thisTimeFileType = "";
        if ("2".equals(checkStatus) && (uncheckTag = invoiceMap.get("invoice_detail_tag")) != null) {
            JSONObject tagObject = JSONObject.parseObject((String)(uncheckTag + ""));
            thisTimeFileType = tagObject.getString("fileType");
        }
        if (StringUtils.isEmpty((CharSequence)thisTimeFileType) && (ext_info = invoiceMap.get("ext_info")) != null) {
            JSONObject extObject = null;
            try {
                extObject = JSONObject.parseObject((String)ext_info.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (extObject != null) {
                thisTimeFileType = extObject.getString(InvoiceSaveConstant.EXT_FILETYPE_NOW);
            }
        }
        boolean bl = isExcel = (thisTimeFileType + "").equalsIgnoreCase("xls") || (thisTimeFileType + "").equalsIgnoreCase("xlsx");
        if (FileUtils.isImage(thisTimeFileType)) {
            thisTimeFileType = "image";
        } else if (isExcel || StringUtils.isEmpty((CharSequence)thisTimeFileType)) {
            thisTimeFileType = "null";
        }
        return thisTimeFileType;
    }

    private static void setMsg(VerifyResultDto dto, Object invoiceValue, Object compareValue, Map<String, Object> invoice) {
        String byz = ResManager.loadKDString((String)"\u4e0d\u4e00\u81f4", (String)"VerifyService_5", (String)"imc-rim-common", (Object[])new Object[0]);
        if ("check_status".equals(dto.getConfigType())) {
            String msg;
            dto.setKey("checkStatus");
            dto.setMsg(ResManager.loadKDString((String)"\u67e5\u9a8c\u4e0d\u901a\u8fc7", (String)"VerifyService_6", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setName(ResManager.loadKDString((String)"\u67e5\u9a8c\u4e0d\u901a\u8fc7", (String)"VerifyService_6", (String)"imc-rim-common", (Object[])new Object[0]));
            Object check_result = invoice.get("check_result");
            if (null != check_result && StringUtils.isNotEmpty((CharSequence)(msg = VerifyService.getCheckResult(check_result.toString())))) {
                dto.setMsg(msg);
            }
        } else if ("repeat_expense".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u91cd\u590d\u62a5\u9500", (String)"VerifyService_7", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setName(ResManager.loadKDString((String)"\u88ab\u5176\u4ed6\u5355\u636e\u5728\u7528\u6216\u5df2\u7528", (String)"VerifyService_8", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("repeat");
        } else if ("original_state".equals(dto.getConfigType())) {
            String signType = RimConfigUtils.getConfig("rim_recog_check", "sign_type");
            if ("1".equals(signType)) {
                dto.setMsg(ResManager.loadKDString((String)"\u6240\u4e0a\u4f20\u53d1\u7968\u975e\u6e90\u6587\u4ef6\uff0c\u6587\u4ef6\u975e\u539f\u751f\u683c\u5f0f\uff0c\u8bf7\u8054\u7cfb\u5f00\u7968\u65b9\u786e\u8ba4", (String)"VerifyService_79", (String)"imc-rim-common", (Object[])new Object[0]));
            } else {
                dto.setMsg(ResManager.loadKDString((String)"\u6240\u4e0a\u4f20\u53d1\u7968\u975e\u6e90\u6587\u4ef6\uff0c\u6587\u4ef6\u4e2d\u65e0\u6709\u6548\u7535\u5b50\u7b7e\u7ae0\uff0c\u8bf7\u8054\u7cfb\u5f00\u7968\u65b9\u786e\u8ba4", (String)"VerifyService_80", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            dto.setKey("withoutFile");
        } else if ("invalid_invoice".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u4f5c\u5e9f", (String)"VerifyService_10", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("invalidInvoice");
        } else if ("red_invoice".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u7ea2\u51b2", (String)"VerifyService_11", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("redInvoice");
        } else if ("modify_invoice".equals(dto.getConfigType())) {
            String serial_no = (String)invoice.get("serial_no");
            LOGGER.info("VerifyService serialNo:" + serial_no);
            StringBuilder sbhtml = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            QFilter qFilter = new QFilter("serial_no", "=", (Object)serial_no);
            DynamicObjectCollection modifyInfoCollect = QueryServiceHelper.query((String)"rim_verify_modify_his", (String)"modify_key,modify_name, before_value", (QFilter[])new QFilter[]{qFilter});
            if (CollectionUtils.isEmpty((Collection)modifyInfoCollect)) {
                sbhtml.append("<div style=\"margin-left: 23px; margin-bottom: 6px;\">");
                sbhtml.append(ResManager.loadKDString((String)"\u5b58\u5728\u624b\u5de5\u4fee\u6539\u8bb0\u5f55", (String)"VerifyService_12", (String)"imc-rim-common", (Object[])new Object[0]));
                sbhtml.append("</div>");
                sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u624b\u5de5\u4fee\u6539\u8bb0\u5f55", (String)"VerifyService_12", (String)"imc-rim-common", (Object[])new Object[0]));
            } else {
                String ms = ResManager.loadKDString((String)"\u5b58\u5728\u624b\u5de5\u4fee\u6539\u8bb0\u5f55,\u539f\u8bc6\u522b\u4fe1\u606f\u4e3a\uff1a", (String)"VerifyService_13", (String)"imc-rim-common", (Object[])new Object[0]);
                sbhtml.append("<div style=\"margin-left: 23px; margin-bottom: 6px;\">");
                sbhtml.append(ms);
                sbhtml.append("</div>");
                sb.append(ms).append("\n");
            }
            int i = 1;
            String entityName = InputInvoiceTypeEnum.getEntity(BigDecimalUtil.transDecimal(invoice.get("invoice_type")).longValue());
            Map fieldMap = InvoiceCollectEditService.getFieldMap((String)entityName);
            for (DynamicObject object : modifyInfoCollect) {
                String modifyName = InvoiceCollectEditService.getModifyName((String)object.getString("modify_key"), (Map)fieldMap);
                if (StringUtils.isEmpty((CharSequence)modifyName)) {
                    modifyName = object.getString("modify_name");
                }
                if (StringUtils.isEmpty((CharSequence)modifyName)) continue;
                sbhtml.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
                sbhtml.append("<p style=\"margin-left: 3px;\"><span>").append(i).append(". ").append(modifyName);
                sbhtml.append(": ").append(object.get("before_value")).append("</span></p>");
                sbhtml.append("</div>");
                sb.append(i).append(". ").append(object.getString("modify_name")).append(": ").append(object.get("before_value")).append('\n');
                ++i;
            }
            dto.setHtmlMsg(sbhtml.toString());
            dto.setMsg(sb.toString());
            dto.setKey("change");
        } else if ("buyer_name".equals(dto.getConfigType())) {
            dto.setName(ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u62ac\u5934\u4e0e\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4", (String)"VerifyService_14", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u62ac\u5934[%1$s]\u4e0e\u4f01\u4e1a\u540d\u79f0[%2$s]  \u4e0d\u4e00\u81f4", (String)"VerifyService_15", (String)"imc-rim-common", (Object[])new Object[0]), invoice.get("buyer_name"), VerifyService.join(compareValue, "|")));
            StringBuilder sb = new StringBuilder();
            String name1 = ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u62ac\u5934:", (String)"VerifyService_16", (String)"imc-rim-common", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0:", (String)"VerifyService_17", (String)"imc-rim-common", (Object[])new Object[0]);
            sb.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name1).append(" <span>").append(invoice.get("buyer_name")).append("</span></p>");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name2).append(" <span>").append(VerifyService.joinLimitSize(compareValue, "|", 5)).append("</span>");
            sb.append("<span style=\"color: rgb(255, 0, 0); font-weight: bold; margin-left: 10px;\">");
            sb.append(byz);
            sb.append("</span></p>");
            sb.append("</div>");
            dto.setKey("verifyBuyerName");
            dto.setHtmlMsg(sb.toString());
        } else if ("buyer_tax_no".equals(dto.getConfigType())) {
            dto.setName(ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u7a0e\u53f7\u4e0e\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"VerifyService_18", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u7a0e\u53f7[%1$s]\u4e0e\u4f01\u4e1a\u7a0e\u53f7[%2$s]  \u4e0d\u4e00\u81f4", (String)"VerifyService_19", (String)"imc-rim-common", (Object[])new Object[0]), invoiceValue, VerifyService.join(compareValue, "|")));
            StringBuilder sb = new StringBuilder();
            String taxNoMsg1 = ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u7a0e\u53f7:", (String)"VerifyService_20", (String)"imc-rim-common", (Object[])new Object[0]);
            String taxNoMsg2 = ResManager.loadKDString((String)"\u4f01\u4e1a\u7a0e\u53f7:", (String)"VerifyService_21", (String)"imc-rim-common", (Object[])new Object[0]);
            sb.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(taxNoMsg1);
            sb.append(" <span>").append(invoiceValue).append("</span></p>");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(taxNoMsg2);
            sb.append(" <span>").append(VerifyService.joinLimitSize(compareValue, "|", 5)).append("</span>");
            sb.append("<span style=\"color: rgb(255, 0, 0); font-weight: bold; margin-left: 10px;\">");
            sb.append(byz);
            sb.append("</span></p>");
            sb.append("</div>");
            dto.setKey("verifyBuyerTaxNo");
            dto.setHtmlMsg(sb.toString());
        } else if ("buyer_name_and_tax_no".equals(dto.getConfigType())) {
            dto.setName(ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u62ac\u5934\u7a0e\u53f7\u4e0e\u4f01\u4e1a\u540d\u79f0\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"VerifyService_22", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u62ac\u5934\u7a0e\u53f7[%1$s]\u4e0e\u4f01\u4e1a\u540d\u79f0\u7a0e\u53f7[%2$s]  \u4e0d\u4e00\u81f4", (String)"VerifyService_23", (String)"imc-rim-common", (Object[])new Object[0]), invoiceValue, VerifyService.join(compareValue, "|")));
            StringBuilder sb = new StringBuilder();
            String name1 = ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u62ac\u5934\u7a0e\u53f7:", (String)"VerifyService_24", (String)"imc-rim-common", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\u7a0e\u53f7:", (String)"VerifyService_25", (String)"imc-rim-common", (Object[])new Object[0]);
            sb.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name1);
            sb.append("<span>").append(invoiceValue).append("</span></p>");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name2);
            sb.append(" <span>").append(VerifyService.joinLimitSize(compareValue, "|", 5)).append("</span>");
            sb.append("<span style=\"color: rgb(255, 0, 0); font-weight: bold; margin-left: 10px;\">");
            sb.append(byz);
            sb.append("</span></p>");
            sb.append("</div>");
            dto.setKey("verifyBuyerName");
            dto.setHtmlMsg(sb.toString());
        } else if ("saler_name".equals(dto.getConfigType())) {
            dto.setName(ResManager.loadKDString((String)"\u53d1\u7968\u9500\u65b9\u62ac\u5934\u4e0e\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u4e00\u81f4", (String)"VerifyService_61", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u9500\u65b9\u62ac\u5934[%1$s]\u4e0e\u4f9b\u5e94\u5546\u540d\u79f0[%2$s]  \u4e0d\u4e00\u81f4", (String)"VerifyService_62", (String)"imc-rim-common", (Object[])new Object[0]), invoiceValue, VerifyService.join(compareValue, "|")));
            StringBuilder sb = new StringBuilder();
            String name1 = ResManager.loadKDString((String)"\u53d1\u7968\u9500\u65b9\u62ac\u5934:", (String)"VerifyService_63", (String)"imc-rim-common", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0:", (String)"VerifyService_64", (String)"imc-rim-common", (Object[])new Object[0]);
            sb.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name1).append(" <span>").append(invoiceValue).append("</span></p>");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name2).append(" <span>").append(VerifyService.joinLimitSize(compareValue, "|", 5)).append("</span>");
            sb.append("<span style=\"color: rgb(255, 0, 0); font-weight: bold; margin-left: 10px;\">");
            sb.append(byz);
            sb.append("</span></p>");
            sb.append("</div>");
            dto.setKey("verifySalerName");
            dto.setHtmlMsg(sb.toString());
        } else if ("saler_tax_no".equals(dto.getConfigType())) {
            dto.setName(ResManager.loadKDString((String)"\u53d1\u7968\u9500\u65b9\u7a0e\u53f7\u4e0e\u4f9b\u5e94\u5546\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"VerifyService_65", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u9500\u65b9\u7a0e\u53f7[%1$s]\u4e0e\u4f9b\u5e94\u5546\u7a0e\u53f7[%2$s]  \u4e0d\u4e00\u81f4", (String)"VerifyService_66", (String)"imc-rim-common", (Object[])new Object[0]), invoiceValue, VerifyService.join(compareValue, "|")));
            StringBuilder sb = new StringBuilder();
            String taxNoMsg1 = ResManager.loadKDString((String)"\u53d1\u7968\u9500\u65b9\u7a0e\u53f7:", (String)"VerifyService_67", (String)"imc-rim-common", (Object[])new Object[0]);
            String taxNoMsg2 = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7a0e\u53f7:", (String)"VerifyService_68", (String)"imc-rim-common", (Object[])new Object[0]);
            sb.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(taxNoMsg1);
            sb.append(" <span>").append(invoiceValue).append("</span></p>");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(taxNoMsg2);
            sb.append(" <span>").append(VerifyService.joinLimitSize(compareValue, "|", 5)).append("</span>");
            sb.append("<span style=\"color: rgb(255, 0, 0); font-weight: bold; margin-left: 10px;\">");
            sb.append(byz);
            sb.append("</span></p>");
            sb.append("</div>");
            dto.setKey("verifySalerTaxNo");
            dto.setHtmlMsg(sb.toString());
        } else if ("saler_name_and_tax_no".equals(dto.getConfigType())) {
            dto.setName(ResManager.loadKDString((String)"\u53d1\u7968\u9500\u65b9\u540d\u79f0\u7a0e\u53f7\u4e0e\u4f9b\u5e94\u5546\u540d\u79f0\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"VerifyService_69", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u9500\u65b9\u540d\u79f0\u7a0e\u53f7[%1$s]\u4e0e\u4f9b\u5e94\u5546\u540d\u79f0\u7a0e\u53f7[%2$s]  \u4e0d\u4e00\u81f4", (String)"VerifyService_70", (String)"imc-rim-common", (Object[])new Object[0]), invoiceValue, VerifyService.join(compareValue, "|")));
            StringBuilder sb = new StringBuilder();
            String name1 = ResManager.loadKDString((String)"\u53d1\u7968\u9500\u65b9\u540d\u79f0\u7a0e\u53f7:", (String)"VerifyService_71", (String)"imc-rim-common", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0\u7a0e\u53f7:", (String)"VerifyService_72", (String)"imc-rim-common", (Object[])new Object[0]);
            sb.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name1);
            sb.append("<span>").append(invoiceValue).append("</span></p>");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name2);
            sb.append(" <span>").append(VerifyService.joinLimitSize(compareValue, "|", 5)).append("</span>");
            sb.append("<span style=\"color: rgb(255, 0, 0); font-weight: bold; margin-left: 10px;\">");
            sb.append(byz);
            sb.append("</span></p>");
            sb.append("</div>");
            dto.setKey("verifySalerName");
            dto.setHtmlMsg(sb.toString());
        } else if ("buyer_address_phone".equals(dto.getConfigType())) {
            dto.setName(ResManager.loadKDString((String)"\u53d1\u7968\u5730\u5740\u7535\u8bdd\u4e0e\u4f01\u4e1a\u5730\u5740\u7535\u8bdd\u4e0d\u4e00\u81f4", (String)"VerifyService_26", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u7684\u5730\u5740\u7535\u8bdd[%1$s]\u4e0e\u5f53\u524d\u4f01\u4e1a\u7684\u5730\u5740\u7535\u8bdd[%2$s]  \u4e0d\u4e00\u81f4", (String)"VerifyService_27", (String)"imc-rim-common", (Object[])new Object[0]), invoiceValue, compareValue));
            StringBuilder sb = new StringBuilder();
            String name1 = ResManager.loadKDString((String)"\u53d1\u7968\u5730\u5740\u7535\u8bdd:", (String)"VerifyService_28", (String)"imc-rim-common", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u4f01\u4e1a\u5730\u5740\u7535\u8bdd:", (String)"VerifyService_29", (String)"imc-rim-common", (Object[])new Object[0]);
            sb.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name1);
            sb.append("<span>").append(invoiceValue).append("</span></p>");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name2);
            sb.append("<span>").append(compareValue).append("</span>");
            sb.append("<span style=\"color: rgb(255, 0, 0); font-weight: bold; margin-left: 10px;\">");
            sb.append(byz);
            sb.append("</span></p>");
            sb.append("</div>");
            dto.setKey("verifyBuyerAddressPhone");
            dto.setHtmlMsg(sb.toString());
        } else if ("buyer_account".equals(dto.getConfigType())) {
            dto.setName(ResManager.loadKDString((String)"\u53d1\u7968\u5f00\u6237\u884c\u8d26\u53f7\u4e0e\u4f01\u4e1a\u5f00\u6237\u884c\u8d26\u53f7\u4e0d\u4e00\u81f4", (String)"VerifyService_30", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u5f00\u6237\u884c\u8d26\u53f7[%1$s]\u4e0e\u4f01\u4e1a\u5f00\u6237\u884c\u8d26\u53f7[%2$s]  \u4e0d\u4e00\u81f4", (String)"VerifyService_31", (String)"imc-rim-common", (Object[])new Object[0]), invoiceValue, compareValue));
            StringBuilder sb = new StringBuilder();
            String name1 = ResManager.loadKDString((String)"\u53d1\u7968\u5f00\u6237\u884c\u8d26\u53f7:", (String)"VerifyService_32", (String)"imc-rim-common", (Object[])new Object[0]);
            String name2 = ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u6237\u884c\u8d26\u53f7:", (String)"VerifyService_33", (String)"imc-rim-common", (Object[])new Object[0]);
            sb.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name1);
            sb.append("<span>").append(invoiceValue).append("</span></p>");
            sb.append("<p style=\"margin-left: 3px;\">");
            sb.append(name2);
            sb.append("<span>").append(compareValue).append("</span>");
            sb.append("<span style=\"color: rgb(255, 0, 0); font-weight: bold; margin-left: 10px;\">");
            sb.append(byz);
            sb.append("</span></p>");
            sb.append("</div>");
            dto.setKey("verifyBuyerAccount");
            dto.setHtmlMsg(sb.toString());
        } else if ("black_list".equals(dto.getConfigType())) {
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0\u6216\u9500\u65b9\u7a0e\u53f7\uff1a%1$s\u5728\u4f01\u4e1a\u9ed1\u540d\u5355\u4e2d", (String)"VerifyService_77", (String)"imc-rim-common", (Object[])new Object[0]), invoiceValue));
            dto.setName(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0\u6216\u9500\u65b9\u7a0e\u53f7\u5728\u9ed1\u540d\u5355", (String)"VerifyService_78", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("verifySalerName");
        } else if ("tax_blacklist".equals(dto.getConfigType())) {
            dto.setMsg(invoiceValue + "");
            dto.setName(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0\u5728\u7a0e\u5c40\u6d89\u7a0e\u9ed1\u540d\u5355", (String)"VerifyService_36", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("verifyCompanyBlacklist");
        } else if ("sensitive_word".equals(dto.getConfigType())) {
            dto.setMsg(String.format(ResManager.loadKDString((String)"\u5305\u542b\u654f\u611f\u8bcd[%1$s]", (String)"VerifyService_37", (String)"imc-rim-common", (Object[])new Object[0]), compareValue));
            dto.setName(ResManager.loadKDString((String)"\u542b\u654f\u611f\u8bcd\u53d1\u7968", (String)"VerifyService_38", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("verifyKey");
        } else if ("person_invoice".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u4e2a\u4eba\u62ac\u5934\u7684\u53d1\u7968", (String)"VerifyService_39", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("personInvoice");
        } else if ("deadline_date".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u8d85\u8fc7\u4f01\u4e1a\u8bbe\u7f6e\u7684\u62a5\u9500\u671f\u9650", (String)"VerifyService_40", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("filterSalerName");
        } else if ("expense_next_year".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u8de8\u5e74\u62a5\u9500", (String)"VerifyService_41", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("expenseTwoYear");
        } else if ("next_year_month".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u8d85\u8fc7\u4f01\u4e1a\u8bbe\u7f6e\u7684\u62a5\u9500\u8de8\u5e74\u671f\u9650", (String)"VerifyService_42", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("twoYearMon");
        } else if ("company_seal".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u65e0\u5370\u7ae0\u53d1\u7968", (String)"VerifyService_43", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("withoutSeal");
        } else if ("continuous_no".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u53d1\u7968\u7591\u4f3c\u4e32\u53f7\uff0c\u53d1\u7968\u6253\u5370\u53f7\u7801\u4e0e\u7968\u9762\u53d1\u7968\u53f7\u7801\u4e0d\u4e00\u81f4", (String)"VerifyService_44", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("errorNumber");
        } else if ("sequence_no".equals(dto.getConfigType())) {
            dto.setMsg(ResManager.loadKDString((String)"\u53d1\u7968\u8fde\u53f7", (String)"VerifyService_45", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setName(ResManager.loadKDString((String)"\u53d1\u7968\u8fde\u53f7", (String)"VerifyService_45", (String)"imc-rim-common", (Object[])new Object[0]));
            dto.setKey("sequenceNum");
        } else {
            dto.setMsg(null);
        }
        if (dto.getName() == null && dto.getMsg() != null) {
            dto.setName(dto.getMsg());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean compare(Object invoiceValue, String cp, Object compareValue, Map<String, Object> invoiceMap) {
        if (CompareTypeEnum.EQUAL.getId().equals(cp)) {
            Object value = VerifyService.getFirst(compareValue);
            if (null == invoiceValue || null == value) {
                return Boolean.FALSE;
            }
            Integer result = VerifyService.comare(invoiceValue, value);
            if (!(invoiceValue instanceof List)) return result != null && result == 0;
            List list = (List)invoiceValue;
            return list.contains(value);
        }
        if (CompareTypeEnum.NOTEQUAL.getId().equals(cp)) {
            Object value = VerifyService.getFirst(compareValue);
            if (null == invoiceValue || null == value) {
                return Boolean.FALSE;
            }
            Integer result = VerifyService.comare(invoiceValue, value);
            if (!(invoiceValue instanceof List)) return result != null && result != 0;
            List list = (List)invoiceValue;
            return !list.contains(value);
        }
        if (CompareTypeEnum.IN.getId().equals(cp)) {
            if (null == invoiceValue || compareValue == null) {
                return Boolean.FALSE;
            }
            if (compareValue.getClass().isArray()) {
                Object[] array;
                for (Object obj : array = (Object[])compareValue) {
                    if (!obj.equals(invoiceValue)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            } else {
                if (!(compareValue instanceof List)) return invoiceValue.toString().equals(compareValue.toString());
                List list = (List)compareValue;
                if (!(invoiceValue instanceof List)) return list.contains(invoiceValue);
                List invoicelist = (List)invoiceValue;
                for (Object obj1 : list) {
                    for (Object obj2 : invoicelist) {
                        if (!obj1.equals(obj2)) continue;
                        return Boolean.TRUE;
                    }
                }
            }
            return Boolean.FALSE;
        } else if (CompareTypeEnum.NOTIN.getId().equals(cp)) {
            if (null == invoiceValue || compareValue == null) {
                return Boolean.FALSE;
            }
            if (compareValue.getClass().isArray()) {
                Object[] array;
                for (Object obj : array = (Object[])compareValue) {
                    if (!obj.equals(invoiceValue)) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (!(compareValue instanceof List)) return !invoiceValue.toString().equals(compareValue.toString());
            List list = (List)compareValue;
            if (!(invoiceValue instanceof List)) return !list.contains(invoiceValue);
            List invoicelist = (List)invoiceValue;
            for (Object obj : invoicelist) {
                if (list.contains(obj)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        } else {
            if (CompareTypeEnum.BETWEEN.getId().equals(cp)) {
                if (null == invoiceValue || compareValue == null) {
                    return Boolean.FALSE;
                }
                Object startValue = null;
                Object endValue = null;
                if (compareValue.getClass().isArray()) {
                    Object[] array = (Object[])compareValue;
                    startValue = VerifyService.getCollectionValue(array, 0);
                    endValue = VerifyService.getCollectionValue(array, 1);
                } else if (compareValue instanceof List) {
                    List list = (List)compareValue;
                    startValue = VerifyService.getCollectionValue(list, 0);
                    endValue = VerifyService.getCollectionValue(list, 1);
                }
                boolean flag1 = VerifyService.compare(invoiceValue, CompareTypeEnum.GREATEROREQUAL.getId(), startValue, invoiceMap);
                boolean flag2 = VerifyService.compare(invoiceValue, CompareTypeEnum.LESSOREQUAL.getId(), endValue, invoiceMap);
                return VerifyService.compare(invoiceValue, CompareTypeEnum.GREATEROREQUAL.getId(), startValue, invoiceMap) != false && VerifyService.compare(invoiceValue, CompareTypeEnum.LESSOREQUAL.getId(), endValue, invoiceMap) != false;
            }
            if (CompareTypeEnum.ISNULL.getId().equals(cp)) {
                return null == invoiceValue || "".equals(invoiceValue.toString());
            }
            if (CompareTypeEnum.ISNOTNULL.getId().equals(cp)) {
                return null != invoiceValue && !"".equals(invoiceValue.toString());
            }
            if (CompareTypeEnum.LIKE.getId().equals(cp)) {
                return (Boolean)VerifyService.compareLike(invoiceValue, compareValue).getLeft();
            }
            if (CompareTypeEnum.NOTLIKE.getId().equals(cp)) {
                Object value = VerifyService.getFirst(compareValue);
                if (null != invoiceValue && null != value) return invoiceValue.toString().indexOf(value.toString()) == -1;
                return Boolean.FALSE;
            }
            if (CompareTypeEnum.LEFTLIKE.getId().equals(cp)) {
                Object value = VerifyService.getFirst(compareValue);
                if (null == invoiceValue || null == value) {
                    return Boolean.FALSE;
                }
                if (!(invoiceValue instanceof List)) return invoiceValue.toString().startsWith(value.toString());
                List invoicelist = (List)invoiceValue;
                for (Object obj1 : invoicelist) {
                    if (!String.valueOf(obj1).startsWith(value.toString())) continue;
                    return Boolean.TRUE;
                }
                return invoiceValue.toString().startsWith(value.toString());
            }
            if (CompareTypeEnum.RIGHTLIKE.getId().equals(cp)) {
                Object value = VerifyService.getFirst(compareValue);
                if (null == invoiceValue || null == value) {
                    return Boolean.FALSE;
                }
                if (!(invoiceValue instanceof List)) return invoiceValue.toString().endsWith(value.toString());
                List invoicelist = (List)invoiceValue;
                for (Object obj1 : invoicelist) {
                    if (!String.valueOf(obj1).endsWith(value.toString())) continue;
                    return Boolean.TRUE;
                }
                return invoiceValue.toString().endsWith(value.toString());
            }
            if (CompareTypeEnum.GREATER.getId().equals(cp)) {
                Object value = VerifyService.getFirst(compareValue);
                if (null != invoiceValue && null != value) Integer result;
                return (result = VerifyService.comare(invoiceValue, value)) != null && result > 0;
                return Boolean.FALSE;
            }
            if (CompareTypeEnum.LESS.getId().equals(cp)) {
                Object value = VerifyService.getFirst(compareValue);
                if (null != invoiceValue && null != value) Integer result;
                return (result = VerifyService.comare(invoiceValue, value)) != null && result < 0;
                return Boolean.FALSE;
            }
            if (CompareTypeEnum.GREATEROREQUAL.getId().equals(cp)) {
                Object value = VerifyService.getFirst(compareValue);
                if (null != invoiceValue && null != value) Integer result;
                return (result = VerifyService.comare(invoiceValue, value)) != null && result >= 0;
                return Boolean.FALSE;
            }
            if (CompareTypeEnum.LESSOREQUAL.getId().equals(cp)) {
                Object value = VerifyService.getFirst(compareValue);
                if (null != invoiceValue && null != value) Integer result;
                return (result = VerifyService.comare(invoiceValue, value)) != null && result <= 0;
                return Boolean.FALSE;
            }
            if (CompareTypeEnum.TODAY.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                return DateUtils.format(new Date()).equals(DateUtils.format(date));
            }
            if (CompareTypeEnum.YESTERDAY.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date date2 = DateUtils.addDay(new Date(), -1);
                return DateUtils.format(date2).equals(DateUtils.format(date));
            }
            if (CompareTypeEnum.THISWEEK.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                int week = calendar.get(7);
                calendar.add(5, 1 - week);
                Date start = DateUtils.trunc(calendar.getTime());
                calendar.add(5, 7);
                Date end = DateUtils.trunc(calendar.getTime());
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.LASTWEEK.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                int week = calendar.get(7);
                calendar.add(5, -6 - week);
                Date start = DateUtils.trunc(calendar.getTime());
                calendar.add(5, 7);
                Date end = DateUtils.trunc(calendar.getTime());
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.THISMONTH.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date start = DateUtils.getFirstDateOfMonth(new Date());
                Date end = DateUtils.getLastDateOfMonth(start);
                return date.compareTo(start) >= 0 && date.compareTo(end) <= 0;
            }
            if (CompareTypeEnum.LASTMONTH.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date firstDate = DateUtils.getFirstDateOfMonth(new Date());
                Date start = DateUtils.getFirstDateOfMonth(DateUtils.addDay(firstDate, -1));
                Date end = DateUtils.getLastDateOfMonth(start);
                return date.compareTo(start) >= 0 && date.compareTo(end) <= 0;
            }
            if (CompareTypeEnum.LASTTHREEMONTH.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date end = new Date();
                Date start = DateUtils.addMonth(end, -3);
                return date.compareTo(start) >= 0 && date.compareTo(end) <= 0;
            }
            if (CompareTypeEnum.THISQUARTER.getId().equals(cp) || CompareTypeEnum.LASTQUARTER.getId().equals(cp) || CompareTypeEnum.NEXTQUARTER.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date quarter = VerifyService.getQuarter();
                if (CompareTypeEnum.THISQUARTER.getId().equals(cp)) {
                    Date end = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(quarter, 3));
                    return date.compareTo(quarter) >= 0 && date.compareTo(end) < 0;
                }
                if (!CompareTypeEnum.NEXTQUARTER.getId().equals(cp)) Date start;
                return date.compareTo(start = DateUtils.addMonth(quarter, -3)) >= 0 && date.compareTo(quarter) < 0;
                Date start = DateUtils.addMonth(quarter, 3);
                Date end = DateUtils.addMonth(start, 3);
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.THISYEAR.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date start = DateUtils.getFirstDateOfYear(new Date());
                Date end = DateUtils.getFirstDateOfYear(DateUtils.addYear(start, 1));
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.LASTYEAR.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date end = DateUtils.getFirstDateOfYear(new Date());
                Date start = DateUtils.getFirstDateOfYear(DateUtils.addYear(end, -1));
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.TOMORROW.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date start = DateUtils.trunc(DateUtils.addDay(new Date(), 1));
                Date end = DateUtils.addDay(start, 1);
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.NEXTWEEK.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date start = DateUtils.trunc(DateUtils.addDay(new Date(), 1));
                Date end = DateUtils.addDay(start, 1);
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.NEXTMONTH.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date start = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(new Date(), 1));
                Date end = DateUtils.addMonth(start, 1);
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if ("26".equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date start = new Date();
                Date end = DateUtils.addMonth(start, 3);
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.NEXTYEAR.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date start = DateUtils.getFirstDateOfYear(DateUtils.addYear(new Date(), 1));
                Date end = DateUtils.getFirstDateOfYear(DateUtils.addYear(start, 1));
                return date.compareTo(start) >= 0 && date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.TODAYBEFORE.getId().equals(cp) || CompareTypeEnum.LESSTHANOREQUALTODAY.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date end = DateUtils.trunc(DateUtils.addDay(new Date(), 1));
                return date.compareTo(end) < 0;
            }
            if (CompareTypeEnum.TODAYAFTER.getId().equals(cp) || CompareTypeEnum.MORETHANOREQUALTODAY.getId().equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date start = DateUtils.trunc(new Date());
                return date.compareTo(start) >= 0;
            }
            if ("newYearMonth".equals(cp)) {
                if (!(invoiceValue instanceof Date)) return Boolean.FALSE;
                Date date = (Date)invoiceValue;
                Date endDate = DateUtils.getFirstDateOfYear(DateUtils.addYear(date, 1));
                int mon = BigDecimalUtil.transDecimal(compareValue).intValue();
                return new Date().compareTo(endDate = DateUtils.addMonth(endDate, mon)) > 0;
            }
            if (CompareTypeEnum.FIELDEQUAL.getId().equals(cp)) {
                Object field = VerifyService.getFirst(compareValue);
                if (field == null) return Boolean.FALSE;
                Object compareValue2 = invoiceMap.get(field.toString());
                return VerifyService.compare(invoiceValue, CompareTypeEnum.EQUAL.getId(), compareValue2, invoiceMap);
            }
            if (CompareTypeEnum.FIELDNOTEQUAL.getId().equals(cp)) {
                Object field = VerifyService.getFirst(compareValue);
                if (field == null) return Boolean.FALSE;
                Object compareValue2 = invoiceMap.get(field.toString());
                return VerifyService.compare(invoiceValue, CompareTypeEnum.NOTEQUAL.getId(), compareValue2, invoiceMap);
            }
            if (CompareTypeEnum.FIELDGREATER.getId().equals(cp)) {
                Object field = VerifyService.getFirst(compareValue);
                if (field == null) return Boolean.FALSE;
                Object compareValue2 = invoiceMap.get(field.toString());
                return VerifyService.compare(invoiceValue, CompareTypeEnum.GREATER.getId(), compareValue2, invoiceMap);
            }
            if (CompareTypeEnum.FIELDGREATEROREQUAL.getId().equals(cp)) {
                Object field = VerifyService.getFirst(compareValue);
                if (field == null) return Boolean.FALSE;
                Object compareValue2 = invoiceMap.get(field.toString());
                return VerifyService.compare(invoiceValue, CompareTypeEnum.GREATEROREQUAL.getId(), compareValue2, invoiceMap);
            }
            if (CompareTypeEnum.CHECKBOXEQUAL.getId().equals(cp)) {
                return VerifyService.compare(invoiceValue, CompareTypeEnum.EQUAL.getId(), compareValue, invoiceMap);
            }
            if (CompareTypeEnum.CHECKBOXNOTEQUAL.getId().equals(cp)) {
                return VerifyService.compare(invoiceValue, CompareTypeEnum.NOTEQUAL.getId(), compareValue, invoiceMap);
            }
            if (CompareTypeEnum.CHECKBOXIN.getId().equals(cp)) {
                return VerifyService.compare(invoiceValue, CompareTypeEnum.IN.getId(), compareValue, invoiceMap);
            }
            if (CompareTypeEnum.CHECKBOXNOTIN.getId().equals(cp)) {
                return VerifyService.compare(invoiceValue, CompareTypeEnum.NOTIN.getId(), compareValue, invoiceMap);
            }
            if (CompareTypeEnum.COMBOBOXISNULL.getId().equals(cp)) {
                return VerifyService.compare(invoiceValue, CompareTypeEnum.ISNULL.getId(), compareValue, invoiceMap);
            }
            if (!CompareTypeEnum.COMBOBOXISNOTNULL.getId().equals(cp)) return Boolean.FALSE;
            return VerifyService.compare(invoiceValue, CompareTypeEnum.ISNOTNULL.getId(), compareValue, invoiceMap);
        }
    }

    private static Pair<Boolean, String> compareLike(Object invoiceValue, Object compareValue) {
        Object value = VerifyService.getFirst(compareValue);
        if (null == invoiceValue || null == value) {
            return Pair.of((Object)Boolean.FALSE, (Object)"");
        }
        if (compareValue.getClass().isArray()) {
            Object[] array = (Object[])compareValue;
            StringBuilder sb = new StringBuilder();
            for (Object obj : array) {
                if (invoiceValue.toString().indexOf(obj.toString()) < 0) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(obj.toString());
            }
            return Pair.of((Object)(sb.length() > 0 ? 1 : 0), (Object)sb.toString());
        }
        if (compareValue instanceof List) {
            List list = (List)compareValue;
            StringBuilder sb = new StringBuilder();
            for (Object obj : list) {
                if (invoiceValue.toString().indexOf(obj.toString()) < 0) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(obj.toString());
            }
            return Pair.of((Object)(sb.length() > 0 ? 1 : 0), (Object)sb.toString());
        }
        return Pair.of((Object)(invoiceValue.toString().indexOf(value.toString()) > -1 ? 1 : 0), (Object)value.toString());
    }

    private static Date getQuarter() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        if (month <= 2) {
            calendar.set(2, 0);
        } else if (month <= 5) {
            calendar.set(2, 3);
        } else if (month <= 8) {
            calendar.set(2, 6);
        } else {
            calendar.set(2, 9);
        }
        return DateUtils.getFirstDateOfMonth(calendar.getTime());
    }

    private static Integer comare(Object value1, Object value2) {
        if (value1 != null && value2 != null) {
            if (VerifyService.isNumberType(value1).booleanValue()) {
                return BigDecimalUtil.transDecimal(value1).compareTo(BigDecimalUtil.transDecimal(value2));
            }
            if (StringUtils.isNumeric((CharSequence)value1.toString()) && StringUtils.isNumeric((CharSequence)value2.toString())) {
                return BigDecimalUtil.transDecimal(value1).compareTo(BigDecimalUtil.transDecimal(value2));
            }
            if (value1 instanceof Date) {
                Date invoiceDate = (Date)value1;
                Date date = null;
                if (value2 instanceof Date) {
                    return invoiceDate.compareTo((Date)value2);
                }
                try {
                    date = DateUtils.stringToDate(value2.toString());
                    return invoiceDate.compareTo(date);
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
            return value1.toString().compareTo(value2.toString());
        }
        return null;
    }

    private static Boolean isNumberType(Object value) {
        return value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof BigDecimal;
    }

    private static Object getFirst(Object compareValue) {
        return VerifyService.getCollectionValue(compareValue, 0);
    }

    private static Object getInvoiceValue(String type, Map<String, Object> invoiceMap, String fieldId) {
        if (fieldId.startsWith("items.") || fieldId.startsWith("items$") || fieldId.startsWith("items_")) {
            List items = (List)invoiceMap.get("items");
            if (!CollectionUtils.isEmpty((Collection)items)) {
                ArrayList list = new ArrayList(items.size());
                String key = fieldId.substring(6, fieldId.length());
                for (int i = 0; i < items.size(); ++i) {
                    Map map = (Map)items.get(i);
                    list.add(map.get(key));
                }
                return list;
            }
        } else {
            if ("buyer_name".equals(type) || "buyer_tax_no".equals(type) || "saler_tax_no".equals(type)) {
                return VerifyService.trimCompanyNameOfInvoice(invoiceMap.get(fieldId));
            }
            if ("buyer_account".equals(type) || "buyer_address_phone".equals(type)) {
                return VerifyService.replaceSpaceOfInvoice(invoiceMap.get(fieldId));
            }
            if (StringUtils.equals((CharSequence)"buyer_name_and_tax_no", (CharSequence)type)) {
                return VerifyService.trimCompanyNameOrTaxNo(invoiceMap.get("buyer_name"), invoiceMap.get("buyer_tax_no"));
            }
            if (StringUtils.equals((CharSequence)"saler_name_and_tax_no", (CharSequence)type)) {
                return VerifyService.trimCompanyNameOrTaxNo(invoiceMap.get("saler_name"), invoiceMap.get("saler_tax_no"));
            }
            if ("saler_name".equals(type)) {
                return VerifyService.trimCompanyNameInvoice(invoiceMap.get(fieldId));
            }
            if ("original_state".equals(fieldId)) {
                try {
                    JSONObject info;
                    String prevOriginalState;
                    Object extInfo = invoiceMap.get("ext_info");
                    if (extInfo != null && StringUtils.isNotEmpty((CharSequence)(prevOriginalState = (info = JSONObject.parseObject((String)(extInfo + ""))).getString("prevOriginalState")))) {
                        return prevOriginalState;
                    }
                }
                catch (Exception exception) {}
            } else if ("invoice_date".equals(fieldId) && invoiceMap.get(fieldId) != null) {
                return DateUtils.getDayStart((Date)invoiceMap.get(fieldId));
            }
            return invoiceMap.get(fieldId);
        }
        return null;
    }

    private static Object getInvoiceValue(String type, Map<String, Object> invoiceMap, String fieldId, List<String> ignoreSpecialChar) {
        if (fieldId.startsWith("items.") || fieldId.startsWith("items$") || fieldId.startsWith("items_")) {
            List items = (List)invoiceMap.get("items");
            if (!CollectionUtils.isEmpty((Collection)items)) {
                ArrayList list = new ArrayList(items.size());
                String key = fieldId.substring(6, fieldId.length());
                for (int i = 0; i < items.size(); ++i) {
                    Map map = (Map)items.get(i);
                    list.add(map.get(key));
                }
                return list;
            }
        } else {
            if ("buyer_name".equals(type) || "buyer_tax_no".equals(type) || "saler_name".equals(type) || "saler_tax_no".equals(type)) {
                return VerifyService.trimCompanyNameOfInvoice(invoiceMap.get(fieldId), ignoreSpecialChar);
            }
            if ("buyer_account".equals(type) || "buyer_address_phone".equals(type)) {
                return VerifyService.replaceSpaceOfInvoice(invoiceMap.get(fieldId));
            }
            if (StringUtils.equals((CharSequence)"buyer_name_and_tax_no", (CharSequence)type)) {
                return VerifyService.trimCompanyNameOrTaxNo(invoiceMap.get("buyer_name"), invoiceMap.get("buyer_tax_no"), ignoreSpecialChar);
            }
            if (StringUtils.equals((CharSequence)"saler_name_and_tax_no", (CharSequence)type)) {
                return VerifyService.trimCompanyNameOrTaxNo(invoiceMap.get("saler_name"), invoiceMap.get("saler_tax_no"));
            }
            if ("original_state".equals(fieldId)) {
                try {
                    JSONObject info;
                    String prevOriginalState;
                    Object extInfo = invoiceMap.get("ext_info");
                    if (extInfo != null && StringUtils.isNotEmpty((CharSequence)(prevOriginalState = (info = JSONObject.parseObject((String)(extInfo + ""))).getString("prevOriginalState")))) {
                        return prevOriginalState;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return invoiceMap.get(fieldId);
        }
        return null;
    }

    private static Boolean queryExpenseNum(Map<String, Object> param, Map<String, Object> invoiceInfo, VerifyResultDto item) {
        Boolean flag = Boolean.FALSE;
        List billList = (List)invoiceInfo.get("expenseBillList");
        if (billList == null || billList.isEmpty()) {
            return flag;
        }
        HashMap billUserMap = new HashMap(4);
        for (Map billInfo : billList) {
            String expense_num = (String)billInfo.get("expense_num");
            String expense_id = (String)billInfo.get("expense_id");
            String userName = (String)billInfo.get("showUserName");
            TreeSet<String> noSet = (TreeSet<String>)billUserMap.get(userName);
            if (noSet == null) {
                noSet = new TreeSet<String>();
            }
            if (StringUtils.isNotEmpty((CharSequence)expense_num)) {
                noSet.add(expense_num);
            } else {
                noSet.add(expense_id);
            }
            billUserMap.put(userName, noSet);
        }
        StringBuilder htmlMsg = new StringBuilder();
        StringBuilder msg = new StringBuilder();
        htmlMsg.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
        int index = 0;
        for (Map.Entry userInfo : billUserMap.entrySet()) {
            htmlMsg.append("<p style=\"margin-left: 3px;\"><span>");
            String expenUserInfo = null;
            expenUserInfo = StringUtils.isNotEmpty((CharSequence)((CharSequence)userInfo.getKey())) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u65e0\u5269\u4f59\u53ef\u62a5\u8d26\u989d\u5ea6\uff0c\u5df2\u88ab\u5355\u636e[%1$s]\u4f7f\u7528,\u63d0\u5355\u4eba\u4e3a%2$s,\u8bf7\u5148\u8054\u7cfb\u63d0\u5355\u4eba\u5220\u9664\u4e0a\u8ff0\u5355\u636e\uff0c\u5982\u4ecd\u63d0\u793a\u88ab\u5360\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u89e3\u7ed1", (String)"VerifyService_75", (String)"imc-rim-common", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable)userInfo.getValue()), userInfo.getKey()) : String.format(ResManager.loadKDString((String)"\u53d1\u7968\u65e0\u5269\u4f59\u53ef\u62a5\u8d26\u989d\u5ea6\uff0c\u5df2\u88ab\u5355\u636e[%1$s]\u4f7f\u7528,\u8bf7\u5148\u8054\u7cfb\u63d0\u5355\u4eba\u5220\u9664\u4e0a\u8ff0\u5355\u636e\uff0c\u5982\u4ecd\u63d0\u793a\u88ab\u5360\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u89e3\u7ed1", (String)"VerifyService_76", (String)"imc-rim-common", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable)userInfo.getValue()));
            htmlMsg.append(expenUserInfo);
            if (index < billUserMap.size() - 1) {
                htmlMsg.append("\uff1b");
            }
            htmlMsg.append("</span></p>");
            if (index > 0) {
                msg.append("\uff1b");
            }
            msg.append(expenUserInfo);
            ++index;
        }
        htmlMsg.append("</div>");
        item.setHtmlMsg(htmlMsg.toString());
        flag = Boolean.TRUE;
        item.setMsg(msg.toString());
        return flag;
    }

    private static String getExpenseUser(String showAllName, String userName) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            if (StringUtils.equals((CharSequence)showAllName, (CharSequence)"1")) {
                sb.append(userName);
            } else {
                String name = VerifyService.replaceNameExt(userName);
                String start = name.substring(0, 1);
                sb.append(start);
                if (name.length() <= 2) {
                    sb.append("*");
                } else {
                    int index = name.length() - 2;
                    for (int i = 0; i < index; ++i) {
                        sb.append("*");
                    }
                    String end = name.substring(name.length() - 1, name.length());
                    sb.append(end);
                }
            }
        }
        return sb.toString();
    }

    private static String replaceNameExt(String name) {
        return name.replaceAll("(\uff08|\\(|\\.).*", "");
    }

    private static String join(Object data, String str) {
        return VerifyService.joinLimitSize(data, str, -1);
    }

    private static String joinLimitSize(Object data, String str, int maxSize) {
        if (data == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList list = Lists.newArrayList();
        if (data.getClass().isArray()) {
            Collections.addAll(list, (Object[])data);
        } else if (data instanceof List) {
            list.addAll((List)data);
        }
        for (int i = 0; i < list.size() && (i < maxSize || maxSize == -1); ++i) {
            if (sb.length() > 0) {
                sb.append(str);
            }
            sb.append(list.get(i));
        }
        if (maxSize != -1 && list.size() > maxSize) {
            sb.append(ResManager.loadKDString((String)"\u7b49......", (String)"VerifyService_49", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public static Boolean isSequenceNo(Long invoiceType, String invoiceCode, List<String> noList) {
        if (CollectionUtils.isEmpty(noList)) {
            return Boolean.FALSE;
        }
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceCode));
        QFilter invoiceNoFilter = new QFilter("invoice_no", "in", noList);
        QFilter expenseStausFilter = new QFilter("expense_status", "in", (Object)ExpenseConstant.getUsedStatus());
        DynamicObject mainObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id", (QFilter[])new QFilter[]{invoiceTypeFilter, invoiceCodeFilter, invoiceNoFilter, expenseStausFilter});
        return mainObject != null;
    }

    public static List<String> getSequenceNoList(String invoiceNo, int count) {
        BigDecimal intvalue = BigDecimalUtil.transDecimal(invoiceNo);
        int start = 0 - count;
        int end = count;
        ArrayList<String> list = new ArrayList<String>(count * 2);
        if (count <= 0 || StringUtils.isEmpty((CharSequence)invoiceNo)) {
            return list;
        }
        String format = "00000000000000000000000000000000";
        DecimalFormat decimalFormat = new DecimalFormat(format.substring(0, invoiceNo.length()));
        for (int i = start; i <= end; ++i) {
            BigDecimal intvalue2;
            if (i == 0 || BigDecimal.ZERO.compareTo(intvalue2 = intvalue.add(new BigDecimal(i))) > 0) continue;
            list.add(decimalFormat.format(intvalue2));
        }
        return list;
    }

    public static String getResultMsg(Object list) {
        if (list == null) {
            return ResManager.loadKDString((String)"\u5408\u89c4\u6027\u6821\u9a8c\u901a\u8fc7", (String)"VerifyService_50", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        String jsonStr = SerializationUtils.toJsonString((Object)list);
        JSONArray resultList = JSONArray.parseArray((String)jsonStr);
        StringBuilder sb = new StringBuilder();
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            JSONObject obj = resultList.getJSONObject(i);
            if (i == size - 1) {
                sb.append(obj.getString("name"));
                continue;
            }
            sb.append(obj.getString("name")).append('\uff0c');
        }
        if (sb.length() <= 1) {
            return ResManager.loadKDString((String)"\u5408\u89c4\u6027\u6821\u9a8c\u901a\u8fc7", (String)"VerifyService_50", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        return sb.toString();
    }

    public static String getResultMsgHtml(Object listObject) {
        if (null == listObject) {
            return "";
        }
        String jsonStr = SerializationUtils.toJsonString((Object)listObject);
        JSONArray resultList = JSONArray.parseArray((String)jsonStr);
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"content\" id=\"tipTxt0\">");
        HashMap<String, ArrayList<JSONObject>> typeMap = new HashMap<String, ArrayList<JSONObject>>(4);
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            JSONObject dto = resultList.getJSONObject(i);
            ArrayList<JSONObject> list = (ArrayList<JSONObject>)typeMap.get(dto.getString("config"));
            if (list == null) {
                list = new ArrayList<JSONObject>(8);
            }
            list.add(dto);
            typeMap.put(dto.getString("config"), list);
        }
        for (Map.Entry entry : typeMap.entrySet()) {
            sb.append(VerifyService.getResultHtmlByJson((String)entry.getKey(), (List)entry.getValue()));
        }
        sb.append("</div> ");
        return sb.toString();
    }

    private static String getResultHtmlByJson(String level, List<JSONObject> list) {
        StringBuilder sb = new StringBuilder();
        if ("0".equals(level)) {
            sb.append("<div class=\"subTitle\"> <img src=\"./kingdee/imc/datagrid/icons/forbid_icon.png\" width=\"16px\" height=\"16px\" />  ");
            sb.append(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a\uff08\u7981\u6b62\u5bfc\u5165\uff09\uff1a", (String)"VerifyService_51", (String)"imc-rim-common", (Object[])new Object[0])).append("</div>");
        } else if ("1".equals(level)) {
            sb.append("<div class=\"subTitle\"> <img src=\"./kingdee/imc/datagrid/icons/err_icon.png\" width=\"16px\" height=\"16px\" />  ");
            sb.append(ResManager.loadKDString((String)"\u4e2d\u5ea6\u8b66\u793a\uff1a", (String)"VerifyService_52", (String)"imc-rim-common", (Object[])new Object[0]));
            sb.append("</div>");
        } else if ("2".equals(level)) {
            sb.append("<div class=\"subTitle\"> <img src=\"./kingdee/imc/datagrid/icons/waring_icon.png\" width=\"16px\" height=\"16px\" />  ");
            sb.append(ResManager.loadKDString((String)"\u8f7b\u5ea6\u63d0\u9192\uff1a", (String)"VerifyService_53", (String)"imc-rim-common", (Object[])new Object[0]));
            sb.append("</div>");
        }
        sb.append(VerifyService.getResultHtmlByJsonItem(list));
        return sb.toString();
    }

    private static String getResultHtmlByJsonItem(List<JSONObject> list) {
        StringBuilder sb = new StringBuilder();
        for (JSONObject dto : list) {
            if (StringUtils.isEmpty((CharSequence)dto.getString("htmlMsg"))) {
                sb.append("<div style=\"margin-left: 20px; margin-bottom: 6px;\">");
                sb.append("<p style=\"margin-left: 3px;\"><span>").append(dto.getString("msg")).append("</span></p>");
                sb.append("</div>");
                continue;
            }
            sb.append(dto.getString("htmlMsg"));
        }
        return sb.toString();
    }

    private static Object getCollectionValue(Object compareValue, int index) {
        if (null == compareValue) {
            return null;
        }
        if (compareValue.getClass().isArray()) {
            Object[] array = (Object[])compareValue;
            if (array.length > index) {
                return array[index];
            }
        } else if (compareValue instanceof List) {
            List list = (List)compareValue;
            if (list.size() > index) {
                return list.get(index);
            }
        } else {
            return compareValue;
        }
        return null;
    }

    private static Object trimCompanyNameOfInvoice(Object companyName) {
        if (ObjectUtils.isEmpty((Object)companyName)) {
            return "";
        }
        if (companyName instanceof String) {
            return VerifyService.trimSpecialSymbols(companyName.toString());
        }
        if (companyName.getClass().isArray()) {
            Object[] array = (Object[])companyName;
            for (int i = 0; i < array.length; ++i) {
                array[i] = VerifyService.trimSpecialSymbols(array[i].toString());
            }
            return array;
        }
        if (companyName instanceof List) {
            List list = (List)companyName;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, VerifyService.trimSpecialSymbols(list.get(i)));
            }
            return list;
        }
        return null;
    }

    private static Object trimCompanyNameInvoice(Object companyName) {
        if (ObjectUtils.isEmpty((Object)companyName)) {
            return "";
        }
        if (companyName instanceof String) {
            return VerifyService.trimBlackListSpecialSymbol(companyName.toString());
        }
        if (companyName.getClass().isArray()) {
            Object[] array = (Object[])companyName;
            for (int i = 0; i < array.length; ++i) {
                array[i] = VerifyService.trimBlackListSpecialSymbol(array[i].toString());
            }
            return array;
        }
        if (companyName instanceof List) {
            List list = (List)companyName;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, VerifyService.trimBlackListSpecialSymbol(list.get(i)));
            }
            return list;
        }
        return null;
    }

    private static Object trimCompanyNameOfInvoice(Object companyName, List<String> options) {
        if (ObjectUtils.isEmpty((Object)companyName)) {
            return "";
        }
        if (companyName instanceof String) {
            return VerifyService.trimSpecialSymbols(options, companyName.toString());
        }
        if (companyName.getClass().isArray()) {
            Object[] array = (Object[])companyName;
            for (int i = 0; i < array.length; ++i) {
                array[i] = VerifyService.trimSpecialSymbols(options, array[i].toString());
            }
            return array;
        }
        if (companyName instanceof List) {
            List list = (List)companyName;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, VerifyService.trimSpecialSymbols(options, list.get(i)));
            }
            return list;
        }
        return null;
    }

    private static Object trimCompanyName(Object companyName) {
        if (ObjectUtils.isEmpty((Object)companyName)) {
            return null;
        }
        if (companyName instanceof String) {
            return VerifyService.trimSpecialSymbols(companyName.toString());
        }
        if (companyName.getClass().isArray()) {
            Object[] array = (Object[])companyName;
            for (int i = 0; i < array.length; ++i) {
                array[i] = VerifyService.trimSpecialSymbols(array[i].toString());
            }
            return array;
        }
        if (companyName instanceof List) {
            List list = (List)companyName;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, VerifyService.trimSpecialSymbols(list.get(i)));
            }
            return list;
        }
        return null;
    }

    private static Object trimCompanyName(Object companyName, List<String> options) {
        if (ObjectUtils.isEmpty((Object)companyName)) {
            return null;
        }
        if (companyName instanceof String) {
            return VerifyService.trimSpecialSymbols(options, companyName.toString());
        }
        if (companyName.getClass().isArray()) {
            Object[] array = (Object[])companyName;
            for (int i = 0; i < array.length; ++i) {
                array[i] = VerifyService.trimSpecialSymbols(options, array[i].toString());
            }
            return array;
        }
        if (companyName instanceof List) {
            List list = (List)companyName;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, VerifyService.trimSpecialSymbols(options, list.get(i)));
            }
            return list;
        }
        return null;
    }

    private static String getCheckResult(String checkResult) {
        if (checkResult != null) {
            String errorCode;
            String checkDescription;
            int rightIndex = checkResult.indexOf(93);
            int leftIndex = checkResult.indexOf(91);
            if (leftIndex >= 0 && rightIndex > leftIndex && !StringUtils.isEmpty((CharSequence)(checkDescription = CheckContant.getCheckResultDesc(errorCode = checkResult.substring(leftIndex + 1, rightIndex))))) {
                return "[" + errorCode + "]" + checkDescription;
            }
        }
        return checkResult;
    }

    public static String trimSpecialSymbols(Object companyName) {
        if (companyName != null) {
            String str = companyName.toString().trim();
            if (str.indexOf(65288) >= 0) {
                str = str.replace('\uff08', '(');
            }
            if (str.indexOf(65289) >= 0) {
                str = str.replace('\uff09', ')');
            }
            if (str.indexOf(65113) >= 0) {
                str = str.replace('\ufe59', '(');
            }
            if (str.indexOf(65114) >= 0) {
                str = str.replace('\ufe5a', ')');
            }
            str = VerifyService.trimStringToEmpty(str).replace("\u00a0", "");
            return str.replaceAll("^[\u3000*| *| *|//*]*", "").replaceAll("[\u3000*| *| *|//*]*$", "").replace(" ", "");
        }
        return null;
    }

    private static String trimStringToEmpty(String str) {
        if (str == null) {
            return "";
        }
        return str.trim().replace("\u200b", "").replace("\u00a0", "");
    }

    public static String trimBlackListSpecialSymbol(Object companyName) {
        if (companyName == null) {
            return null;
        }
        String input = companyName.toString();
        input = input.trim();
        input = VerifyService.replaceBrackets(input);
        return VerifyService.replaceDashes(input);
    }

    public static String trimSpecialSymbols(List<String> options, Object companyName) {
        if (companyName == null) {
            return null;
        }
        String input = companyName.toString();
        if (options.isEmpty()) {
            input = input.trim();
            input = VerifyService.replaceBrackets(input);
            input = VerifyService.replaceDashes(input);
            return input;
        }
        if (options.contains("1")) {
            input = VerifyService.trimStringToEmpty(input);
        }
        if (options.contains("2")) {
            input = VerifyService.replaceBrackets(input);
        }
        if (options.contains("3")) {
            input = VerifyService.replaceDashes(input);
        }
        if (options.contains("5")) {
            input = input.trim();
            input = input.replace("\u200b", "").replace("\u00a0", "");
            input = input.replaceAll("^[\u3000*| *| *|//*]*", "").replaceAll("[\u3000*| *| *|//*]*$", "").replace(" ", "");
        }
        return input;
    }

    private static String replaceBrackets(String str) {
        if (str.indexOf(65288) >= 0) {
            str = str.replace('\uff08', '(');
        }
        if (str.indexOf(65289) >= 0) {
            str = str.replace('\uff09', ')');
        }
        if (str.indexOf(65113) >= 0) {
            str = str.replace('\ufe59', '(');
        }
        if (str.indexOf(65114) >= 0) {
            str = str.replace('\ufe5a', ')');
        }
        return str;
    }

    private static String replaceDashes(String input) {
        return input.replaceAll("\u2014{2}", "-").replace("\u2014", "-").replace("-", "-");
    }

    private static List<Object> changeToList(Object object) {
        Object trimObject = VerifyService.trimCompanyName(object);
        if (trimObject == null) {
            return new ArrayList<Object>();
        }
        ArrayList companyNameList = Lists.newArrayList();
        if (trimObject.getClass().isArray()) {
            Collections.addAll(companyNameList, (Object[])trimObject);
        } else if (trimObject instanceof List) {
            companyNameList.addAll((List)trimObject);
        } else if (trimObject instanceof String) {
            companyNameList.add(trimObject);
        }
        return companyNameList;
    }

    private static List<Object> changeToList(Object object, List<String> options) {
        Object trimObject = VerifyService.trimCompanyName(object, options);
        if (trimObject == null) {
            return new ArrayList<Object>();
        }
        ArrayList companyNameList = Lists.newArrayList();
        if (trimObject.getClass().isArray()) {
            Collections.addAll(companyNameList, (Object[])trimObject);
        } else if (trimObject instanceof List) {
            companyNameList.addAll((List)trimObject);
        } else if (trimObject instanceof String) {
            companyNameList.add(trimObject);
        }
        return companyNameList;
    }

    private static Object trimCompanyNameOrTaxNo(Object companyName, Object taxNo) {
        if (ObjectUtils.isEmpty((Object)companyName) && ObjectUtils.isEmpty((Object)taxNo)) {
            return "";
        }
        List<String> nameAndTaxNoList = VerifyService.concatNameAndTaxNo(VerifyService.trimCompanyNameOfInvoice(companyName), VerifyService.trimCompanyNameOfInvoice(taxNo));
        if (nameAndTaxNoList.isEmpty()) {
            return "";
        }
        if (nameAndTaxNoList.size() == 1) {
            return nameAndTaxNoList.get(0);
        }
        return nameAndTaxNoList;
    }

    private static Object trimCompanyNameOrTaxNo(Object companyName, Object taxNo, List<String> ignoreSpecialChar) {
        if (ObjectUtils.isEmpty((Object)companyName) && ObjectUtils.isEmpty((Object)taxNo)) {
            return "";
        }
        List<String> nameAndTaxNoList = VerifyService.concatNameAndTaxNo(VerifyService.trimCompanyNameOfInvoice(companyName, ignoreSpecialChar), VerifyService.trimCompanyNameOfInvoice(taxNo));
        if (nameAndTaxNoList.isEmpty()) {
            return "";
        }
        if (nameAndTaxNoList.size() == 1) {
            return nameAndTaxNoList.get(0);
        }
        return nameAndTaxNoList;
    }

    private static List<String> concatNameAndTaxNo(Object companyName, Object taxNo) {
        ArrayList companyNameList = Lists.newArrayList();
        if (companyName != null && companyName.getClass().isArray()) {
            Collections.addAll(companyNameList, (Object[])companyName);
        } else if (companyName instanceof List) {
            companyNameList.addAll((List)companyName);
        } else if (companyName instanceof String) {
            companyNameList.add(companyName);
        }
        ArrayList taxNoList = Lists.newArrayList();
        if (taxNo != null && taxNo.getClass().isArray()) {
            Collections.addAll(taxNoList, (Object[])taxNo);
        } else if (taxNo instanceof List) {
            taxNoList.addAll((List)taxNo);
        } else if (taxNo instanceof String) {
            taxNoList.add(taxNo);
        }
        int size = companyNameList.size() > taxNoList.size() ? companyNameList.size() : taxNoList.size();
        ArrayList nameAndTaxNoList = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            String nameAndTaxNo = "";
            if (i < companyNameList.size()) {
                nameAndTaxNo = nameAndTaxNo + companyNameList.get(i);
            }
            nameAndTaxNo = nameAndTaxNo + "-";
            if (i < taxNoList.size()) {
                nameAndTaxNo = nameAndTaxNo + taxNoList.get(i);
            }
            nameAndTaxNoList.add(nameAndTaxNo);
        }
        return nameAndTaxNoList;
    }

    private static String replaceSpace(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        String result = VerifyService.trimSpecialSymbols(key);
        if (result != null) {
            return result.replaceAll("[\u3000*| *| *|//s*]*", "");
        }
        return null;
    }

    private static String replaceSpaceOfInvoice(Object key) {
        if (StringUtils.isBlank((Object)key)) {
            return "";
        }
        String result = VerifyService.trimSpecialSymbols(key);
        if (result != null) {
            return result.replaceAll("[\u3000*| *| *|//s*]*", "");
        }
        return "";
    }

    private static Map<String, Date> queryUsedName(List<Object> taxNoList, List<Object> buyerNameList) {
        HashMap<String, Date> namemap = new HashMap<String, Date>(8);
        if (taxNoList == null || taxNoList.isEmpty()) {
            return namemap;
        }
        try {
            QFilter filter = new QFilter("number", "in", taxNoList);
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)"number,usednameentry.used_name as used_name,usednameentry.used_name_date as used_name_date", (QFilter[])filter.toArray());
            List<String> buyerNameAndTaxNoList = VerifyService.concatNameAndTaxNo(VerifyService.trimCompanyName(buyerNameList), VerifyService.trimCompanyName(taxNoList));
            for (DynamicObject obj : collect) {
                String used_name = obj.getString("used_name");
                if (StringUtils.isEmpty((CharSequence)used_name)) continue;
                String number = obj.getString("number");
                String taxNo = (String)VerifyService.trimCompanyName(number);
                String name = (String)VerifyService.trimCompanyName(used_name);
                String nameAndTaxNo = name + '-' + taxNo;
                if (buyerNameAndTaxNoList.contains(nameAndTaxNo)) continue;
                namemap.put(nameAndTaxNo, obj.getDate("used_name_date"));
            }
        }
        catch (Exception e) {
            LOGGER.info("\u83b7\u53d6\u66fe\u7528\u540d\u5931\u8d25" + e.getMessage());
        }
        return namemap;
    }

    private static Map<String, Date> queryUsedName(List<Object> taxNoList, List<Object> buyerNameList, List<String> options) {
        HashMap<String, Date> namemap = new HashMap<String, Date>(8);
        if (taxNoList == null || taxNoList.isEmpty()) {
            return namemap;
        }
        try {
            QFilter filter = new QFilter("number", "in", taxNoList);
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)"number,usednameentry.used_name as used_name,usednameentry.used_name_date as used_name_date", (QFilter[])filter.toArray());
            List<String> buyerNameAndTaxNoList = VerifyService.concatNameAndTaxNo(VerifyService.trimCompanyName(buyerNameList, options), VerifyService.trimCompanyName(taxNoList));
            for (DynamicObject obj : collect) {
                String used_name = obj.getString("used_name");
                if (StringUtils.isEmpty((CharSequence)used_name)) continue;
                String number = obj.getString("number");
                String taxNo = (String)VerifyService.trimCompanyName(number);
                String name = (String)VerifyService.trimCompanyName(used_name, options);
                String nameAndTaxNo = name + '-' + taxNo;
                if (buyerNameAndTaxNoList.contains(nameAndTaxNo)) continue;
                namemap.put(nameAndTaxNo, obj.getDate("used_name_date"));
            }
        }
        catch (Exception e) {
            LOGGER.info("\u83b7\u53d6\u66fe\u7528\u540d\u5931\u8d25" + e.getMessage());
        }
        return namemap;
    }

    public static void convertBuyerInfo(JSONObject sourceJson, JSONObject tagJson) {
        if (sourceJson == null || tagJson == null) {
            return;
        }
        JSONArray companyInfo = sourceJson.getJSONArray("companyInfo");
        tagJson.put("companyInfo", (Object)companyInfo);
        if (companyInfo != null) {
            ArrayList<String> taxList = new ArrayList<String>(companyInfo.size());
            ArrayList<String> nameList = new ArrayList<String>(companyInfo.size());
            for (int i = 0; i < companyInfo.size(); ++i) {
                JSONObject info = companyInfo.getJSONObject(i);
                String taxNo = info.getString("taxNo");
                if (taxNo != null && taxNo.indexOf(61) > 0) {
                    String[] nos = taxNo.split("=");
                    String[] names = null;
                    String name = info.getString("name");
                    if (name != null) {
                        names = name.split("=");
                    }
                    for (int j = 0; j < nos.length; ++j) {
                        taxList.add(nos[j]);
                        if (names != null && names.length > j) {
                            nameList.add(names[j]);
                            continue;
                        }
                        nameList.add("");
                    }
                    continue;
                }
                taxList.add(info.getString("taxNo"));
                nameList.add(info.getString("name"));
            }
            tagJson.put("buyer_tax_no", taxList);
            tagJson.put("buyer_name", nameList);
        }
    }

    public static void convertSalerInfo(JSONObject sourceJson, JSONObject tagJson) {
        if (sourceJson == null || tagJson == null) {
            return;
        }
        JSONArray salerInfo = sourceJson.getJSONArray("salerInfo");
        tagJson.put("salerInfo", (Object)salerInfo);
        if (salerInfo != null) {
            ArrayList<String> taxList = new ArrayList<String>(salerInfo.size());
            ArrayList<String> nameList = new ArrayList<String>(salerInfo.size());
            for (int i = 0; i < salerInfo.size(); ++i) {
                JSONObject info = salerInfo.getJSONObject(i);
                taxList.add(info.getString("taxNo"));
                nameList.add(info.getString("name"));
            }
            tagJson.put("saler_tax_no", taxList);
            tagJson.put("saler_name", nameList);
        }
    }
}

