/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.license.service;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang3.StringUtils;

public class FpzsAnonymousUserService {
    private static Log logger = LogFactory.getLog(FpzsAnonymousUserService.class);
    private static final String eventCodeKey = "eventCode";
    public static final String insideCode = "incode2";
    private static final int timeout = 15;

    public static boolean isAnonymousUser() {
        RequestContext request = RequestContext.get();
        return "-1".equals(request.getUserId());
    }

    public static void preOpenForm(PreOpenFormEventArgs e) {
        if (FpzsAnonymousUserService.isAnonymousUser()) {
            int result;
            FormShowParameter parameter = e.getFormShowParameter();
            String anonymousForm = RimConfigUtils.getConfig("anonymous_form");
            if (anonymousForm != null && parameter.getFormId() != null && anonymousForm.indexOf(parameter.getFormId()) >= 0) {
                return;
            }
            Map customParams = parameter.getCustomParams();
            String code = (String)customParams.get(insideCode);
            if (code == null) {
                code = (String)customParams.get(eventCodeKey);
            }
            if ((result = FpzsAnonymousUserService.check(code)) == 1) {
                e.setCancel(true);
                logger.info("\u533f\u540d\u7528\u6237\u64cd\u4f5c\u9519\u8bef\uff1a\u975e\u6cd5\u53c2\u6570,{},{}", (Object)parameter.getFormId(), (Object)code);
                e.setCancelMessage(ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237\u64cd\u4f5c\u9519\u8bef\uff1a\u975e\u6cd5\u53c2\u6570", (String)"FpzsAnonymousUserService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                return;
            }
            if (result == 2) {
                e.setCancel(true);
                logger.info("\u533f\u540d\u7528\u6237\u64cd\u4f5c\u9519\u8bef\uff1a\u53c2\u6570\u9519\u8bef,{},{}", (Object)parameter.getFormId(), (Object)code);
                e.setCancelMessage(ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237\u64cd\u4f5c\u9519\u8bef\uff1a\u53c2\u6570\u9519\u8bef", (String)"FpzsAnonymousUserService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                return;
            }
        }
    }

    public static int check(String eventCode) {
        if (StringUtils.isEmpty((CharSequence)eventCode)) {
            return 1;
        }
        String body = CacheHelper.get("rim_event_code:" + eventCode);
        if (body == null) {
            return 2;
        }
        return 0;
    }

    public static void addEventCode(FormShowParameter param, String eventCode) {
        if (FpzsAnonymousUserService.isAnonymousUser()) {
            param.setCustomParam(insideCode, (Object)eventCode);
            CacheHelper.put("rim_event_code:" + eventCode, "1", 15);
        }
    }

    public static Map<String, Object> addEventCode(Map<String, Object> customParams, String eventCode) {
        if (FpzsAnonymousUserService.isAnonymousUser()) {
            CacheHelper.put("rim_event_code:" + eventCode, "1", 15);
            customParams.put(insideCode, eventCode);
        }
        return customParams;
    }

    public static void addEventCode(String eventCode, int thistimeOut) {
        CacheHelper.put("rim_event_code:" + eventCode, "1", thistimeOut);
    }
}

