/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.openapi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.multitenant.model.FpzsServiceOpenApiRequest;
import kd.imc.rim.common.multitenant.openapi.FpzsOpenApiService;
import kd.imc.rim.common.multitenant.service.impl.FpzsPluginLocalService;
import kd.imc.rim.common.utils.ListUtils;
import org.apache.commons.codec.binary.Base64;

public class FpzsPluginOpenApiImpl
extends FpzsOpenApiService {
    public ApiResult doBusiness(FpzsServiceOpenApiRequest request) {
        String method;
        switch (method = request.getReqMethod()) {
            case "dealWxPushInvoiceData": {
                return this.dealWxPushInvoiceData(request);
            }
            case "saveAwsAttach": {
                return this.saveAwsAttach(request);
            }
            case "getFpzsConfig": {
                return this.getFpzsConfig(request);
            }
            case "getFpzsAttachList": {
                return this.getFpzsAttachList(request);
            }
            case "afterCloseAttachUpload": {
                return this.afterCloseAttachUpload(request);
            }
            case "loadAttachById": {
                return this.loadAttachById(request);
            }
            case "getBillInvoiceIdAndAttachId": {
                return this.getBillInvoiceIdAndAttachId(request);
            }
            case "getMainIdBySerialNo": {
                return this.getMainIdBySerialNo(request);
            }
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"ErrorType_3", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    private ApiResult dealWxPushInvoiceData(FpzsServiceOpenApiRequest request) {
        FpzsPluginLocalService localService = new FpzsPluginLocalService();
        JSONObject param = this.getJSONObject(request.getReqParam());
        try {
            JSONObject businessParam = param.getJSONObject("businessParam");
            if (businessParam == null) {
                businessParam = new JSONObject();
            }
            businessParam.put("org_id", (Object)request.getReqOrgId());
            businessParam.put(InvoiceSaveConstant.OPERATE_USER_ID, (Object)request.getReqUserId());
            List<Long> list = localService.dealWxPushInvoiceData(param.getJSONArray("invoiceData"), param.getJSONArray("fids"), businessParam);
            return ApiResult.success(list);
        }
        catch (KDException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    private ApiResult saveAwsAttach(FpzsServiceOpenApiRequest request) {
        FpzsPluginLocalService localService = new FpzsPluginLocalService();
        JSONObject param = this.getJSONObject(request.getReqParam());
        try {
            List<Long> list = localService.saveAwsAttach(param.getJSONArray("attachmentDatas"), param.getLong("rimUser"));
            return ApiResult.success(list);
        }
        catch (KDException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    private ApiResult getFpzsConfig(FpzsServiceOpenApiRequest request) {
        FpzsPluginLocalService localService = new FpzsPluginLocalService();
        try {
            JSONObject list = localService.getFpzsConfig(request.getReqOrgId());
            String retStr = Base64.encodeBase64String((byte[])list.toJSONString().getBytes());
            return ApiResult.success((Object)retStr);
        }
        catch (KDException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    private ApiResult getFpzsAttachList(FpzsServiceOpenApiRequest request) {
        FpzsPluginLocalService localService = new FpzsPluginLocalService();
        JSONObject obj = this.getJSONObject(request.getReqParam());
        JSONArray attachIds = obj.getJSONArray("attachIds");
        JSONArray existsInvoice = obj.getJSONArray("invoiceSerialNos");
        HashSet<String> existsInvoiceSerialNos = new HashSet<String>(8);
        if (existsInvoice != null) {
            for (int i = 0; i < existsInvoice.size(); ++i) {
                existsInvoiceSerialNos.add(existsInvoice.getString(i));
            }
        }
        JSONArray array = localService.getFpzsAttachList(ListUtils.parseLongList(attachIds), existsInvoiceSerialNos);
        return ApiResult.success((Object)array);
    }

    private ApiResult afterCloseAttachUpload(FpzsServiceOpenApiRequest request) {
        FpzsPluginLocalService localService = new FpzsPluginLocalService();
        JSONObject obj = this.getJSONObject(request.getReqParam());
        JSONArray array = localService.afterCloseAttachUpload(obj.getJSONArray("uploadUrls"), (Map<String, Object>)obj.getJSONObject("customParam"), obj.getString("serialNo"));
        return ApiResult.success((Object)array);
    }

    private ApiResult loadAttachById(FpzsServiceOpenApiRequest request) {
        FpzsPluginLocalService localService = new FpzsPluginLocalService();
        JSONObject obj = this.getJSONObject(request.getReqParam());
        JSONObject array = localService.loadAttachById(obj.getLong("attachId"));
        return ApiResult.success((Object)array);
    }

    private ApiResult getBillInvoiceIdAndAttachId(FpzsServiceOpenApiRequest request) {
        FpzsPluginLocalService localService = new FpzsPluginLocalService();
        JSONObject obj = this.getJSONObject(request.getReqParam());
        JSONObject result = localService.getBillInvoiceIdAndAttachId((Map<String, Object>)obj);
        return ApiResult.success((Object)result);
    }

    private ApiResult getMainIdBySerialNo(FpzsServiceOpenApiRequest request) {
        FpzsPluginLocalService localService = new FpzsPluginLocalService();
        JSONObject obj = this.getJSONObject(request.getReqParam());
        JSONArray serialNos = obj.getJSONArray("serialNos");
        List<Long> result = localService.getMainIdBySerialNo(ListUtils.parseList(serialNos, String.class));
        return ApiResult.success(result);
    }
}

