/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.openapi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.multitenant.model.FpzsServiceOpenApiRequest;
import kd.imc.rim.common.multitenant.openapi.FpzsOpenApiService;
import kd.imc.rim.common.multitenant.service.impl.FpzsLocalService;
import kd.imc.rim.common.utils.CacheHelper;

public class FpzsServiceOpenApiImpl
extends FpzsOpenApiService {
    public ApiResult doBusiness(FpzsServiceOpenApiRequest request) {
        String method = request.getReqMethod();
        try {
            switch (method) {
                case "save": {
                    return this.save(request);
                }
                case "delete": 
                case "deleteAttach": 
                case "deleteInvoice": 
                case "queryVerify": 
                case "check": 
                case "checkNew": 
                case "saveVoucher": 
                case "queryInvoiceAndFile": 
                case "queryInvoice": 
                case "queryAttach": 
                case "queryCover": 
                case "deleteVoucher": 
                case "saveVoucherCover": 
                case "editInvoice": {
                    return this.common(request, method, "Map");
                }
                case "queryFile": {
                    return this.queryFile(request);
                }
                case "signInvoice": 
                case "unSignInvoice": {
                    return this.common(request, method, "List");
                }
                case "recognitionCheck": {
                    return this.recognitionCheck(request);
                }
                case "getFpzsPushData": {
                    return this.getFpzsPushData(request);
                }
                case "eventCode": {
                    return this.eventCode(request);
                }
                case "saveBatch": 
                case "deleteBatch": {
                    return this.batch(request);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            ApiResult apiResult = new ApiResult();
            apiResult.setErrorCode("0023");
            apiResult.setMessage(ResManager.loadKDString((String)"method\u53c2\u6570\u4e0d\u5408\u6cd5", (String)"FpzsServiceOpenApiImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            apiResult.setSuccess(false);
            return apiResult;
        }
        return null;
    }

    private ApiResult common(FpzsServiceOpenApiRequest request, String method, String methodType) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object param = null;
        param = "Map".equals(methodType) ? this.getJSONObject(request.getReqParam()) : this.getJSONArray(request.getReqParam());
        Class<FpzsLocalService> clazz = FpzsLocalService.class;
        Method[] methods = clazz.getMethods();
        Method classMethod = null;
        for (Method meth : methods) {
            if (!meth.getName().equals(method)) continue;
            int size = meth.getParameters().length;
            AnnotatedType type = meth.getParameters()[0].getAnnotatedType();
            if (type.getType().getTypeName().indexOf(methodType) <= 0) continue;
            classMethod = meth;
            break;
        }
        if (classMethod == null) {
            ApiResult apiResult = new ApiResult();
            apiResult.setErrorCode("0023");
            apiResult.setMessage(ResManager.loadKDString((String)"method\u53c2\u6570\u4e0d\u5408\u6cd5", (String)"FpzsServiceOpenApiImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            apiResult.setSuccess(false);
            return apiResult;
        }
        Map result = (Map)classMethod.invoke((Object)new FpzsLocalService(), param);
        return this.createApiResult(result);
    }

    private ApiResult queryFile(FpzsServiceOpenApiRequest request) {
        JSONArray param = this.getJSONArray(request.getReqParam());
        ArrayList<String> paramList = new ArrayList<String>(param.size());
        for (int i = 0; i < param.size(); ++i) {
            paramList.add(param.getString(i));
        }
        FpzsLocalService localService = new FpzsLocalService();
        List<Map<String, String>> list = localService.queryFile(paramList);
        ApiResult apiResult = new ApiResult();
        apiResult.setErrorCode("0000");
        apiResult.setData(list);
        return apiResult;
    }

    private ApiResult save(FpzsServiceOpenApiRequest request) {
        FpzsLocalService localService = new FpzsLocalService();
        JSONObject jsonObject = this.getJSONObject(request.getReqParam());
        this.setOrgId(jsonObject, "orgId");
        Map<String, Object> result = localService.save((Map<String, Object>)jsonObject);
        return this.createApiResult(result);
    }

    private ApiResult recognitionCheck(FpzsServiceOpenApiRequest request) {
        FpzsLocalService localService = new FpzsLocalService();
        JSONObject jsonObject = this.getJSONObject(request.getReqParam());
        jsonObject.put("orgId", (Object)request.getReqOrgId());
        Map<String, Object> result = localService.recognitionCheck((Map<String, Object>)jsonObject);
        return this.createApiResult(result);
    }

    private ApiResult createApiResult(Map<String, Object> result) {
        ApiResult apiResult = new ApiResult();
        apiResult.setErrorCode((String)result.get("errcode"));
        apiResult.setMessage((String)result.get("description"));
        apiResult.setData(result.get("data"));
        return apiResult;
    }

    private ApiResult getFpzsPushData(FpzsServiceOpenApiRequest request) {
        String cacheKey = "rim_push:" + request.getReqParam().toString();
        String dataJson = CacheHelper.get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)dataJson)) {
            CacheHelper.remove(cacheKey);
        }
        return ApiResult.success((Object)dataJson);
    }

    private ApiResult eventCode(FpzsServiceOpenApiRequest request) {
        String eventCode = FpzsMainService.createEventCode(this.getJSONObject(request.getReqParam()));
        return ApiResult.success((Object)eventCode);
    }

    private ApiResult batch(FpzsServiceOpenApiRequest request) {
        FpzsLocalService localService = new FpzsLocalService();
        Map<String, Object> result = null;
        List<Map<String, Object>> paramList = this.getListMap(this.getJSONArray(request.getReqParam()));
        if ("saveBatch".equals(request.getReqMethod())) {
            result = localService.saveBatch(paramList);
            return this.createApiResult(result);
        }
        if ("deleteBatch".equals(request.getReqMethod())) {
            result = localService.deleteBatch(paramList);
            return this.createApiResult(result);
        }
        return ApiResult.success(null);
    }

    private List<Map<String, Object>> getListMap(JSONArray paramList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(paramList.size());
        for (int i = 0; i < paramList.size(); ++i) {
            list.add((Map<String, Object>)paramList.getJSONObject(i));
        }
        return list;
    }
}

