/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.SpecialTypeMarkEnum;
import kd.imc.rim.common.expense.domain.ExpenseCoverDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.impl.InOutputInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.fpzs.FpzsCommonService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.multitenant.service.impl.FpzsLocalService;
import kd.imc.rim.common.multitenant.service.impl.FpzsRemoteService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import org.apache.commons.lang.BooleanUtils;

public abstract class AbstractFpzsService {
    private static final Log logger = LogFactory.getLog(AbstractFpzsService.class);
    public static final int BILL_OPERATE_MAX_SIZE = 1000;
    private static final Pattern AMOUNT_PATTERN = Pattern.compile("^\\d+(\\.\\d{0,9})?$");
    private static final Set<String> INVALID_KEYS = new HashSet<String>();

    public static AbstractFpzsService newInstance() {
        MultiTenantService service = new MultiTenantService();
        if (service.isMultiTenant()) {
            return new FpzsRemoteService();
        }
        return new FpzsLocalService();
    }

    public abstract Map<String, Object> billCreate(Map<String, Object> var1);

    public abstract Map<String, Object> billUpdate(Map<String, Object> var1);

    public abstract Map<String, Object> statusUpdate(Map<String, Object> var1);

    public abstract Map<String, Object> save(Map<String, Object> var1);

    public abstract Map<String, Object> saveBatch(List<Map<String, Object>> var1);

    public abstract Map<String, Object> deleteBatch(List<Map<String, Object>> var1);

    public void pushBdsBySave(ExpenseDTO dto) {
        String expenseNum = dto.getExpenseNum();
        String pushBdsImageSys = RimConfigUtils.getConfig("push_bds_image_sys");
        if (!"1".equals(pushBdsImageSys)) {
            logger.info("\u672a\u5f00\u542f\u63a8\u9001\u81f3\u5f71\u50cf\u914d\u7f6e:{}", (Object)expenseNum);
            return;
        }
        try {
            JSONObject map = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto));
            String billId = (String)map.get((Object)"expenseId");
            String entityId = (String)map.get((Object)"entityId");
            AttachQueryService attachQueryService = new AttachQueryService();
            JSONArray invoiceAttachObj = attachQueryService.queryFpzsAttach(billId, entityId, "4", true);
            map.put("attachList", (Object)invoiceAttachObj);
            ExpenseRelationService ers = new ExpenseRelationService();
            String fileBagNo = ers.queryFileBagNo(dto.getExpenseId(), entityId);
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)fileBagNo)) {
                map.put("fileBagNo", (Object)fileBagNo);
            }
            logger.info("\u63a8\u9001\u661f\u701a\u5f71\u50cf\uff1a{}", (Object)map);
            DispatchServiceHelper.invokeBizService((String)"imc", (String)"bds", (String)"ReceiveRimService", (String)"saveExpenseInfo", (Object[])new Object[]{map});
        }
        catch (Exception e) {
            logger.info("beanToMap Exception:", (Object)e);
        }
    }

    public abstract Map<String, Object> delete(Map<String, Object> var1);

    public void pushBdsByDelete(ExpenseDTO dto) {
        String pushBdsImageSys = RimConfigUtils.getConfig("push_bds_image_sys");
        if (!"1".equals(pushBdsImageSys)) {
            logger.info("\u672a\u5f00\u542f\u63a8\u9001\u81f3\u5f71\u50cf\u914d\u7f6e:{}", (Object)dto.getExpenseNum());
            return;
        }
        String expenseId = dto.getExpenseId();
        if (org.apache.commons.lang.StringUtils.isEmpty((String)expenseId)) {
            return;
        }
        try {
            JSONObject map = JSON.parseObject((String)JSONObject.toJSONString((Object)dto));
            DispatchServiceHelper.invokeBizService((String)"imc", (String)"bds", (String)"ReceiveRimService", (String)"deleteExpenseInfo", (Object[])new Object[]{map});
        }
        catch (Exception e) {
            logger.info("beanToMap Exception:", (Object)e);
        }
    }

    public abstract Map<String, Object> deleteAttach(Map<String, Object> var1);

    public abstract Map<String, Object> deleteInvoice(List<String> var1);

    public Map<String, Object> query(List<String> param, String resource) {
        return this.query(param, resource, null);
    }

    public abstract Map<String, Object> query(List<String> var1, String var2, String var3);

    public void convertDateLong(Map<String, Object> bodyMap, String ... timeKeys) {
        if (bodyMap == null) {
            return;
        }
        for (String timeKey : timeKeys) {
            String pattern = "yyyy-MM-dd HH:mm:ss";
            if ("invoice_date".equals(timeKey) || "invoiceDate".equals(timeKey)) {
                pattern = "yyyy-MM-dd";
            }
            try {
                Long time = (Long)bodyMap.get(timeKey);
                Date date = new Date(time);
                SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                String dateString = formatter.format(date);
                bodyMap.put(timeKey, dateString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map<String, Object> query(List<String> param) {
        return this.query(param, null);
    }

    public abstract Map<String, Object> queryVerify(Map<String, Object> var1);

    public abstract Map<String, Object> check(Map<String, Object> var1);

    public abstract Map<String, Object> checkNew(Map<String, Object> var1);

    protected ExpenseDTO getExpenseDTO(Map<String, Object> param) {
        JSONArray invoiceData;
        String json = SerializationUtils.toJsonString(param);
        logger.info("getExpenseDTO-param:" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        String billId = jsonObj.getString("billId");
        String billNo = jsonObj.getString("billNo");
        String billType = jsonObj.getString("billType");
        String entityId = jsonObj.getString("entityId");
        String viewPage = jsonObj.getString("viewPage");
        String resource = jsonObj.getString("resource");
        String status = jsonObj.getString("status");
        String billUser = jsonObj.getString("billUser");
        String batch = jsonObj.getString("batch");
        String updateInvoiceOrg = jsonObj.getString("updateInvoiceOrg");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)billUser)) {
            billUser = RequestContext.get().getUserId();
        }
        Long orgId = jsonObj.getLong("orgId");
        ExpenseDTO dto = new ExpenseDTO();
        Boolean isAllowRepeat = jsonObj.getBoolean("isAllowRepeat");
        if (isAllowRepeat != null) {
            dto.setAllowRepeat(isAllowRepeat);
        }
        dto.setExpenseId(billId);
        dto.setExpenseNum(billNo);
        dto.setExpenseType(billType);
        dto.setResource(resource);
        dto.setEntityId(entityId);
        dto.setViewPage(viewPage);
        dto.setStatus(status);
        dto.setBillUser(billUser);
        dto.setOrgId(orgId);
        dto.setOriginalId(jsonObj.getString("originalId"));
        dto.setOriginalType(jsonObj.getString("originalType"));
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)dto.getOriginalId()) && org.apache.commons.lang.StringUtils.isEmpty((String)dto.getOriginalType())) {
            dto.setOriginalType(dto.getEntityId());
        }
        dto.setBatch(batch);
        FpzsCommonService.setBotpBillList(jsonObj, dto);
        if (org.apache.commons.lang.StringUtils.equals((String)updateInvoiceOrg, (String)"1")) {
            dto.setUpdateInvoiceOrg(true);
        }
        if (dto.getOrgId() == null || dto.getOrgId() < 0L) {
            dto.setOrgId(RequestContext.get().getOrgId());
        }
        if ((invoiceData = jsonObj.getJSONArray("invoiceData")) != null) {
            boolean updateDeductionPurpose = false;
            if (dto.getOrgId() != null && dto.getOrgId() > 0L) {
                updateDeductionPurpose = SysParamUtil.getSysParamByOrgId(dto.getOrgId(), "update_deduction_purpose");
                logger.info("\u7ec4\u7ec7id: {}, \u5355\u636e\u662f\u5426\u53ef\u62b5\u6263\u5199\u5165\u62b5\u6263\u7528\u9014\uff1a{}", (Object)dto.getOrgId(), (Object)updateDeductionPurpose);
            }
            ArrayList<ExpenseInvoiceDTO> subList = new ArrayList<ExpenseInvoiceDTO>(invoiceData.size());
            List serialNoList = invoiceData.stream().map(t -> (JSONObject)t).filter(t -> org.apache.commons.lang.StringUtils.isNotBlank((String)t.getString("serialNo"))).map(t -> t.getString("serialNo")).collect(Collectors.toList());
            HashMap<String, Boolean> SerialNoMap = new HashMap<String, Boolean>(invoiceData.size());
            if (!CollectionUtils.isEmpty(serialNoList)) {
                QFilter filter = new QFilter("serial_no", "in", serialNoList);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"invoice_type,serial_no", (QFilter[])new QFilter[]{filter});
                for (DynamicObject object : collection) {
                    if (!org.apache.commons.lang.StringUtils.isNotBlank((String)object.getString("serial_no")) || object.getLong("invoice_type") <= 0L) continue;
                    long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(object.getLong("invoice_type"));
                    SerialNoMap.put(object.getString("serial_no"), InputInvoiceTypeEnum.canTransportDeduction(invoiceType));
                }
            }
            for (int i = 0; i < invoiceData.size(); ++i) {
                String deductionFlag;
                JSONObject invoice = invoiceData.getJSONObject(i);
                ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                this.setInvoiceAllowRepeat(dto, invoice, invoiceDto);
                if (invoice.get((Object)"useAmount") != null) {
                    try {
                        invoiceDto.setExpenseAmount(invoice.getBigDecimal("useAmount"));
                    }
                    catch (Exception object) {
                        // empty catch block
                    }
                }
                invoiceDto.setSerialNo(invoice.getString("serialNo"));
                String deductionPurpose = invoice.getString("deductionPurpose");
                invoiceDto.setDeductionPurpose(deductionPurpose);
                String notDeductibleType = invoice.getString("notDeductibleType");
                if ("2".equals(deductionPurpose)) {
                    if (org.apache.commons.lang.StringUtils.isNotBlank((String)notDeductibleType) && DeductionConstant.NOT_DEDUCTIBLE_TYPE_LIST.contains(notDeductibleType)) {
                        invoiceDto.setNotDeductibleType(notDeductibleType);
                    } else {
                        invoiceDto.setNotDeductibleType("5");
                    }
                }
                if ("true".equals(deductionFlag = invoice.getString("deductionFlag")) || "1".equals(deductionFlag)) {
                    invoiceDto.setDeductionFlag("1");
                } else if ("false".equals(deductionFlag) || "0".equals(deductionFlag)) {
                    invoiceDto.setDeductionFlag("0");
                }
                logger.info("\u5355\u636e\u662f\u5426\u53ef\u62b5\u6263\u5199\u5165\u62b5\u6263\u7528\u9014: \u53d1\u7968\u6d41\u6c34\u53f7: {}, \u4f20\u5165\u7684\u62b5\u6263\u6807\u8bc6deductionFlag\uff1a{}, \u62b5\u6263\u7528\u9014\uff1a{}", new Object[]{invoiceDto.getSerialNo(), invoice.getString("deductionFlag"), invoiceDto.getDeductionPurpose()});
                Boolean canTransportDeduction = false;
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)invoice.getString("serialNo")) && SerialNoMap.containsKey(invoice.getString("serialNo"))) {
                    canTransportDeduction = (Boolean)SerialNoMap.get(invoice.getString("serialNo"));
                }
                if (!canTransportDeduction.booleanValue() && updateDeductionPurpose && org.apache.commons.lang.StringUtils.isBlank((String)invoiceDto.getDeductionPurpose()) && org.apache.commons.lang.StringUtils.isNotBlank((String)deductionFlag)) {
                    invoiceDto.setDeductionFlag("1");
                    logger.info("\u5355\u636e\u662f\u5426\u53ef\u62b5\u6263\u5199\u5165\u62b5\u6263\u7528\u9014 \u53c2\u6570\u751f\u6548, dto\u7684\u62b5\u6263\u6807\u8bc6\uff1a{}", (Object)invoiceDto.getDeductionFlag());
                    if ("true".equals(deductionFlag) || "1".equals(deductionFlag)) {
                        invoiceDto.setDeductionPurpose("1");
                    } else if ("false".equals(deductionFlag) || "0".equals(deductionFlag)) {
                        invoiceDto.setDeductionPurpose("2");
                        if (org.apache.commons.lang.StringUtils.isNotBlank((String)notDeductibleType) && DeductionConstant.NOT_DEDUCTIBLE_TYPE_LIST.contains(notDeductibleType)) {
                            invoiceDto.setNotDeductibleType(notDeductibleType);
                        } else {
                            invoiceDto.setNotDeductibleType("5");
                        }
                    }
                }
                invoiceDto.setDeductionAmount(invoice.getBigDecimal("deductionTaxAmount"));
                invoiceDto.setEffectiveTaxAmount(invoice.getBigDecimal("effectiveTaxAmount"));
                invoiceDto.setOutputAmount(invoice.getBigDecimal("outputAmount"));
                invoiceDto.setRemark(invoice.getString("remark"));
                invoiceDto.setEntryId(invoice.getString("entryId"));
                invoiceDto.setOriginalState(invoice.getString("originalState"));
                invoiceDto.setOrgId(invoice.getLong("invoiceOrgId"));
                invoiceDto.setExtInfo(invoice.getJSONObject("extInfo"));
                invoiceDto.setInvoiceResource(invoice.getString("invoiceResource"));
                invoiceDto.setRepeatBillsScope(invoice.getJSONArray("repeatBillsScope"));
                subList.add(invoiceDto);
            }
            dto.setInvoiceList(subList);
        }
        dto.setAttachList(jsonObj);
        JSONObject coverData = jsonObj.getJSONObject("coverData");
        if (coverData != null) {
            ArrayList<ExpenseCoverDTO> coverList = new ArrayList<ExpenseCoverDTO>(1);
            ExpenseCoverDTO expenseCoverDTO = new ExpenseCoverDTO();
            expenseCoverDTO.setCoverNo(coverData.getString("coveNo"));
            expenseCoverDTO.setBase64(coverData.getString("base64"));
            String type = coverData.getString("coveType");
            if (type != null && (type.equalsIgnoreCase("pdf") || "1".equals(type))) {
                expenseCoverDTO.setFileType(1);
            } else {
                expenseCoverDTO.setFileType(2);
            }
            coverList.add(expenseCoverDTO);
            dto.setCoverDTOList(coverList);
            jsonObj.remove((Object)"coverData");
            jsonObj.put("coverMsg", (Object)String.format(ResManager.loadKDString((String)"\u5c01\u9762\u6570\u91cf%1$s,base64: %2$s", (String)"AbstractFpzsService_0", (String)"imc-rim-common", (Object[])new Object[0]), coverList.size(), org.apache.commons.lang.StringUtils.length((String)expenseCoverDTO.getBase64())));
            FpzsCommonService.saveExpenseLog(String.valueOf(param.get("rim_operate_method")), billId, billNo, jsonObj.toJSONString());
        } else {
            FpzsCommonService.saveExpenseLog(String.valueOf(param.get("rim_operate_method")), billId, billNo, json);
        }
        return dto;
    }

    private void setInvoiceAllowRepeat(ExpenseDTO dto, JSONObject invoice, ExpenseInvoiceDTO invoiceDto) {
        JSONArray repeatBillsScope;
        String serialNo = invoice.getString("serialNo");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)serialNo)) {
            return;
        }
        Boolean allowRepeat = invoice.getBoolean("isAllowRepeat");
        if (allowRepeat == null) {
            allowRepeat = Boolean.FALSE;
        }
        if (allowRepeat.booleanValue() && (repeatBillsScope = invoice.getJSONArray("repeatBillsScope")) != null && repeatBillsScope.size() > 0) {
            List collect = repeatBillsScope.stream().filter(f -> {
                JSONObject repeatBillObj = (JSONObject)f;
                String expenseId = repeatBillObj.getString("expenseId") == null ? "" : repeatBillObj.getString("expenseId");
                String entityid = repeatBillObj.getString("entityId") == null ? "" : repeatBillObj.getString("entityId");
                String resource = repeatBillObj.getString("resource") == null ? "" : repeatBillObj.getString("resource");
                boolean currentBillFlag = expenseId.equals(dto.getExpenseId()) && entityid.equals(dto.getEntityId()) && resource.equals(dto.getResource());
                return !currentBillFlag;
            }).collect(Collectors.toList());
            repeatBillsScope = new JSONArray(collect);
            QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObjectCollection relations = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_id, entityid, resource", (QFilter[])new QFilter[]{serialNoFilter});
            if (relations.size() > 0) {
                JSONArray compareArray = new JSONArray();
                for (DynamicObject relation : relations) {
                    boolean currentBillFlag;
                    String expenseId = relation.getString("expense_id");
                    String entityid = relation.getString("entityid");
                    String resource = relation.getString("resource");
                    boolean bl = currentBillFlag = expenseId.equals(dto.getExpenseId()) && entityid.equals(dto.getEntityId()) && resource.equals(dto.getResource());
                    if (currentBillFlag) continue;
                    JSONObject obj = new JSONObject();
                    obj.put("expenseId", (Object)expenseId);
                    obj.put("entityId", (Object)entityid);
                    obj.put("resource", (Object)resource);
                    compareArray.add((Object)obj);
                }
                if (!repeatBillsScope.containsAll((Collection)compareArray)) {
                    allowRepeat = Boolean.FALSE;
                    logger.info("\u6d41\u6c34\u53f7\uff1a{} \u4e0d\u5728\u6307\u5b9a\u5141\u8bb8\u91cd\u590d\u62a5\u9500\u7684\u5355\u636e\u5185:{} compareArray:{}\uff0c\u4e0d\u53ef\u91cd\u590d\u62a5\u9500", new Object[]{serialNo, repeatBillsScope, compareArray});
                }
            }
        }
        invoiceDto.setAllowRepeat(allowRepeat);
    }

    public abstract Map<String, Object> saveVoucher(Map<String, Object> var1);

    public abstract Map<String, Object> saveVoucherCover(Map<String, Object> var1);

    public abstract Map<String, Object> queryInvoiceAndFile(Map<String, Object> var1);

    public abstract Map<String, Object> queryInvoice(Map<String, Object> var1);

    public abstract Map<String, Object> queryAttach(Map<String, Object> var1);

    public abstract Map<String, Object> queryCover(Map<String, Object> var1);

    public abstract Map<String, Object> deleteVoucher(Map<String, Object> var1);

    public Map<String, Object> syncSimInvoice(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        try {
            String originalState;
            String json = SerializationUtils.toJsonString(param);
            logger.info("syncSimInvoice-param:" + json);
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            String orgId = jsonObj.getString("orgId");
            String buyerOrgId = jsonObj.getString("buyerOrgId");
            String serialNo = jsonObj.getString("serialNo");
            QFilter filter = new QFilter("orderno", "=", (Object)serialNo);
            DynamicObject idObject = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter[]{filter});
            if (idObject == null) {
                logger.info("syncSimInvoice\u9500\u9879\u53d1\u7968\u4e0d\u5b58\u5728{}", (Object)serialNo);
                return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"FpzsService_6", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)"sim_vatinvoice");
            JSONObject invoiceObj = new JSONObject();
            invoiceObj.put("originalParam", (Object)jsonObj);
            invoiceObj.put("dataSource", (Object)"simInvoice");
            if (org.apache.commons.lang.StringUtils.isEmpty((String)orgId) && org.apache.commons.lang.StringUtils.isNotEmpty((String)buyerOrgId)) {
                QFilter filter1 = new QFilter("serial_no", "=", (Object)serialNo);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"org_id as org", (QFilter[])new QFilter[]{filter1});
                if (obj == null) {
                    invoiceObj.put("org_id", (Object)buyerOrgId);
                } else {
                    invoiceObj.put("org_id", (Object)obj.getLong("org"));
                }
            } else {
                invoiceObj.put("org_id", (Object)orgId);
            }
            invoiceObj.put("serialNo", (Object)serialNo);
            String invoicetype = invoiceObject.getString("invoicetype");
            String inputType = "";
            if ("026".equals(invoicetype)) {
                inputType = "1";
            } else if ("028".equals(invoicetype)) {
                inputType = "2";
            } else if ("007".equals(invoicetype)) {
                inputType = "3";
            } else if ("004".equals(invoicetype)) {
                inputType = "4";
            } else if ("08xdp".equals(invoicetype)) {
                inputType = "27";
            } else if ("10xdp".equals(invoicetype)) {
                inputType = "26";
            } else if ("025".equals(invoicetype)) {
                inputType = "5";
            }
            this.setSpecialtype(invoiceObject, invoiceObj);
            invoiceObj.put("invoiceType", (Object)inputType);
            invoiceObj.put("invoiceAmount", invoiceObject.get("invoiceamount"));
            invoiceObj.put("type", invoiceObject.get("issuetype"));
            invoiceObj.put("payee", invoiceObject.get("payee"));
            invoiceObj.put("salerTaxNo", invoiceObject.get("salertaxno"));
            invoiceObj.put("machineNo", invoiceObject.get("jqbh"));
            invoiceObj.put("invoiceNo", invoiceObject.get("invoiceno"));
            invoiceObj.put("buyerTaxNo", invoiceObject.get("buyertaxno"));
            invoiceObj.put("originalInvoiceNo", invoiceObject.get("originalinvoiceno"));
            invoiceObj.put("invoiceCode", invoiceObject.get("invoicecode"));
            invoiceObj.put("serialNo", (Object)serialNo);
            invoiceObj.put("checkCode", invoiceObject.get("checkcode"));
            invoiceObj.put("totalAmount", invoiceObject.get("totalamount"));
            invoiceObj.put("salerAddressPhone", invoiceObject.get("saleraddr"));
            invoiceObj.put("totalTaxAmount", invoiceObject.get("totaltax"));
            invoiceObj.put("originalInvoiceCode", invoiceObject.get("originalinvoicecode"));
            invoiceObj.put("salerName", invoiceObject.get("salername"));
            invoiceObj.put("remark", invoiceObject.get("remark"));
            invoiceObj.put("checkStatus", (Object)"1");
            invoiceObj.put("buyerAddressPhone", invoiceObject.get("buyeraddr"));
            invoiceObj.put("drawer", invoiceObject.get("drawer"));
            invoiceObj.put("reviewer", invoiceObject.get("reviewer"));
            invoiceObj.put("invoiceDate", invoiceObject.get("issuetime"));
            invoiceObj.put("buyerName", invoiceObject.get("buyername"));
            String issueSource = invoiceObject.getString("issuesource");
            invoiceObj.put("invalidDate", invoiceObject.get("invaliddate"));
            String pdfFileurl = (String)invoiceObject.get("pdffileurl");
            String fileType = "1";
            String fileUrl = null;
            String xmlFileUrl = null;
            boolean electricFlag = false;
            if ("26".equals(inputType) || "27".equals(inputType)) {
                fileUrl = (String)invoiceObject.get("fileurl");
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)fileUrl)) {
                    electricFlag = true;
                    fileType = "4";
                }
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)pdfFileurl)) {
                    electricFlag = true;
                }
                xmlFileUrl = (String)invoiceObject.get("xmlfileurl");
            } else if (org.apache.commons.lang.StringUtils.isEmpty((String)pdfFileurl)) {
                pdfFileurl = (String)invoiceObject.get("fileurl");
                if ("2".equals(inputType)) {
                    fileType = "4";
                }
            }
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)pdfFileurl) || electricFlag) {
                invoiceObj.put("generatePdf", (Object)"0");
                FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_IMG2);
                JSONObject object = new JSONObject();
                if ("26".equals(inputType) || "27".equals(inputType)) {
                    object.put("sim_down_file", (Object)"1");
                    object.put("snapshot_url", (Object)xmlFileUrl);
                    if ("1".equals(fileType)) {
                        object.put("fileUrl", (Object)pdfFileurl);
                    } else {
                        object.put("fileUrl", (Object)fileUrl);
                        object.put("ofd_url", (Object)pdfFileurl);
                    }
                } else {
                    object.put("fileUrl", (Object)pdfFileurl);
                }
                object.put("fileType", (Object)fileType);
                object.put("invoiceType", (Object)inputType);
                object.put("serialNo", (Object)serialNo);
                service.insert(serialNo, object);
                invoiceObj.put("simFileType", (Object)fileType);
            }
            if ("1".equals(originalState = jsonObj.getString("originalState"))) {
                invoiceObj.put("originalState", (Object)"1");
            }
            invoiceObj.put("buyerAccount", invoiceObject.get("buyerbank"));
            String invoicestatus = invoiceObject.getString("invoicestatus");
            if ("6".equals(invoicestatus)) {
                invoiceObj.put("invoiceStatus", (Object)"2");
            } else if ("2".equals(invoicestatus)) {
                invoiceObj.put("invoiceStatus", (Object)"7");
            } else if ("7".equals(invoicestatus)) {
                invoiceObj.put("invoiceStatus", (Object)"0");
            } else {
                invoiceObj.put("invoiceStatus", (Object)invoicestatus);
            }
            DynamicObjectCollection items = invoiceObject.getDynamicObjectCollection("items");
            JSONArray itemArray = new JSONArray();
            for (DynamicObject item : items) {
                JSONObject itemObj = new JSONObject();
                itemObj.put("unitPrice", item.get("unitprice"));
                itemObj.put("num", item.get("num"));
                itemObj.put("preferentialPolicy", item.get("taxpremark"));
                itemObj.put("zeroTaxRateFlag", item.get("zerotaxmark"));
                itemObj.put("taxRate", item.get("taxrate"));
                itemObj.put("unit", item.get("unit"));
                itemObj.put("specModel", item.get("specification"));
                itemObj.put("detailAmount", item.get("amount"));
                itemObj.put("vatException", item.get("zzstsgl"));
                itemObj.put("goodsCode", item.get("goodscode"));
                itemObj.put("taxAmount", item.get("tax"));
                itemObj.put("goodsName", item.get("goodsname"));
                itemObj.put("discountType", item.get("rowtype"));
                itemArray.add((Object)itemObj);
            }
            invoiceObj.put("items", (Object)itemArray);
            invoiceObj.put("resource", (Object)"\u5f00\u7968\u7ba1\u7406");
            invoiceObj.put("collect_type", (Object)CollectTypeEnum.PC_SIM.getCode());
            invoiceObj.put("needUserRelation", (Object)"0");
            try {
                long invoicingoperator = DynamicObjectUtil.getDynamicObjectLongValue(invoiceObject.get("invoicingoperator"));
                if (invoicingoperator <= 0L && (invoicingoperator = AbstractFpzsService.getUserIdByUserName(invoiceObject.getString("drawer")).longValue()) <= 0L) {
                    invoicingoperator = RequestContext.get().getCurrUserId();
                }
                logger.info("\u5f00\u7968\u540c\u6b65-\u521b\u5efa\u4eba\u53d6\u503c:{}", (Object)invoicingoperator);
                invoiceObj.put(InvoiceSaveConstant.OPERATE_USER_ID, (Object)invoicingoperator);
            }
            catch (Exception e) {
                logger.info("\u5f00\u7968\u540c\u6b65-\u521b\u5efa\u4eba\u53d6\u503c exception:{}", (Object)e);
            }
            InvoiceSaveService saveService = InvoiceSaveService.newInstance(inputType);
            InvoiceSaveResult saveResult = saveService.save(invoiceObj);
            Object voucher = jsonObj.get((Object)"voucherInfo");
            if (voucher != null) {
                JSONObject voucherInfo = null;
                JSONArray serialNoArray = new JSONArray();
                serialNoArray.add((Object)saveResult.getSerialNo());
                if (voucher instanceof List) {
                    JSONArray voucherInfoArray = jsonObj.getJSONArray("voucherInfo");
                    HashMap<String, Object> voucherParam = new HashMap<String, Object>(8);
                    VoucherService voucherService = new VoucherService();
                    for (int i = 0; i < voucherInfoArray.size(); ++i) {
                        JSONObject vouch = voucherInfoArray.getJSONObject(i);
                        String vouchId = vouch.getString("vouchId");
                        String resource = vouch.getString("resource");
                        if (!org.apache.commons.lang.StringUtils.isNotEmpty((String)vouchId) || !org.apache.commons.lang.StringUtils.isNotEmpty((String)resource)) continue;
                        voucherParam.put("voucherInfo", vouch);
                        voucherParam.put("serialNoArray", serialNoArray);
                        voucherService.saveVoucher(voucherParam);
                    }
                } else {
                    voucherInfo = jsonObj.getJSONObject("voucherInfo");
                    HashMap<String, Object> voucherParam = new HashMap<String, Object>(8);
                    String vouchId = voucherInfo.getString("vouchId");
                    String resource = voucherInfo.getString("resource");
                    if (org.apache.commons.lang.StringUtils.isNotEmpty((String)vouchId) && org.apache.commons.lang.StringUtils.isNotEmpty((String)resource)) {
                        VoucherService voucherService = new VoucherService();
                        voucherParam.put("voucherInfo", voucherInfo);
                        voucherParam.put("serialNoArray", serialNoArray);
                        voucherService.saveVoucher(voucherParam);
                    }
                }
            }
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)pdfFileurl) || electricFlag) {
                FileHandleService.startDownAwsFile("0");
            }
        }
        catch (Exception e) {
            logger.error("syncSimInvoice-error:", (Throwable)e);
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"FpzsService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return ResultContant.createSuccessJSONObject();
    }

    private void setSpecialtype(DynamicObject invoiceObject, JSONObject invoiceObj) {
        String specialtype = invoiceObject.getString("specialtype");
        if ("02".equals(specialtype) || "E16".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.AGRICULTURAL_PRODUCTS.getCode());
        }
        if ("08".equals(specialtype) || "E01".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.REFINED_OIL.getCode());
        }
        if ("11".equals(specialtype) || "E18".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.CIGARETTE.getCode());
        }
        if ("18".equals(specialtype) || "E14".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.MOTOR_VEHICLE.getCode());
        }
        if ("E06".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.REAL_ESTATE_MANAGEMENT_LEASING_SERVICE.getCode());
        }
        if ("E05".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.REAL_ESTATE_SALES_SERVICE.getCode());
        }
        if ("E04".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.FREIGHT_SERVICE.getCode());
        }
        if ("E03".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.CONSTRUCTION_SERVICE.getCode());
        }
        if ("E09".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.PASSENGER_TRANSPORTATION_SERVICE.getCode());
        }
        if ("E07".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.VEHICLE_AND_VESSEL_TAX_COLLECTION.getCode());
        }
        if ("E12".equals(specialtype)) {
            invoiceObj.put("specialTypeMark", (Object)SpecialTypeMarkEnum.SELFPRODUCED_AGRICULTURAL_PRODUCTS_SALES.getCode());
        }
    }

    private static Long getUserIdByUserName(String userName) {
        QFilter filter = new QFilter("name", "=", (Object)userName);
        DynamicObject receiverObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,name", (QFilter[])filter.toArray());
        if (receiverObj != null) {
            return receiverObj.getLong("id");
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean fileExists(String url) {
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(url));){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info("syncSimInvoice-\u6587\u4ef6\u4e0d\u5b58\u5728{}", (Object)url);
            return false;
        }
    }

    public abstract List<Map<String, String>> queryFile(List<String> var1);

    public Map<String, Object> queryPermissionByOrgId(Long orgId) {
        if (orgId == null) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        if (org.apache.commons.lang.StringUtils.isEmpty((String)taxNo)) {
            logger.info("\u8bb8\u53ef\u63a7\u5236\u5f53\u524d\u7ec4\u7ec7{}\u7a0e\u53f7\u4e3a\u7a7a", (Object)orgId);
            return ResultContant.createJSONObject(ErrorType.NO_ACCESS);
        }
        QFilter taxFilter = new QFilter("epinfo.number", "=", (Object)taxNo);
        QFilter groupFilter = new QFilter("servergroup", "=", (Object)"1");
        QFilter stateFilter = new QFilter("authstate", "=", (Object)"1");
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_invoice_permission", (String)"id,orginfo.id as org_id,authstate", (QFilter[])new QFilter[]{taxFilter, groupFilter, stateFilter});
        if (collect == null || collect.isEmpty()) {
            logger.info("\u8bb8\u53ef\u63a7\u5236\u5f53\u524d\u7ec4\u7ec7{}\u7a0e\u53f7{}\u672a\u6388\u6743", (Object)orgId, (Object)taxNo);
            return ResultContant.createJSONObject(ErrorType.NO_ACCESS);
        }
        JSONObject returnResult = ResultContant.createSuccessJSONObject();
        return returnResult;
    }

    public abstract Map<String, Object> signInvoice(List<String> var1);

    public abstract Map<String, Object> unSignInvoice(List<String> var1);

    public abstract Map<String, Object> dapVoucherWriteBack(Map<String, Object> var1);

    public abstract Map<String, Object> recognitionCheck(Map<String, Object> var1);

    public abstract Map<String, Object> editInvoice(Map<String, Object> var1);

    public void setParamValue(DynamicObject mainInvoice, JSONObject paramJson) {
        for (String key : paramJson.keySet()) {
            try {
                String columnKey = AbstractFpzsService.camelToUnderscore(key);
                if ("currencyId".equals(key)) {
                    columnKey = "currencyid";
                }
                DynamicObjectUtil.setDynamicObjectValue(mainInvoice, columnKey, paramJson, key);
            }
            catch (Exception exception) {}
        }
    }

    public void validateParamValue(JSONObject paramJson) {
        Long currencyId;
        ArrayList invalid = new ArrayList(8);
        paramJson.keySet().forEach(key -> {
            if (INVALID_KEYS.contains(key)) {
                invalid.add(key);
            }
        });
        if (!invalid.isEmpty()) {
            for (String invalidkey : invalid) {
                paramJson.remove((Object)invalidkey);
            }
        }
        if ((currencyId = paramJson.getLong("currencyId")) > 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)currencyId);
            DynamicObject bdCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,name", (QFilter[])qFilter.toArray());
            if (bdCurrency != null) {
                paramJson.put("currencyName", (Object)bdCurrency.getString("name"));
                paramJson.put("currencyId", (Object)bdCurrency.getLong("id"));
            } else {
                paramJson.remove((Object)"currencyName");
                paramJson.remove((Object)"currencyId");
            }
        } else {
            String currencyNumber = paramJson.getString("currencyNumber");
            QFilter qFilter = new QFilter("number", "=", (Object)currencyNumber);
            DynamicObject bdCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,name", (QFilter[])qFilter.toArray());
            if (bdCurrency != null) {
                paramJson.put("currencyName", (Object)bdCurrency.getString("name"));
                paramJson.put("currencyId", (Object)bdCurrency.getLong("id"));
            } else {
                paramJson.remove((Object)"currencyName");
                paramJson.remove((Object)"currencyId");
            }
        }
        for (String key2 : paramJson.keySet()) {
            boolean avaliableAmount;
            Object value = paramJson.get((Object)key2);
            if (key2.contains("Date")) {
                if (!(value instanceof String)) continue;
                try {
                    paramJson.getDate(key2);
                }
                catch (Exception e) {
                    logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a{}", (Object)e);
                    paramJson.remove((Object)key2);
                }
                continue;
            }
            if (!key2.contains("Amount") || !(value instanceof String) || (avaliableAmount = this.isValidAmount((String)value))) continue;
            paramJson.remove((Object)key2);
        }
    }

    private boolean isValidAmount(String amountStr) {
        return AMOUNT_PATTERN.matcher(amountStr).matches();
    }

    public static String camelToUnderscore(String camelCase) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public abstract Map<String, Object> outInvoiceApply(Map<String, Object> var1);

    public abstract Map<String, Object> outInvoiceDownloadResult(Map<String, Object> var1);

    public abstract Map<String, Object> stopInvoiceDownload(Map<String, Object> var1);

    public abstract Map<String, Object> syncAwsHisBillData(Map<String, Object> var1);

    public Map<String, Object> downOutFile(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        JSONObject result = ResultContant.createSuccessJSONObject();
        try {
            JSONObject data;
            String json = SerializationUtils.toJsonString(param);
            logger.info("downOutFile-param:" + json);
            JSONObject jsonObj = JSONObject.parseObject((String)json);
            String taxNo = jsonObj.getString("taxNo");
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
            }
            String dkType = DeductionConstant.getDkType(taxNo);
            if (!"4".equals(dkType)) {
                String msg = String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%1$s\u5bf9\u5e94\u7684\u6536\u7968\u901a\u9053\u975e\u65b0\u7535\u5b50\u7a0e\u52a1\u5e73\u53f0", (String)"AbstractFpzsService_5", (String)"imc-rim-common", (Object[])new Object[0]), taxNo);
                return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), msg);
            }
            String account = jsonObj.getString("account");
            if (StringUtils.isBlank((CharSequence)account)) {
                return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u7535\u5b50\u7a0e\u5c40\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractFpzsService_1", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            JSONArray invoices = jsonObj.getJSONArray("invoices");
            if (CollectionUtils.isEmpty((Collection)invoices)) {
                return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractFpzsService_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            int maxApplySize = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "rpa_max_size_down_ele_file");
            if (invoices.size() > maxApplySize) {
                String msg = String.format(ResManager.loadKDString((String)"\u6700\u5927\u5141\u8bb8\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6\u6570\u91cf\u4e3a:%1$s", (String)"AbstractFpzsService_3", (String)"imc-rim-common", (Object[])new Object[0]), maxApplySize);
                return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), msg);
            }
            Date minInvoiceDate = null;
            Date maxInvoiceDate = null;
            JSONArray checkInvoices = new JSONArray(invoices.size());
            JSONArray failInvoices = new JSONArray(invoices.size());
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject invoice = invoices.getJSONObject(i);
                if (invoice == null) {
                    JSONObject failInvoice = new JSONObject(2);
                    String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u53d1\u7968\u660e\u7ec6\u4e3a\u7a7a", (String)"AbstractFpzsService_6", (String)"imc-rim-common", (Object[])new Object[0]), i + 1);
                    failInvoice.put("description", (Object)msg);
                    checkInvoices.add((Object)failInvoice);
                    continue;
                }
                String invoiceNo = invoice.getString("invoiceNo");
                if (StringUtils.isBlank((CharSequence)invoiceNo)) {
                    JSONObject failInvoice = new JSONObject(2);
                    String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", (String)"AbstractFpzsService_7", (String)"imc-rim-common", (Object[])new Object[0]), i + 1);
                    failInvoice.put("description", (Object)msg);
                    checkInvoices.add((Object)failInvoice);
                    continue;
                }
                String buyerName = invoice.getString("buyerName");
                if (StringUtils.isBlank((CharSequence)buyerName)) {
                    JSONObject failInvoice = new JSONObject(2);
                    String msg = ResManager.loadKDString((String)"\u8d2d\u623f\u540d\u79f0\u4e3a\u7a7a", (String)"AbstractFpzsService_8", (String)"imc-rim-common", (Object[])new Object[0]);
                    failInvoice.put("description", (Object)msg);
                    failInvoice.put("invoiceNo", (Object)invoiceNo);
                    checkInvoices.add((Object)failInvoice);
                    continue;
                }
                String salerName = invoice.getString("salerName");
                if (StringUtils.isBlank((CharSequence)salerName)) {
                    JSONObject failInvoice = new JSONObject(2);
                    String msg = ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0\u4e3a\u7a7a", (String)"AbstractFpzsService_9", (String)"imc-rim-common", (Object[])new Object[0]);
                    failInvoice.put("description", (Object)msg);
                    failInvoice.put("invoiceNo", (Object)invoiceNo);
                    checkInvoices.add((Object)failInvoice);
                    continue;
                }
                String totalAmount = invoice.getString("totalAmount");
                if (StringUtils.isBlank((CharSequence)totalAmount)) {
                    JSONObject failInvoice = new JSONObject(2);
                    String msg = ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u4e3a\u7a7a", (String)"AbstractFpzsService_10", (String)"imc-rim-common", (Object[])new Object[0]);
                    failInvoice.put("description", (Object)msg);
                    failInvoice.put("invoiceNo", (Object)invoiceNo);
                    checkInvoices.add((Object)failInvoice);
                    continue;
                }
                String invoiceDateStr = invoice.getString("invoiceDate");
                Date invoiceDate = null;
                try {
                    invoiceDate = DateUtils.stringToDate(invoiceDateStr, "yyyy-MM-dd HH:mm:ss");
                }
                catch (Exception e) {
                    JSONObject failInvoice = new JSONObject(2);
                    String msg = ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (String)"AbstractFpzsService_11", (String)"imc-rim-common", (Object[])new Object[0]);
                    failInvoice.put("description", (Object)msg);
                    failInvoice.put("invoiceNo", (Object)invoiceNo);
                    checkInvoices.add((Object)failInvoice);
                    continue;
                }
                if (invoiceDate == null || DateUtils.isTimeZero(invoiceDate)) continue;
                if (minInvoiceDate == null) {
                    minInvoiceDate = invoiceDate;
                } else if (minInvoiceDate.compareTo(invoiceDate) > 0) {
                    minInvoiceDate = invoiceDate;
                }
                if (maxInvoiceDate == null) {
                    maxInvoiceDate = invoiceDate;
                } else if (maxInvoiceDate.compareTo(invoiceDate) < 0) {
                    maxInvoiceDate = invoiceDate;
                }
                checkInvoices.add((Object)invoice);
            }
            if (CollectionUtils.isEmpty((Collection)checkInvoices)) {
                JSONObject failResult = new JSONObject();
                failResult.put("errcode", (Object)ErrorType.PARAM_NULL.getCode());
                failResult.put("failInvoices", (Object)failInvoices);
                failResult.put("successInvoices", (Object)new JSONArray());
                return failResult;
            }
            Long orgId = RequestContext.get().getOrgId();
            NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
            JSONObject requestParam = new JSONObject();
            requestParam.put("dataType", (Object)"2");
            requestParam.put("taxNo", (Object)taxNo);
            requestParam.put("account", (Object)account);
            if (BooleanUtils.isTrue((Boolean)jsonObj.getBoolean("snapshotMark"))) {
                requestParam.put("snapshotMark", (Object)jsonObj.getBoolean("snapshotMark"));
            }
            requestParam.put("invoices", (Object)checkInvoices);
            JSONObject resultRpa = ((DeductService)deductService).applyInvoiceFile(requestParam);
            if (!ResultContant.isSuccess(resultRpa).booleanValue()) {
                JSONObject failResult = new JSONObject();
                failResult.put("errcode", (Object)ErrorType.PARAM_NULL.getCode());
                for (int i = 0; i < checkInvoices.size(); ++i) {
                    JSONObject invoice = checkInvoices.getJSONObject(i);
                    JSONObject failInvoice = new JSONObject(2);
                    failInvoice.put("description", (Object)resultRpa.getString("description"));
                    failInvoice.put("invoiceNo", (Object)invoice.getString("invoiceNo"));
                    failInvoices.add((Object)failInvoice);
                }
                failResult.put("failInvoices", (Object)failInvoices);
                failResult.put("successInvoices", (Object)new JSONArray());
                return failResult;
            }
            requestParam.put("minInvoiceDate", minInvoiceDate);
            requestParam.put("maxInvoiceDate", maxInvoiceDate);
            requestParam.put("invoiceType", (Object)jsonObj.getString("invoiceTypes"));
            this.dealData(resultRpa, requestParam);
            if (resultRpa != null && (data = resultRpa.getJSONObject("data")) != null) {
                result.put("batchNo", (Object)data.getString("batchNo"));
            }
            result.put("successInvoices", (Object)checkInvoices);
            if (!CollectionUtils.isEmpty((Collection)failInvoices)) {
                result.put("failInvoices", (Object)failInvoices);
            }
        }
        catch (Exception e) {
            logger.error("downOutFile-error:", (Throwable)e);
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"FpzsService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return result;
    }

    private JSONObject dealData(JSONObject result, JSONObject param) {
        JSONObject data;
        String taskNo;
        String taxNo = param.getString("taxNo");
        if (!ResultContant.isSuccess(result).booleanValue()) {
            return ResultContant.createJSONObject(result.getString("errcode"), result.getString("description"));
        }
        String invoiceType = param.getString("invoiceType");
        if (org.apache.commons.lang.StringUtils.isBlank((String)invoiceType)) {
            invoiceType = "26,27,28,29";
        }
        List invoices = (List)param.getObject("invoices", List.class);
        Date minInvoiceDate = param.getDate("minInvoiceDate");
        Date maxInvoiceDate = param.getDate("maxInvoiceDate");
        if (result != null && ResultContant.isSuccess(result).booleanValue() && StringUtils.isNotEmpty((CharSequence)(taskNo = (data = result.getJSONObject("data")).getString("batchNo")))) {
            Long orgId2 = TenantUtils.getOrgByNumberOrTaxNo(null, taxNo);
            InOutputInvoiceDownServiceImpl downService = new InOutputInvoiceDownServiceImpl();
            String applyBatchNo = UUID.getBatchNo("DOWN");
            DynamicObject fileLog = downService.getDownLogDynamicObject(applyBatchNo, taskNo, orgId2, taxNo, 0, "", InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType));
            if (minInvoiceDate != null) {
                fileLog.set("invoice_startdate", (Object)minInvoiceDate);
            }
            if (maxInvoiceDate != null) {
                fileLog.set("invoice_enddate", (Object)maxInvoiceDate);
            }
            fileLog.set("aws_invoice_type", (Object)invoiceType);
            fileLog.set("gov_status", (Object)"6");
            fileLog.set("download_errcode", (Object)"0");
            fileLog.set("inout", (Object)"8");
            fileLog.set("apply_step", (Object)1);
            String accountApp = result.getString("account");
            if (StringUtils.isNotBlank((CharSequence)accountApp)) {
                fileLog.set("account", (Object)accountApp);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileLog});
            ArrayList<DynamicObject> syncAccountList = new ArrayList<DynamicObject>(invoices.size());
            for (JSONObject invoice : invoices) {
                invoice.put("invoiceType", (Object)invoiceType);
                DynamicObject account = downService.getAccountDynamicObject(invoice, applyBatchNo, "", "8", null, orgId2);
                syncAccountList.add(account);
            }
            SaveServiceHelper.save((DynamicObject[])syncAccountList.toArray(new DynamicObject[0]));
        }
        return result;
    }

    static {
        INVALID_KEYS.add("expenseStatus");
        INVALID_KEYS.add("taxOrg");
        INVALID_KEYS.add("orgId");
        INVALID_KEYS.add("originalState");
        INVALID_KEYS.add("delete");
    }
}

