/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleMultiTenantDownService;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import org.apache.commons.lang3.StringUtils;

public class ExpenseRelationServiceAdapter {
    private static final Log LOGGER = LogFactory.getLog(ExpenseRelationServiceAdapter.class);

    public JSONObject queryExpenseMessage(String expenseId, String resurce, String entityId, List<Object> serialList, Map<String, Object> param, String pageId, List<Object> attachList) {
        MultiTenantService service = new MultiTenantService();
        if (service.isMultiTenant()) {
            HashMap<String, Object> reqParams = new HashMap<String, Object>(10);
            reqParams.put("expenseId", expenseId);
            reqParams.put("resurce", resurce);
            reqParams.put("entityId", entityId);
            reqParams.put("serialList", serialList);
            param = this.addRelevanceExpenseId(param, entityId, expenseId, false);
            reqParams.put("param", param);
            reqParams.put("pageId", pageId);
            JSONObject result = (JSONObject)service.doPost("ExpenseRelationServiceOpenApiImpl", "queryExpenseMessage", reqParams);
            FileHandleMultiTenantDownService fileService = new FileHandleMultiTenantDownService();
            return fileService.convertInvoiceUrl(result);
        }
        param = this.addRelevanceExpenseId(param, entityId, expenseId, true);
        return new ExpenseRelationService().queryExpenseMessage(expenseId, resurce, entityId, serialList, param, pageId, attachList);
    }

    private Map<String, Object> addRelevanceExpenseId(Map<String, Object> param, String entityId, String billId, boolean mainTenant) {
        List<String> relevanceExpenseIdList = this.getExpenseIdList(param.get("relevanceExpenseId"));
        Map<String, List<Long>> expenseMap = this.queryExpense(relevanceExpenseIdList);
        this.addExpenseMap(expenseMap, entityId, billId);
        ExpenseService expenseService = new ExpenseService();
        for (Map.Entry<String, List<Long>> entrySet : expenseMap.entrySet()) {
            List<Map<String, String>> botpBillList;
            if (mainTenant) {
                botpBillList = expenseService.loadBillLinkByMainTenant(entrySet.getKey(), entrySet.getValue());
                for (Map<String, String> map : botpBillList) {
                    relevanceExpenseIdList.add(map.get("billId"));
                }
                continue;
            }
            botpBillList = expenseService.loadBillLinkBySubTenant(entrySet.getKey(), entrySet.getValue());
            for (Map<String, String> map : botpBillList) {
                relevanceExpenseIdList.add(map.get("billId"));
            }
        }
        if (relevanceExpenseIdList != null && !relevanceExpenseIdList.isEmpty()) {
            LOGGER.info("\u67e5\u770b\u53d1\u7968\u5173\u8054\u5355\u636e{}", relevanceExpenseIdList);
            param.put("relevanceExpenseId", relevanceExpenseIdList);
        }
        return param;
    }

    private List<String> getExpenseIdList(Object relevanceExpenseId) {
        ArrayList<String> relevanceExpenseIdList = new ArrayList<String>(8);
        if (relevanceExpenseId == null) {
            return relevanceExpenseIdList;
        }
        if (relevanceExpenseId instanceof String) {
            String[] relevanceExpenseIdArr = ((String)relevanceExpenseId).split(",");
            relevanceExpenseIdList.addAll(Arrays.stream(relevanceExpenseIdArr).collect(Collectors.toList()));
        } else if (relevanceExpenseId instanceof List) {
            List list = (List)relevanceExpenseId;
            for (Object obj : list) {
                if (obj == null) continue;
                relevanceExpenseIdList.add(obj.toString());
            }
        }
        return relevanceExpenseIdList;
    }

    public String queryExpenseNumByExpenseId(String expenseId) {
        MultiTenantService service = new MultiTenantService();
        if (service.isMultiTenant()) {
            HashMap<String, String> reqParams = new HashMap<String, String>(10);
            reqParams.put("expenseId", expenseId);
            return (String)service.doPost("ExpenseRelationServiceOpenApiImpl", "queryExpenseNumByExpenseId", reqParams);
        }
        return new ExpenseRelationService().queryExpenseNumByExpenseId(expenseId);
    }

    private Map<String, List<Long>> queryExpense(List<String> relevanceExpenseIdList) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(4);
        if (relevanceExpenseIdList != null && !relevanceExpenseIdList.isEmpty()) {
            QFilter filter = new QFilter("expense_id", "in", relevanceExpenseIdList);
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_expense", (String)"expense_id,entityid", (QFilter[])filter.toArray());
            for (DynamicObject obj : collect) {
                String entityid = obj.getString("entityid");
                this.addExpenseMap(map, entityid, obj.getString("expense_id"));
            }
        }
        return map;
    }

    private void addExpenseMap(Map<String, List<Long>> map, String entityid, String expenseId) {
        Long id = BigDecimalUtil.transDecimal(expenseId).longValue();
        if (id > 0L && StringUtils.isNotEmpty((CharSequence)entityid)) {
            List<Long> list = map.get(entityid);
            if (list == null) {
                list = new ArrayList<Long>(8);
            }
            list.add(id);
            map.put(entityid, list);
        }
    }
}

