/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.constant.FpzsConstant;
import kd.imc.rim.common.constant.InputInvoiceConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.fpzs.FpzsAttachmentService;
import kd.imc.rim.common.invoice.fpzs.FpzsAwsService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.query.convert.impl.AirConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.multitenant.service.AbstractFpzsPluginService;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;

public class FpzsPluginLocalService
extends AbstractFpzsPluginService {
    private static final Log logger = LogFactory.getLog(FpzsPluginLocalService.class);

    @Override
    public List<Long> dealWxPushInvoiceData(JSONArray invoiceData, JSONArray fids, JSONObject businessParam) {
        if (!CollectionUtils.isEmpty((Collection)invoiceData)) {
            return this.dealWxPushInvoiceData(invoiceData, businessParam);
        }
        if (!CollectionUtils.isEmpty((Collection)fids)) {
            return this.dealWxPushInvoiceSerial(fids, businessParam);
        }
        return new ArrayList<Long>(0);
    }

    private List<Long> dealWxPushInvoiceData(JSONArray invoiceData, JSONObject businessParam) {
        ArrayList<Long> invoiceIds = new ArrayList<Long>(16);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < invoiceData.size(); ++i) {
            String seatName;
            JSONObject invoiceJson = invoiceData.getJSONObject(i);
            InvoiceSaveService service = InvoiceSaveService.newInstance(invoiceJson.getString("invoiceType"));
            if (service == null) continue;
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(service.getInvoiceType() + "");
            Date trainTime = null;
            String departureTime = "";
            if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
                try {
                    trainTime = invoiceJson.getDate("trainTime");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                departureTime = invoiceJson.getString("departureTime");
            }
            String checkStatus = invoiceJson.getString("checkStatus");
            Class entityClazz = InputInvoiceTypeEnum.getClazzByCode(invoiceType);
            if (entityClazz != null) {
                JSONObject covertObj = InputInvoiceTypeEnum.needCheck(invoiceType) != false && "1".equals(checkStatus) ? ConvertFieldUtil.convert(entityClazz, invoiceJson, "2") : ConvertFieldUtil.convert(entityClazz, invoiceJson, "1");
                invoiceJson.putAll((Map)covertObj);
                if (trainTime != null) {
                    invoiceJson.put("trainTime", (Object)trainTime);
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)departureTime)) {
                    invoiceJson.put("departureTime", (Object)departureTime);
                }
            }
            invoiceJson.putAll((Map)businessParam);
            invoiceJson.put("wxPush", (Object)"1");
            if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) && StringUtils.isEmpty((CharSequence)(seatName = invoiceJson.getString("seatGradeName")))) {
                invoiceJson.put("seatGradeName", (Object)AirConvertService.convertSeatName((String)invoiceJson.getString("seatGrade")));
            }
            boolean dealAttachRelation = true;
            if (InvoiceConvertUtils.isSaleListInvoiceType(invoiceType)) {
                if ("1".equals(checkStatus)) {
                    RecognitionCheckHelper.markSaleListByCheckResult(invoiceJson);
                } else {
                    RecognitionCheckHelper.markSaleListInvoice(invoiceJson);
                }
                String originalState = invoiceJson.getString("originalState");
                if ("1".equals(originalState)) {
                    invoiceJson.put("salelistComplete", (Object)"0");
                    dealAttachRelation = false;
                }
            }
            try {
                logger.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001save\uff1a{}", (Object)invoiceJson);
                InvoiceSaveResult saveResult = service.save(invoiceJson);
                if (dealAttachRelation && "1".equals(invoiceJson.getString("isSaleListInvoice"))) {
                    RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                    recognitionCheckHelper.dealInvoiceAttachRelation(invoiceJson);
                }
                invoiceIds.add((Long)saveResult.getMainId());
                continue;
            }
            catch (MsgException e) {
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u53d1\u7968\u5904\u7406\u5931\u8d25:%2$s", (String)"FpzsPluginLocalService_0", (String)"imc-rim-common", (Object[])new Object[0]), i + 1, e.getMessage());
                sb.append(msg).append(';');
            }
        }
        if (sb.length() > 0) {
            throw new KDException(sb.toString());
        }
        return invoiceIds;
    }

    private List<Long> dealWxPushInvoiceSerial(JSONArray fids, JSONObject businessParam) {
        ArrayList<String> awsSerialList = new ArrayList<String>(fids.size());
        ArrayList<Long> invoiceIds = new ArrayList<Long>(fids.size());
        for (int i = 0; i < fids.size(); ++i) {
            String seri = fids.getString(i);
            awsSerialList.add(seri);
        }
        FpzsAwsService awsService = new FpzsAwsService();
        try {
            Map syncResult = awsService.syncInvoiceFromAws(businessParam.getLong("org_id"), awsSerialList, businessParam);
            if (syncResult != null) {
                for (Map.Entry entry : syncResult.entrySet()) {
                    InvoiceSaveResult result1 = (InvoiceSaveResult)entry.getValue();
                    invoiceIds.add((Long)result1.getMainId());
                }
                return invoiceIds;
            }
        }
        catch (IOException e1) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u7968\u5931\u8d25%1$s", (String)"FpzsPluginLocalService_1", (String)"imc-rim-common", (Object[])new Object[0]), e1.getMessage()));
        }
        return invoiceIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> saveAwsAttach(JSONArray attachmentDatas, Long rimUser) {
        ArrayList<Long> newAttachIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)attachmentDatas)) {
            for (int i = 0; i < attachmentDatas.size(); ++i) {
                JSONObject attachmentData = (JSONObject)attachmentDatas.get(i);
                if (ObjectUtils.isEmpty((Object)attachmentData)) continue;
                QFilter attachNoFilter = new QFilter("attach_no", "=", (Object)attachmentData.getString("serialNo"));
                DynamicObject attachObj = QueryServiceHelper.queryOne((String)"rim_attach", (String)"id", (QFilter[])attachNoFilter.toArray());
                if (!ObjectUtils.isEmpty((Object)attachObj)) {
                    newAttachIds.add(attachObj.getLong("id"));
                    continue;
                }
                attachObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
                attachObj.set("attach_no", (Object)attachmentData.getString("serialNo"));
                attachObj.set("attach_type", (Object)attachmentData.getString("attachmentType"));
                attachObj.set("create_time", (Object)attachmentData.getDate("gatherTime"));
                attachObj.set("attach_name", (Object)attachmentData.getString("attachmentName"));
                attachObj.set("attach_category", (Object)AttachConstant.ATTACH_OTHER_CATEGORY_ID);
                String originalFileName = null;
                String awsLocalUrl = attachmentData.getString("localUrl");
                String awsSnapshotUrl = attachmentData.getString("snapshotUrl");
                String url = null;
                String fileExtension = "";
                String localUrl = FileUtils.downLoadAndUpload(awsLocalUrl);
                String snapshotUrl = FileUtils.downLoadAndUpload(awsSnapshotUrl);
                originalFileName = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)attachmentData.getString("originalFileName")) ? attachmentData.getString("originalFileName") : attachmentData.getString("attachmentName");
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)awsLocalUrl)) {
                    fileExtension = awsLocalUrl.substring(awsLocalUrl.lastIndexOf(46) + 1);
                    originalFileName = originalFileName.concat(".").concat(fileExtension);
                    url = awsLocalUrl;
                } else if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)awsSnapshotUrl)) {
                    fileExtension = awsSnapshotUrl.substring(awsSnapshotUrl.lastIndexOf(46) + 1);
                    originalFileName = originalFileName.concat(fileExtension);
                    url = snapshotUrl;
                }
                String fileHash = null;
                if (org.apache.commons.lang3.StringUtils.isNotBlank(url)) {
                    InputStream inputStream = null;
                    try {
                        inputStream = FileUtils.getInputStreamByGet(url);
                        fileHash = FileUtils.getSHA256(inputStream);
                    }
                    catch (Exception e) {
                        logger.error("\u8bfb\u53d6\u9644\u4ef6\u5931\u8d25", (Throwable)e);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                logger.error("\u83b7\u53d6aws\u6587\u4ef6\u7684hash\u503c\u5931\u8d25", (Throwable)e);
                            }
                        }
                    }
                }
                attachObj.set("attach_hash_value", fileHash);
                attachObj.set("original_name", (Object)originalFileName);
                attachObj.set("update_time", (Object)new Date());
                attachObj.set("snapshot_url", (Object)snapshotUrl);
                attachObj.set("attach_url", (Object)localUrl);
                attachObj.set("user", (Object)RequestContext.get().getUserId());
                attachObj.set("rim_user", (Object)rimUser);
                DynamicObject saveObj = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachObj})[0];
                if (ObjectUtils.isEmpty((Object)saveObj)) continue;
                newAttachIds.add(saveObj.getLong("id"));
            }
        }
        return newAttachIds;
    }

    @Override
    public JSONObject getFpzsConfig(Long orgId) {
        JSONObject map = new JSONObject();
        Map<String, String> fpzsConfig = ImcConfigUtil.getValue("rim_fpzs");
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject config = service.getAwsConfig(orgId);
        map.put("rim_fpzs", fpzsConfig);
        map.put("aws_config", (Object)config);
        return map;
    }

    @Override
    public JSONArray getFpzsAttachList(List<Long> attachIds, Set<String> invoiceSerialNos) {
        JSONArray list = new JSONArray();
        HashSet<Long> attachLongSet = new HashSet<Long>(16);
        HashMap<String, String> attachRelaion = new HashMap<String, String>(16);
        if (!CollectionUtils.isEmpty(attachIds)) {
            for (Long id : attachIds) {
                attachLongSet.add(id);
            }
        }
        if (invoiceSerialNos != null && !invoiceSerialNos.isEmpty()) {
            QFilter serialFilter = new QFilter("relation_id", "in", invoiceSerialNos);
            QFilter typeFilter = new QFilter("relation_type", "=", (Object)"3");
            DynamicObjectCollection attachCollection = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id,relation_id", (QFilter[])new QFilter[]{serialFilter, typeFilter});
            for (DynamicObject obj : attachCollection) {
                String attaId = obj.getString("attach_id");
                attachRelaion.put(attaId, obj.getString("relation_id"));
            }
        }
        if (!CollectionUtils.isEmpty(attachLongSet)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_attach");
            DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((Object[])attachLongSet.toArray(), (DynamicObjectType)mainEntityType);
            Map<Long, String> categoryNameMap = this.getCategoryName(dynamicObject);
            for (DynamicObject obj : dynamicObject) {
                Map<String, Object> map = DynamicObjectUtil.dynamicObjectToMap(obj);
                Long categoryId = DynamicObjectUtil.getDynamicObjectLongValue(obj.get("attach_category"));
                String cateName = categoryNameMap.get(categoryId);
                if (cateName != null) {
                    map.put("attach_category_name", cateName);
                } else {
                    map.put("attach_category_name", "\u5176\u4ed6");
                }
                map.put("serial_no", attachRelaion.get(map.get("id").toString()));
                list.add(map);
            }
        }
        return list;
    }

    private Map<Long, String> getCategoryName(DynamicObject[] dynamicObject) {
        HashSet<Long> attachCategorySet = new HashSet<Long>(8);
        for (DynamicObject obj : dynamicObject) {
            if (obj.get("attach_category") == null && obj.get("attach_category.id") == null) {
                obj.set("attach_category", (Object)AttachConstant.ATTACH_OTHER_CATEGORY_ID);
            }
            if (obj.get("attach_category") == null) {
                obj.set("attach_category", obj.get("attach_category.id"));
            }
            Long categoryId = DynamicObjectUtil.getDynamicObjectLongValue(obj.get("attach_category"));
            attachCategorySet.add(categoryId);
        }
        QFilter categoryFilter = new QFilter("id", "in", attachCategorySet);
        DynamicObjectCollection attachCategory = QueryServiceHelper.query((String)"bdm_attach_type", (String)"id,name,simplify_name", (QFilter[])categoryFilter.toArray());
        HashMap<Long, String> nameMap = new HashMap<Long, String>(attachCategory.size());
        attachCategory.forEach(cate -> nameMap.put(cate.getLong("id"), cate.getString("simplify_name")));
        return nameMap;
    }

    @Override
    public JSONArray verifyByMainIds(Map<String, Object> customParam, List<Long> invoiceIds, List<Long> uncheckInvoiceIds) {
        return VerifyUtil.verifyByMainIds(customParam, invoiceIds, uncheckInvoiceIds, true);
    }

    @Override
    public Map<String, List<Map<String, Object>>> queryAttachBySerialNosCondition(List<String> serialList) {
        return FpzsMainService.queryAttachBySerialNos(serialList);
    }

    @Override
    public JSONObject verifySequenceNoCondition(Map<String, Object> customParam, JSONObject dataJson) {
        return VerifyService.verifySequenceNo(customParam, dataJson);
    }

    @Override
    public JSONArray afterCloseAttachUpload(JSONArray uploadUrls, Map<String, Object> customParam, String serialNo) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        ArrayList<Long> fileArray = new ArrayList<Long>(8);
        for (int i = 0; i < uploadUrls.size(); ++i) {
            Map urlObj = (Map)uploadUrls.get(i);
            if (CollectionUtils.isEmpty((Map)urlObj)) continue;
            Object resource = urlObj.get("resource");
            DynamicObject attachObject = null;
            String strUrl = urlObj.get("url").toString();
            String originalName = urlObj.get("name").toString();
            String fileName = org.apache.commons.lang3.StringUtils.substring((String)originalName.substring(0, originalName.lastIndexOf(46)), (int)0, (int)80);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fileName)) {
                throw new KDException(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsPluginLocalService_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String fileExtension = originalName.substring(originalName.lastIndexOf(46) + 1);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fileExtension)) {
                throw new KDException(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u6587\u4ef6\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u662f\u5426\u6b63\u5e38", (String)"FpzsPluginLocalService_3", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            if (!FpzsConstant.isAttachAallType() && !Arrays.asList(InputInvoiceConstant.ALLOW_FILE_TYPE).contains(fileExtension.toLowerCase())) {
                throw new KDException(ResManager.loadKDString((String)"\u76ee\u524d\u53ea\u652f\u6301\u56fe\u7247/PDF/office\u6587\u6863/txt\u7b49\u683c\u5f0f\u4f5c\u4e3a\u9644\u4ef6", (String)"FpzsAttachService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            String fileFormat = FileUtils.getFileType(originalName);
            String attachHash = null;
            boolean isTempFile = false;
            if (!ObjectUtils.isEmpty(resource) && "scanner".equals(resource.toString())) {
                attachObject = FpzsAttachmentService.newAttachDynamicObj(customParam);
                attachHash = FileUploadUtils.getSHA256FromAttach(strUrl);
                logger.info("\u3010\u53d1\u7968\u52a9\u624b\u4e0a\u4f20\u9644\u4ef6\u3011-url\u5730\u5740\uff1a{}hash\u503c\uff1a{},\u6587\u4ef6\u540d\uff1a{}", new Object[]{strUrl, attachHash, originalName});
            } else {
                try {
                    isTempFile = strUrl.startsWith("http");
                }
                catch (Exception e) {
                    logger.error("\u4e34\u65f6\u6587\u4ef6\u5224\u65ad\u5f02\u5e38:", (Throwable)e);
                    isTempFile = false;
                }
                attachHash = isTempFile ? FileUploadUtils.getSHA256FromCache(strUrl) : FileUploadUtils.getSHA256FromAttach(strUrl);
                attachObject = FpzsAttachmentService.newAttachDynamicObj(customParam);
                logger.info("\u4e0a\u4f20\u9644\u4ef6\u4e34\u65f6\u6587\u4ef6\uff0cisTempFlie:{}\uff0curl:{}", (Object)isTempFile, (Object)strUrl);
                if (isTempFile) {
                    InputStream inputStream = null;
                    try {
                        inputStream = tempFileCache.getInputStream(strUrl);
                        strUrl = FileUploadUtils.upload(FileUploadUtils.getInvoiceDir("attach") + attachHash + '.' + fileFormat, originalName, inputStream);
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)strUrl)) {
                            throw new KDException(String.format(ResManager.loadKDString((String)"%1$s\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5", (String)"FpzsPluginLocalService_5", (String)"imc-rim-common", (Object[])new Object[0]), originalName));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u4e34\u65f6\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38:", (Throwable)e);
                        throw new KDException(String.format(ResManager.loadKDString((String)"%1$s\u6587\u4ef6\u4e0a\u4f20\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5", (String)"FpzsPluginLocalService_4", (String)"imc-rim-common", (Object[])new Object[0]), originalName));
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                logger.error("\u9644\u4ef6\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25:", (Throwable)e);
                            }
                        }
                    }
                }
            }
            attachObject.set("update_time", (Object)new Date());
            attachObject.set("attach_hash_value", (Object)attachHash);
            attachObject.set("attach_url", (Object)strUrl);
            if (ObjectUtils.isEmpty((Object)attachObject.get("attach_category")) && ObjectUtils.isEmpty((Object)attachObject.get("attach_category.id"))) {
                attachObject.set("attach_category", (Object)AttachConstant.ATTACH_OTHER_CATEGORY_ID);
            } else if (!ObjectUtils.isEmpty((Object)attachObject.get("attach_category.id"))) {
                attachObject.set("attach_category", (Object)attachObject.getLong("attach_category.id"));
            }
            String iconImage = "";
            if ("pdf".equalsIgnoreCase(fileFormat)) {
                iconImage = FpzsAttachmentService.getAttachIconUrl(strUrl, fileFormat);
                attachObject.set("icon_url", (Object)iconImage);
                attachObject.set("snapshot_url", (Object)iconImage);
                attachObject.set("attach_type", (Object)"1");
            } else if ("ofd".equalsIgnoreCase(fileFormat)) {
                attachObject.set("attach_type", (Object)"4");
            } else if ("doc".equalsIgnoreCase(fileFormat) || "docx".equalsIgnoreCase(fileFormat)) {
                attachObject.set("attach_type", (Object)"5");
            } else if ("xls".equalsIgnoreCase(fileFormat) || "xlsx".equalsIgnoreCase(fileFormat)) {
                attachObject.set("attach_type", (Object)"6");
            } else if ("pptx".equalsIgnoreCase(fileFormat)) {
                attachObject.set("attach_type", (Object)"7");
            } else if ("txt".equalsIgnoreCase(fileFormat)) {
                attachObject.set("attach_type", (Object)"8");
            } else if (FileUtils.isImage(fileFormat)) {
                attachObject.set("attach_type", (Object)"2");
                attachObject.set("snapshot_url", (Object)strUrl);
            } else {
                attachObject.set("attach_type", (Object)(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fileFormat) ? fileExtension.toLowerCase() : fileFormat.toLowerCase()));
            }
            attachObject.set("file_extension", (Object)fileExtension);
            attachObject.set("attach_name", (Object)fileName);
            attachObject.set("remark", urlObj.get("description"));
            attachObject.set("original_name", (Object)(fileName + '.' + fileExtension));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachObject});
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)serialNo)) {
                FpzsAttachmentService.saveAttachRelation(serialNo, attachObject.getPkValue().toString());
            }
            fileArray.add(attachObject.getLong("id"));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)serialNo)) {
            HashSet<String> invoiceSerialNos = new HashSet<String>();
            invoiceSerialNos.add(serialNo);
            return this.getFpzsAttachList(fileArray, invoiceSerialNos);
        }
        return this.getFpzsAttachList(fileArray, null);
    }

    @Override
    public JSONObject loadAttachById(Long attachId) {
        QFilter filter = new QFilter("id", "=", (Object)attachId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"rim_attach", (String)"attach_category, attach_name, attach_type,remark,create_time,id,attach_url,file_extension, attach_no, snapshot_url", (QFilter[])filter.toArray());
        if (dynamicObject == null) {
            return null;
        }
        Map<Long, String> nameMap = this.getCategoryName(new DynamicObject[]{dynamicObject});
        JSONObject result = DynamicObjectUtil.dynamicObject2Json(dynamicObject);
        String attach_no = dynamicObject.getString("attach_no");
        QFilter attachNoFilter = new QFilter("attach_no", "=", (Object)attach_no);
        DynamicObjectCollection attachCollect = QueryServiceHelper.query((String)"rim_attach", (String)"id", (QFilter[])new QFilter[]{attachNoFilter});
        if (!CollectionUtils.isEmpty((Collection)attachCollect)) {
            ArrayList<String> list = new ArrayList<String>(4);
            attachCollect.forEach(obj -> list.add(obj.get("id").toString()));
            RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
            int bindNum = recognitionCheckHelper.queryAttachNum(list);
            result.put("attach_sum", (Object)bindNum);
        } else {
            result.put("attach_sum", (Object)0);
        }
        Long attach_category = result.getLong("attach_category");
        result.put("simplify_name", (Object)nameMap.get(attach_category));
        return result;
    }

    @Override
    public JSONObject getBillInvoiceIdAndAttachId(Map<String, Object> param) {
        JSONObject result = new JSONObject();
        String billId = (String)param.get("billId");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billId)) {
            return result;
        }
        ExpenseDTO expenseDTO = new ExpenseDTO();
        expenseDTO.setExpenseId(billId);
        expenseDTO.setEntityId((String)param.get("entityId"));
        expenseDTO.setResource((String)param.get("resource"));
        String cachekey = FpzsMainService.getPushInvoiceKey(expenseDTO.getExpenseId(), expenseDTO.getEntityId(), expenseDTO.getResource());
        String incoiceCache = CacheHelper.get(cachekey);
        AttachQueryService attachQueryService = new AttachQueryService();
        JSONArray attachArray = attachQueryService.queryFpzsAttach(billId, expenseDTO.getEntityId(), expenseDTO.getResource(), false);
        boolean isQueryDb = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)incoiceCache) && CollectionUtils.isEmpty((Collection)attachArray);
        List serialNos = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)incoiceCache)) {
            serialNos = JSONArray.parseArray((String)incoiceCache, String.class);
        } else if (isQueryDb) {
            ExpenseService expenseService = new ExpenseService();
            QFilter idfilter = expenseService.getExpenseRelationQFilter(expenseDTO, "expense_id", "entityid", "resource");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{idfilter});
            serialNos = collection.stream().map(s -> s.getString("serial_no")).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty((Object)serialNos)) {
            result.put("invoiceIds", this.getMainIdBySerialNo(serialNos));
        }
        if (CollectionUtils.isEmpty((Collection)attachArray) && isQueryDb) {
            attachArray = attachQueryService.queryFpzsAttach(billId, expenseDTO.getEntityId(), expenseDTO.getResource(), true);
        }
        if (!CollectionUtils.isEmpty((Collection)attachArray)) {
            ArrayList<Long> attachIds = new ArrayList<Long>(attachArray.size());
            for (int i = 0; i < attachArray.size(); ++i) {
                attachIds.add(Long.parseLong(attachArray.getJSONObject(i).getString("attachId")));
            }
            result.put("attachIds", attachIds);
        }
        return result;
    }

    @Override
    public List<Long> getMainIdBySerialNo(List<String> serialNos) {
        if (CollectionUtils.isEmpty(serialNos)) {
            return Lists.newArrayList();
        }
        QFilter mainFilter = new QFilter("serial_no", "in", serialNos);
        DynamicObjectCollection mainCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id", (QFilter[])new QFilter[]{mainFilter});
        return mainCollection.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }
}

