/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.XbrlTypeConstant;
import kd.imc.rim.common.helper.ElectAccVoucherHelper;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.download.excel.TaxInvoiceConvertUtil;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.recognition.listener.IRecognitionListener;
import kd.imc.rim.common.invoice.recognition.listener.RecognitionListenerResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.ElectAccVoucherService;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.extract.XmlUtil;
import kd.imc.rim.common.utils.extract.ZipExtractUtil;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class EInvoiceZipXmlDealService {
    private static Log logger = LogFactory.getLog(EInvoiceZipXmlDealService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject analysisAndCheckSave(String fileUrl, String fileName, Long orgId, JSONObject businessParam, IRecognitionListener recognitionListener) {
        boolean isCheck;
        JSONObject xmlUrlMap;
        JSONArray invoiceArray;
        JSONObject result;
        Throwable throwable;
        InputStream fileInputStream;
        boolean isVoucherOrg;
        block58: {
            Object object;
            block57: {
                if (StringUtils.isEmpty((String)fileUrl)) return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u6216\u6587\u4ef6\u540d\u4e3a\u7a7a", (String)"EInvoiceZipXmlDealService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                if (StringUtils.isEmpty((String)fileName)) {
                    return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u6216\u6587\u4ef6\u540d\u4e3a\u7a7a", (String)"EInvoiceZipXmlDealService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                isVoucherOrg = ElectAccVoucherService.checkOrg(orgId);
                byte[] fileByte = null;
                if (businessParam != null) {
                    fileByte = businessParam.getBytes("fileByte");
                }
                try {
                    fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl), fileByte);
                    throwable = null;
                    try {
                        fileByte = FileUtils.getByte(fileInputStream);
                        String fileType = FileUtils.getFileType(fileName);
                        result = new JSONObject();
                        invoiceArray = new JSONArray();
                        xmlUrlMap = new JSONObject();
                        if ("zip".equalsIgnoreCase(fileType)) {
                            Map<String, String> zipFileMap = ZipExtractUtil.extractFileForXml(fileByte);
                            if (zipFileMap.isEmpty()) {
                                JSONObject jSONObject = ResultContant.createJSONObject("0002", ResManager.loadKDString((String)"\u89e3\u6790zip\u538b\u7f29\u5305\u4e3a\u7a7a", (String)"EInvoiceZipXmlDealService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                return jSONObject;
                            }
                            object = zipFileMap.entrySet().iterator();
                            break block57;
                        }
                        if (!"xml".equalsIgnoreCase(fileType) || fileByte == null) break block58;
                        ByteArrayInputStream xbrlStream = new ByteArrayInputStream(fileByte);
                        object = null;
                        try {
                            String xmlUrl = FileConvertUtils.upload((byte[])FileUtils.getByte(xbrlStream), (String)"xml");
                            JSONObject invoice = XmlUtil.readXml((byte[])fileByte);
                            if (invoice == null) break block58;
                            String invoiceNo = (invoice = EInvoiceZipXmlDealService.convertInvoice(invoice)).getString("invoiceNo");
                            if (StringUtils.isNotEmpty((String)invoiceNo)) {
                                xmlUrlMap.put(invoiceNo, (Object)xmlUrl);
                            }
                            invoiceArray.add((Object)invoice);
                            break block58;
                        }
                        catch (Throwable xmlUrl) {
                            object = xmlUrl;
                            throw xmlUrl;
                        }
                        finally {
                            if (xbrlStream != null) {
                                if (object != null) {
                                    try {
                                        xbrlStream.close();
                                    }
                                    catch (Throwable xmlUrl) {
                                        ((Throwable)object).addSuppressed(xmlUrl);
                                    }
                                } else {
                                    xbrlStream.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    RecognitionListenerResult listener = new RecognitionListenerResult(fileUrl, fileName, 1, 1, new JSONArray());
                    if (recognitionListener != null) {
                        recognitionListener.handle(listener);
                    }
                    logger.info("EInvoiceZipXmlDealService Exception\uff1a", (Object)e);
                    if (!(e instanceof MsgException)) {
                        if (!(e instanceof KDBizException)) return ResultContant.createJSONObject("9999", ResManager.loadKDString((String)"\u6570\u7535zip/xml\u89e3\u6790\u5931\u8d25", (String)"EInvoiceZipXmlDealService_4", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                    if (e.getMessage() == null) return ResultContant.createJSONObject("9999", ResManager.loadKDString((String)"\u6570\u7535zip/xml\u89e3\u6790\u5931\u8d25", (String)"EInvoiceZipXmlDealService_4", (String)"imc-rim-common", (Object[])new Object[0]));
                    return ResultContant.createJSONObject("9999", e.getMessage());
                }
            }
            while (object.hasNext()) {
                Map.Entry<String, String> entry = object.next();
                String xmlStr = entry.getValue();
                if (StringUtils.isEmpty((String)xmlStr)) continue;
                ByteArrayInputStream xbrlStream = new ByteArrayInputStream(xmlStr.getBytes("utf-8"));
                Throwable throwable3 = null;
                try {
                    String xmlUrl = FileConvertUtils.upload((byte[])FileUtils.getByte(xbrlStream), (String)"xml");
                    JSONObject invoice = XmlUtil.xml2Json((String)xmlStr);
                    invoice = EInvoiceZipXmlDealService.convertInvoice(invoice);
                    String invoiceNo = invoice.getString("invoiceNo");
                    if (StringUtils.isNotEmpty((String)invoiceNo)) {
                        xmlUrlMap.put(invoiceNo, (Object)xmlUrl);
                    }
                    invoiceArray.add((Object)invoice);
                }
                catch (Throwable xmlUrl) {
                    throwable3 = xmlUrl;
                    throw xmlUrl;
                }
                finally {
                    if (xbrlStream == null) continue;
                    if (throwable3 != null) {
                        try {
                            xbrlStream.close();
                        }
                        catch (Throwable xmlUrl) {
                            throwable3.addSuppressed(xmlUrl);
                        }
                        continue;
                    }
                    xbrlStream.close();
                }
            }
        }
        if (invoiceArray.isEmpty()) {
            return ResultContant.createJSONObject("0003", ResManager.loadKDString((String)"\u6570\u7535\u7968xml\u89e3\u6790\u4e3a\u7a7a", (String)"EInvoiceZipXmlDealService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String itemsKey = "items";
        ArrayList entityList = Lists.newArrayList();
        ConvertFieldUtil.convertRecognitionEntity(entityList, invoiceArray, itemsKey);
        businessParam.put("fileName", (Object)fileName);
        businessParam.remove((Object)"fileByte");
        JSONArray finalInfo = new JSONArray();
        JSONArray invoiceInfos = new JSONArray((List)entityList);
        boolean bl = isCheck = !"1".equals(businessParam.getString("notCheck"));
        if (!isCheck) {
            businessParam.put("errcode", (Object)"4999");
            businessParam.put("description", (Object)CheckContant.getCheckResultDesc("4999"));
            for (int i = 0; i < invoiceInfos.size(); ++i) {
                JSONObject invoice = invoiceInfos.getJSONObject(i);
                invoice.put("xmlUrl", xmlUrlMap.get((Object)invoice.getString("invoiceNo")));
                invoice.put("fileType", (Object)"xml");
                invoice.put("serialNo", (Object)UUID.randomUUID());
                invoice.put("snapshotUrl", (Object)"");
                invoice.putAll((Map)businessParam);
                EInvoiceZipXmlDealService.saveInvoice(invoice, businessParam);
                finalInfo.add((Object)invoice);
            }
        } else {
            finalInfo = EInvoiceZipXmlDealService.invoiceCheck(entityList, xmlUrlMap, orgId, businessParam);
        }
        if (isVoucherOrg && Objects.nonNull(finalInfo) && finalInfo.size() > 0) {
            for (Object finalInfoObj : finalInfo) {
                DynamicObject idObject;
                JSONObject finalInfoJsonObj = (JSONObject)finalInfoObj;
                String serialNo = finalInfoJsonObj.getString("serialNo");
                boolean notSaveInvoice = CommonUtils.isNotSaveInvoice(finalInfoJsonObj);
                if (notSaveInvoice) continue;
                String invoiceNo = finalInfoJsonObj.getString("invoiceNo");
                String xmlUrl = xmlUrlMap.getString(invoiceNo);
                String xbrlName = EInvoiceZipXmlDealService.getXbrlName(finalInfoJsonObj.getLong("invoiceType"), finalInfoJsonObj.getString("invoiceDate"), serialNo);
                ElectAccVoucherService.saveVoucher(serialNo, xbrlName, xmlUrl, XbrlTypeConstant.E_INVOICE.getCode());
                String invoiceCode = finalInfoJsonObj.getString("invoiceCode");
                DynamicObject invoiceObject = ElectAccVoucherHelper.queryInvoiceMain(invoiceCode, invoiceNo);
                String invoiceType = finalInfoJsonObj.getString("invoiceType");
                InvoiceSaveService service = InvoiceSaveService.newInstance(invoiceType + "");
                if (service == null) continue;
                invoiceObject = BusinessDataServiceHelper.loadSingle((Object)invoiceObject.get("id"), (String)"rim_invoice");
                service.setMainInvoiceInfo(invoiceObject);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObject});
                String checkStatus = finalInfoJsonObj.getString("checkStatus");
                if ("1".equals(checkStatus) || (idObject = QueryServiceHelper.queryOne((String)"rim_invoice_uncheck", (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)finalInfoJsonObj.getString("serialNo"))})) == null) continue;
                DynamicObject uncheckObj = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)"rim_invoice_uncheck");
                service.setMainInvoiceInfo(uncheckObj);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{uncheckObj});
            }
        }
        result.put("errcode", (Object)"0000");
        result.put("description", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"EInvoiceZipXmlDealService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        result.put("data", (Object)finalInfo);
        RecognitionListenerResult listener = new RecognitionListenerResult(fileUrl, fileName, 1, 1, finalInfo);
        if (recognitionListener == null) return result;
        recognitionListener.handle(listener);
        return result;
        finally {
            if (fileInputStream != null) {
                if (throwable != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    fileInputStream.close();
                }
            }
        }
    }

    private static String getXbrlName(Long invoiceType, String invoiceDate, String serialNo) {
        String prefix = "";
        invoiceDate = invoiceDate.replaceAll("-", "");
        prefix = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) ? "einv_ord_issuer_" : "einv_spcl_issuer_";
        return prefix + invoiceDate + '_' + serialNo + ".xml";
    }

    private static void saveInvoice(JSONObject invoice, JSONObject businessParam) {
        block3: {
            try {
                InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
                invoiceCollectService.saveInvoice(invoice, null, null);
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"EInvoiceZipXmlDealService_5", (String)"imc-rim-common", (Object[])new Object[0]);
                if (e instanceof MsgException) {
                    errorMsg = ((MsgException)e).getErrorMsg();
                }
                invoice.put("errorMsg", (Object)errorMsg);
                if (!"1".equals(businessParam.getString("throwSaveError"))) break block3;
                throw e;
            }
        }
    }

    private static JSONObject convertInvoice(JSONObject invoice) {
        JSONObject usedCarSales;
        JSONObject specificInformation;
        JSONObject generalOrSpecialVAT;
        JSONObject header = invoice.getJSONObject("Header");
        JSONObject eInvoiceElement = invoice.getJSONObject("EInvoiceData");
        if (eInvoiceElement == null || header == null) {
            return new JSONObject();
        }
        String invoiceNo = header.getString("EIid");
        JSONObject inherentLabel = header.getJSONObject("InherentLabel");
        Long defaultType = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode();
        if (inherentLabel != null && (generalOrSpecialVAT = inherentLabel.getJSONObject("GeneralOrSpecialVAT")) != null) {
            String labelCode = generalOrSpecialVAT.getString("LabelCode");
            defaultType = InputInvoiceTypeEnum.getInvoiceTypeByFromXml(labelCode);
        }
        invoice = EInvoiceZipXmlDealService.getInvoiceElementInfo(eInvoiceElement);
        invoice.put("invoiceType", (Object)defaultType);
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(defaultType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(defaultType)) {
            EInvoiceZipXmlDealService.putAirTrainEleInfo(invoice, eInvoiceElement, defaultType);
        } else if (InputInvoiceTypeEnum.MOTOR_ELE_INVOICE.getCode().equals(defaultType)) {
            JSONObject motorVehicleSales;
            specificInformation = eInvoiceElement.getJSONObject("SpecificInformation");
            if (specificInformation != null && (motorVehicleSales = specificInformation.getJSONObject("MotorVehicleSales")) != null) {
                invoice.putAll((Map)motorVehicleSales);
            }
        } else if (InputInvoiceTypeEnum.USEDCAR_ELE_INVOICE.getCode().equals(defaultType) && (specificInformation = eInvoiceElement.getJSONObject("SpecificInformation")) != null && (usedCarSales = specificInformation.getJSONObject("UsedCarSales")) != null) {
            invoice.putAll((Map)usedCarSales);
        }
        invoice.put("invoiceNo", (Object)invoiceNo);
        return invoice;
    }

    private static void putAirTrainEleInfo(JSONObject invoice, JSONObject eInvoiceElement, Long defaultType) {
        JSONObject specificInformation = eInvoiceElement.getJSONObject("SpecificInformation");
        if (specificInformation != null) {
            JSONObject transInfo;
            if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(defaultType)) {
                invoice.put("otherTotalTaxAmount", (Object)BigDecimal.ZERO);
                transInfo = specificInformation.getJSONObject("ItineraryReceiptOfE-TicketForAirTransportation");
                String markingOfDomesticOrInternational = transInfo.getString("MarkingOfDomesticOrInternational");
                if ("\u56fd\u5185".equals(markingOfDomesticOrInternational)) {
                    invoice.put("internationalFlag", (Object)"1");
                } else {
                    invoice.put("internationalFlag", (Object)"2");
                }
            } else {
                transInfo = specificInformation.getJSONObject("RailwayE-Ticket");
                String leftmarkArea = transInfo.getString("LeftmarkArea");
                if ("\u9000".equals(leftmarkArea)) {
                    invoice.put("businessType", (Object)"2");
                } else {
                    invoice.put("businessType", (Object)"1");
                }
                invoice.put("SellerBankName", (Object)(invoice.getString("SellerBankName") + invoice.getString("SellerBankAccNum")));
                invoice.put("SellerTelNum", (Object)(invoice.getString("SellerAddr") + invoice.getString("SellerTelNum")));
            }
            invoice.putAll((Map)transInfo);
            EInvoiceZipXmlDealService.putTaxRate(invoice, eInvoiceElement);
            JSONObject itineraryDetailInformation = transInfo.getJSONObject("ItineraryDetailInformation");
            if (itineraryDetailInformation != null) {
                invoice.putAll((Map)itineraryDetailInformation);
            }
            invoice.put("IssuingStatus", (Object)TaxInvoiceConvertUtil.getInvoiceStateByCN(invoice.get((Object)"IssuingStatus") + ""));
        }
    }

    private static void putTaxRate(JSONObject invoice, JSONObject eInvoiceData) {
        Object issuItemInformation = eInvoiceData.get((Object)"IssuItemInformation");
        if (issuItemInformation instanceof JSONArray) {
            JSONArray itemInfoArray = eInvoiceData.getJSONArray("IssuItemInformation");
            if (itemInfoArray != null && !itemInfoArray.isEmpty()) {
                for (int i = 0; i < itemInfoArray.size(); ++i) {
                    JSONObject itemInfo = itemInfoArray.getJSONObject(i);
                    String taxRate = itemInfo.getString("TaxRate");
                    String itemName = itemInfo.getString("ItemName");
                    if (!StringUtils.isNotEmpty((String)itemName) || !itemName.contains("\u7968\u4ef7") || !StringUtils.isNotEmpty((String)taxRate)) continue;
                    invoice.put("taxRate", (Object)taxRate);
                    if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
                        invoice.put("ticketPrice", (Object)itemInfo.getString("Amount"));
                    }
                    break;
                }
            }
        } else if (issuItemInformation instanceof JSONObject) {
            JSONObject itemInfo = eInvoiceData.getJSONObject("IssuItemInformation");
            invoice.put("taxRate", (Object)itemInfo.getString("TaxRate"));
        }
    }

    private static JSONArray invoiceCheck(List entityList, JSONObject xmlUrlMap, Long orgId, JSONObject businessParam) {
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return null;
        }
        JSONArray result = new JSONArray();
        for (Object obj : entityList) {
            CheckResult checkResult;
            String invoiceStr = JSONObject.toJSONString(obj);
            JSONObject invoice = JSON.parseObject((String)invoiceStr);
            boolean flag = ConvertFieldUtil.checkNullValidate(invoice, obj.getClass());
            if (!flag) {
                result.add((Object)invoice);
                continue;
            }
            CheckParam checkParam = ConvertFieldUtil.getInvoiceCheckPart(invoice);
            String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
            if (StringUtils.isNotEmpty((String)invoice.getString("buyerTaxNo"))) {
                taxNo = invoice.getString("buyerTaxNo");
            }
            if ("0000".equals((checkResult = SimplyCheckService.checkInvoice(checkParam, orgId, taxNo)).getErrcode()) && checkResult.getData() != null) {
                Object invoiceEntity = checkResult.getData();
                String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoice.getLong("invoiceType")) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
                    JSONObject checkObj = JSON.parseObject((String)invoiceCheckStr);
                    checkObj.keySet().removeIf(key -> StringUtils.isEmpty((String)checkObj.getString(key)));
                    invoice.putAll((Map)checkObj);
                } else if (InputInvoiceTypeEnum.USEDCAR_ELE_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
                    String drawer = invoice.getString("drawer");
                    invoice = JSON.parseObject((String)invoiceCheckStr);
                    invoice.put("drawer", (Object)drawer);
                } else {
                    invoice = JSON.parseObject((String)invoiceCheckStr);
                }
                invoice.put("checkStatus", (Object)"1");
            } else {
                invoice.put("checkStatus", (Object)"2");
                invoice.put("errcode", (Object)checkResult.getErrcode());
                invoice.put("description", (Object)checkResult.getDescription());
            }
            invoice.put("serialNo", (Object)UUID.randomUUID());
            invoice.put("xmlUrl", xmlUrlMap.get((Object)invoice.getString("invoiceNo")));
            invoice.put("snapshotUrl", (Object)"");
            invoice.put("fileType", (Object)"xml");
            invoice.putAll((Map)businessParam);
            Object invoiceDate = invoice.get((Object)"invoiceDate");
            if (invoiceDate instanceof Long) {
                Date date = new Date((Long)invoiceDate);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String dateString = formatter.format(date);
                invoice.put("invoiceDate", (Object)dateString);
            }
            EInvoiceZipXmlDealService.saveInvoice(invoice, businessParam);
            result.add((Object)invoice);
        }
        return result;
    }

    private static JSONObject getInvoiceElementInfo(JSONObject eInvoiceElement) {
        Object issuItemInformation;
        JSONObject basicInformation;
        JSONObject buyerInfomation;
        JSONObject fullInfo = new JSONObject();
        JSONObject sellerInformation = eInvoiceElement.getJSONObject("SellerInformation");
        if (sellerInformation != null) {
            fullInfo.putAll((Map)sellerInformation);
        }
        if ((buyerInfomation = eInvoiceElement.getJSONObject("BuyerInformation")) != null) {
            fullInfo.putAll((Map)buyerInfomation);
        }
        if ((basicInformation = eInvoiceElement.getJSONObject("BasicInformation")) != null) {
            fullInfo.putAll((Map)basicInformation);
        }
        if ((issuItemInformation = eInvoiceElement.get((Object)"IssuItemInformation")) != null) {
            JSONArray items = new JSONArray();
            if (issuItemInformation instanceof JSONObject) {
                items.add(issuItemInformation);
            } else if (issuItemInformation instanceof JSONArray) {
                items = (JSONArray)issuItemInformation;
            }
            fullInfo.put("items", (Object)items);
        }
        return fullInfo;
    }
}

