/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.MulComboProp;
import kd.bos.lang.Lang;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceInfoLabelService {
    private String showType = "image";
    private String contextPath;
    private static final String IMAGE = "image";
    private static final String LABEL = "label";
    private Map<String, ValueMapItem> imgMap = null;

    public InvoiceInfoLabelService() {
        Lang lang;
        String showTypeConfig = RimConfigUtils.getConfig("invoiceinfo_showtype");
        this.showType = IMAGE.equals(showTypeConfig) || LABEL.equals(showTypeConfig) ? showTypeConfig : ((lang = RequestContext.get().getLang()) != null && !lang.name().equals(Lang.zh_CN.name()) ? LABEL : IMAGE);
        if (IMAGE.equals(this.showType)) {
            this.contextPath = RequestContext.get().getClientFullContextPath();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            this.imgMap = new HashMap<String, ValueMapItem>(mainPros.size());
            for (IDataEntityProperty property : mainPros) {
                if (!property.getName().equals("invoice_info")) continue;
                MulComboProp prop = (MulComboProp)property;
                List items = prop.getComboItems();
                for (ValueMapItem item : items) {
                    this.imgMap.put(item.getValue(), item);
                }
            }
        }
    }

    public boolean isShowLabel() {
        return LABEL.equals(this.showType);
    }

    public String getInvoiceInfoText(String invoiceInfo) {
        String[] items;
        StringBuilder sb = new StringBuilder();
        for (String item : items = invoiceInfo.split(",")) {
            String text = this.getLabelText(item);
            if (!StringUtils.isNotEmpty((CharSequence)text)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(text);
        }
        return sb.toString();
    }

    public String getInvoiceInfoShowContent(String invoiceInfo) {
        if (IMAGE.equals(this.showType)) {
            return this.getShowImage(invoiceInfo);
        }
        return this.getShowLabel(invoiceInfo);
    }

    private String getShowImage(String invoiceInfo) {
        String[] items = invoiceInfo.split(",");
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            ValueMapItem img;
            if (MapUtils.isEmpty(this.imgMap) || (img = this.imgMap.get(item)) == null || !StringUtils.isNotEmpty((CharSequence)img.getImageKey())) continue;
            sb.append("<img src=\"").append(this.contextPath).append(img.getImageKey().substring(1));
            sb.append("\" title=\"").append(img.getName()).append("\"/>&nbsp;");
        }
        return sb.toString();
    }

    private String getShowLabel(String invoiceInfo) {
        String[] items;
        StringBuilder sb = new StringBuilder();
        sb.append("<div style=\"display: flex\">");
        for (String item : items = invoiceInfo.split(",")) {
            sb.append("<div class=\"").append(this.getLabelClass(item)).append("\">").append(this.getLabelText(item)).append("</div>");
        }
        sb.append("</div>");
        return sb.toString();
    }

    private String getLabelClass(String val) {
        switch (val) {
            case "au_0": 
            case "ex_1": 
            case "st_2": {
                return "btn";
            }
            case "ty_1": 
            case "ty_12": 
            case "ty_15": 
            case "ty_2": 
            case "ty_26": 
            case "ty_27": 
            case "ty_28": 
            case "ty_29": 
            case "ty_3": 
            case "ty_4": 
            case "ty_5": 
            case "vc_1": {
                return "btn btn-type";
            }
            case "au_1": 
            case "au_2": 
            case "au_3": 
            case "ch_1": 
            case "ch_4": 
            case "ex_60": 
            case "ex_65": 
            case "mo_1": 
            case "td_1": {
                return "btn btn-green";
            }
            case "ch_2": 
            case "ch_3": 
            case "or_0": {
                return "btn btn-orange";
            }
            case "ty_13": 
            case "ty_21": 
            case "ty_23": 
            case "ty_25": 
            case "ty_7": 
            case "ty_83": 
            case "ty_84": {
                return "btn btn-type-blue";
            }
            case "ty_14": 
            case "ty_19": 
            case "ty_30": 
            case "ty_47": {
                return "btn btn-type-orange";
            }
            case "ty_10": 
            case "ty_16": 
            case "ty_17": 
            case "ty_20": 
            case "ty_24": 
            case "ty_8": 
            case "ty_9": {
                return "btn btn-type-green";
            }
            case "ty_11": {
                return "btn btn-type-pink";
            }
            case "st_3": 
            case "st_4": 
            case "st_6": 
            case "st_7": 
            case "st_8": {
                return "btn btn-red";
            }
            case "ex_30": {
                return "btn btn-blue";
            }
            case "or_1": 
            case "au_4": 
            case "au_5": {
                return "btn btn-green";
            }
        }
        return "";
    }

    private String getLabelText(String val) {
        switch (val) {
            case "au_0": {
                return ResManager.loadKDString((String)"\u672a\u52fe\u9009", (String)"InvoiceInfoLabelService_0", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "au_1": {
                return ResManager.loadKDString((String)"\u5df2\u52fe\u9009", (String)"InvoiceInfoLabelService_1", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "au_2": {
                return ResManager.loadKDString((String)"\u5df2\u62b5\u6263", (String)"InvoiceInfoLabelService_2", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "au_3": {
                return ResManager.loadKDString((String)"\u5df2\u62b5\u6263", (String)"InvoiceInfoLabelService_2", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "au_4": {
                return ResManager.loadKDString((String)"\u9884\u52fe\u9009", (String)"InvoiceInfoLabelService_3", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "au_5": {
                return ResManager.loadKDString((String)"\u52fe\u9009\u4e2d", (String)"InvoiceInfoLabelService_4", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ch_1": {
                return ResManager.loadKDString((String)"\u5df2\u9a8c", (String)"InvoiceInfoLabelService_5", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ch_2": {
                return ResManager.loadKDString((String)"\u672a\u9a8c", (String)"InvoiceInfoLabelService_6", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ch_3": {
                return ResManager.loadKDString((String)"\u672a\u9a8c", (String)"InvoiceInfoLabelService_6", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ch_4": {
                return ResManager.loadKDString((String)"\u5df2\u9a8c", (String)"InvoiceInfoLabelService_5", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ex_1": {
                return ResManager.loadKDString((String)"\u672a\u7528", (String)"InvoiceInfoLabelService_7", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ex_30": {
                return ResManager.loadKDString((String)"\u5728\u7528", (String)"InvoiceInfoLabelService_8", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ex_60": {
                return ResManager.loadKDString((String)"\u5df2\u7528", (String)"InvoiceInfoLabelService_9", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ex_65": {
                return ResManager.loadKDString((String)"\u5df2\u5165\u8d26", (String)"InvoiceInfoLabelService_10", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "mo_1": {
                return ResManager.loadKDString((String)"\u5df2\u6539", (String)"InvoiceInfoLabelService_11", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "or_0": {
                return ResManager.loadKDString((String)"\u672a\u7b7e\u6536", (String)"InvoiceInfoLabelService_12", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "or_1": {
                return ResManager.loadKDString((String)"\u5df2\u7b7e\u6536", (String)"InvoiceInfoLabelService_13", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "st_2": {
                return ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"InvoiceInfoLabelService_14", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "st_3": {
                return ResManager.loadKDString((String)"\u7ea2\u51b2", (String)"InvoiceInfoLabelService_15", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "st_4": {
                return ResManager.loadKDString((String)"\u5f02\u5e38", (String)"InvoiceInfoLabelService_16", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "st_6": {
                return ResManager.loadKDString((String)"\u7ea2\u7968\u5f85\u786e\u8ba4", (String)"InvoiceInfoLabelService_17", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "st_7": {
                return ResManager.loadKDString((String)"\u90e8\u5206\u7ea2\u51b2", (String)"InvoiceInfoLabelService_18", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "st_8": {
                return ResManager.loadKDString((String)"\u5168\u989d\u7ea2\u51b2", (String)"InvoiceInfoLabelService_19", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "td_1": {
                return ResManager.loadKDString((String)"\u5df2\u62b5\u6263", (String)"InvoiceInfoLabelService_2", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_1": {
                return ResManager.loadKDString((String)"\u7535\u7968", (String)"InvoiceInfoLabelService_20", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_10": {
                return ResManager.loadKDString((String)"\u98de\u673a", (String)"InvoiceInfoLabelService_21", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_11": {
                return ResManager.loadKDString((String)"\u5176\u5b83", (String)"InvoiceInfoLabelService_22", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_12": {
                return ResManager.loadKDString((String)"\u673a\u52a8", (String)"InvoiceInfoLabelService_23", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_13": {
                return ResManager.loadKDString((String)"\u4e8c\u624b", (String)"InvoiceInfoLabelService_24", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_14": {
                return ResManager.loadKDString((String)"\u5b9a\u989d", (String)"InvoiceInfoLabelService_25", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_15": {
                return ResManager.loadKDString((String)"\u901a\u884c", (String)"InvoiceInfoLabelService_26", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_16": {
                return ResManager.loadKDString((String)"\u5ba2\u8fd0", (String)"InvoiceInfoLabelService_27", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_17": {
                return ResManager.loadKDString((String)"\u8fc7\u8def", (String)"InvoiceInfoLabelService_28", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_19": {
                return ResManager.loadKDString((String)"\u5b8c\u7a0e", (String)"InvoiceInfoLabelService_29", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_2": {
                return ResManager.loadKDString((String)"\u7535\u7968", (String)"InvoiceInfoLabelService_20", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_20": {
                return ResManager.loadKDString((String)"\u8f6e\u8239", (String)"InvoiceInfoLabelService_30", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_21": {
                return ResManager.loadKDString((String)"\u6d77\u5173", (String)"InvoiceInfoLabelService_31", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_23": {
                return ResManager.loadKDString((String)"\u673a\u6253", (String)"InvoiceInfoLabelService_32", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_24": {
                return ResManager.loadKDString((String)"\u706b\u8f66", (String)"InvoiceInfoLabelService_33", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_25": {
                return ResManager.loadKDString((String)"\u8d22\u653f", (String)"InvoiceInfoLabelService_34", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_26": {
                return ResManager.loadKDString((String)"\u6570\u7535", (String)"InvoiceInfoLabelService_35", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_27": {
                return ResManager.loadKDString((String)"\u6570\u7535", (String)"InvoiceInfoLabelService_35", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_28": {
                return ResManager.loadKDString((String)"\u6570\u7535\u822a\u7a7a", (String)"InvoiceInfoLabelService_36", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_29": {
                return ResManager.loadKDString((String)"\u6570\u7535\u94c1\u8def", (String)"InvoiceInfoLabelService_37", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_3": {
                return ResManager.loadKDString((String)"\u7eb8\u7968", (String)"InvoiceInfoLabelService_38", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_30": {
                return ResManager.loadKDString((String)"\u6d77\u5916", (String)"InvoiceInfoLabelService_39", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_4": {
                return ResManager.loadKDString((String)"\u4e13\u7968", (String)"InvoiceInfoLabelService_40", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_47": {
                return ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34", (String)"InvoiceInfoLabelService_41", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_5": {
                return ResManager.loadKDString((String)"\u5377\u7968", (String)"InvoiceInfoLabelService_42", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_7": {
                return ResManager.loadKDString((String)"\u673a\u6253", (String)"InvoiceInfoLabelService_32", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_8": {
                return ResManager.loadKDString((String)"\u7684\u58eb", (String)"InvoiceInfoLabelService_43", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_9": {
                return ResManager.loadKDString((String)"\u706b\u8f66", (String)"InvoiceInfoLabelService_33", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "vc_1": {
                return ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"InvoiceInfoLabelService_44", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_83": {
                return ResManager.loadKDString((String)"\u6570\u7535\u673a\u52a8\u8f66", (String)"InvoiceInfoLabelService_45", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            case "ty_84": {
                return ResManager.loadKDString((String)"\u6570\u7535\u4e8c\u624b\u8f66", (String)"InvoiceInfoLabelService_46", (String)"imc-rim-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public String verify() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        for (IDataEntityProperty property : mainPros) {
            if (!property.getName().equals("invoice_info")) continue;
            MulComboProp prop = (MulComboProp)property;
            List items = prop.getComboItems();
            for (ValueMapItem item : items) {
                String val = item.getValue();
                String text = this.getLabelText(val);
                String style = this.getLabelClass(val);
                if (!StringUtils.isEmpty((CharSequence)text) && !StringUtils.isEmpty((CharSequence)style)) continue;
                throw new RuntimeException("value:" + val + ",text:" + text + ",style:" + style);
            }
        }
        return "success";
    }
}

