/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InvoiceLog {
    private static Log logger = LogFactory.getLog(InvoiceLog.class);
    public static final String LOG_TYPE_SAVE = "save";
    public static final String LOG_TYPE_SIGN = "sign";
    public static final String LOG_TYPE_UNSIGN = "unsign";
    public static final String LOG_TYPE_DELETE = "delete";
    public static final String LOG_TYPE_EXPENSE = "expense";
    public static final String LOG_TYPE_VOUCHER = "voucher";
    public static final String LOG_TYPE_SYNC_HIS_DATA = "sync_his_data";
    public static final String LOG_TYPE_CHANGEORG = "changeorg";
    public static final String LOG_TYPE_CHANGETAXORG = "changtaxorg";
    public static final String LOG_TYPE_DEDUCT_AUTHENTICATE = "deduct_authenticate";
    public static final String LOG_TYPE_TAX_RECORDED = "tax_recorded";
    public static final String LOG_TYPE_TRANSPORT_DEDUCTION = "transport_deduction";
    public static final String LOG_TYPE_AGRIC_HANDLE = "agric_handle";

    public static void insert(String logType, String serialNo, String logInfo) {
        InvoiceLog.insert(logType, serialNo, logInfo, 0L, null, null);
    }

    public static void insert(String logType, List<String> serialNos, String logInfo) {
        try {
            RequestContext context = RequestContext.get();
            Long orgId = context.getOrgId();
            Long userId = Long.valueOf(context.getUserId());
            Date date = new Date();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(serialNos.size());
            for (String serialNo : serialNos) {
                list.add(InvoiceLog.createDynamicObject(logType, serialNo, logInfo, orgId, null, null, userId, date));
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.info("\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void insert(String logType, Map<String, String> invoiceInfo) {
        try {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(invoiceInfo.size());
            RequestContext context = RequestContext.get();
            Long orgId = context.getOrgId();
            Long userId = Long.valueOf(context.getUserId());
            Date date = new Date();
            for (Map.Entry<String, String> entry : invoiceInfo.entrySet()) {
                list.add(InvoiceLog.createDynamicObject(logType, entry.getKey(), entry.getValue(), orgId, null, null, userId, date));
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.info("\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void insert(String logType, String serialNo, String logInfo, Long orgId, String resource, String collectType) {
        try {
            RequestContext context = RequestContext.get();
            if (orgId == null || orgId < 1L) {
                orgId = context.getOrgId();
            }
            Long userId = Long.valueOf(context.getUserId());
            Date date = new Date();
            DynamicObject logObject = InvoiceLog.createDynamicObject(logType, serialNo, logInfo, orgId, resource, collectType, userId, date);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
        }
        catch (Exception e) {
            logger.info("\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private static DynamicObject createDynamicObject(String logType, String serialNo, String logInfo, Long orgId, String resource, String collectType, Long userId, Date date) {
        DynamicObject logObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_log");
        logObject.set("log_type", (Object)logType);
        logObject.set("serial_no", (Object)serialNo);
        logObject.set("log_info", (Object)logInfo);
        logObject.set("org", (Object)orgId);
        logObject.set("resource", (Object)resource);
        logObject.set("collect_type", (Object)collectType);
        logObject.set("creater", (Object)userId);
        logObject.set("create_time", (Object)date);
        return logObject;
    }

    public static void insertExpenseLog(String logType, String billId, String billNo, String content) {
        try {
            DynamicObject logObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense_log");
            RequestContext context = RequestContext.get();
            logObject.set("billid", (Object)billId);
            logObject.set("billno", (Object)billNo);
            logObject.set("log_type", (Object)logType);
            logObject.set("content_tag", (Object)content);
            logObject.set("creater", (Object)context.getUserId());
            logObject.set("create_time", (Object)new Date());
            logObject.set("traceid", (Object)context.getTraceId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
        }
        catch (Exception e) {
            logger.info("\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25");
        }
    }
}

