/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.constant.InvoiceUploadErrorType;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.recognition.listener.IRecognitionListener;
import kd.imc.rim.common.invoice.recognition.listener.RecognitionListenerResult;
import kd.imc.rim.common.invoice.recognitionnew.task.FileUploadAndSignTask;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.FormFileEntity;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class RecognitionCheckService {
    private static RecognitionCheckService instance = null;
    private static Log logger = LogFactory.getLog(RecognitionCheckService.class);
    private RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
    private static Integer recheckorginPage = 999123413;
    private static ThreadPool uploadThreadPool = ThreadPools.newFixedThreadPool((String)"recognitionUploadThread_2", (int)(Runtime.getRuntime().availableProcessors() + 1));

    private RecognitionCheckService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecognitionCheckService getInstance() {
        Class<RecognitionCheckService> clazz = RecognitionCheckService.class;
        synchronized (RecognitionCheckService.class) {
            if (instance == null) {
                instance = new RecognitionCheckService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public JSONObject recognitionCheckInvoice(String fileUrl, String fileName, IRecognitionListener recognitionListener, JSONObject businessParam) {
        logger.info("\u8bc6\u522b\u67e5\u9a8cfileName:{},businessParam:{}", (Object)fileName, (Object)businessParam);
        fileName = FileUtils.truncateFileName(fileName, 50);
        this.markDeleteByVerifySave(businessParam);
        boolean isCheck = this.getCheckFlag(businessParam);
        return this.extracted_new(fileUrl, fileName, recognitionListener, businessParam, isCheck);
    }

    private void markDeleteByVerifySave(JSONObject businessParam) {
        String verifySaveFlag;
        if (businessParam != null && "0".equals(verifySaveFlag = RimConfigUtils.getConfig("verify_save"))) {
            businessParam.put("delete", (Object)"2");
        }
    }

    private JSONObject extracted_new(String fileUrl, String fileName, IRecognitionListener recognitionListener, JSONObject businessParam, boolean isCheck) {
        JSONArray attachResult;
        JSONArray finalResult;
        long startTime = System.currentTimeMillis();
        Object result = null;
        RecognitionListenerResult listener = new RecognitionListenerResult(fileUrl, fileName, 0, 0, new JSONArray());
        try {
            List<JSONObject> recognitionResultList;
            long fileStartTime = System.currentTimeMillis();
            byte[] fileByte = null;
            if (businessParam != null) {
                fileByte = businessParam.getBytes("fileByte");
            }
            Map<String, Object> extMap = this.recognitionCheckHelper.getRecognitionCheckExtMap(businessParam);
            Object recogType = extMap.get("recogType");
            FormFileEntity fileEntity = this.recognitionCheckHelper.getFormFileEntity(fileUrl, fileName, fileByte, recogType);
            fileEntity.setFileByte(fileByte);
            if (!fileEntity.getSuccess().booleanValue()) {
                this.handle(recognitionListener, listener);
                return InvoiceUploadErrorType.getSplitErrorResult();
            }
            int totalPage = CollectionUtils.isEmpty(fileEntity.getSubFileList()) ? 1 : fileEntity.getSubFileList().size();
            String originalStateDefault = fileEntity.getOriginalStateDefault();
            if ("1".equals(originalStateDefault)) {
                extMap.put("originalStateDefault", originalStateDefault);
            }
            String fileType = fileEntity.getFileType();
            Map<Integer, Object> subFileFutureMap = this.syncUploadSubFile(fileEntity);
            logger.info("RecognitionCheckService \u6587\u4ef6\u89e3\u6790\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - fileStartTime));
            try {
                long recognitionStartTime = System.currentTimeMillis();
                recognitionResultList = this.recognitionCheckHelper.recognitionInvoiceFile(fileEntity, extMap);
                logger.info("RecognitionCheckService \u8bc6\u522b\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - recognitionStartTime));
                this.checkOriginal(fileEntity, subFileFutureMap, recognitionResultList);
                finalResult = JSONObject.parseArray((String)JSONObject.toJSONString(recognitionResultList));
            }
            catch (Throwable t) {
                this.handle(recognitionListener, listener);
                if (t instanceof MsgException) {
                    return JSON.parseObject((String)t.toString());
                }
                logger.info("\u8bc6\u522b\u7a0b\u5e8f\u9519\u8bef\uff1a", (Object)t);
                if (t instanceof KDBizException) {
                    return InvoiceUploadErrorType.getErrorResult("0011", t.getMessage());
                }
                return InvoiceUploadErrorType.getRecognitionErrorResult();
            }
            if (isCheck && recognitionResultList.size() > 0) {
                try {
                    long checkStartTime = System.currentTimeMillis();
                    List<JSONObject> checkResultList = this.recognitionCheckHelper.checkInvoiceByRecognitionInfo(recognitionResultList, extMap);
                    logger.info("RecognitionCheckService \u67e5\u9a8c\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - checkStartTime));
                    finalResult = JSONObject.parseArray((String)JSONObject.toJSONString(checkResultList));
                }
                catch (Throwable t) {
                    this.handle(recognitionListener, listener);
                    logger.info("\u67e5\u9a8c\u7a0b\u5e8f\u9519\u8bef\uff1a", (Object)t);
                    return InvoiceUploadErrorType.getCheckErrorResult();
                }
            }
            HashMap fileBaseInfo = Maps.newHashMap();
            fileBaseInfo.put("fileType", fileType);
            fileBaseInfo.put("fileUrl", fileUrl);
            fileBaseInfo.put("fileName", fileName);
            fileBaseInfo.put("size", fileEntity.getFileSize());
            fileBaseInfo.put("fileHash", fileEntity.getFileHash());
            finalResult = this.putFileInfo(fileBaseInfo, finalResult, subFileFutureMap, originalStateDefault);
            attachResult = this.dealSaleList(finalResult, businessParam);
            boolean isHandleAttach = attachResult.size() > 0 && finalResult.size() == 0;
            logger.info("isHandleAttach:{}", (Object)isHandleAttach);
            if (isHandleAttach) {
                this.handleAttach(attachResult, recognitionListener, fileUrl, fileName, totalPage);
            }
            try {
                if (fileBaseInfo.get("totalPage") == null) {
                    totalPage = this.getTotalPage(finalResult, attachResult);
                    fileBaseInfo.put("totalPage", totalPage);
                }
                this.saveInvoice(finalResult, attachResult, isHandleAttach, fileBaseInfo, businessParam, recognitionListener);
                FileUploadUtils.saveBasAttachment(fileUrl, fileName, "rim_invoice", "", fileEntity.getFileSize());
            }
            catch (Throwable t) {
                this.handle(recognitionListener, listener);
                logger.info("\u53d1\u7968\u4fdd\u5b58\u9519\u8bef\uff1a", (Object)t);
            }
        }
        catch (IOException t) {
            logger.info("RecognitionCheckService IOException :{}", (Object)t);
            this.handle(recognitionListener, listener);
            return InvoiceUploadErrorType.getSplitErrorResult();
        }
        catch (MsgException t) {
            logger.info("RecognitionCheckService MsgException :{}", (Object)t);
            this.handle(recognitionListener, listener);
            JSONObject errorInfo = new JSONObject();
            errorInfo.put("errcode", (Object)t.getErrorCode());
            errorInfo.put("description", (Object)t.getMessage());
            return errorInfo;
        }
        catch (Throwable t) {
            logger.info("RecognitionCheckService BaseErrorResult Throwable:{}", (Object)t);
            this.handle(recognitionListener, listener);
            if (t instanceof KDBizException) {
                return InvoiceUploadErrorType.getErrorResult("0011", t.getMessage());
            }
            return InvoiceUploadErrorType.getBaseErrorResult();
        }
        boolean resultFlag = finalResult.size() != 0 || attachResult.size() != 0;
        logger.info("RecognitionCheckService \u8bc6\u522b\u67e5\u9a8c\u5165\u5e93\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        if (resultFlag) {
            return InvoiceUploadErrorType.getSuccessResult(finalResult, attachResult);
        }
        this.handle(recognitionListener, listener);
        return InvoiceUploadErrorType.getFailResult();
    }

    private void checkOriginal(FormFileEntity fileEntity, Map<Integer, Object> subFileFutureMap, List<JSONObject> recognitionResultList) {
        if (!StringUtils.isBlank((CharSequence)fileEntity.getSecondPageText()) && !CollectionUtils.isEmpty(recognitionResultList)) {
            JSONObject firstInvoice = recognitionResultList.get(0);
            Long invoiceType = firstInvoice.getLong("invoiceType");
            String invoiceNo = firstInvoice.getString("invoiceNo");
            String invoiceCode = firstInvoice.getString("invoiceCode");
            if (InputInvoiceTypeEnum.isCheckOriginalFile(invoiceType) && StringUtils.isNotEmpty((CharSequence)invoiceCode) && StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
                int codeindx = fileEntity.getSecondPageText().indexOf(invoiceCode);
                int noidx = fileEntity.getSecondPageText().indexOf(invoiceNo);
                if (codeindx < 0 || noidx < 0) {
                    return;
                }
            }
            for (int i = 1; i < recognitionResultList.size(); ++i) {
                JSONObject invoice = recognitionResultList.get(i);
                if (RecognitionCheckHelper.isSalePage(invoice)) continue;
                return;
            }
            FileUploadAndSignTask task = new FileUploadAndSignTask(fileEntity.getFileUrl(), fileEntity.getFileByte(), fileEntity.getFileName(), "pdf", fileEntity.getFileHash(), true, null, RequestContext.get());
            task.setSignOnly(true);
            Future subUploadFuture = uploadThreadPool.submit((Callable)task);
            subFileFutureMap.put(recheckorginPage, subUploadFuture);
        }
    }

    private int getTotalPage(JSONArray finalResult, JSONArray attachArray) {
        int i;
        HashSet<Integer> pageNumSet = new HashSet<Integer>(8);
        if (finalResult != null && !finalResult.isEmpty()) {
            for (i = 0; i < finalResult.size(); ++i) {
                pageNumSet.add(finalResult.getJSONObject(i).getInteger("pageNo"));
            }
        }
        if (attachArray != null && !attachArray.isEmpty()) {
            for (i = 0; i < attachArray.size(); ++i) {
                pageNumSet.add(attachArray.getJSONObject(i).getInteger("pageNo"));
            }
        }
        return pageNumSet.size();
    }

    private void handleAttach(JSONArray attachResult, IRecognitionListener recognitionListener, String fileUrl, String fileName, int totalPage) {
        if (attachResult == null || attachResult.size() == 0) {
            return;
        }
        if (recognitionListener != null) {
            Map<Integer, List<Object>> handleMap = attachResult.stream().collect(Collectors.groupingBy(v -> ((JSONObject)v).getInteger("pageNo")));
            logger.info("handleAttach handleMap:{}", handleMap);
            for (Map.Entry<Integer, List<Object>> entry : handleMap.entrySet()) {
                int pageNo = entry.getKey();
                logger.info("\u9644\u4ef6\u901a\u77e5\u524d\u7aefpageNo\uff1a{}", (Object)pageNo);
                JSONArray invoiceArray = JSONArray.parseArray((String)JSON.toJSONString(entry.getValue()));
                RecognitionListenerResult listener = new RecognitionListenerResult(fileUrl, fileName, pageNo, totalPage, invoiceArray);
                recognitionListener.handle(listener);
            }
        }
    }

    private JSONArray dealSaleList(JSONArray finalResult, JSONObject businessParam) {
        if (finalResult.size() == 0) {
            return new JSONArray();
        }
        Map<String, String> configMap = ImcConfigUtil.getValue("rim_recog_check");
        String isDealSaleList = configMap.get("is_dealsalelist");
        if (!"0".equals(isDealSaleList)) {
            JSONArray targetArray = this.recognitionCheckHelper.getTargetArray(finalResult);
            finalResult.removeAll((Collection)targetArray);
            Map<String, Long> invoiceTypeMap = this.getInvoiceTypeMapAndRemoveFinancialDetail(finalResult);
            JSONArray attachArray = this.recognitionCheckHelper.bindAttachInvoice(targetArray, businessParam, invoiceTypeMap);
            ArrayList finishList = Lists.newArrayList();
            if (attachArray.size() > 0) {
                for (int i = 0; i < attachArray.size(); ++i) {
                    JSONObject attachInfo = attachArray.getJSONObject(i);
                    String invoiceCode = attachInfo.getString("invoiceCode");
                    String invoiceNo = attachInfo.getString("invoiceNo");
                    String isVat = attachInfo.getString("isVat");
                    if (!"1".equals(isVat)) continue;
                    StringBuilder attachNo = new StringBuilder();
                    attachNo.append(invoiceCode).append('_').append(invoiceNo);
                    if (finishList.contains(attachNo.toString())) continue;
                    JSONObject numObject = this.recognitionCheckHelper.calcSaleListComplete(invoiceCode, invoiceNo, attachNo.toString());
                    int salelistSum = numObject.getInteger("salelistSum");
                    if (salelistSum == 0) {
                        salelistSum = attachInfo.getInteger("page_sum");
                    }
                    attachInfo.put("salelistSum", (Object)salelistSum);
                    attachInfo.put("bindNum", (Object)numObject.getInteger("bindNum"));
                    finishList.add(attachNo.toString());
                }
            }
            return attachArray;
        }
        return new JSONArray();
    }

    private Map<String, Long> getInvoiceTypeMapAndRemoveFinancialDetail(JSONArray finalResult) {
        HashMap<String, Long> invoiceTypeMap = new HashMap<String, Long>(8);
        boolean notFINANCIAL = false;
        for (int i = 0; i < finalResult.size(); ++i) {
            JSONObject invoiceInfo = finalResult.getJSONObject(i);
            Long invoiceType = invoiceInfo.getLong("invoiceType");
            if (!InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
                invoiceTypeMap.put(StringUtils.trimToEmpty((String)invoiceInfo.getString("invoiceCode")) + StringUtils.trimToEmpty((String)invoiceInfo.getString("invoiceNo")), invoiceType);
                continue;
            }
            if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) continue;
            notFINANCIAL = true;
        }
        if (invoiceTypeMap.size() > 0 && !notFINANCIAL) {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>(8);
            for (int i = 0; i < finalResult.size(); ++i) {
                JSONObject invoiceInfo = finalResult.getJSONObject(i);
                Long invoiceType = invoiceInfo.getLong("invoiceType");
                String title = invoiceInfo.getString("title");
                if (RecognitionCheckHelper.isSalePage(invoiceInfo) || !InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType) || !StringUtils.isNotEmpty((CharSequence)title) || title.indexOf("\u660e\u7ec6") <= 0) continue;
                list.add(invoiceInfo);
            }
            if (!list.isEmpty()) {
                finalResult.removeAll(list);
            }
        }
        return invoiceTypeMap;
    }

    public void handle(IRecognitionListener recognitionListener, RecognitionListenerResult listener) {
        if (recognitionListener != null) {
            recognitionListener.handle(listener);
        }
    }

    public static void setInvoiceSeq(JSONObject invoiceInfo, JSONObject businessParam, int pageNo, int invoiceIndex) {
        String uploadIndex;
        if (invoiceInfo == null) {
            return;
        }
        if (businessParam == null) {
            uploadIndex = String.valueOf(System.currentTimeMillis());
        } else {
            uploadIndex = businessParam.getString("uploadIndex");
            if (StringUtils.isEmpty((CharSequence)uploadIndex)) {
                uploadIndex = String.valueOf(System.currentTimeMillis());
                businessParam.put("uploadIndex", (Object)uploadIndex);
            }
        }
        invoiceInfo.put("uploadSeq", (Object)RecognitionCheckService.getInvoiceSeq(uploadIndex, pageNo, invoiceIndex));
    }

    public static Long getInvoiceSeq(String uploadIndex, int pageNo, int invoiceIndex) {
        DecimalFormat decimalFormat = new DecimalFormat("000");
        return Long.valueOf(uploadIndex + decimalFormat.format(pageNo) + decimalFormat.format(invoiceIndex));
    }

    private JSONArray putFileInfo(Map<String, Object> fileBaseInfo, JSONArray finalResult, Map<Integer, Object> subFileFutureMap, String originalStateDefault) throws ExecutionException, InterruptedException {
        String updateFileType = String.valueOf(fileBaseInfo.get("fileType"));
        String updateFileUrl = String.valueOf(fileBaseInfo.get("fileUrl"));
        int size = finalResult.size();
        boolean pdfSplit = false;
        List type = finalResult.stream().map(m -> ((JSONObject)m).getLong("invoiceType")).collect(Collectors.toList());
        if ((size > 1 || type.contains(InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode()) || type.contains(InputInvoiceTypeEnum.OVERSEA_RECEIPT.getCode()) || type.contains(InputInvoiceTypeEnum.HGJKS.getCode())) && "pdf".equals(updateFileType)) {
            pdfSplit = true;
        }
        Object refeature = subFileFutureMap.get(recheckorginPage);
        boolean returnFirst = false;
        for (int i = 0; i < finalResult.size(); ++i) {
            JSONObject invoiceInfo = (JSONObject)finalResult.get(i);
            Long invoiceType = invoiceInfo.getLong("invoiceType");
            invoiceInfo.put("fileName", fileBaseInfo.get("fileName"));
            invoiceInfo.put("fileHash", fileBaseInfo.get("fileHash"));
            int pageNo = Integer.parseInt(invoiceInfo.get((Object)"pageNo") + "");
            Object feature = subFileFutureMap.get(pageNo);
            if (feature != null) {
                JSONObject fileReuslt2;
                long start = System.currentTimeMillis();
                JSONObject fileReuslt = this.getUploadResult(feature);
                if (refeature != null && i == 0 && (fileReuslt2 = this.getUploadResult(refeature)) != null) {
                    returnFirst = "true".equals(fileReuslt2.getString("isOriginal"));
                }
                if (fileReuslt != null) {
                    String isOriginal = fileReuslt.getString("isOriginal");
                    invoiceInfo.put("isOriginal", (Object)isOriginal);
                    if (!"1".equals(invoiceInfo.getString("originalState"))) {
                        if ("true".equals(isOriginal)) {
                            invoiceInfo.put("originalState", (Object)"1");
                        } else {
                            invoiceInfo.put("originalState", (Object)"0");
                        }
                    }
                    invoiceInfo.put("subFileName", (Object)fileReuslt.getString("subFileName"));
                    invoiceInfo.put("snapshotUrl", (Object)fileReuslt.getString("snapshotUrl"));
                    invoiceInfo.put("imageUrl", (Object)fileReuslt.getString("imageUrl"));
                    invoiceInfo.put("ofdUrl", (Object)fileReuslt.getString("ofdUrl"));
                    invoiceInfo.put("pdfUrl", (Object)fileReuslt.getString("pdfUrl"));
                    if (pdfSplit) {
                        invoiceInfo.put("pdfUrl", (Object)updateFileUrl);
                    }
                    invoiceInfo.put("localUrl", (Object)"");
                    invoiceInfo.put("kdcloudUrl", (Object)"");
                    String fileType = FileUtils.getFileType((String)fileBaseInfo.get("fileName"), updateFileUrl);
                    if (StringUtils.isEmpty((CharSequence)fileType)) {
                        fileType = updateFileType;
                    }
                    if ("pdf".equals(fileType)) {
                        invoiceInfo.put("fileType", (Object)"1");
                    } else if ("ofd".equals(fileType)) {
                        invoiceInfo.put("fileType", (Object)"4");
                    } else {
                        invoiceInfo.put("fileType", (Object)"2");
                    }
                    invoiceInfo.put("synConvert", (Object)fileReuslt.getString("synConvert"));
                } else {
                    invoiceInfo.put("synConvert", (Object)true);
                }
                logger.info("\u83b7\u53d6\u6587\u4ef6\u5904\u7406\u7ed3\u679c\u7b49\u5f85\u65f6\u957f{},{}", (Object)(System.currentTimeMillis() - start), (Object)fileReuslt);
                if (!returnFirst || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) continue;
                JSONArray finalResult2 = new JSONArray();
                invoiceInfo.put("originalState", (Object)"1");
                finalResult2.add((Object)invoiceInfo);
                fileBaseInfo.put("totalPage", 1);
                return finalResult2;
            }
            logger.info("\u83b7\u53d6\u6587\u4ef6\u5904\u7406\u7ed3\u679c\u7b2c{}\u9875\u7ed3\u679c\u4e3a\u7a7a", (Object)pageNo);
        }
        return finalResult;
    }

    private JSONObject getUploadResult(Object feature) {
        block6: {
            long timeOut = 10L;
            if (feature instanceof Future) {
                try {
                    return (JSONObject)((Future)feature).get(timeOut, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    logger.info("\u83b7\u53d6\u6587\u4ef6\u5904\u7406\u7ed3\u679c\u7b49\u5f85\u8d85\u65f6-{} InterruptedException", (Object)timeOut);
                    break block6;
                }
                catch (ExecutionException e) {
                    logger.info("\u83b7\u53d6\u6587\u4ef6\u5904\u7406\u7ed3\u679c\u7b49\u5f85\u8d85\u65f6-{} ExecutionException", (Object)timeOut);
                    break block6;
                }
                catch (TimeoutException e) {
                    logger.info("\u83b7\u53d6\u6587\u4ef6\u5904\u7406\u7ed3\u679c\u7b49\u5f85\u8d85\u65f6-{} TimeoutException", (Object)timeOut);
                    break block6;
                }
            }
            if (feature instanceof JSONObject) {
                return (JSONObject)feature;
            }
        }
        return null;
    }

    private Map<Integer, Object> syncUploadSubFile(FormFileEntity fileFile) {
        if (fileFile == null || !fileFile.getSuccess().booleanValue()) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        int pageNo = 0;
        if (CollectionUtils.isEmpty(fileFile.getSubFileList())) {
            result.put(1, this.syncUploadOneFile(fileFile, 1));
        } else {
            int totalPage = fileFile.getSubFileList().size();
            for (FormFileEntity subFile : fileFile.getSubFileList()) {
                result.put(++pageNo, this.syncUploadOneFile(subFile, totalPage));
            }
        }
        return result;
    }

    private Object syncUploadOneFile(FormFileEntity fileFile, int totalPage) {
        Future subUploadFuture = null;
        RequestContext context = RequestContext.get();
        if ("ofd".equalsIgnoreCase(fileFile.getFileType()) || "pdf".equalsIgnoreCase(fileFile.getFileType())) {
            try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(fileFile.getFileUrl()), fileFile.getFileByte());){
                byte[] streamByte = FileUtils.getByte(fileInputStream);
                if (StringUtils.isEmpty((CharSequence)fileFile.getFileHash())) {
                    fileFile.setFileHash(FileConvertUtils.getSHA256((byte[])streamByte));
                }
                subUploadFuture = uploadThreadPool.submit((Callable)new FileUploadAndSignTask(fileFile.getFileUrl(), streamByte, fileFile.getFileName(), fileFile.getFileType(), fileFile.getFileHash(), fileFile.getSignatureFlag(), null, context));
            }
            catch (IOException e) {
                logger.error("\u6587\u4ef6\u5904\u7406\u5931\u8d25:" + fileFile.getFileUrl(), (Throwable)e);
            }
        } else {
            JSONObject result = new JSONObject();
            result.put("isOriginal", (Object)false);
            result.put("fileType", (Object)"2");
            result.put("imageUrl", (Object)fileFile.getFileUrl());
            result.put("snapshotUrl", (Object)fileFile.getFileUrl());
            result.put("subFileName", (Object)fileFile.getFileName());
            return result;
        }
        return subUploadFuture;
    }

    private void saveInvoice(JSONArray finalResult, JSONArray attachResult, boolean isHandleAttach, Map<String, Object> fileBaseInfo, JSONObject businessParam, IRecognitionListener recognitionListener) {
        JSONObject invoiceInfo;
        int i;
        String fileUrl = (String)fileBaseInfo.get("fileUrl");
        String fileName = (String)fileBaseInfo.get("fileName");
        int totalPage = (Integer)fileBaseInfo.get("totalPage");
        JSONArray handleResult = new JSONArray();
        JSONArray mayErrorResult = new JSONArray();
        HashMap<String, JSONObject> saveSuccessResult = new HashMap<String, JSONObject>(finalResult.size());
        boolean repeatSave = false;
        for (i = 0; i < finalResult.size(); ++i) {
            try {
                invoiceInfo = finalResult.getJSONObject(i);
                int pageNo = Integer.parseInt(invoiceInfo.get((Object)"pageNo") + "");
                RecognitionCheckService.setInvoiceSeq(invoiceInfo, businessParam, pageNo, i + 1);
                HashSet<String> serialNosSet = new HashSet<String>(8);
                String snapshotUrl = null;
                String awsInvoiceType = invoiceInfo.getString("invoiceType");
                Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsInvoiceType);
                if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType)) {
                    String originalConfig = RimConfigUtils.getConfig("rim_config", "einvoice_auto_sign");
                    if (StringUtils.isEmpty((CharSequence)originalConfig) || "0".equals(originalConfig)) {
                        invoiceInfo.put("originalState", (Object)"0");
                    } else {
                        invoiceInfo.put("originalState", (Object)"1");
                    }
                }
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                    try {
                        if (BigDecimalUtil.transDecimal(invoiceInfo.get((Object)"invoiceAmount")).compareTo(BigDecimal.ZERO) <= 0) {
                            BigDecimal totalAmount = invoiceInfo.getBigDecimal("totalAmount");
                            BigDecimal taxAmount = CommonUtils.getJsonValue((Map<String, Object>)invoiceInfo, BigDecimal.class, "taxAmount", "totalTaxAmount");
                            BigDecimal invoiceAmount = totalAmount.subtract(taxAmount);
                            invoiceInfo.put("invoiceAmount", (Object)invoiceAmount);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u6570\u7535\u98de\u673a\u7968\uff0c\u8bbe\u7f6e\u4e0d\u542b\u7a0e\u91d1\u989d\u62a5\u9519, \u53d1\u7968\u53f7\u7801\uff1a" + invoiceInfo.getString("invoiceNo"), (Throwable)e);
                    }
                }
                invoiceInfo.put("invoiceType", (Object)invoiceType);
                Long tax_org = null;
                String resourcePlugin = "";
                if (null != businessParam) {
                    businessParam.remove((Object)"fileByte");
                    invoiceInfo.putAll((Map)businessParam);
                    tax_org = businessParam.getLong("tax_org");
                    resourcePlugin = businessParam.getString("resourcePlugin");
                }
                if (!ObjectUtils.isEmpty(tax_org)) {
                    invoiceInfo.put("tax_org", tax_org);
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceInfo.getString("snapshotUrl"))) {
                    snapshotUrl = FileUtils.downLoadAndUpload(invoiceInfo.getString("snapshotUrl"));
                }
                if (StringUtils.isNotEmpty(snapshotUrl)) {
                    invoiceInfo.put("snapshotUrl", (Object)snapshotUrl);
                }
                logger.info("\u53d1\u7968\u8bc6\u522b\u67e5\u9a8c\u8fd4\u56de\u6570\u636e\uff1a" + invoiceInfo);
                ConvertFieldUtil.getStandardInvoice(invoiceInfo);
                if (StringUtils.isEmpty((CharSequence)invoiceInfo.getString("serialNo")) || serialNosSet.add(invoiceInfo.getString("serialNo"))) {
                    InvoiceSaveService invoiceSaveService;
                    if ("sign_by_expense".equals(resourcePlugin) && (invoiceSaveService = InvoiceSaveService.newInstance(invoiceInfo.getString("invoiceType"))) != null) {
                        invoiceInfo.put("delete", (Object)invoiceSaveService.setInvoiceFiled(invoiceInfo));
                    }
                    String fileHash = invoiceInfo.getString("fileHash");
                    String errcode = invoiceInfo.getString("errcode");
                    if ("4999".equals(errcode) && InvoiceConvertUtils.isVatInvoiceType(invoiceInfo.getLong("invoiceType"))) {
                        invoiceInfo.put("checkStatus", (Object)"3");
                    }
                    try {
                        Object invoiceDate = invoiceInfo.get((Object)"invoiceDate");
                        if (invoiceDate instanceof Long) {
                            Date date = new Date((Long)invoiceDate);
                            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                            String dateString = formatter.format(date);
                            invoiceInfo.put("invoiceDate", (Object)dateString);
                        }
                        this.invoiceCollectService.saveInvoice(invoiceInfo, fileUrl, fileHash);
                        String invoiceUniqueKey = invoiceInfo.getString(InvoiceSaveConstant.PARAM_INVOICE_UNIQUE_KEY);
                        if (StringUtils.isNotEmpty((CharSequence)invoiceUniqueKey)) {
                            JSONObject saveResult = (JSONObject)saveSuccessResult.get(invoiceUniqueKey);
                            if (saveResult == null) {
                                saveSuccessResult.put(invoiceUniqueKey, invoiceInfo);
                            } else if (!InvoiceSaveConstant.SAVE_METHOD_SAVEUNCHECK.equals(saveResult.get((Object)InvoiceSaveConstant.PARAM_SAVE_METHOD))) {
                                saveSuccessResult.put(invoiceUniqueKey, invoiceInfo);
                            }
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"RecognitionCheckService_0", (String)"imc-rim-common", (Object[])new Object[0]);
                        if (e instanceof MsgException) {
                            String errorCode = ((MsgException)e).getErrorCode();
                            if (ErrorType.REPEAT_SAVE_INVOICE.getCode().equals(errorCode)) {
                                repeatSave = true;
                                invoiceInfo.put(InvoiceSaveConstant.PARAM_INVOICE_UNIQUE_KEY, ((MsgException)e).getData());
                            }
                            errorMsg = ((MsgException)e).getErrorMsg();
                            invoiceInfo.put("errorCode", (Object)errorCode);
                        }
                        invoiceInfo.put("errorMsg", (Object)errorMsg);
                        mayErrorResult.add((Object)invoiceInfo);
                    }
                    String isSaleListInvoice = invoiceInfo.getString("isSaleListInvoice");
                    Map<String, String> configMap = ImcConfigUtil.getValue("rim_recog_check");
                    String isDealSaleList = configMap.get("is_dealsalelist");
                    if ("1".equals(isSaleListInvoice) && !"0".equals(isDealSaleList)) {
                        this.recognitionCheckHelper.dealInvoiceAttachRelation(invoiceInfo);
                    }
                    logger.info("\u53d1\u7968\u52a9\u624b\u672c\u5730\u4e0a\u4f20\u4fdd\u5b58\u53d1\u7968\u540e\u7684\u6570\u636e\uff1a" + invoiceInfo);
                }
                handleResult.add((Object)invoiceInfo);
                continue;
            }
            catch (Throwable t) {
                handleResult.add((Object)mayErrorResult);
                logger.info("\u53d1\u7968\u5165\u5e93\u5931\u8d25\uff1a", (Object)t);
            }
        }
        if (repeatSave) {
            for (i = 0; i < finalResult.size(); ++i) {
                JSONObject saveResult;
                invoiceInfo = finalResult.getJSONObject(i);
                String invoiceUniqueKey = invoiceInfo.getString(InvoiceSaveConstant.PARAM_INVOICE_UNIQUE_KEY);
                if (!StringUtils.isNotEmpty((CharSequence)invoiceUniqueKey) || !ErrorType.REPEAT_SAVE_INVOICE.getCode().equals(invoiceInfo.getString("errorCode")) || (saveResult = (JSONObject)saveSuccessResult.get(invoiceUniqueKey)) == null) continue;
                invoiceInfo.remove((Object)"errorCode");
                invoiceInfo.remove((Object)"errorMsg");
                invoiceInfo.put("serialNo", (Object)saveResult.getString("serialNo"));
                invoiceInfo.put("unCheckId", (Object)saveResult.getString("unCheckId"));
                invoiceInfo.put("invoice_info", (Object)saveResult.getString("invoice_info"));
                invoiceInfo.put("mainId", (Object)saveResult.getString("mainId"));
                invoiceInfo.put(InvoiceSaveConstant.PARAM_INVOICE_UNIQUE_KEY, (Object)saveResult.getString(InvoiceSaveConstant.PARAM_INVOICE_UNIQUE_KEY));
                invoiceInfo.put(InvoiceSaveConstant.PARAM_SAVE_METHOD, (Object)saveResult.getString(InvoiceSaveConstant.PARAM_SAVE_METHOD));
            }
        }
        if (recognitionListener != null) {
            this.finallyHandleResult(handleResult, isHandleAttach, attachResult, fileUrl, fileName, totalPage, recognitionListener);
        }
    }

    private void finallyHandleResult(JSONArray handleResult, boolean isHandleAttach, JSONArray attachResult, String fileUrl, String fileName, int totalPage, IRecognitionListener recognitionListener) {
        Map<Integer, List<Object>> handleMap = handleResult.stream().collect(Collectors.groupingBy(v -> ((JSONObject)v).getInteger("pageNo")));
        Map<Object, Object> handleAttachMap = Maps.newLinkedHashMap();
        if (!isHandleAttach) {
            handleAttachMap = attachResult.stream().collect(Collectors.groupingBy(v -> ((JSONObject)v).getInteger("pageNo")));
        }
        JSONArray handleAttachArray = new JSONArray();
        for (Map.Entry<Integer, List<Object>> entry : handleMap.entrySet()) {
            int pageNo = entry.getKey();
            JSONArray invoiceArray = JSONArray.parseArray((String)JSON.toJSONString(entry.getValue()));
            logger.info("handleAttachMap:{}", (Object)handleAttachMap);
            if (!handleAttachMap.isEmpty()) {
                logger.info("\u6dfb\u52a0\u6e05\u5355\u5230\u53d1\u7968\u7ed3\u679c\u96c6\u901a\u77e5\u524d\u7aef\uff1a{}", (Object)pageNo);
                for (Map.Entry<Object, Object> attachEntry : handleAttachMap.entrySet()) {
                    int attachPageNo = (Integer)attachEntry.getKey();
                    if (pageNo == attachPageNo) {
                        invoiceArray.addAll((Collection)JSONArray.parseArray((String)JSON.toJSONString((Object)attachEntry.getValue())));
                        continue;
                    }
                    handleAttachArray.addAll((Collection)JSONArray.parseArray((String)JSON.toJSONString((Object)attachEntry.getValue())));
                }
            }
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            RecognitionListenerResult listener = new RecognitionListenerResult(fileUrl, fileName, pageNo, totalPage, invoiceArray);
            recognitionListener.handle(listener);
        }
        if (!handleAttachArray.isEmpty()) {
            Map<Integer, List<Object>> handleAttach = handleAttachArray.stream().collect(Collectors.groupingBy(v -> ((JSONObject)v).getInteger("pageNo")));
            for (Map.Entry<Integer, List<Object>> entry : handleAttach.entrySet()) {
                int pageNo = entry.getKey();
                JSONArray attachArray = JSONArray.parseArray((String)JSON.toJSONString(entry.getValue()));
                RecognitionListenerResult listener = new RecognitionListenerResult(fileUrl, fileName, pageNo, totalPage, attachArray);
                recognitionListener.handle(listener);
            }
        }
    }

    private boolean getCheckFlag(JSONObject businessParam) {
        boolean isCheck = true;
        if (businessParam != null) {
            boolean bl = isCheck = !"1".equals(businessParam.getString("notCheck"));
        }
        if (!isCheck) {
            businessParam.put("errcode", (Object)"4999");
            businessParam.put("description", (Object)CheckContant.getCheckResultDesc("4999"));
        }
        return isCheck;
    }
}

