/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceResourceEnum;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.checknew.CheckFactory;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;

public class SimplyCheckService {
    private static Log logger = LogFactory.getLog(SimplyCheckService.class);
    private static final String AWSCHECKSERIVCESTR = "kd.imc.rim.common.invoice.checknew.impl.AwsCheckService";
    private static final String LQCHECKSERIVCESTR = "kd.imc.rim.common.invoice.checknew.impl.LqCheckService";

    public static CheckResult checkInvoiceAndSave(CheckParam checkParam, Long orgId, String taxNo, Map<String, Object> busiParams) {
        String checkImplStr = RimConfigUtils.getConfig("rim_recog_check", "cimpl");
        CheckResult checkResult = SimplyCheckService.checkInvoice(checkImplStr, checkParam, orgId, taxNo);
        if ("0000".equals(checkResult.getErrcode())) {
            InvoiceSaveService service;
            Object invoiceEntity = checkResult.getData();
            String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
            JSONObject invoiceJson = JSON.parseObject((String)invoiceCheckStr);
            String checkStatus = invoiceJson.getString("checkStatus");
            if (StringUtils.isEmpty((String)checkStatus)) {
                invoiceJson.put("checkStatus", (Object)"1");
            }
            ConvertFieldUtil.getStandardInvoice(invoiceJson);
            invoiceJson.put("resource", (Object)InvoiceResourceEnum.fpzs_scanner);
            invoiceJson.put("collect_type", (Object)CollectTypeEnum.PC_SCAN_GUN.getCode());
            if (busiParams != null) {
                invoiceJson.putAll(busiParams);
            }
            if ((service = InvoiceSaveService.newInstance(invoiceJson.getString("invoiceType"))) != null) {
                String verifySaveFlag = RimConfigUtils.getConfig("verify_save");
                if ("0".equals(verifySaveFlag)) {
                    invoiceJson.put("delete", (Object)"2");
                }
                InvoiceSaveResult result = service.save(invoiceJson);
                String isSaleListInvoice = invoiceJson.getString("isSaleListInvoice");
                if ("1".equals(isSaleListInvoice)) {
                    RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                    recognitionCheckHelper.dealInvoiceAttachRelation(invoiceJson);
                }
                invoiceJson.put("serialNo", (Object)result.getSerialNo());
                invoiceJson.put("invoice_info", (Object)result.getInvoiceInfo());
                invoiceJson.put("mainId", result.getMainId());
                invoiceJson.put("invoiceId", result.getInvoiceId());
            }
            checkResult.setData(invoiceJson);
        }
        return checkResult;
    }

    public static CheckResult checkInvoice(CheckParam checkParam, Long orgId, String taxNo) {
        String checkImplStr = RimConfigUtils.getConfig("rim_recog_check", "cimpl");
        return SimplyCheckService.checkInvoice(checkImplStr, checkParam, orgId, taxNo);
    }

    public static CheckResult checkInvoice(String checkImplStr, CheckParam checkParam, Long orgId, String taxNo) {
        long startTime = System.currentTimeMillis();
        CheckResult checkResult = SimplyCheckService.validateCheckParam(checkParam);
        if (StringUtils.isNotEmpty((String)checkResult.getErrcode())) {
            return checkResult;
        }
        try {
            boolean isAwsCheck;
            if (checkParam.getCacheDate() == 0) {
                String checkdate = RimConfigUtils.getConfig("checkdate");
                if (StringUtils.isNotEmpty((String)checkdate)) {
                    checkParam.setCacheDate(Integer.parseInt(checkdate));
                } else {
                    checkParam.setCacheDate(7);
                }
            }
            boolean bl = isAwsCheck = StringUtils.isEmpty((String)checkImplStr) || AWSCHECKSERIVCESTR.equals(checkImplStr);
            if (orgId == null || orgId == 0L) {
                orgId = RequestContext.get().getOrgId();
            }
            if (StringUtils.isEmpty((String)taxNo)) {
                taxNo = TenantUtils.getTaxNoByOrgId(orgId);
            }
            HashMap extMap = Maps.newHashMap();
            extMap.put("orgId", orgId);
            extMap.put("taxNo", taxNo);
            extMap.put("eid", RequestContext.get().getUserId());
            checkParam.setExtMap(extMap);
            String checkType = TenantUtils.getCheckTypeByTaxNo(taxNo);
            boolean isLqCheck = false;
            if ("2".equals(checkType) || LQCHECKSERIVCESTR.equals(checkImplStr)) {
                isLqCheck = true;
                checkResult = CheckFactory.getLqCheckService().checkInvoice(checkParam);
            }
            if (isLqCheck && "04".equals(checkResult.getErrcode()) || "1".equals(checkType)) {
                checkResult = CheckFactory.getCheckService(checkImplStr).checkInvoice(checkParam);
            }
            if ("0000".equals(checkResult.getErrcode()) && checkResult.getData() != null) {
                Object invoiceEntity = checkResult.getData();
                String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                JSONObject invoiceCheckInfo = JSON.parseObject((String)invoiceCheckStr);
                if (isLqCheck) {
                    invoiceCheckInfo.put("serialNo", (Object)UUID.randomUUID());
                }
                Long invoiceType = invoiceCheckInfo.getLong("invoiceType");
                if (InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) && !isAwsCheck && !checkResult.isLeqi()) {
                    SimplyCheckService.convertRollItems(invoiceCheckInfo);
                }
                if (InvoiceConvertUtils.isSaleListInvoiceType(invoiceType)) {
                    RecognitionCheckHelper.markSaleListByCheckResult(invoiceCheckInfo);
                }
                checkResult.setData(invoiceCheckInfo);
            } else {
                String errCode = checkResult.getErrcode();
                ErrorCode errorCode = CheckContant.getCustomErrorCode(errCode);
                if (errorCode != null) {
                    checkResult.setErrcode(errorCode.getCode());
                    checkResult.setDescription(errorCode.getMessage());
                } else if (!isAwsCheck) {
                    String prodErrCode = CheckContant.convertAisinoErrCode(errCode);
                    checkResult.setErrcode(prodErrCode);
                    String checkResultDesc = CheckContant.getCheckResultDesc(prodErrCode);
                    if (!StringUtils.isEmpty((String)checkResultDesc)) {
                        checkResult.setDescription(checkResultDesc);
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("\u67e5\u9a8c\u5931\u8d25\uff1a", t);
            if (t instanceof MsgException) {
                JSONObject exception = JSON.parseObject((String)t.toString());
                checkResult.setErrcode(exception.getString("errcode"));
                checkResult.setDescription(exception.getString("description"));
            }
            checkResult.setErrcode("9999");
            checkResult.setDescription(ResManager.loadKDString((String)"\u67e5\u9a8c\u63a5\u53e3\u8bf7\u6c42\u9519\u8bef", (String)"SimplyCheckService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        SimplyCheckService.saveCheckLog(checkImplStr, checkParam, checkResult, orgId, startTime, RequestContext.get().getUserId());
        return checkResult;
    }

    private static CheckResult validateCheckParam(CheckParam checkParam) {
        CheckResult checkResult = new CheckResult();
        String prodErrCode = "";
        if (checkParam == null) {
            prodErrCode = CheckContant.convertAisinoErrCode("0005");
        } else {
            boolean typeCheck;
            if (StringUtils.isEmpty((String)checkParam.getInvoiceNo())) {
                prodErrCode = CheckContant.convertAisinoErrCode("0316");
            }
            if (StringUtils.isEmpty((String)checkParam.getInvoiceDate())) {
                prodErrCode = CheckContant.convertAisinoErrCode("4008");
            }
            Long invoiceType = checkParam.getInvoiceType();
            boolean bl = typeCheck = InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType);
            if (typeCheck && checkParam.getInvoiceMoney() == null && checkParam.getTotalAmount() == null) {
                prodErrCode = CheckContant.convertAisinoErrCode("0005");
            }
        }
        if (StringUtils.isNotEmpty((String)prodErrCode)) {
            checkResult.setErrcode(prodErrCode);
            checkResult.setDescription(CheckContant.getCheckResultDesc(prodErrCode));
        }
        return checkResult;
    }

    private static void saveCheckLog(String checkImplStr, CheckParam checkParam, CheckResult checkResult, Long orgId, long startTime, String eid) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"rim_check_log");
        object.set("creater", (Object)Long.parseLong(eid));
        object.set("create_time", (Object)new Date());
        if (!StringUtils.isEmpty((String)checkImplStr)) {
            int index = checkImplStr.lastIndexOf(46);
            object.set("interface", (Object)checkImplStr.substring(index + 1));
        } else {
            object.set("interface", (Object)"AwsCheckService");
        }
        object.set("take_time", (Object)(System.currentTimeMillis() - startTime));
        object.set("invoice_code", (Object)checkParam.getInvoiceCode());
        object.set("invoice_no", (Object)checkParam.getInvoiceNo());
        object.set("errcode", (Object)checkResult.getErrcode());
        object.set("description", (Object)checkResult.getDescription());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    private static void convertRollItems(JSONObject invoiceInfo) {
        JSONArray invoiceItems = invoiceInfo.getJSONArray("items");
        if (invoiceItems != null && invoiceItems.size() > 0) {
            for (int k = 0; k < invoiceItems.size(); ++k) {
                JSONObject itemInfo = invoiceItems.getJSONObject(k);
                BigDecimal unitPrice = itemInfo.getBigDecimal("unitPrice");
                BigDecimal taxRate = itemInfo.getBigDecimal("taxRate");
                if (unitPrice == null || taxRate == null || taxRate.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal divideNum = BigDecimal.ONE.add(itemInfo.getBigDecimal("taxRate"));
                unitPrice = unitPrice.divide(divideNum, 4);
                itemInfo.put("unitPrice", (Object)unitPrice);
            }
        }
    }
}

