/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.collector.InvoiceHisDataSyncService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.task.AbstractTaskService;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.DateUtils;

public class SyncWxInvoiceTaskService
extends AbstractTaskService {
    private static Log LOGGER = LogFactory.getLog(SyncWxInvoiceTaskService.class);
    private static final int PAGE_SIZE = 200;

    @Override
    public JSONObject toTask(DynamicObject taskObject) {
        int count;
        String content = taskObject.getString("content_tag");
        JSONObject json = JSONObject.parseObject((String)content);
        for (int i = 1; i <= 20 && (count = this.syncData(json.getString("phone"), json.getDate("createTimeStart"), json.getDate("createTimeEnd"), i)) >= 200; ++i) {
        }
        return this.success(null);
    }

    private int syncData(String phone, Date startDate, Date endDate, int pageNo) {
        JSONObject param = new JSONObject();
        param.put("pageNo", (Object)pageNo);
        param.put("pageSize", (Object)200);
        param.put("userPhone", (Object)phone);
        param.put("expenseInfo", (Object)"0");
        param.put("attachmentInfoFlag", (Object)"1");
        param.put("collectTimeStart", (Object)DateUtils.format(startDate));
        param.put("collectTimeEnd", (Object)DateUtils.format(endDate));
        LOGGER.info("\u540c\u6b65\u5fae\u4fe1\u7968\u5939{}", (Object)param);
        RequestContext context = RequestContext.get();
        AwsFpyService serice = AwsFpyService.newInstance();
        JSONObject result = serice.postEncryptAppJson("syncWechatInvoices", context.getOrgId(), (Map<String, Object>)param);
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONArray data = result.getJSONArray("data");
            InvoiceHisDataSyncService.saveInvoice(context.getOrgId(), context, data, phone);
            return data.size();
        }
        if (result != null) {
            throw new MsgException(result.getString("errcode"), result.getString("description"));
        }
        return 0;
    }
}

