/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service.task;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.service.task.AbstractTaskService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.StringUtils;

public class TaskService {
    private static String reqId = null;

    public void createTask(String taskNo, String taskType, Map<String, Object> contentMap) {
        QFilter filter1 = new QFilter("taskno", "=", (Object)taskNo);
        QFilter filter2 = new QFilter("tasktype", "=", (Object)taskType);
        DeleteServiceHelper.delete((String)"rim_task", (QFilter[])new QFilter[]{filter1, filter2});
        DynamicObject taskObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_task");
        taskObject.set("taskno", (Object)taskNo);
        taskObject.set("tasktype", (Object)taskType);
        taskObject.set("status", (Object)"0");
        taskObject.set("content_tag", (Object)SerializationUtils.toJsonString(contentMap));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskObject});
    }

    public void start(int threadNo) {
        for (int thread = 0; thread < threadNo; ++thread) {
            String lockKey = "rimTaskServiceThread" + TaskService.getReqId() + thread;
            try (DLock lock = DLock.create((String)lockKey, (String)"rimTaskServiceThread");){
                if (!lock.tryLock()) continue;
                ThreadPools.executeOnceIncludeRequestContext((String)"rimTaskServiceThread", () -> {
                    int pageSize = 200;
                    boolean iscotinue = true;
                    int times = 0;
                    while (iscotinue) {
                        QFilter filter1 = new QFilter("status", "=", (Object)"0");
                        QFilter filter2 = new QFilter("createtime", ">", (Object)DateUtils.addHour(new Date(), -12));
                        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_task", (String)"id,taskno,tasktype", (QFilter[])new QFilter[]{filter1, filter2}, (String)"", (int)pageSize);
                        for (DynamicObject obj : collect) {
                            this.doTask(obj.getLong("id"));
                        }
                        if (collect.size() > 0) {
                            times = 0;
                        }
                        if (collect.size() < pageSize) {
                            ++times;
                        }
                        if (times <= 1) continue;
                        iscotinue = false;
                    }
                    String clearFlag = CacheHelper.get("rimTaskServiceThread_clear");
                    if (clearFlag == null) {
                        this.clearTask();
                    }
                });
                continue;
            }
        }
    }

    public DynamicObject queryTask(String taskNo) {
        if (StringUtils.isNotEmpty((CharSequence)taskNo)) {
            QFilter filter = new QFilter("taskno", "=", (Object)taskNo);
            DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_task", (String)"status,errormsg", (QFilter[])new QFilter[]{filter});
            return obj;
        }
        return null;
    }

    public void clearTask() {
        QFilter filter = new QFilter("createtime", "<=", (Object)DateUtils.addDay(new Date(), -1));
        DeleteServiceHelper.delete((String)"rim_task", (QFilter[])new QFilter[]{filter});
        CacheHelper.put("rimTaskServiceThread_clear", "1", 82800);
    }

    private static String getReqId() {
        if (reqId == null) {
            TaskService.setReqId();
        }
        return reqId;
    }

    private static synchronized void setReqId() {
        if (reqId == null) {
            reqId = UUID.randomUUIDZero();
        }
    }

    private void doTask(Long taskId) {
        block18: {
            String lockKey = "rimTaskService" + taskId;
            try (DLock lock = DLock.create((String)lockKey, (String)"rimTaskService");){
                if (!lock.tryLock()) break block18;
                DynamicObject taskObject = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"rim_task");
                if ("0".equals(taskObject.getString("status"))) {
                    try {
                        AbstractTaskService service = AbstractTaskService.newInstance(taskObject.getString("tasktype"));
                        taskObject.set("status", (Object)"2");
                        if (service != null) {
                            JSONObject result = service.toTask(taskObject);
                            if (ResultContant.isSuccess(result).booleanValue()) {
                                taskObject.set("status", (Object)"1");
                            } else {
                                taskObject.set("status", (Object)"2");
                            }
                        }
                    }
                    catch (Exception e) {
                        taskObject.set("errormsg", (Object)StringUtils.substring((String)e.getMessage(), (int)0, (int)100));
                    }
                    taskObject.set("traceid", (Object)RequestContext.get().getTraceId());
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskObject});
            }
        }
    }
}

