/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import kd.sdk.annotation.SdkDeprecated;

public class BigDecimalUtil {
    public static final BigDecimal ZERO = new BigDecimal(0);

    @SdkDeprecated
    public static BigDecimal transDecimal(Object val) {
        if (null == val || "".equals(val)) {
            return BigDecimal.ZERO;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        try {
            return new BigDecimal(String.valueOf(val).replaceAll(",", ""));
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    public static String format(BigDecimal val, String format) {
        if (val == null) {
            return "";
        }
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(val);
    }

    public static String format(BigDecimal val) {
        if (val == null) {
            return "";
        }
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        return decimalFormat.format(val);
    }

    public static String transToPoint(String val, int scale) {
        if (!BigDecimalUtil.isNumber(val)) {
            return "";
        }
        return new BigDecimal(val).setScale(scale, 4).toPlainString();
    }

    public static boolean isNumber(String number) {
        try {
            BigDecimal val = new BigDecimal(number);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String decimalFormat(BigDecimal value) {
        if (null != value) {
            DecimalFormat df4 = new DecimalFormat("##,##0.00");
            return df4.format(value);
        }
        return "";
    }
}

