/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.redis.JedisClientWrapper;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.redis.RedisTracker;
import kd.bos.redis.wrapper.ClusterJedisClient;
import kd.bos.redis.wrapper.CommonJedisClient;
import kd.bos.redis.wrapper.ShardedJedisClient;
import org.apache.commons.lang3.StringUtils;

public class CacheHelper {
    private static Log logger = LogFactory.getLog(CacheHelper.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("imc");
    private static LocalMemoryCache localcache = null;
    public static final String EMPTY_STR = "\u25cf\u25c6\u25a0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LocalMemoryCache getLocalMemoryCache() {
        if (localcache != null) {
            return localcache;
        }
        Class<CacheHelper> clazz = CacheHelper.class;
        synchronized (CacheHelper.class) {
            if (localcache == null) {
                CacheConfigInfo localConfig = new CacheConfigInfo();
                localConfig.setMaxItemSize(5000);
                localConfig.setTimeout(180);
                localConfig.setTimeToLive(true);
                localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("imc_region", "rim", localConfig);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return localcache;
        }
    }

    @Deprecated
    public static String getCachePrefix() {
        String fix = RequestContext.get().getTenantId() + '_' + RequestContext.get().getAccountId() + '_';
        return fix;
    }

    private static String getFullCacheKey(String cacheKey) {
        RequestContext request = RequestContext.get();
        return String.format("%s_%s_%s", request.getTenantId(), request.getAccountId(), cacheKey);
    }

    public static void put(String key, String content, int timeOut) {
        String fullCacheKey = CacheHelper.getFullCacheKey(key);
        cache.put(fullCacheKey, (Object)content, timeOut);
        CacheHelper.getLocalMemoryCache().put(fullCacheKey, (Object)content);
    }

    public static void put(String key, String content) {
        String fullCacheKey = CacheHelper.getFullCacheKey(key);
        cache.put(CacheHelper.getFullCacheKey(key), (Object)content);
        CacheHelper.getLocalMemoryCache().put(fullCacheKey, (Object)content);
    }

    public static String get(String key) {
        return CacheHelper.get(key, false);
    }

    public static String get(String key, boolean loadLocal) {
        String fullCacheKey = CacheHelper.getFullCacheKey(key);
        if (!loadLocal) {
            return (String)cache.get(fullCacheKey);
        }
        String val = (String)CacheHelper.getLocalMemoryCache().get(fullCacheKey);
        if (EMPTY_STR.equals(val)) {
            return "{}";
        }
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return val;
        }
        val = (String)cache.get(fullCacheKey);
        if (StringUtils.isBlank((CharSequence)val)) {
            CacheHelper.getLocalMemoryCache().put(fullCacheKey, (Object)EMPTY_STR);
            return val;
        }
        CacheHelper.getLocalMemoryCache().put(fullCacheKey, (Object)val);
        return val;
    }

    public static void remove(String key) {
        String fullCacheKey = CacheHelper.getFullCacheKey(key);
        cache.remove(fullCacheKey);
        CacheHelper.getLocalMemoryCache().remove(new String[]{fullCacheKey});
    }

    public static int addToSet(String key, String[] arr) {
        return cache.addToSet(CacheHelper.getFullCacheKey(key), arr);
    }

    public static long inc(String key, int timeoutSeconds) {
        return cache.inc(CacheHelper.getFullCacheKey(key), timeoutSeconds);
    }

    public static long decr(String key, int timeoutSeconds) {
        return cache.decr(CacheHelper.getFullCacheKey(key), timeoutSeconds);
    }

    public static int addToSet(String key, String[] arr, int timeOut) {
        return cache.addToSet(CacheHelper.getFullCacheKey(key), arr, timeOut);
    }

    public static String[] getSetValues(String key) {
        return cache.getSetValues(CacheHelper.getFullCacheKey(key));
    }

    public static void removeAllSetValues(String key) {
        String[] setValues = cache.getSetValues(key);
        if (setValues != null && setValues.length != 0) {
            cache.removeSetValues(key, cache.getSetValues(key));
        }
    }

    private static AutoCloseable getJedisClient(String cacheKey) {
        String className = null;
        try {
            Class<?> classType = cache.getClass();
            className = classType.getName();
            if (CacheHelper.isXCacheWhiteListCacheWrapper(className)) {
                Method chooseCache = classType.getDeclaredMethod("chooseCache", String.class);
                ReflectionUtils.makeAccessible((Method)chooseCache);
                DistributeSessionlessCache distributeSessionlessCache = (DistributeSessionlessCache)chooseCache.invoke((Object)cache, cacheKey);
                return CacheHelper.getJedisClient(distributeSessionlessCache);
            }
            return CacheHelper.getJedisClient(cache);
        }
        catch (Exception e) {
            logger.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25{},{}", (Object)className, (Object)e);
            return null;
        }
    }

    private static boolean isXCacheWhiteListCacheWrapper(String className) {
        return "kd.bos.cache.XCacheWhiteListCacheWrapper".equals(className);
    }

    private static AutoCloseable getJedisClient(DistributeSessionlessCache distributeSessionlessCache) {
        String className = null;
        try {
            Class<?> classType = distributeSessionlessCache.getClass();
            className = classType.getName();
            Class<?> superclassType = classType.getSuperclass();
            Method method = superclassType.getDeclaredMethod("getJedis", new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            Object client = method.invoke((Object)distributeSessionlessCache, new Object[0]);
            if (client instanceof JedisClientWrapper) {
                JedisClientWrapper jedisClientWrapper = (JedisClientWrapper)client;
                Class<JedisClientWrapper> jedisClientWrapperClass = JedisClientWrapper.class;
                Field field = jedisClientWrapperClass.getDeclaredField("jedis");
                ReflectionUtils.makeAccessible((Field)field);
                Object jedis = field.get(jedisClientWrapper);
                Object originalObject = RedisTracker.getOriginalObject((Object)jedis);
                if (originalObject instanceof CommonJedisClient) {
                    return (CommonJedisClient)originalObject;
                }
                if (originalObject instanceof ShardedJedisClient) {
                    return (ShardedJedisClient)originalObject;
                }
                if (originalObject instanceof ClusterJedisClient) {
                    return (ClusterJedisClient)originalObject;
                }
                logger.info("\u5ba2\u6237\u7aef\u7c7b\u578b\u9519\u8bef{}", originalObject);
            }
        }
        catch (Exception e) {
            logger.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25{},{}", (Object)className, (Object)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long lpush(String cachekey, String ... string) {
        try (AutoCloseable jedisClient = CacheHelper.getJedisClient(cachekey);){
            if (jedisClient != null) {
                cachekey = CacheHelper.getCachePrefix() + cachekey;
                if (jedisClient instanceof CommonJedisClient) {
                    Long l = ((CommonJedisClient)jedisClient).lpush(cachekey, string);
                    return l;
                }
                if (jedisClient instanceof ShardedJedisClient) {
                    Long l = ((ShardedJedisClient)jedisClient).lpush(cachekey, string);
                    return l;
                }
                if (jedisClient instanceof ClusterJedisClient) {
                    Long l = ((ClusterJedisClient)jedisClient).lpush(cachekey, string);
                    return l;
                }
                logger.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25{}", (Object)jedisClient.getClass().getName());
            } else {
                logger.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u4e3a\u7a7a");
            }
            Long l = -1L;
            return l;
        }
        catch (Exception e) {
            logger.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25" + e);
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String rpop(String cachekey) {
        try (AutoCloseable jedisClient = CacheHelper.getJedisClient(cachekey);){
            if (jedisClient == null) return null;
            cachekey = CacheHelper.getCachePrefix() + cachekey;
            if (jedisClient instanceof CommonJedisClient) {
                String string = ((CommonJedisClient)jedisClient).rpop(cachekey);
                return string;
            }
            if (jedisClient instanceof ShardedJedisClient) {
                String string = ((ShardedJedisClient)jedisClient).rpop(cachekey);
                return string;
            }
            if (!(jedisClient instanceof ClusterJedisClient)) return null;
            String string = ((ClusterJedisClient)jedisClient).rpop(cachekey);
            return string;
        }
        catch (Exception e) {
            logger.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25" + e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getLlen(String cachekey) {
        try (AutoCloseable jedisClient = CacheHelper.getJedisClient(cachekey);){
            if (jedisClient == null) return null;
            cachekey = CacheHelper.getCachePrefix() + cachekey;
            if (jedisClient instanceof CommonJedisClient) {
                Long l = ((CommonJedisClient)jedisClient).llen(cachekey);
                return l;
            }
            if (jedisClient instanceof ShardedJedisClient) {
                Long l = ((ShardedJedisClient)jedisClient).llen(cachekey);
                return l;
            }
            if (!(jedisClient instanceof ClusterJedisClient)) return null;
            Long l = ((ClusterJedisClient)jedisClient).llen(cachekey);
            return l;
        }
        catch (Exception e) {
            logger.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25" + e);
        }
        return null;
    }
}

