/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.compress.utils.Lists;

public class CommonUtils {
    private static Log LOGGER = LogFactory.getLog(CommonUtils.class);
    private static String[] DELETE_CACHE_KEYS = new String[]{"listsinvoice_", "listscaner_", "lists_his_invoice_", "lists_his_attach_"};

    public static <T> T getJsonValue(Map<String, Object> param, Class<T> clazz, String ... fieldKeys) {
        return CommonUtils.getJsonValue(param, clazz, false, fieldKeys);
    }

    public static <T> T getJsonValue(Map<String, Object> param, Class<T> clazz, boolean notBlank, String ... fieldKeys) {
        for (String fieldKey : fieldKeys) {
            Object obj = param.get(fieldKey);
            Object value = TypeUtils.castToJavaBean((Object)obj, clazz);
            if (value == null) continue;
            if (!notBlank || !String.class.equals(clazz)) {
                return (T)value;
            }
            if (!StringUtils.isNotBlank((Object)value)) continue;
            return (T)value;
        }
        return null;
    }

    public static List<String> getMultiValues(String multiValue) {
        ArrayList values = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)multiValue)) {
            String[] splits;
            for (String split : splits = multiValue.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)split)) continue;
                values.add(split);
            }
        }
        return values;
    }

    public static List<Long> getChildrenOrgIds(long orgId, boolean isContainOwn) {
        return CommonUtils.getChildrenOrgIds(orgId, isContainOwn, false);
    }

    public static List<Long> getChildrenOrgIds(Long orgId, boolean isContainOwn, boolean isFilterPermission) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdm_org", (String)"longnumber", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if (obj == null) {
            if (isContainOwn) {
                return Collections.singletonList(orgId);
            }
            return new ArrayList<Long>();
        }
        QFilter orgFilter = new QFilter("longnumber", "like", (Object)(obj.getString("longnumber") + ".%"));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])orgFilter.toArray());
        List<Long> orgIds = Stream.of(objs).map(o -> o.getLong("id")).collect(Collectors.toList());
        if (isContainOwn) {
            orgIds.add(orgId);
        }
        if (isFilterPermission) {
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
            List hasPermOrgIds = userHasPermOrgs.getHasPermOrgs();
            orgIds.retainAll(hasPermOrgIds);
        }
        return orgIds;
    }

    public static String getInvoiceCodeNoGroup(String invoiceCode, String invoiceNo) {
        if (StringUtils.isNotEmpty((CharSequence)invoiceCode)) {
            return invoiceCode + "-" + invoiceNo;
        }
        return invoiceNo;
    }

    public static Object encrypt(Object value) {
        String str;
        int length;
        if (value instanceof String && (length = (str = (String)value).length()) > 4) {
            int avg = length / 3;
            if (avg > 4) {
                avg = 4;
            }
            if (avg > 0) {
                return str.replaceAll("(.{" + avg + "}).{" + (str.length() - avg * 2) + "}(.{" + avg + "})", "$1****$2");
            }
        }
        return value;
    }

    public static boolean compareInvoiceCodeNo(JSONObject result, JSONObject param) {
        return CommonUtils.compareInvoiceCodeNo(result, param, "");
    }

    public static boolean compareInvoiceCodeNo(JSONObject result, JSONObject param, String billType) {
        if (result == null || param == null) {
            return false;
        }
        String invoiceNo1 = CommonUtils.getJsonValue((Map<String, Object>)result, String.class, "invoiceNo", "customDeclarationNo");
        String invoiceNo2 = CommonUtils.getJsonValue((Map<String, Object>)param, String.class, "invoiceNo", "customDeclarationNo");
        String invoiceDate1 = DateUtils.format(result.getDate("invoiceDate"));
        String invoiceDate2 = DateUtils.format(param.getDate("invoiceDate"));
        String invoiceCode1 = StringUtils.trimToEmpty((String)result.getString("invoiceCode"));
        String invoiceCode2 = StringUtils.trimToEmpty((String)param.getString("invoiceCode"));
        String etaxInvoiceNo2 = param.getString("etaxInvoiceNo");
        if ("2".equals(billType)) {
            return Objects.equals(invoiceCode1, invoiceCode2) && Objects.equals(invoiceNo1, invoiceNo2) && Objects.equals(invoiceDate1, invoiceDate2);
        }
        return Objects.equals(invoiceCode1, invoiceCode2) && Objects.equals(invoiceNo1, invoiceNo2) || Objects.equals(invoiceNo1, etaxInvoiceNo2);
    }

    public static String getUnitTestResult(String prefix, String cacheKey) {
        return CommonUtils.getUnitTestResult(prefix, cacheKey, null);
    }

    public static String getUnitTestResult(String prefix, String cacheKey, Map<String, Object> param) {
        block3: {
            boolean unitTest = RimConfigUtils.isUnitTest();
            if (unitTest && StringUtils.isNotEmpty((CharSequence)prefix) && StringUtils.isNotEmpty((CharSequence)cacheKey)) {
                try {
                    Class<?> clazz = Class.forName("kd.imc.rim.unittest.UnitTestResultService");
                    Method classMethod = clazz.getDeclaredMethod("getUntilTestResult", String.class, String.class, Map.class);
                    String result = (String)classMethod.invoke(clazz.newInstance(), prefix, cacheKey, param);
                    return result;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException classMethod) {
                    String result = CacheHelper.get(prefix + cacheKey);
                    if (result == null) break block3;
                    return result;
                }
            }
        }
        return null;
    }

    public static void jsonNullToEmptyString(JSONObject param, String ... fieldKeys) {
        if (param == null || ObjectUtils.isEmpty((Object[])fieldKeys)) {
            return;
        }
        for (String fieldKey : fieldKeys) {
            if (!StringUtils.isNotEmpty((CharSequence)fieldKey) || param.getString(fieldKey) != null) continue;
            param.put(fieldKey, (Object)"");
        }
    }

    public static boolean isNotSaveInvoice(JSONObject invoice) {
        if (invoice == null) {
            return true;
        }
        String mainId = invoice.getString("mainId");
        String unCheckId = invoice.getString("unCheckId");
        return StringUtils.isEmpty((CharSequence)mainId) && StringUtils.isEmpty((CharSequence)unCheckId);
    }

    public static <T> List<T> futureWait(List<Future<T>> futureList, int maxSize, int index) {
        if (!CollectionUtils.isEmpty(futureList) && maxSize > 0 && index % maxSize == 0) {
            ArrayList<T> result = new ArrayList<T>(futureList.size());
            for (Future<T> future : futureList) {
                try {
                    result.add(future.get());
                }
                catch (Exception exception) {}
            }
            futureList.clear();
            return result;
        }
        return Lists.newArrayList();
    }

    public static int getTempFileMaxTimeout() {
        String configTimeout = System.getProperty("tempfile.max.timeout");
        int timeout = 86400;
        if (StringUtils.isNotEmpty((CharSequence)configTimeout)) {
            try {
                timeout = Integer.parseInt(configTimeout);
            }
            catch (Exception var4) {
                LOGGER.error("Config for [tempfile.max.timeout] has a error value: " + configTimeout);
            }
        }
        return timeout;
    }

    public static void copyData(JSONObject tagJon, JSONObject resourceJson, String ... fieldKeys) {
        if (tagJon == null || resourceJson == null || fieldKeys == null) {
            return;
        }
        for (String fieldKey : fieldKeys) {
            Object value2;
            if (StringUtils.isEmpty((CharSequence)fieldKey) || ObjectUtils.isEmpty((Object)(value2 = resourceJson.get((Object)fieldKey)))) continue;
            tagJon.put(fieldKey, value2);
        }
    }

    public static boolean isMatchErrcodes(JSONObject json, String ... matchValues) {
        return CommonUtils.isMatchMultiValues(json, "errcode", matchValues);
    }

    public static boolean isMatchMultiValues(JSONObject json, String queryKey, String ... matchValues) {
        if (json == null || matchValues == null || StringUtils.isEmpty((CharSequence)queryKey)) {
            return false;
        }
        return Arrays.asList(matchValues).contains(json.getString(queryKey));
    }

    public static ErrorCode getCustomErrorCode(String interfaceCode, String errCode) {
        QFilter filter2;
        QFilter filter1;
        DynamicObject obj;
        if (StringUtils.isNotBlank((CharSequence)interfaceCode) && StringUtils.isNotBlank((CharSequence)errCode) && (obj = QueryServiceHelper.queryOne((String)"rim_error_code", (String)"rim_code,rim_desc", (QFilter[])new QFilter[]{filter1 = new QFilter("interface", "=", (Object)interfaceCode), filter2 = new QFilter("out_code", "=", (Object)errCode)})) != null) {
            return new ErrorCode(obj.getString("rim_code"), obj.getString("rim_desc"));
        }
        return null;
    }

    public static void deleteCache(int count) {
        block19: {
            LOGGER.info("\u5f00\u59cb\u5220\u9664\u4e34\u65f6\u7f13\u5b58");
            try (DLock dLock = DLock.create((String)"commonutils_deletecache", (String)"commonutils_deletecache");){
                if (!dLock.tryLock()) break block19;
                try {
                    if (count <= 0) {
                        count = 50000;
                    }
                    int index = 0;
                    IFormView formView = null;
                    String pageId = null;
                    HashSet<String> handlePageIds = new HashSet<String>(8);
                    HashSet<String> unHandlePageIds = new HashSet<String>(8);
                    while (index < count) {
                        ++index;
                        pageId = CacheHelper.rpop("rim_cache_list_keys");
                        if (StringUtils.isEmpty((CharSequence)pageId)) {
                            break;
                        }
                        formView = SessionManager.getCurrent().getView(pageId);
                        if (formView == null) {
                            if (!handlePageIds.add(pageId)) continue;
                            for (String deleteCacheKey : DELETE_CACHE_KEYS) {
                                CacheHelper.remove(deleteCacheKey + pageId);
                            }
                            continue;
                        }
                        if (!unHandlePageIds.add(pageId)) continue;
                        CacheHelper.lpush("rim_cache_list_keys", pageId);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u5f00\u59cb\u5220\u9664\u4e34\u65f6\u7f13\u5b58", (Throwable)e);
                }
            }
        }
    }

    public static DynamicObject loadSingle(String entityName, QFilter[] filters) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])filters);
        if (dynamicObject == null) {
            return dynamicObject;
        }
        return BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)entityName);
    }

    public static boolean dynamicObjectContainsProperty(DynamicObject dynamicObject, String propertyName) {
        if (dynamicObject == null) {
            return false;
        }
        IDataEntityProperty dp = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)propertyName);
        return dp != null;
    }

    public static BigDecimal getImportItemBalance() {
        BigDecimal maxAmount = new BigDecimal("0.06");
        String amountValue = RimConfigUtils.getConfig("import_item_balance");
        if (StringUtils.isNotEmpty((CharSequence)amountValue)) {
            try {
                maxAmount = new BigDecimal(amountValue);
            }
            catch (Exception e) {
                maxAmount = new BigDecimal("0.06");
            }
        }
        return maxAmount;
    }

    public static String getPdfUrl(JSONObject invoice) {
        return CommonUtils.getJsonValue((Map<String, Object>)invoice, String.class, true, "pdfurl", "pdfUrl");
    }

    public static String extractUrlToken(String url) {
        return CommonUtils.extractUrlToken(url, "access_token");
    }

    public static String extractUrlToken(String url, String findKey) {
        if (url == null || StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)findKey)) {
            return null;
        }
        String regex = String.format("%s=([^&]*)", findKey);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String getUrlLog(String requestUrl) {
        String token;
        if (StringUtils.isNotBlank((CharSequence)requestUrl) && StringUtils.contains((CharSequence)requestUrl, (CharSequence)"access_token=") && StringUtils.isNotBlank((CharSequence)(token = CommonUtils.extractUrlToken(requestUrl)))) {
            requestUrl = StringUtils.replace((String)requestUrl, (String)("access_token=" + token + "&"), (String)"").replace("access_token=" + token, "");
        }
        return requestUrl;
    }
}

