/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectField;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang.StringUtils;

public class InvoiceCheckUtils {
    private static final Set<String> SPECIAL_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate"}));
    private static final Set<String> GENERAL_PAPER_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TAXI_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount", "place"}));
    private static final Set<String> TRAIN_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "trainNum", "printingSequenceNo", "invoiceDate", "totalAmount", "stationGetOn", "stationGetOff"}));
    private static final Set<String> AIR_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "electronicTicketNum", "printNum", "invoiceDate", "invoiceAmount", "totalAmount", "otherTotalTaxAmount", "placeOfDeparture", "destination"}));
    private static final Set<String> QUOTA_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "totalAmount", "place"}));
    private static final Set<String> TRANSPORT_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount", "stationGetOn", "stationGetOff"}));
    private static final Set<String> ROAD_BRIDGE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TAX_PROOF_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "buyerTaxNo", "taxPaidProofNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> BOAT_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount", "stationGetOn", "stationGetOff"}));
    private static final Set<String> OTHER_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "totalAmount"}));
    public static final Set<String> HGJKS_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "customDeclarationNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TRAIN_REFUND_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "number", "totalAmount"}));
    private static final Set<String> FINANCIAL_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "totalAmount", "invoiceDate"}));
    private static final Set<String> ELECTRIC_INVOICE_MUST = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TAXI_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> TRAIN_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "trainNum", "sequenceNo", "invoiceDate", "totalAmount", "passengerName"}));
    private static final Set<String> AIR_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "electronicTicketNum", "printNum", "totalAmount", "invoiceDate", "customerName"}));
    private static final Set<String> QUOTA_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "totalAmount"}));
    private static final Set<String> TRANSPORT_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> ROAD_BRIDGE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> BOAT_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceCode", "invoiceNo", "invoiceDate", "totalAmount"}));
    private static final Set<String> HGJKS_INVOICE_MUST_INPUT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"invoiceType", "customDeclarationNo", "invoiceDate", "totalTaxAmount"}));
    public static final Set<String> EXPENSE_STATUS_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"1", "30", "60", "65", ""}));
    public static final Set<String> INVOICE_STATS_CHECK;
    public static final Set<String> ZERO_FOUR_CHECK;
    public static final Set<String> ONE_FIVE_CHECK;
    public static final Set<String> ONE_TWO_CHECK;
    public static final Set<String> ZERO_ONE_CHECK;
    public static final Set<String> ZERO_TWO_CHECK;

    public static ApiResult checkMust(JSONObject invoice, boolean isEdit) {
        return InvoiceCheckUtils.checkMust(invoice, isEdit, true);
    }

    public static ApiResult checkMust(JSONObject invoice, boolean isEdit, boolean needCheckCode) {
        String awsType = invoice.getString("invoiceType");
        if (StringUtils.isBlank((String)awsType)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e3a\u7a7a", (String)"InvoiceCheckUtils_0", (String)"imc-rim-common", (Object[])new Object[0]), (String)"2001");
        }
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsType);
        if (Arrays.asList(InputInvoiceTypeEnum.getVatTypes()).contains(invoiceType) || InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
            ApiResult result;
            InputInvoiceTypeEnum type = InputInvoiceTypeEnum.getInvoiceType(invoiceType);
            if (InputInvoiceTypeEnum.isEleInvoice(invoiceType).booleanValue()) {
                return InvoiceCheckUtils.checkHaveNull(ELECTRIC_INVOICE_MUST, invoice, ResManager.loadKDString((String)"\u6570\u7535\u53d1\u7968", (String)"InvoiceCheckUtils_1", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            if (needCheckCode && (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType)) && (result = InvoiceCheckUtils.checkHaveNull(Sets.newHashSet((Object[])new String[]{"checkCode"}), invoice, type.getName())) != null) {
                return result;
            }
            if ((InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType)) && (result = InvoiceCheckUtils.checkHaveNull(Sets.newHashSet((Object[])new String[]{"invoiceAmount"}), invoice, type.getName())) != null) {
                return result;
            }
            if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType) && (result = InvoiceCheckUtils.checkHaveNull(Sets.newHashSet((Object[])new String[]{"totalAmount"}), invoice, type.getName())) != null) {
                return result;
            }
            return InvoiceCheckUtils.checkHaveNull(SPECIAL_MUST, invoice, ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u53d1\u7968", (String)"InvoiceCheckUtils_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(GENERAL_PAPER_MUST, invoice, InputInvoiceTypeEnum.GENERAL_PAPER.getName());
        }
        if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(TAXI_INVOICE_MUST, invoice, InputInvoiceTypeEnum.TAXI_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(TAXI_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.TAXI_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(TRAIN_INVOICE_MUST, invoice, InputInvoiceTypeEnum.TRAIN_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(TRAIN_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.TRAIN_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            if (StringUtils.isEmpty((String)invoice.getString("eticketNo"))) {
                invoice.put("eticketNo", (Object)invoice.getString("electronicTicketNum"));
            }
            if (StringUtils.isEmpty((String)invoice.getString("electronicTicketNum"))) {
                invoice.put("electronicTicketNum", (Object)invoice.getString("eticketNo"));
            }
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(AIR_INVOICE_MUST, invoice, InputInvoiceTypeEnum.AIR_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(AIR_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.AIR_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(QUOTA_INVOICE_MUST, invoice, InputInvoiceTypeEnum.QUOTA_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(QUOTA_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.QUOTA_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(TRANSPORT_INVOICE_MUST, invoice, InputInvoiceTypeEnum.TRANSPORT_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(TRANSPORT_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.TRANSPORT_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceType)) {
            if (InvoiceConvertUtils.checkRoadBridgeMustInput(invoice)) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u8fc7\u8def\u8fc7\u6865\u8d39\u53d1\u7968\u4ee3\u7801\u3001\u51fa\u53e3\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"InvoiceCheckUtils_7", (String)"imc-rim-common", (Object[])new Object[0]), (String)"2001");
            }
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(ROAD_BRIDGE_MUST, invoice, InputInvoiceTypeEnum.ROAD_BRIDGE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(ROAD_BRIDGE_MUST_INPUT, invoice, InputInvoiceTypeEnum.ROAD_BRIDGE.getName());
        }
        if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(TAX_PROOF_MUST, invoice, InputInvoiceTypeEnum.TAX_PROOF.getName());
        }
        if (InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(BOAT_INVOICE_MUST, invoice, InputInvoiceTypeEnum.BOAT_INVOICE.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(BOAT_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.BOAT_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(OTHER_INVOICE_MUST, invoice, InputInvoiceTypeEnum.OTHER_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            if (StringUtils.isEmpty((String)invoice.getString("customDeclarationNo"))) {
                invoice.put("customDeclarationNo", (Object)invoice.getString("invoiceNo"));
            }
            if (StringUtils.isEmpty((String)invoice.getString("invoiceNo"))) {
                invoice.put("invoiceNo", (Object)invoice.getString("customDeclarationNo"));
            }
            if (isEdit) {
                return InvoiceCheckUtils.checkHaveNull(HGJKS_INVOICE_MUST, invoice, InputInvoiceTypeEnum.HGJKS.getName());
            }
            return InvoiceCheckUtils.checkHaveNull(HGJKS_INVOICE_MUST_INPUT, invoice, InputInvoiceTypeEnum.HGJKS.getName());
        }
        if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(FINANCIAL_INVOICE_MUST, invoice, InputInvoiceTypeEnum.FINANCIAL_INVOICE.getName());
        }
        if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(invoiceType)) {
            return InvoiceCheckUtils.checkHaveNull(TRAIN_REFUND_INVOICE_MUST, invoice, InputInvoiceTypeEnum.TRAIN_REFUND.getName());
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u5728\u6807\u51c6\u8303\u56f4", (String)"InvoiceCheckUtils_3", (String)"imc-rim-common", (Object[])new Object[0]), (String)"2002");
    }

    public static ApiResult checkHaveNull(Set<String> fields, JSONObject data, String invoiceTypeName) {
        for (String field : fields) {
            Object value = data.get((Object)field);
            if (Objects.isNull(value)) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"%1$s\u7f3a\u5c11\u5fc5\u5f55\u53c2\u6570\uff1a%2$s", (String)"InvoiceCheckUtils_4", (String)"imc-rim-common", (Object[])new Object[0]), invoiceTypeName, field), (String)"2001");
            }
            if (!(value instanceof String) || !StringUtils.isBlank((String)((String)value))) continue;
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"%1$s\u7f3a\u5c11\u5fc5\u5f55\u53c2\u6570\uff1a%2$s", (String)"InvoiceCheckUtils_4", (String)"imc-rim-common", (Object[])new Object[0]), invoiceTypeName, field), (String)"2001");
        }
        return null;
    }

    public static ApiResult checkFieldFormat(JSONObject invoice) {
        String invoiceDate = invoice.getString("invoiceDate");
        if (StringUtils.isNotBlank((String)invoiceDate)) {
            SimpleDateFormat dataFormater = new SimpleDateFormat("yyyy-MM-dd");
            try {
                dataFormater.parse(invoiceDate);
            }
            catch (ParseException e) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d1\u7968\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (String)"InvoiceCheckUtils_5", (String)"imc-rim-common", (Object[])new Object[0]), (String)"2002");
            }
        }
        try {
            List<String> amountFields = InvoiceCollectField.getAmountField();
            for (String amountField : amountFields) {
                invoice.getBigDecimal(amountField);
            }
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u91d1\u989d\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef", (String)"InvoiceCheckUtils_6", (String)"imc-rim-common", (Object[])new Object[0]), (String)"2002");
        }
        return null;
    }

    public static void enIDNum(DynamicObject invoice) {
    }

    public static void encodeIDNumber(JSONObject invoice, String key, int enlenth) {
        if (invoice == null) {
            return;
        }
        String start = "";
        String end = "";
        String middleOriginal = "";
        String customerIdNo = invoice.getString(key);
        String middle = "";
        if (StringUtils.isNotBlank((String)customerIdNo) && customerIdNo.length() >= 2) {
            if (customerIdNo.length() == 18) {
                if (enlenth == 4) {
                    start = customerIdNo.substring(0, 10);
                    end = customerIdNo.substring(14, 18);
                    middleOriginal = customerIdNo.substring(10, 14);
                    middle = "****";
                } else if (enlenth == 8) {
                    start = customerIdNo.substring(0, 6);
                    end = customerIdNo.substring(14, 18);
                    middleOriginal = customerIdNo.substring(6, 14);
                    middle = "********";
                }
            } else {
                start = customerIdNo.substring(0, customerIdNo.length() - 2);
                middleOriginal = customerIdNo.substring(customerIdNo.length() - 2);
                middle = "**";
            }
            if (!customerIdNo.contains("*")) {
                invoice.put("idNumMiddle", (Object)middleOriginal);
            }
            customerIdNo = start + middle + end;
        }
        invoice.put(key, (Object)customerIdNo);
    }

    public static JSONObject conver(JSONObject source) {
        JSONObject result = new JSONObject();
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(source.getString("invoiceType"));
        result.put("invoice_type", (Object)invoiceType);
        InvoiceCheckUtils.copyValue(source, result, "invoiceIndex", "invoiceIndex");
        InvoiceCheckUtils.copyValue(source, result, "expenseInfo", "expenseInfo");
        InvoiceCheckUtils.copyValue(source, result, "voucherInfo", "voucherInfo");
        InvoiceCheckUtils.copyValue(source, result, "tag", "tag");
        InvoiceCheckUtils.convertExpense(source, result);
        InvoiceCheckUtils.convertVouch(source, result);
        if (Arrays.asList(InputInvoiceTypeEnum.getVatTypes()).contains(invoiceType) || InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "checkCode", "check_code");
            InvoiceCheckUtils.copyValue(source, result, "invoiceAmount", "invoice_amount");
            InvoiceCheckUtils.copyValue(source, result, "invoiceStatus", "invoice_status");
            InvoiceCheckUtils.copyValue(source, result, "checkStatus", "check_status");
            InvoiceCheckUtils.copyValue(source, result, "specialTypeMark", "special_type_mark");
            InvoiceCheckUtils.copyValue(source, result, "reviewer", "reviewer");
            InvoiceCheckUtils.copyValue(source, result, "remark", "remark");
            InvoiceCheckUtils.copyValue(source, result, "drawer", "drawer");
            InvoiceCheckUtils.copyValue(source, result, "payee", "payee");
            InvoiceCheckUtils.convertItems(source, result);
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertTaxAndName(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
            InvoiceCheckUtils.convertTransportOffset(source, result);
            InvoiceCheckUtils.convertInvoiceOffset(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                InvoiceCheckUtils.converAirEleField(source, result);
            }
            if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
                InvoiceCheckUtils.converTrainEleField(source, result);
            }
            if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType)) {
                InvoiceCheckUtils.converUsedcarField(source, result);
            }
            if (InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_ELE_INVOICE.getCode().equals(invoiceType)) {
                InvoiceCheckUtils.converMotorField(source, result);
            }
            String etaxInvoiceNo = source.getString("etaxInvoiceNo");
            if (InputInvoiceTypeEnum.isExistEtaxInvoiceNo(invoiceType) && InvoiceConvertUtils.checkElectronicNo(etaxInvoiceNo)) {
                result.put("electronic_no", (Object)etaxInvoiceNo);
            }
        } else if (InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "totalTaxAmount", "total_tax_amount");
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertTaxAndName(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "timeGetOn", "time_get_on");
            InvoiceCheckUtils.copyValue(source, result, "timeGetOff", "time_get_off");
            InvoiceCheckUtils.copyValue(source, result, "mileage", "mileage");
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "trainNum", "train_num");
            InvoiceCheckUtils.copyValue(source, result, "sequenceNo", "sequence_no");
            InvoiceCheckUtils.copyValue(source, result, "travelDate", "travel_date");
            InvoiceCheckUtils.convertSeatGrade(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.converDateAndAmount(source, result);
            InvoiceCheckUtils.convertTaxAmount(source, result);
            InvoiceCheckUtils.convertStationAndPassenger(source, result);
            InvoiceCheckUtils.convertTransportOffset(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
            BigDecimal totalTaxAmount = DeductionUtils.trainTaxAmountByInvoiceDate(source.getDate("invoiceDate"), source.getBigDecimal("totalAmount"), source.getString("passengerName"), source.getString("customerIdentityNum"), source.getString("stationGetOn"), source.getString("stationGetOff"), source.getString("businessType"));
            result.put("total_tax_amount", (Object)totalTaxAmount);
            result.put("taxAmount", (Object)totalTaxAmount);
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "eticketNo", "eticket_no");
            InvoiceCheckUtils.copyValue(source, result, "printNum", "print_num");
            InvoiceCheckUtils.copyValue(source, result, "customerName", "customer_name");
            InvoiceCheckUtils.copyValue(source, result, "invoiceAmount", "invoice_amount");
            InvoiceCheckUtils.copyValue(source, result, "placeOfDeparture", "place_of_departure");
            InvoiceCheckUtils.copyValue(source, result, "destination", "destination");
            InvoiceCheckUtils.copyValue(source, result, "customerIdNo", "customer_id_no");
            InvoiceCheckUtils.convertAirOther(source, result);
            InvoiceCheckUtils.convertSeatGrade(source, result);
            InvoiceCheckUtils.converDateAndAmount(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertTransportOffset(source, result);
            InvoiceCheckUtils.convertTaxAmount(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
            BigDecimal amount = DeductionUtils.airTaxAmountByInvoiceDate(source.getDate("invoiceDate"), source.getBigDecimal("invoiceAmount"), source.getBigDecimal("fuelSurcharge"), source.getString("customerName"), source.getBigDecimal("otherTotalTaxAmount"), source.getBigDecimal("totalAmount"), source.getBigDecimal("airportConstructionFee"), source.getString("placeOfDeparture"), source.getString("destination"));
            result.put("total_tax_amount", (Object)amount);
            result.put("taxAmount", (Object)amount);
        } else if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "invoiceCode", "invoice_code");
            InvoiceCheckUtils.copyValue(source, result, "invoiceNo", "invoice_no");
            InvoiceCheckUtils.copyValue(source, result, "totalAmount", "total_amount");
            InvoiceCheckUtils.copyValue(source, result, "place", "place");
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue2(source, result, "customer_id_no", "customerIdNo", "customerIdentityNum");
            InvoiceCheckUtils.copyValue(source, result, "insurancePremium", "insurance_premium");
            InvoiceCheckUtils.convertTransportOffset(source, result);
            InvoiceCheckUtils.convertTaxAmount(source, result);
            InvoiceCheckUtils.convertStationAndPassenger(source, result);
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
            BigDecimal amount = null;
            amount = InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) ? DeductionUtils.passengerTransport16TaxAmountByInvoiceDate(source.getDate("invoiceDate"), source.getBigDecimal("totalAmount"), source.getString("passengerName"), result.getString("customer_id_no"), source.getBigDecimal("insurancePremium"), result.getString("station_get_on"), result.getString("station_get_off")) : DeductionUtils.passengerTransport20TaxAmountByInvoiceDate(source.getDate("invoiceDate"), source.getBigDecimal("totalAmount"), source.getString("passengerName"), result.getString("customer_id_no"), result.getString("station_get_on"), result.getString("station_get_off"));
            result.put("total_tax_amount", (Object)amount);
            result.put("taxAmount", (Object)amount);
        } else if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "entrance", "entrance");
            InvoiceCheckUtils.copyValue(source, result, "exit", "exit");
            InvoiceCheckUtils.copyValue(source, result, "time", "time");
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "taxPaidProofNo", "tax_paid_proof_no");
            InvoiceCheckUtils.convertBuyerTaxNo(source, result);
            InvoiceCheckUtils.converDateAndAmount(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "customDeclarationNo", "custom_declaration_no");
            InvoiceCheckUtils.copyValue(source, result, "deptName", "dept_name");
            InvoiceCheckUtils.copyValue(source, result, "effectiveTaxAmount", "effective_tax_amount");
            InvoiceCheckUtils.converDateAndAmount(source, result);
            InvoiceCheckUtils.convertInvoiceOffset(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.copyValue(source, result, "invoicingPartyCode", "invoicing_party_code");
            InvoiceCheckUtils.copyValue(source, result, "invoicingPartyName", "invoicing_party_name");
            InvoiceCheckUtils.copyValue(source, result, "payerPartyCode", "payer_party_code");
            InvoiceCheckUtils.copyValue(source, result, "payerPartyName", "payer_party_name");
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.convertOriginalState(source, result);
            InvoiceCheckUtils.convertOrg(source, result);
        } else if (!InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(invoiceType) && InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.converHead(source, result);
            InvoiceCheckUtils.copyValue2(source, result, "title", "title");
            InvoiceCheckUtils.copyValue2(source, result, "remark", "remark");
        }
        InvoiceCheckUtils.copyValue(source, result, "resource", "resource");
        InvoiceCheckUtils.converFileValue(source, result);
        InvoiceCheckUtils.converCustomFieldValue(source, result);
        return result;
    }

    private static void converUsedcarField(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue2(source, result, "buyer_phone_number", "buyerPhoneNumber");
        InvoiceCheckUtils.copyValue2(source, result, "buyer_id_no", "buyerIdNo");
        InvoiceCheckUtils.copyValue2(source, result, "buyer_address", "buyerAddress");
        InvoiceCheckUtils.copyValue2(source, result, "saler_phone_number", "salerPhoneNumber");
        InvoiceCheckUtils.copyValue2(source, result, "saler_id_no", "salerIdNo");
        InvoiceCheckUtils.copyValue2(source, result, "saler_address", "salerAddress");
        InvoiceCheckUtils.copyValue2(source, result, "license_plate_number", "licensePlateNumber");
        InvoiceCheckUtils.copyValue2(source, result, "registration_number", "registrationNumber");
        InvoiceCheckUtils.copyValue2(source, result, "vehicle_type", "vehicleType");
        InvoiceCheckUtils.copyValue2(source, result, "vehicle_identification_no", "vehicleIdentificationNo");
        InvoiceCheckUtils.copyValue2(source, result, "band_model", "bandModel");
        InvoiceCheckUtils.copyValue2(source, result, "vehicle_management_name", "vehicleManagementName");
        InvoiceCheckUtils.copyValue2(source, result, "auction_name", "auctionName");
        InvoiceCheckUtils.copyValue2(source, result, "auction_phone_number", "auctionPhoneNumber");
        InvoiceCheckUtils.copyValue2(source, result, "auction_address", "auctionAddress");
        InvoiceCheckUtils.copyValue2(source, result, "auction_taxpayer_id", "auctionTaxpayerId");
        InvoiceCheckUtils.copyValue2(source, result, "auction_bank_accout", "auctionBankAccout");
        InvoiceCheckUtils.copyValue2(source, result, "market_name", "marketName");
        InvoiceCheckUtils.copyValue2(source, result, "market_phone_number", "marketPhoneNumber");
        InvoiceCheckUtils.copyValue2(source, result, "market_taxpayer_id", "marketTaxpayerId");
        InvoiceCheckUtils.copyValue2(source, result, "market_address", "marketAddress");
        InvoiceCheckUtils.copyValue2(source, result, "market_bank_accout", "marketBankAccout");
        InvoiceCheckUtils.copyValue2(source, result, "remark", "remark");
        InvoiceCheckUtils.copyValue2(source, result, "drawer", "drawer");
        InvoiceCheckUtils.copyValue2(source, result, "machine_no", "machineNo");
    }

    private static void converMotorField(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue2(source, result, "buyer_cardno", "buyerCardno");
        InvoiceCheckUtils.copyValue2(source, result, "saler_account", "salerAccount");
        InvoiceCheckUtils.copyValue2(source, result, "saler_phone", "salerPhone");
        InvoiceCheckUtils.copyValue2(source, result, "saler_address", "salerAddress");
        InvoiceCheckUtils.copyValue2(source, result, "saler_bank_name", "salerBankName");
        InvoiceCheckUtils.copyValue2(source, result, "vehicle_type", "vehicleType");
        InvoiceCheckUtils.copyValue2(source, result, "brand_model", "brandModel");
        InvoiceCheckUtils.copyValue2(source, result, "producing_area", "producingArea");
        InvoiceCheckUtils.copyValue2(source, result, "machine_no", "machineNo");
        InvoiceCheckUtils.copyValue2(source, result, "original_invoice_no", "originalInvoiceNo");
        InvoiceCheckUtils.copyValue2(source, result, "certificate_num", "certificateNum");
        InvoiceCheckUtils.copyValue2(source, result, "import_certificate", "importCertificate");
        InvoiceCheckUtils.copyValue2(source, result, "commodity_inspection_num", "commodityInspectionNum");
        InvoiceCheckUtils.copyValue2(source, result, "engine_num", "engineNum");
        InvoiceCheckUtils.copyValue2(source, result, "vehicle_identification_code", "vehicleIdentificationCode");
        InvoiceCheckUtils.copyValue2(source, result, "over_tax_code", "overTaxCode");
        InvoiceCheckUtils.copyValue2(source, result, "tax_authority_code", "taxAuthorityCode");
        InvoiceCheckUtils.copyValue2(source, result, "tax_authority_name", "taxAuthorityName");
        InvoiceCheckUtils.copyValue2(source, result, "tax_rate", "taxRate");
        InvoiceCheckUtils.copyValue2(source, result, "total_ton", "totalTon");
        InvoiceCheckUtils.copyValue2(source, result, "limite_people", "limitePeople");
        InvoiceCheckUtils.copyValue2(source, result, "proxy_mark", "proxyMark");
        InvoiceCheckUtils.copyValue2(source, result, "drawer", "drawer");
        InvoiceCheckUtils.copyValue2(source, result, "type", "type");
        InvoiceCheckUtils.copyValue2(source, result, "goods_code", "goodsCode");
        InvoiceCheckUtils.copyValue2(source, result, "recipient", "recipient");
        InvoiceCheckUtils.copyValue2(source, result, "preferential_policy", "preferentialPolicy");
        InvoiceCheckUtils.copyValue2(source, result, "zerotaxrate_flag", "zeroTaxRateFlag");
    }

    private static void converCustomFieldValue(JSONObject source, JSONObject result) {
        String cusFields = RimConfigUtils.getConfig("rim_invoice_import", "cus_fields");
        if (!StringUtils.isEmpty((String)cusFields)) {
            String[] fields;
            JSONObject customMap = new JSONObject();
            for (String field : fields = cusFields.split(",")) {
                Object val = source.get((Object)field);
                if (val == null) continue;
                customMap.put(field, source.get((Object)field));
            }
            if (!customMap.isEmpty()) {
                result.put("CustomFieldValue", (Object)customMap);
            }
        }
    }

    private static void converTrainEleField(JSONObject source, JSONObject result) {
        result.put("id_number", source.get((Object)"customerIdentityNum"));
        result.put("seller_deposit_bank_acc", source.get((Object)"sellerDepositBankAndAccountNum"));
        result.put("seller_addr_phone_num", source.get((Object)"sellerAddressPhoneNum"));
        result.put("seller_unif_soc_cre_code", source.get((Object)"sellerUnifiedSocialCreditCode"));
        result.put("seller_name", source.get((Object)"sellerName"));
        result.put("purc_deposit_bank_acc", source.get((Object)"purchaserDepositBankAccNum"));
        result.put("purchaser_addr_phone_num", source.get((Object)"purchaserAddressPhoneNum"));
        result.put("purch_unifie_soc_cre_code", source.get((Object)"purchaserUnifiedSocialCreditCode"));
        result.put("purchaser_name", source.get((Object)"purchaserName"));
        result.put("air_condi_characteristics", source.get((Object)"airConditCharacteristics"));
        result.put("seat", source.get((Object)"seatNo"));
        result.put("carriage", source.get((Object)"carriage"));
        result.put("departure_time", source.get((Object)"departureTime"));
        result.put("destin_station_phonics", source.get((Object)"destinationStationPhonics"));
        result.put("departure_station_phonics", source.get((Object)"departureStationPhonics"));
        result.put("original_invoice_no", source.get((Object)"originalInvoiceNo"));
        result.put("ele_ticket_number", source.get((Object)"eleTicketNumber"));
        InvoiceCheckUtils.copyValue2(source, result, "tax_amount", "totalTaxAmount", "taxAmount");
        InvoiceCheckUtils.copyValue2(source, result, "tax_rate", "taxRate");
        InvoiceCheckUtils.copyValue2(source, result, "passenger_name", "passengerName");
        InvoiceCheckUtils.copyValue2(source, result, "detail_amount", "invoiceAmount");
        InvoiceCheckUtils.copyValue2(source, result, "seat_level", "seatLevel", "seat", "seatgrade");
        InvoiceCheckUtils.copyValue2(source, result, "invoice_date", "invoiceDate", "issueDate");
        InvoiceCheckUtils.copyValue2(source, result, "issue_date", "issueDate", "invoiceDate");
        InvoiceCheckUtils.copyValue2(source, result, "business_type", "businessType", "typeOfBusiness");
        InvoiceCheckUtils.copyValue2(source, result, "departure_station", "departureStation", "stationGetOn");
        InvoiceCheckUtils.copyValue2(source, result, "destination_station", "destinationStation", "stationGetOff");
        InvoiceCheckUtils.copyValue2(source, result, "train_num", "trainNum");
        InvoiceCheckUtils.copyValue2(source, result, "travel_date", "trainTime", "carrierDate");
        InvoiceCheckUtils.copyValue2(source, result, "id_number", "idNumber", "customerIdentityNum");
        InvoiceCheckUtils.copyValue2(source, result, "purch_unifie_soc_cre_code", "buyerTaxNo");
        InvoiceCheckUtils.copyValue2(source, result, "buyer_tax_no", "buyerTaxNo");
        InvoiceCheckUtils.copyValue2(source, result, "purchaser_name", "buyerName");
        InvoiceCheckUtils.copyValue2(source, result, "buyer_name", "buyerName");
        InvoiceCheckUtils.copyValue2(source, result, "seller_unif_soc_cre_code", "salerTaxNo");
        InvoiceCheckUtils.copyValue2(source, result, "saler_tax_no", "salerTaxNo");
        InvoiceCheckUtils.copyValue2(source, result, "seller_name", "salerName");
        InvoiceCheckUtils.copyValue2(source, result, "saler_name", "salerName");
    }

    private static void converAirEleField(JSONObject source, JSONObject result) {
        result.put("international_flag", source.get((Object)"internationalFlag"));
        InvoiceCheckUtils.copyValue2(source, result, "gp_order_no", "gpOrderNo", "numberOfGpOrder");
        result.put("customer_name", source.get((Object)"customerName"));
        result.put("customer_identity_num", source.get((Object)"customerIdentityNum"));
        result.put("place_of_departure", source.get((Object)"placeOfDeparture"));
        result.put("destination", source.get((Object)"destination"));
        result.put("flight_num", source.get((Object)"flightNum"));
        result.put("seat_grade", source.get((Object)"seatGrade"));
        result.put("carrier_date", source.get((Object)"carrierDate"));
        result.put("carrier", source.get((Object)"carrier"));
        result.put("air_time", source.get((Object)"airTime"));
        result.put("fare_basis", source.get((Object)"fareBasis"));
        result.put("free_bag_allowance", source.get((Object)"freeBaggageAllowance"));
        result.put("fuel_surcharge", source.get((Object)"fuelSurcharge"));
        result.put("airport_construction_fee", source.get((Object)"airportConstructionFee"));
        result.put("other_total_tax_amount", source.get((Object)"otherTotalTaxAmount"));
        result.put("electronic_ticket_num", source.get((Object)"electronicTicketNum"));
        result.put("insurance_premium", source.get((Object)"insurancePremium"));
        result.put("fillingUnit", source.get((Object)"filling_unit"));
        result.put("endorsement", source.get((Object)"endorsement"));
        result.put("ticket_price", source.get((Object)"ticketPrice"));
        result.put("verification_code", source.get((Object)"verificationCode"));
        InvoiceCheckUtils.copyValue2(source, result, "tax_rate", "taxRate");
        InvoiceCheckUtils.copyValue2(source, result, "issue_date", "issueDate", "invoiceDate");
        InvoiceCheckUtils.copyValue2(source, result, "invoice_date", "invoiceDate", "issueDate");
        InvoiceCheckUtils.copyValue2(source, result, "tax_amount", "totalTaxAmount", "taxAmount");
        InvoiceCheckUtils.copyValue2(source, result, "pur_unified_cre_code", "unifiedSocialCreditCodeOfPurchaser", "buyerTaxNo", "purUnifiedCreCode");
        InvoiceCheckUtils.copyValue2(source, result, "buyer_tax_no", "unifiedSocialCreditCodeOfPurchaser", "buyerTaxNo", "purUnifiedCreCode");
        InvoiceCheckUtils.copyValue2(source, result, "purchaser_name", "buyerName", "purchaserName");
        InvoiceCheckUtils.copyValue2(source, result, "seller_name", "salerName");
        InvoiceCheckUtils.copyValue2(source, result, "saler_name", "salerName");
        InvoiceCheckUtils.copyValue2(source, result, "carrier_date", "carrieDate");
    }

    private static void converFileValue(JSONObject source, JSONObject result) {
        String pixel;
        String region;
        String rotationAngle;
        String pdfurl;
        String snapshotUrl = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "snapshotUrl", "imageUrl");
        if (StringUtils.isNotEmpty((String)snapshotUrl)) {
            result.put("snapshot_url", (Object)snapshotUrl);
            result.put("original_type", (Object)"2");
        }
        if (StringUtils.isNotEmpty((String)(pdfurl = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "pdfurl", "pdfUrl")))) {
            result.put("pdf_url", (Object)pdfurl);
            result.put("original_type", (Object)"1");
        }
        String downloadUrl = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "downloadUrl");
        String fileName = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "fileName");
        result.put("original_filename", (Object)fileName);
        String fileType = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "fileType");
        if (StringUtils.isNotEmpty((String)downloadUrl)) {
            if ("4".equals(fileType) || "ofd".equalsIgnoreCase(fileType)) {
                result.put("original_type", (Object)"4");
                result.put("ofd_url", (Object)downloadUrl);
            }
            if ("1".equals(fileType) || "pdf".equalsIgnoreCase(fileType)) {
                result.put("original_type", (Object)"1");
                result.put("pdf_url", (Object)downloadUrl);
            }
            if ("2".equals(fileType) || FileUtils.isImage(fileType)) {
                result.put("original_type", (Object)"2");
                result.put("image_url", (Object)downloadUrl);
                if (StringUtils.isEmpty((String)snapshotUrl)) {
                    result.put("snapshot_url", (Object)downloadUrl);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(rotationAngle = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "rotationAngle")))) {
            result.put("rotation_angle", (Object)BigDecimalUtil.transDecimal(rotationAngle));
        }
        if (StringUtils.isNotEmpty((String)(region = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "region")))) {
            result.put("region", (Object)region);
        }
        if (StringUtils.isNotEmpty((String)(pixel = CommonUtils.getJsonValue((Map<String, Object>)source, String.class, "pixel")))) {
            result.put("pixel", (Object)pixel);
        }
    }

    private static void converHead(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "invoiceCode", "invoice_code");
        InvoiceCheckUtils.copyValue(source, result, "invoiceNo", "invoice_no");
        InvoiceCheckUtils.converDateAndAmount(source, result);
    }

    private static void converDateAndAmount(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "totalAmount", "total_amount");
        InvoiceCheckUtils.copyValue(source, result, "invoiceDate", "invoice_date");
    }

    private static void convertOriginalState(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "originalState", "original_state");
    }

    private static void convertSeatGrade(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "seatGrade", "seat_grade");
    }

    private static void convertTaxAndName(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "salerName", "saler_name");
        InvoiceCheckUtils.copyValue(source, result, "salerTaxNo", "saler_tax_no");
        InvoiceCheckUtils.copyValue(source, result, "buyerName", "buyer_name");
        InvoiceCheckUtils.convertBuyerTaxNo(source, result);
    }

    private static void convertBuyerTaxNo(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "buyerTaxNo", "buyer_tax_no");
    }

    private static void convertOrg(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "resource", "resource");
        InvoiceCheckUtils.copyValue(source, result, "org", "org");
        InvoiceCheckUtils.copyValue(source, result, "tax_org", "tax_org");
    }

    private static void convertAirOther(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "airportConstructionFee", "airport_construction_fee");
        InvoiceCheckUtils.copyValue(source, result, "fuelSurcharge", "fuel_surcharge");
        InvoiceCheckUtils.copyValue(source, result, "insurancePremium", "insurance_premium");
    }

    private static void convertTransportOffset(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "transportDeduction", "transport_deduction");
        InvoiceCheckUtils.copyValue(source, result, "effectiveTaxAmount", "effective_tax_amount");
    }

    private static void convertStationAndPassenger(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "stationGetOn", "station_get_on");
        InvoiceCheckUtils.copyValue(source, result, "stationGetOff", "station_get_off");
        InvoiceCheckUtils.copyValue(source, result, "passengerName", "passenger_name");
    }

    private static void convertInvoiceOffset(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "deductionFlag", "deduction_flag");
        InvoiceCheckUtils.copyValue(source, result, "deductionPurpose", "deduction_purpose");
        InvoiceCheckUtils.copyValue(source, result, "notDeductibleType", "not_deductible_type");
        InvoiceCheckUtils.copyValue(source, result, "authenticateTlag", "authenticate_flag");
        InvoiceCheckUtils.copyValue(source, result, "authenticateFlag", "authenticate_flag");
        InvoiceCheckUtils.copyValue(source, result, "selectTime", "select_time");
        InvoiceCheckUtils.copyValue(source, result, "authenticateTime", "authenticate_time");
        InvoiceCheckUtils.convertTaxAmount(source, result);
    }

    private static void convertTaxAmount(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "totalTaxAmount", "total_tax_amount");
        InvoiceCheckUtils.copyValue(source, result, "taxPeriod", "tax_period");
    }

    private static void convertItems(JSONObject source, JSONObject result) {
        JSONArray oldItems = source.getJSONArray("items");
        JSONArray newItems = new JSONArray();
        result.put("needClear", (Object)Boolean.TRUE);
        if (oldItems != null && !oldItems.isEmpty()) {
            result.put("items", (Object)newItems);
            for (int i = 0; i < oldItems.size(); ++i) {
                JSONObject oldItem = oldItems.getJSONObject(i);
                JSONObject newItem = new JSONObject();
                newItems.add((Object)newItem);
                InvoiceCheckUtils.copyValue(oldItem, newItem, "goodsName", "goods_name");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "specModel", "spec_model");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "unit", "unit");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "num", "num");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "unitPrice", "unit_price");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "detailAmount", "detail_amount");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "taxRate", "tax_rate");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "taxAmount", "tax_amount");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "goodsCode", "goods_code");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "vehPlate", "veh_plate");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "startDate", "start_date");
                InvoiceCheckUtils.copyValue(oldItem, newItem, "endDate", "end_date");
            }
        }
    }

    private static void convertExpense(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "expense_num", "expense_num");
        InvoiceCheckUtils.copyValue(source, result, "expense_status", "expense_status");
    }

    private static void convertVouch(JSONObject source, JSONObject result) {
        InvoiceCheckUtils.copyValue(source, result, "account_date", "account_date");
        InvoiceCheckUtils.copyValue(source, result, "vouch_no", "vouch_no");
    }

    @Deprecated
    private static void copyValue(JSONObject source, JSONObject result, String sourceKey, String resultKey) {
        Object sourceValue = source.get((Object)sourceKey);
        if (!Objects.isNull(sourceValue)) {
            if (sourceValue instanceof String) {
                sourceValue = ((String)sourceValue).trim();
            }
            result.put(resultKey, sourceValue);
        }
    }

    private static void copyValue2(JSONObject source, JSONObject result, String resultKey, String ... sourceKeys) {
        for (String sourceKey : sourceKeys) {
            Object sourceValue = source.get((Object)sourceKey);
            if (Objects.isNull(sourceValue)) continue;
            if (sourceValue instanceof String) {
                sourceValue = ((String)sourceValue).trim();
            }
            result.put(resultKey, sourceValue);
        }
    }

    public static String getBillNo(JSONObject invoiceJson) {
        if (invoiceJson == null) {
            return "";
        }
        String invoiceCode = invoiceJson.getString("invoiceCode");
        String billno = StringUtils.isNotBlank((String)invoiceCode) ? invoiceCode + "-" + invoiceJson.getString("invoiceNo") : invoiceJson.getString("invoiceNo");
        if (billno != null && billno.length() > 36) {
            billno = billno.substring(0, 36);
        }
        return billno;
    }

    static {
        ZERO_FOUR_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"0", "1", "2", "3", "4", ""}));
        ONE_FIVE_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5", ""}));
        ONE_TWO_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"1", "2", ""}));
        ZERO_ONE_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"1", "0", ""}));
        ZERO_TWO_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"0", "1", "2", ""}));
        INVOICE_STATS_CHECK = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"0", "1", "2", "3", "8", "7", "6", "4", ""}));
    }
}

