/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ListUtils;

public class ListUtils {
    public static <T> List<List<T>> splitList(List<T> list, int len) {
        if (list == null || list.size() == 0 || len < 1) {
            return null;
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>(list.size());
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List<T> subList = list.subList(i * len, Math.min((i + 1) * len, size));
            result.add(subList);
        }
        return result;
    }

    public static List<Long> parseLongList(Object[] objs) {
        ArrayList<Long> result = new ArrayList<Long>(objs.length);
        for (Object obj : objs) {
            result.add(BigDecimalUtil.transDecimal(obj).longValue());
        }
        return result;
    }

    public static List<Long> parseLongList(JSONArray array) {
        if (array == null) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> result = new ArrayList<Long>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            result.add(BigDecimalUtil.transDecimal(array.get(i)).longValue());
        }
        return result;
    }

    public static <T> List<T> parseList(JSONArray array, Class<T> clazz) {
        if (array == null) {
            return new ArrayList(0);
        }
        return array.toJavaList(clazz);
    }

    public static JSONArray subJSONArray(JSONArray param, int index, int max) {
        JSONArray result = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)param)) {
            for (int i = index; i < param.size() && i != max; ++i) {
                result.add(param.get(i));
            }
        }
        return result;
    }

    public static <T> List<T> checkRepeat(List<T> list) {
        return list.stream().collect(Collectors.toMap(e -> e, e -> 1, (a, b) -> a + b)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> entry.getKey()).collect(Collectors.toList());
    }

    public static Map<String, List<JSONObject>> splitListToMonth(List<JSONObject> list, String fieldKey) {
        if (CollectionUtils.isEmpty(list) || StringUtils.isEmpty((CharSequence)fieldKey)) {
            return null;
        }
        List collect = list.stream().sorted(Comparator.comparing(t -> t.getDate(fieldKey), Comparator.nullsLast(Date::compareTo))).collect(Collectors.toList());
        return ListUtils.groupBy(collect, row -> row.getDate(fieldKey) != null ? DateUtils.format(row.getDate(fieldKey), "yyyyMM") : null);
    }

    public static <K, V> Map<K, List<V>> groupBy(List<V> list, GroupBy<K, V> groupBy) {
        return ListUtils.groupBy(list, groupBy);
    }

    public static <K, V> Map<K, List<V>> groupBy(Collection<V> list, GroupBy<K, V> groupBy) {
        LinkedHashMap resultMap = new LinkedHashMap();
        for (V e : list) {
            Object k = groupBy.groupBy(e);
            if (resultMap.containsKey(k)) {
                ((List)resultMap.get(k)).add(e);
                continue;
            }
            LinkedList<V> tmp = new LinkedList<V>();
            tmp.add(e);
            resultMap.put(k, tmp);
        }
        return resultMap;
    }
}

