/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.utils.StringUtils;

public class StringRegUtils {
    private static final String[] REGS = new String[]{"\uff01", "\uff0c", "\u3002", "\uff1b", "\uff1a", "!", ",", ".", ";", ":"};
    public static final List<String> END_CHAR_LIST = Stream.of(";", "\r", "\n", "&lt", "<", " ", ".", "\u4ee3\u5f00\u4f01\u4e1a").collect(Collectors.toList());

    public static String chineseCharToEnglishChar(String str) {
        for (int i = 0; i < REGS.length / 2; ++i) {
            str = str.replaceAll(REGS[i], REGS[i + REGS.length / 2]);
        }
        return str;
    }

    public static String filterChar(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return str.replaceAll(";", "").replaceAll("<br/>", "").replaceAll("&lt", "").replaceAll("br/", "").replaceAll("&gt", "").trim();
    }

    public static String filterAllChar(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return str.replaceAll(";", "").replaceAll("<br/>", "").replaceAll("&lt", "").replaceAll("br/", "").replaceAll("&gt", "").replaceAll(":", "").trim();
    }

    public static String getEndSeparator(String str) {
        if (StringUtils.contains((CharSequence)str, (CharSequence)";")) {
            return ";";
        }
        if (StringUtils.contains((CharSequence)str, (CharSequence)"\r")) {
            return "\r";
        }
        if (StringUtils.contains((CharSequence)str, (CharSequence)"\n")) {
            return "\r";
        }
        if (StringUtils.contains((CharSequence)str, (CharSequence)"&lt")) {
            return "&lt";
        }
        if (StringUtils.contains((CharSequence)str, (CharSequence)" ")) {
            return " ";
        }
        if (StringUtils.contains((CharSequence)str, (CharSequence)"<")) {
            return "<";
        }
        if (StringUtils.contains((CharSequence)str, (CharSequence)" ")) {
            return " ";
        }
        return null;
    }

    public static int getEndIndex(String str) {
        List indexList = END_CHAR_LIST.stream().map(c -> StringUtils.indexOfIgnoreCase((CharSequence)str, (CharSequence)c)).filter(i -> i > -1).collect(Collectors.toList());
        if (indexList.isEmpty()) {
            return str.length();
        }
        return (Integer)Collections.min(indexList);
    }
}

