/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils.itextpdf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.FormFileEntity;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.pdfanalysis.PdfAnalysisService;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;

public class ItextPdfUtils {
    private static Log logger = LogFactory.getLog(ItextPdfUtils.class);
    private static String id = DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss");

    /*
     * Unable to fully structure code
     */
    public static FormFileEntity extractpdf(String fileUrl, String fileName, byte[] fileByte) throws IOException {
        ItextPdfUtils.logger.info("pdf\u5904\u7406{},{}", (Object)ItextPdfUtils.id, (Object)fileName);
        formFileEntity = new FormFileEntity(fileUrl, fileName);
        formFileEntity.setFileByte(fileByte);
        fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl), fileByte);
        var5_5 = null;
        try {
            block92: {
                block93: {
                    block89: {
                        block90: {
                            block91: {
                                block95: {
                                    block86: {
                                        block87: {
                                            block88: {
                                                block83: {
                                                    block84: {
                                                        block85: {
                                                            streamByte = FileUtils.getByte(fileInputStream);
                                                            if (streamByte == null || streamByte.length == 0) {
                                                                formFileEntity.setSuccess(Boolean.FALSE);
                                                                formFileEntity.setMessage("");
                                                                var7_9 = formFileEntity;
                                                                return var7_9;
                                                            }
                                                            fileHash = FileConvertUtils.getSHA256((byte[])streamByte);
                                                            cacheResult = ItextPdfUtils.getSplitResultCache(fileHash);
                                                            if (cacheResult != null) {
                                                                ItextPdfUtils.setOriginalStateDefault(streamByte, cacheResult);
                                                                var9_13 = cacheResult;
                                                                return var9_13;
                                                            }
                                                            formFileEntity.setFileHash(fileHash);
                                                            formFileEntity.setFileSize(streamByte.length);
                                                            document = PDDocument.load((byte[])streamByte);
                                                            var10_18 = null;
                                                            startTime = System.currentTimeMillis();
                                                            numberOfPages = document.getNumberOfPages();
                                                            if (numberOfPages != 0) break block83;
                                                            var14_22 = null;
                                                            if (document == null) break block84;
                                                            if (var10_18 == null) break block85;
                                                            try {
                                                                document.close();
                                                            }
                                                            catch (Throwable var15_24) {
                                                                var10_18.addSuppressed(var15_24);
                                                            }
                                                            break block84;
                                                        }
                                                        document.close();
                                                    }
                                                    return var14_22;
                                                }
                                                length = streamByte.length;
                                                signatureFlag = false;
                                                invoice = null;
                                                if (length >= 0x1400000) ** GOTO lbl96
                                                isMore = false;
                                                if (numberOfPages > 1) {
                                                    isMore = true;
                                                }
                                                if (numberOfPages > 1 || ItextPdfUtils.isAnalysis()) {
                                                    invoice = ItextPdfUtils.analysis(streamByte, isMore);
                                                }
                                                if (invoice == null) ** GOTO lbl81
                                                if (invoice.get((Object)"invoice") != null || !"2".equals(invoice.getString("type"))) break block86;
                                                formFileEntity.setFileType("pdf");
                                                formFileEntity.setFileName(fileName);
                                                formFileEntity.setFileUrl(fileUrl);
                                                var18_30 = formFileEntity;
                                                if (document == null) break block87;
                                                if (var10_18 == null) break block88;
                                                try {
                                                    document.close();
                                                }
                                                catch (Throwable var19_34) {
                                                    var10_18.addSuppressed(var19_34);
                                                }
                                                break block87;
                                            }
                                            document.close();
                                        }
                                        return var18_30;
                                    }
                                    invoiceType = 0L;
                                    if (isMore) {
                                        array = invoice.getJSONArray("invoice");
                                        if (array != null && array.size() > 0) {
                                            invoiceType = array.getJSONObject(0).getLong("invoiceType");
                                        }
                                    } else {
                                        invoiceType = invoice.getLong("invoiceType");
                                    }
                                    signatureFlag = InputInvoiceTypeEnum.isEleInvoice(invoiceType) == false;
                                    break block95;
lbl81:
                                    // 1 sources

                                    if (numberOfPages == 1) {
                                        signatureFlag = true;
                                    } else if (numberOfPages > 1) {
                                        stripper = new PDFTextStripper();
                                        stripper.setStartPage(2);
                                        stripper.setEndPage(2);
                                        textFromPage = stripper.getText(document);
                                        if (textFromPage.indexOf("\u6e05\u5355") > 1) {
                                            signatureFlag = true;
                                        } else if (textFromPage.indexOf("\u6240\u5c5e\u589e\u503c\u7a0e") > 0 && textFromPage.indexOf("\u53d1\u7968\u4ee3\u7801") > 0 && textFromPage.indexOf("\u9875") > 0 && textFromPage.indexOf("\u7b2c") > 0 && textFromPage.indexOf("\u8005\u63d0") > 0) {
                                            signatureFlag = true;
                                        } else {
                                            formFileEntity.setSecondPageText(textFromPage);
                                        }
                                    }
                                }
                                ItextPdfUtils.setOriginalStateDefault(streamByte, formFileEntity);
                                if (!signatureFlag && invoice == null) break block89;
                                formFileEntity.setFileType("pdf");
                                formFileEntity.setInvoiceInfo(invoice);
                                formFileEntity.setSignatureFlag(signatureFlag);
                                formFileEntity.setSuccess(Boolean.TRUE);
                                formFileEntity.setSecondPageText(null);
                                ItextPdfUtils.logger.info("pdf\u6587\u4ef6\u5904\u7406{}\u9875,{}kb,\u8017\u65f6{}", new Object[]{numberOfPages, length / 1024, System.currentTimeMillis() - startTime});
                                ItextPdfUtils.cacheSplitResult(fileHash, formFileEntity);
                                isMore = formFileEntity;
                                if (document == null) break block90;
                                if (var10_18 == null) break block91;
                                try {
                                    document.close();
                                }
                                catch (Throwable stripper) {
                                    var10_18.addSuppressed(stripper);
                                }
                                break block90;
                            }
                            document.close();
                        }
                        return isMore;
                    }
                    maxPdfPage = 50;
                    maxPdfPageStr = ImcConfigUtil.getValue("rim_fpzs", "maxpdfpage");
                    if (StringUtils.isNotBlank((CharSequence)maxPdfPageStr)) {
                        maxPdfPage = Integer.parseInt(maxPdfPageStr);
                    }
                    if (numberOfPages > maxPdfPage) {
                        throw new MsgException("0300", String.format(ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25,\u591a\u9875pdf\u8d85\u8fc7%1$s\u9875", (String)"ItextPdfUtils_0", (String)"imc-rim-common", (Object[])new Object[0]), new Object[]{maxPdfPage}));
                    }
                    formFileEntity.setFileType("pdf");
                    formFileEntity.setSignatureFlag(Boolean.FALSE);
                    pdfRenderer = new PDFRenderer(document);
                    dpi = ItextPdfUtils.getSplitPdfDpi();
                    for (pageIndex = 0; pageIndex < numberOfPages; ++pageIndex) {
                        bufferedImage = pdfRenderer.renderImageWithDPI(pageIndex, dpi, ImageType.RGB);
                        imageName = fileName.substring(0, fileName.lastIndexOf(46)) + '_' + pageIndex + ".jpg";
                        imageOs = new ByteArrayOutputStream();
                        var25_45 = null;
                        try {
                            ImageIO.write((RenderedImage)bufferedImage, "jpg", imageOs);
                            subUrl = FileConvertUtils.upload((byte[])imageOs.toByteArray(), (String)"jpg");
                            subformFileEntity = new FormFileEntity(subUrl, imageName);
                            subformFileEntity.setFileType("jpg");
                            subformFileEntity.setSignatureFlag(Boolean.FALSE);
                            formFileEntity.addSubFile(subformFileEntity);
                            continue;
                        }
                        catch (Throwable var26_48) {
                            var25_45 = var26_48;
                            throw var26_48;
                        }
                        finally {
                            if (imageOs != null) {
                                if (var25_45 != null) {
                                    try {
                                        imageOs.close();
                                    }
                                    catch (Throwable var26_47) {
                                        var25_45.addSuppressed(var26_47);
                                    }
                                } else {
                                    imageOs.close();
                                }
                            }
                        }
                    }
                    ItextPdfUtils.logger.info("pdf\u5207\u5272\u4e0e\u63d0\u53d6\u56fe\u7247{}\u9875,{}kb,\u8017\u65f6{}", new Object[]{numberOfPages, length / 1024, System.currentTimeMillis() - startTime});
                    ItextPdfUtils.cacheSplitResult(fileHash, formFileEntity);
                    var21_39 = formFileEntity;
                    if (document == null) break block92;
                    if (var10_18 == null) break block93;
                    try {
                        document.close();
                    }
                    catch (Throwable var22_41) {
                        var10_18.addSuppressed(var22_41);
                    }
                    break block92;
                }
                document.close();
            }
            return var21_39;
            {
                catch (Throwable var11_20) {
                    try {
                        try {
                            try {
                                var10_18 = var11_20;
                                throw var11_20;
                            }
                            catch (Throwable var30_52) {
                                if (document != null) {
                                    if (var10_18 != null) {
                                        try {
                                            document.close();
                                        }
                                        catch (Throwable var31_53) {
                                            var10_18.addSuppressed(var31_53);
                                        }
                                    } else {
                                        document.close();
                                    }
                                }
                                throw var30_52;
                            }
                        }
                        catch (MsgException e1) {
                            throw e1;
                        }
                        catch (Exception e1) {
                            formFileEntity.setFileType("pdf");
                            formFileEntity.setFileName(fileName);
                            formFileEntity.setFileUrl(fileUrl);
                            ItextPdfUtils.logger.error("\u6821\u9a8c\u6e90\u6587\u4ef6\u5f02\u5e38\u5f02\u5e38:" + e1.getMessage(), (Throwable)e1);
                        }
                    }
                    catch (Throwable var6_8) {
                        var5_5 = var6_8;
                        throw var6_8;
                    }
                    catch (Throwable var32_54) {
                        throw var32_54;
                    }
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                if (var5_5 != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable var8_11) {
                        var5_5.addSuppressed(var8_11);
                    }
                } else {
                    fileInputStream.close();
                }
            }
        }
        return formFileEntity;
    }

    private static void setOriginalStateDefault(byte[] streamByte, FormFileEntity formFileEntity) throws IOException {
        block6: {
            try {
                PdfReader reader = new PdfReader(streamByte);
                PdfTextExtractor pdfTextExtractor = new PdfTextExtractor(reader);
                String signType = RimConfigUtils.getConfig("rim_recog_check", "sign_type");
                logger.info("signType:{}", (Object)signType);
                if ("1".equals(signType)) {
                    try {
                        String textFromPage = pdfTextExtractor.getTextFromPage(1);
                        logger.info("textFromPage:{}", (Object)textFromPage);
                        if (!StringUtils.isEmpty((CharSequence)textFromPage)) {
                            formFileEntity.setOriginalStateDefault("1");
                        }
                        break block6;
                    }
                    catch (Throwable ignore) {
                        formFileEntity.setOriginalStateDefault("1");
                    }
                    break block6;
                }
                formFileEntity.setOriginalStateDefault("");
            }
            catch (Exception e) {
                formFileEntity.setOriginalStateDefault("");
            }
        }
    }

    public static JSONObject analysis(byte[] fileStreamByte, boolean more) {
        long start = System.currentTimeMillis();
        JSONObject pdfInvoice = PdfAnalysisService.analysis((byte[])fileStreamByte, (boolean)more);
        logger.info("pdf\u89e3\u6790\u7ed3\u679c\u8017\u65f6{}\uff1a{}", (Object)(System.currentTimeMillis() - start), (Object)pdfInvoice);
        if (pdfInvoice != null) {
            Object invoice = pdfInvoice.get((Object)"invoice");
            if (invoice == null) {
                if ("2".equals(pdfInvoice.getString("type"))) {
                    return pdfInvoice;
                }
                return null;
            }
            if (more) {
                List array = (List)invoice;
                JSONArray result = new JSONArray();
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject jsonObject = PdfAnalysisService.fixInvoiceInfo((JSONObject)JSONObject.parseObject((String)JSON.toJSONString(array.get(i))));
                    result.add((Object)ItextPdfUtils.putInvoiceType(jsonObject));
                }
                pdfInvoice.put("invoice", (Object)result);
            } else {
                JSONObject jsonObject = PdfAnalysisService.fixInvoiceInfo((JSONObject)JSONObject.parseObject((String)JSON.toJSONString((Object)invoice)));
                pdfInvoice = ItextPdfUtils.putInvoiceType(jsonObject);
            }
            return pdfInvoice;
        }
        return null;
    }

    private static JSONObject putInvoiceType(JSONObject invoice) {
        if (invoice != null) {
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
            invoice.put("invoiceType", (Object)invoiceType);
        }
        return invoice;
    }

    public static float getSplitPdfDpi() {
        String dipStr = RimConfigUtils.getConfig("rim_pdf_split", "dpi");
        if (!StringUtils.isEmpty((CharSequence)dipStr)) {
            float dpi = BigDecimalUtil.transDecimal(dipStr).floatValue();
            if (dpi >= 300.0f) {
                return 300.0f;
            }
            if (dpi > 1.0f) {
                return dpi;
            }
        }
        return 100.0f;
    }

    private static boolean isAnalysis() {
        String dipStr = RimConfigUtils.getConfig("rim_pdf_split", "analysis");
        return !"0".equals(dipStr);
    }

    public static void cacheSplitResult(String hash, FormFileEntity entity) {
        CacheHelper.put("split_" + hash, SerializationUtils.toJsonString((Object)entity), 3600);
    }

    public static FormFileEntity getSplitResultCache(String hash) {
        String cacheKey = "split_" + hash;
        String cache = CacheHelper.get(cacheKey);
        if (!StringUtils.isEmpty((CharSequence)cache)) {
            logger.info("\u6587\u4ef6\u7f13\u5b58key:{}", (Object)cacheKey);
            return (FormFileEntity)SerializationUtils.fromJsonString((String)cache, FormFileEntity.class);
        }
        return null;
    }
}

