/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectField;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.formplugin.collector.InvoiceCollectEditPlugin;

public class ExpenseEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(InvoiceCollectEditPlugin.class);
    private static String submitButton = "btnok";
    private static String expenseNumCombo = "expense_num";
    private static String invoiceTypeCombo = "invoice_type_combo";
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
    private ExpenseRelationService expenseRelationService = new ExpenseRelationService();

    public void registerListener(EventObject e) {
        Button submit = (Button)this.getControl(submitButton);
        submit.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String editFlag = this.getPageCache().get("editFlag");
        if (StringUtils.isEmpty((CharSequence)editFlag) || "0".equals(editFlag)) {
            this.getView().close();
        } else {
            JSONObject invoice = JSONObject.parseObject((String)this.getPageCache().get("invoice"));
            HashMap<String, String> returnData = new HashMap<String, String>(4);
            String serialNo = invoice.getString("serialNo");
            returnData.put("serialNo", serialNo);
            returnData.put("expenseNum", invoice.getString("expenseNum"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        this.getPageCache().put("editFlag", "1");
        Object newValue = null;
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas.length == 1) {
            JSONObject invoice;
            Map invoiceFieldMap;
            newValue = changeDatas[0].getNewValue();
            if (newValue instanceof Date) {
                newValue = DateUtils.format((Date)((Date)newValue), (String)"yyyy-MM-dd");
            }
            if ((invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)(invoice = JSONObject.parseObject((String)this.getPageCache().get("invoice"))).getLong("invoiceType"))).containsValue(fieldKey)) {
                for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                    if (!StringUtils.equals((CharSequence)((CharSequence)invoiceField.getValue()), (CharSequence)fieldKey)) continue;
                    if (((String)invoiceField.getKey()).contains(",")) {
                        String[] valueKeys;
                        for (String valueKey : valueKeys = ((String)invoiceField.getKey()).split(",")) {
                            invoice.put(valueKey, newValue);
                        }
                        continue;
                    }
                    invoice.put((String)invoiceField.getKey(), newValue);
                }
            }
            this.getPageCache().put("invoice", invoice.toJSONString());
        }
    }

    private void initView() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        logger.info("\u7f16\u8f91\u9884\u89c8\u754c\u9762\u53d1\u7968\u6570\u636e\u521d\u59cb\u5316\uff1a" + customParams);
        Object invoiceBody = customParams.get("invoice");
        Object editSerialNo = customParams.get("serialNo");
        JSONObject invoice = new JSONObject();
        if (invoiceBody != null) {
            invoice = JSONObject.parseObject((String)invoiceBody.toString());
        } else if (editSerialNo != null) {
            Map mainDetailMap = VerifyUtil.queryInvoiceDynamicObjectBySerialNo((String)editSerialNo.toString());
            DynamicObject mainObj = (DynamicObject)mainDetailMap.get("main");
            Long invoiceType = mainObj.getLong("invoice_type");
            InvoiceConvertService convertService = InvoiceConvertService.newInstance((Long)invoiceType, null);
            Map mainMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)mainObj);
            Map map = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)((DynamicObject)mainDetailMap.get("file")));
            Map bodyMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)((DynamicObject)mainDetailMap.get("detail")));
            InvoiceConvertService.putAll((Map)mainMap, (Map)map);
            InvoiceConvertService.putAll((Map)mainMap, (Map)bodyMap);
            invoice = convertService.convert(mainMap);
        }
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType"));
        if (this.expenseRelationService.canEdit(invoice.getString("expenseNum")).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        }
        invoice.put("invoiceType", (Object)invoiceType);
        this.getPageCache().put("invoiceInit", invoice.toJSONString());
        this.getPageCache().put("invoice", invoice.toJSONString());
        this.getModel().setValue("invoice_type_combo", (Object)invoiceType);
        Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoiceType);
        Boolean editAllowFlag = Boolean.FALSE;
        if (null != customParams.get("editAllow")) {
            editAllowFlag = (Boolean)customParams.get("editAllow");
        }
        if (invoiceFieldMap != null) {
            invoiceFieldMap.put("expenseNum", "expense_num");
            List amountField = InvoiceCollectField.getAmountField();
            for (Map.Entry entry : invoiceFieldMap.entrySet()) {
                if (null == this.getControl((String)entry.getValue())) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{(String)entry.getValue()});
                Boolean encrypt = InvoiceCollectField.encryptField((String)((String)entry.getValue()), (Boolean)editAllowFlag);
                if (((String)entry.getKey()).contains(",")) {
                    String[] valueKeys;
                    for (String valueKey : valueKeys = ((String)entry.getKey()).split(",")) {
                        String fieldValue = invoice.getString(valueKey);
                        if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                        if (amountField.contains(valueKey)) {
                            fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                        }
                        this.getModel().setValue((String)entry.getValue(), encrypt != false ? InvoiceConvertService.encrypt((Object)fieldValue) : fieldValue);
                    }
                } else {
                    String fieldValue = invoice.getString((String)entry.getKey());
                    if (StringUtils.isNotEmpty((CharSequence)fieldValue) && amountField.contains(entry.getKey())) {
                        fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                    }
                    this.getModel().setValue((String)entry.getValue(), encrypt != false ? InvoiceConvertService.encrypt((Object)fieldValue) : fieldValue);
                }
                if (editAllowFlag.booleanValue()) continue;
                this.getView().setEnable(Boolean.FALSE, new String[]{(String)entry.getValue()});
            }
            if (!editAllowFlag.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{submitButton});
                this.getView().setEnable(Boolean.FALSE, new String[]{invoiceTypeCombo});
            }
        }
        String snapshotUrl = invoice.getString("snapshotUrl");
        boolean showNoDataFlex = false;
        if (!StringUtils.isBlank((CharSequence)snapshotUrl)) {
            this.showInvoiceInfo(snapshotUrl, invoice.getString("orientation"), invoice.getString("pixel"), invoice.getString("region"));
        } else {
            String string = invoice.getString("serialNo");
            if (!StringUtils.isBlank((CharSequence)string)) {
                DynamicObject fileDynamicObject = this.invoiceCollectService.getFileBySerial(string);
                if (null != fileDynamicObject && StringUtils.isNotEmpty((CharSequence)fileDynamicObject.getString("snapshot_url"))) {
                    logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u62c9\u53d6\u5f97\u6587\u4ef6\u4fe1\u606f\u4e3a\uff1a" + fileDynamicObject);
                    String imageUrl = fileDynamicObject.getString("snapshot_url");
                    String rotateDeg = fileDynamicObject.getString("rotation_angle");
                    String region = fileDynamicObject.getString("region");
                    String pixel = fileDynamicObject.getString("pixel");
                    this.showInvoiceInfo(imageUrl, rotateDeg, pixel, region);
                    showNoDataFlex = false;
                } else {
                    showNoDataFlex = true;
                }
            }
        }
        if (showNoDataFlex) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"no_data_flex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"no_data_flex"});
        }
    }

    private void showInvoiceInfo(String url, String rotateDeg, String pixel, String region) {
        ArrayList urlList = new ArrayList();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            Map previewMap = UrlServiceUtils.getAttachmentPreviewUrlAndType((String)url);
            urlMap.putAll(previewMap);
        }
        urlMap.put("rotateDeg", rotateDeg);
        urlMap.put("pixel", pixel);
        urlMap.put("region", region);
        urlList.add(urlMap);
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        JSONObject map = new JSONObject();
        map.put("pageId", (Object)this.getView().getPageId());
        map.put("list", urlList);
        map.put("flexKey", (Object)"#invoice_flex_show");
        map.put("displayFlag", (Object)"cuteImage");
        map.put("time", (Object)System.currentTimeMillis());
        ScannerService.addCustomParam((Map)map, (String)"viewinvoice");
        customcontrol.setData((Object)map);
    }
}

