/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.invoice.collector.InvoiceMainInfoDownService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class InvoiceDownNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(InvoiceDownNewPlugin.class);
    private static ThreadPool checkAuthThreadPool = ThreadPools.newFixedThreadPool((String)"InvoiceDownNewPlugin_thread", (int)6);
    private static final String BTN_DOWN = "btn_down3";
    private static final String BTN_RESET = "btn_reset3";
    private static final String toolBarExit = "baritemap3";
    private static final String PARAM_INVOICE_START_DATE = "invoice_date_start3";
    private static final String PARAM_INVOICE_END_DATE = "invoice_date_end3";
    private static final String PERIOD_START_DATE = "period_start_date3";
    private static final String PERIOD_END_DATE = "period_end_date3";
    private static final String PARAM_INVOICE_TYPE = "invoice_type3";
    private static final String PARAM_DEDUCT_FLAG = "deduct_flag3";
    private static final String PARAM_INVOICE_STATUS = "invoice_status3";
    private static final String PARAM_BILL_TYPE = "bill_type3";
    private static final String DOWN_ORG = "org3";
    private static final String TAX_PERIOD_SET = "taxPeriodSet";
    private static final String DEDUCTION_PURPOSE = "deduction_purpose3";
    private static final String DK_TYPE = "dk_type3";
    private static final String PARAM_BILL_TYPE_ALL = "-1";
    private static final String PARAM_BILL_TYPE_0 = "0";
    private static final String PARAM_BILL_TYPE_1 = "1";
    private static final String PARAM_BILL_TYPE_2 = "2";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap3"});
        BasedataEdit base = (BasedataEdit)this.getView().getControl(DOWN_ORG);
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Label label = (Label)this.getControl("label_remark3");
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"1\u3001\u4e0b\u8f7d\u8fdb\u9879\u53d1\u7968\u8868\u5934\u4fe1\u606f\uff0c\u8be5\u529f\u80fd\u4e0d\u9650\u5236\u4e0b\u8f7d\u6b21\u6570\u3002\u4e0b\u8f7d\u7ed3\u679c\u4e0e\u7a0e\u5c40\u6570\u636e\u67091\u5c0f\u65f6\u65f6\u5dee\u3002", (String)"InvoiceDownPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0])).append("\n");
        sb.append(ResManager.loadKDString((String)"2\u3001\u7531\u4e8e\u5168\u7968\u9762\u4fe1\u606f\u9700\u8981\u901a\u8fc7\u67e5\u9a8c\u83b7\u53d6\uff0c\u5f53\u4e0b\u8f7d\u7684\u53d1\u7968\u6570\u636e\u8f83\u591a\u65f6\uff0c\u6570\u636e\u540c\u6b65\u81f3\u5168\u7968\u6c60\u53ef\u80fd\u5b58\u5728\u65f6\u5dee\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5019\uff01", (String)"InvoiceDownPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        label.setText(sb.toString());
        this.setVisibleFlex();
        this.setVisibleFlexDeductFlag();
        this.initCondition();
    }

    private void initCondition() {
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("invoice_date_field3");
        dateRangeEdit.setMinDate(DateUtils.stringToDate((String)"2017-01-01"));
        Date now = DateUtils.trunc((Date)new Date());
        dateRangeEdit.setMaxDate(now);
        Date startDate = DateUtils.getFirstDateOfMonth((Date)now);
        Date end = DateUtils.addDay((Date)now, (int)-1);
        if (DateUtils.trunc((Date)startDate).compareTo(now) == 0) {
            end = now;
        }
        this.getModel().setValue(PARAM_INVOICE_START_DATE, (Object)startDate);
        this.getModel().setValue(PARAM_INVOICE_END_DATE, (Object)end);
        this.getModel().setValue(DOWN_ORG, (Object)RequestContext.get().getOrgId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (DOWN_ORG.equals(fieldKey)) {
            this.setVisibleFlex();
        }
        if (PARAM_BILL_TYPE.equals(fieldKey) || PARAM_DEDUCT_FLAG.equals(fieldKey)) {
            this.setVisibleFlexDeductFlag();
        }
    }

    private void setVisibleFlex() {
        String taxNo = TenantUtils.getTaxNoByOrgId((Long)this.getCurrentOrgId());
        String dkType = DeductionConstant.getDkType((String)taxNo);
        this.getModel().setValue(DK_TYPE, (Object)dkType);
        List<ComboItem> comboItems = this.setDeductPurposeItem(dkType, "");
        ComboEdit editor = (ComboEdit)this.getView().getControl(DEDUCTION_PURPOSE);
        editor.setComboItems(comboItems);
    }

    private void setVisibleFlexDeductFlag() {
        String billType = (String)this.getModel().getValue(PARAM_BILL_TYPE);
        List<ComboItem> comboItems = this.setDeductPurposeItem("", billType);
        ComboEdit editor = (ComboEdit)this.getView().getControl(DEDUCTION_PURPOSE);
        editor.setComboItems(comboItems);
    }

    private List<ComboItem> setDeductPurposeItem(String dkType, String billType) {
        String deductionPurpose;
        String deductFlag;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1);
        LocaleString name1 = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"InvoiceDownNewPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        ComboItem comboItem1 = new ComboItem(name1, PARAM_BILL_TYPE_ALL);
        comboItems.add(comboItem1);
        LocaleString name2 = new LocaleString(ResManager.loadKDString((String)"\u62b5\u6263", (String)"InvoiceDownNewPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        ComboItem comboItem2 = new ComboItem(name2, PARAM_BILL_TYPE_1);
        comboItems.add(comboItem2);
        boolean hideUnDeductFlag = false;
        if (PARAM_BILL_TYPE_2.equals(billType) && PARAM_BILL_TYPE_2.equals(deductFlag = (String)this.getModel().getValue(PARAM_DEDUCT_FLAG))) {
            hideUnDeductFlag = true;
        }
        if (!hideUnDeductFlag) {
            LocaleString name3 = new LocaleString(ResManager.loadKDString((String)"\u4e0d\u62b5\u6263", (String)"InvoiceDownNewPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            ComboItem comboItem3 = new ComboItem(name3, PARAM_BILL_TYPE_2);
            comboItems.add(comboItem3);
        } else {
            deductionPurpose = (String)this.getModel().getValue(DEDUCTION_PURPOSE);
            if (PARAM_BILL_TYPE_2.equals(deductionPurpose)) {
                this.getModel().setValue(DEDUCTION_PURPOSE, (Object)PARAM_BILL_TYPE_1);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dkType) && !PARAM_BILL_TYPE_2.equals(dkType) || !PARAM_BILL_TYPE_2.equals(billType) && StringUtils.isNotBlank((CharSequence)billType)) {
            LocaleString name4 = new LocaleString(ResManager.loadKDString((String)"\u9000\u7a0e", (String)"InvoiceDownNewPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            ComboItem comboItem4 = new ComboItem(name4, "3");
            comboItems.add(comboItem4);
        } else {
            deductionPurpose = (String)this.getModel().getValue(DEDUCTION_PURPOSE);
            if ("3".equals(deductionPurpose)) {
                this.getModel().setValue(DEDUCTION_PURPOSE, (Object)PARAM_BILL_TYPE_1);
            }
        }
        return comboItems;
    }

    private void checkDkTypeOrTaxNo(String dkType) {
        if (StringUtils.isBlank((CharSequence)dkType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6536\u7968\u901a\u9053\uff0c\u8bf7\u5148\u8fdb\u884c\u914d\u7f6e", (String)"InvoiceDownNewPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_DOWN.equals(itemKey)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.BTN_DOWNLOAD, (String)BTN_DOWN);
            String billType = (String)this.getModel().getValue(PARAM_BILL_TYPE);
            String checkMsg = this.checkParam();
            if (StringUtils.isNotEmpty((CharSequence)checkMsg)) {
                this.getView().showErrorNotification(checkMsg);
                return;
            }
            Long orgId = this.getCurrentOrgId();
            String taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u673a\u6784\u5173\u8054\u7684\u7a0e\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"InvoiceDownNewPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
                this.getView().showTipNotification(ErrorType.SMALL_SCALE_TAXPAYER_DOWN.getName(), Integer.valueOf(2000));
                return;
            }
            String dkType = DeductionConstant.getDkType((String)taxNo);
            if ("5".equals(dkType) || "6".equals(dkType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6536\u7968\u901a\u9053\u6682\u4e0d\u652f\u6301\u6b64\u529f\u80fd\uff0c\u8bf7\u524d\u5f80\u3010\u5168\u91cf\u53d1\u7968\u6570\u636e\u540c\u6b65\u8bbe\u7f6e\u3011\u914d\u7f6e\u5f52\u96c6\u4efb\u52a1", (String)"InvoiceDownPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (PARAM_BILL_TYPE_2.equals(billType) && !"4".equals(dkType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u53ea\u6709\u65b0\u7535\u5b50\u7a0e\u52a1\u5e73\u53f0\u652f\u6301\u4ee3\u6263\u4ee3\u7f34\u5b8c\u7a0e\u51ed\u8bc1\u8fdb\u9879\u8981\u7d20\u4e0b\u8f7d", (String)"InvoiceDownNewPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            DeductService service = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)orgId);
            JSONObject loginResult = service.login(taxNo, BTN_DOWN, (AbstractFormPlugin)this);
            if (ResultContant.isSuccess((JSONObject)loginResult).booleanValue()) {
                this.downInvoice(orgId, taxNo);
            } else if (!ErrorType.NEED_LOGIN.getCode().equals(loginResult.getString("errcode")) || !ErrorType.NEED_LOGIN.getName().equals(loginResult.getString("description"))) {
                this.getView().showErrorNotification(loginResult.getString("description"));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId != null && actionId.startsWith("loginAfter")) {
            String notSelectLoginFail = RimConfigUtils.getConfig((String)"not_select_login_fail");
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData()) && PARAM_BILL_TYPE_1.equals(notSelectLoginFail)) {
                LOGGER.info("\u672a\u767b\u5f55\u4e0d\u63d0\u4ea4\u53c2\u6570\u5f00\u542f");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25", (String)"DeductionLoginOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            Long orgId = this.getCurrentOrgId();
            String taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
            this.downInvoice(orgId, taxNo);
        }
    }

    private void downInvoice(Long orgId, String taxNo) {
        String dkType = DeductionConstant.getDkType((String)taxNo);
        InvoiceMainInfoDownService downService = DeductServiceFactory.newInstanceForInvoiceMainInfoDown((String)dkType, (Long)orgId, (AbstractFormPlugin)this);
        JSONObject param = this.getPageParam();
        param.put("taxNo", (Object)taxNo);
        JSONObject result = null;
        Object taxPeriodObject = param.get((Object)TAX_PERIOD_SET);
        if (taxPeriodObject != null) {
            long startTime = System.currentTimeMillis();
            LOGGER.info("InvoiceDownPlugin-\u591a\u5c5e\u671f\u4e0b\u8f7d\u5f00\u59cb");
            boolean successFlag = false;
            JSONObject totalResult = new JSONObject();
            Set taxPeriodSet = (Set)taxPeriodObject;
            ArrayList<Future> futureList = new ArrayList<Future>(6);
            for (Date taxPeriod : taxPeriodSet) {
                JSONObject paramCheckAuth = new JSONObject();
                paramCheckAuth.putAll((Map)param);
                paramCheckAuth.put("taxPeriod", (Object)taxPeriod);
                Future future = checkAuthThreadPool.submit(() -> this.commitDownInvoice(orgId, taxNo, downService, paramCheckAuth));
                futureList.add(future);
            }
            for (Future future : futureList) {
                try {
                    result = (JSONObject)future.get();
                    if (!ResultContant.isSuccess((JSONObject)result).booleanValue() || successFlag) continue;
                    successFlag = true;
                    totalResult = result;
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error("\u5f02\u6b65\u8c03\u7528\u5f02\u5e38" + e);
                }
            }
            if (!successFlag) {
                totalResult = result;
            }
            if (totalResult == null) {
                totalResult = new JSONObject();
            }
            LOGGER.info("\u4e0b\u8f7d\u7ed3\u679c\uff1a{}", (Object)SerializationUtils.toJsonString((Object)totalResult));
            LOGGER.info("InvoiceDownPlugin-\u591a\u5c5e\u671f\u4e0b\u8f7d\u8017\u65f6: {}", (Object)(System.currentTimeMillis() - startTime));
            this.showApplyResult(totalResult);
        } else {
            result = this.commitDownInvoice(orgId, taxNo, downService, param);
            LOGGER.info("\u4e0b\u8f7d\u7ed3\u679c\uff1a{}", (Object)SerializationUtils.toJsonString((Object)result));
            this.showApplyResult(result);
        }
    }

    private void showApplyResult(JSONObject totalResult) {
        if (ResultContant.isSuccess((JSONObject)totalResult).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u7533\u8bf7\u6210\u529f\uff0c\u8bf7\u524d\u5f80\u201c\u53d1\u7968\u5f52\u96c6\u7ba1\u7406-\u6570\u636e\u540c\u6b65\u65e5\u5fd7\u201d\u67e5\u770b\u72b6\u6001", (String)"InvoiceDownNewPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7533\u8bf7\uff0c\u5931\u8d25\u539f\u56e0 %1$s", (String)"InvoiceDownNewPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), totalResult.getString("description")));
        }
    }

    private JSONObject commitDownInvoice(Long orgId, String taxNo, InvoiceMainInfoDownService downService, JSONObject param) {
        JSONObject result;
        LOGGER.info("\u5f53\u524d\u7ebf\u7a0b\uff0c {}" + Thread.currentThread().getName());
        try {
            this.buildPubilcParam(param, orgId);
            result = downService.doDownNew(param);
        }
        catch (MsgException msg) {
            result = ResultContant.createJSONObject((String)msg.getErrorCode(), (String)msg.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u53d1\u7968:" + taxNo, (Throwable)e);
            result = ResultContant.createJSONObject((String)ErrorType.PARAM_NULL.getCode(), (String)e.getMessage());
        }
        if (result != null) {
            result.remove((Object)"data");
        } else {
            result = new JSONObject();
        }
        return result;
    }

    private void buildPubilcParam(JSONObject param, Long orgId) {
        String dkType;
        String taxNo = param.getString("taxNo");
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
        }
        String deductionPurpose = param.getString("deductionPurpose");
        String invoiceType = param.getString("invoiceType");
        String manageStatus = param.getString("manageStatus");
        String invoiceStatus = param.getString("invoiceStatus");
        String deductFlag = param.getString("deductFlag");
        Date startDate = param.getDate("startDate");
        Date endDate = param.getDate("endDate");
        Date taxPeriod = param.getDate("taxPeriod");
        String startDateStr = DateUtils.format((Date)startDate);
        String endDateStr = DateUtils.format((Date)endDate);
        param.put("taxNo", (Object)taxNo);
        param.put("synctype", (Object)"04");
        param.put("synccondition", (Object)(startDateStr + "," + endDateStr));
        param.put("currentOrgId", (Object)0);
        JSONObject searchOpt = new JSONObject();
        searchOpt.put("startTime", (Object)startDateStr);
        searchOpt.put("endTime", (Object)endDateStr);
        searchOpt.put("deductFlag", (Object)deductFlag);
        if (StringUtils.isNotBlank((CharSequence)deductionPurpose)) {
            searchOpt.put("deductionPurpose", (Object)deductionPurpose);
        }
        if (taxPeriod != null) {
            searchOpt.put("taxPeriod", (Object)taxPeriod);
        }
        if (!PARAM_BILL_TYPE_ALL.equals(invoiceType)) {
            searchOpt.put("invoiceType", (Object)invoiceType);
        } else {
            searchOpt.put("invoiceType", (Object)"");
        }
        if (!PARAM_BILL_TYPE_ALL.equals(invoiceStatus)) {
            searchOpt.put("invoiceStatus", (Object)invoiceStatus);
        }
        if ("4".equals(dkType = DeductionConstant.getDkType((String)taxNo)) && PARAM_BILL_TYPE_0.equals(deductFlag)) {
            searchOpt.put("invoiceStatus", (Object)invoiceStatus);
        }
        if (!PARAM_BILL_TYPE_ALL.equals(manageStatus)) {
            searchOpt.put("manageStatus", (Object)manageStatus);
        }
        param.put("asyncFlag", (Object)PARAM_BILL_TYPE_1);
        param.put("searchOpt", (Object)searchOpt);
    }

    private JSONObject getPageParam() {
        Date startDate = (Date)this.getModel().getValue(PARAM_INVOICE_START_DATE);
        String dkType = (String)this.getModel().getValue(DK_TYPE);
        String deductionPurpose = (String)this.getModel().getValue(DEDUCTION_PURPOSE);
        Date endDate = (Date)this.getModel().getValue(PARAM_INVOICE_END_DATE);
        Date taxperiod = null;
        String deductFlag = (String)this.getModel().getValue(PARAM_DEDUCT_FLAG);
        String invoiceType = (String)this.getModel().getValue(PARAM_INVOICE_TYPE);
        String invoiceStatus = (String)this.getModel().getValue(PARAM_INVOICE_STATUS);
        String billType = (String)this.getModel().getValue(PARAM_BILL_TYPE);
        Date periodStartDate = (Date)this.getModel().getValue(PERIOD_START_DATE);
        Date periodEndDate = (Date)this.getModel().getValue(PERIOD_END_DATE);
        JSONObject param = new JSONObject();
        if (PARAM_BILL_TYPE_1.equals(billType)) {
            invoiceType = InputInvoiceTypeEnum.HGJKS.getAwsType();
        }
        if (PARAM_BILL_TYPE_2.equals(billType)) {
            invoiceType = InputInvoiceTypeEnum.WITHHOLDING.getAwsType();
        }
        Set<Date> taxPeriodSet = null;
        if (PARAM_BILL_TYPE_1.equals(deductFlag)) {
            param.put("deductionPurpose", (Object)deductionPurpose);
            taxperiod = this.getCurrentTaxPeriod(dkType);
        } else if (PARAM_BILL_TYPE_2.equals(deductFlag)) {
            param.put("deductionPurpose", (Object)deductionPurpose);
            periodStartDate = InvoiceDownNewPlugin.setFirstDayOfMonth(periodStartDate);
            periodEndDate = InvoiceDownNewPlugin.setFirstDayOfMonth(periodEndDate);
            taxPeriodSet = this.calculateTaxPeriod(periodStartDate, periodEndDate);
        }
        param.put("deductFlag", (Object)deductFlag);
        param.put("billType", (Object)billType);
        param.put("invoiceType", (Object)invoiceType);
        param.put("manageStatus", (Object)PARAM_BILL_TYPE_0);
        param.put("invoiceStatus", (Object)invoiceStatus);
        param.put("startDate", (Object)startDate);
        param.put("endDate", (Object)endDate);
        if (taxperiod != null) {
            param.put("taxPeriod", (Object)taxperiod);
        }
        param.put("notQueryPage", (Object)PARAM_BILL_TYPE_1);
        if (!CollectionUtils.isEmpty(taxPeriodSet)) {
            param.put(TAX_PERIOD_SET, taxPeriodSet);
        }
        return param;
    }

    private Date getCurrentTaxPeriod(String dkType) {
        String currentTaxPeriod;
        String taxNo;
        DeductService deductService;
        Long currentOrgId = this.getCurrentOrgId();
        if (!"4".equals(dkType) && (deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)currentOrgId, null)) != null && StringUtils.isNotBlank((CharSequence)(taxNo = TenantUtils.getTaxNoByOrgId((Long)currentOrgId))) && StringUtils.isNotBlank((CharSequence)(currentTaxPeriod = deductService.syncGetTaxperiod(taxNo)))) {
            try {
                return DateUtils.stringToDate((String)currentTaxPeriod, (String)"yyyyMM");
            }
            catch (Exception e) {
                LOGGER.info("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c\u7a0e\u6b3e\u5c5e\u671f\uff1a{}", (Object)currentTaxPeriod);
            }
        }
        return null;
    }

    private Set<Date> calculateTaxPeriod(Date periodStartDate, Date periodEndDate) {
        HashSet<Date> taxPeriodSet = new HashSet<Date>();
        this.getTaxPeriodSet(periodStartDate, periodEndDate, taxPeriodSet);
        return taxPeriodSet;
    }

    private void getTaxPeriodSet(Date periodStartDate, Date periodEndDate, Set<Date> taxPeriodSet) {
        if (DateUtils.compare((Date)periodStartDate, (Date)periodEndDate) <= 0) {
            taxPeriodSet.add(periodStartDate);
            Date nextMontyDate = DateUtils.addMonth((Date)periodStartDate, (int)1);
            this.getTaxPeriodSet(nextMontyDate, periodEndDate, taxPeriodSet);
        }
    }

    private String checkParam() {
        Date startDate = (Date)this.getModel().getValue(PARAM_INVOICE_START_DATE);
        Date endDate = (Date)this.getModel().getValue(PARAM_INVOICE_END_DATE);
        Date periodStartDate = (Date)this.getModel().getValue(PERIOD_START_DATE);
        Date periodEndDate = (Date)this.getModel().getValue(PERIOD_END_DATE);
        String deductFlag = (String)this.getModel().getValue(PARAM_DEDUCT_FLAG);
        String deductionPurpose = (String)this.getModel().getValue(DEDUCTION_PURPOSE);
        if (PARAM_BILL_TYPE_ALL.equals(deductFlag) || PARAM_BILL_TYPE_0.equals(deductFlag)) {
            if (startDate == null || endDate == null) {
                return ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceDownPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (DateUtils.compare((Date)startDate, (Date)endDate) > 0) {
                return ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"InvoiceDownPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (DateUtils.compare((Date)DateUtils.addYear((Date)startDate, (int)1), (Date)endDate) < 0) {
                return ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7\u4e00\u5e74", (String)"InvoiceDownPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
        } else if (PARAM_BILL_TYPE_1.equals(deductFlag) || PARAM_BILL_TYPE_2.equals(deductFlag)) {
            if (StringUtils.isBlank((CharSequence)deductionPurpose)) {
                return ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceDownNewPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (PARAM_BILL_TYPE_2.equals(deductFlag)) {
                if (periodStartDate == null) {
                    return ResManager.loadKDString((String)"\u8d77\u59cb\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceDownPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                if (periodEndDate == null) {
                    return ResManager.loadKDString((String)"\u7ed3\u675f\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceDownPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                if (DateUtils.compare((Date)(periodStartDate = InvoiceDownNewPlugin.setFirstDayOfMonth(periodStartDate)), (Date)(periodEndDate = InvoiceDownNewPlugin.setFirstDayOfMonth(periodEndDate))) > 0) {
                    return ResManager.loadKDString((String)"\u8d77\u59cb\u5c5e\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u5c5e\u671f", (String)"InvoiceDownPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                if (DateUtils.compare((Date)DateUtils.addMonth((Date)periodEndDate, (int)-5), (Date)periodStartDate) > 0) {
                    return ResManager.loadKDString((String)"\u591a\u5c5e\u671f\u6700\u591a\u652f\u6301\u8de8\u5ea66\u4e2a\u6708\uff0c\u4f8b\uff1a2024-01~2024-06", (String)"InvoiceDownPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            }
        }
        return null;
    }

    private static Date setFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private Long getCurrentOrgId() {
        DynamicObject orgDynamicObject = (DynamicObject)this.getModel().getValue(DOWN_ORG);
        Long orgId = RequestContext.get().getOrgId();
        if (orgDynamicObject != null) {
            orgId = orgDynamicObject.getLong("id");
        }
        return orgId;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_invoice_down_shuipan", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter idQFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        }
    }
}

