/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectField;
import kd.imc.rim.common.invoice.recognitionnew.task.FileUploadAndSignTask;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;

public class OverseaInvoiceCollectEnterPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(OverseaInvoiceCollectEnterPlugin.class);
    private static final String submitButton = "save_btn";

    public void registerListener(EventObject e) {
        Button submitbutton = (Button)this.getControl(submitButton);
        submitbutton.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        this.getPageCache().remove("overSeaReceiptAndOverSea");
        if (submitButton.equals(control.getKey())) {
            Long invoiceType = Long.parseLong((String)this.getModel().getValue("invoicetype_1"));
            if (InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(invoiceType)) {
                this.enterOverseaInvoice();
            } else {
                this.enterOverReceiptInvoice();
            }
        }
    }

    private void putOverseaInvoiceFile(JSONObject invoiceData) {
        Map file;
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List fileInfos = panel.getAttachmentData();
        if (!CollectionUtils.isEmpty((Collection)fileInfos) && !(file = (Map)fileInfos.get(0)).isEmpty()) {
            String url = (String)file.get("url");
            String name = (String)file.get("name");
            if (FileUtils.checkFileType((String)name, (String[])new String[]{"pdf", "ofd", "jpg", "png", "jpeg"})) {
                String fileType = FileUtils.getFileType((String)name);
                TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                try (InputStream inputStream = tempFileCache.getInputStream(url);){
                    String path = FileUploadUtils.upload((String)(FileUploadUtils.getInvoiceDir((String)"invoice") + MD5.md5Hex((String)url) + name), (String)name, (InputStream)inputStream);
                    invoiceData.put("fileType", (Object)fileType);
                    invoiceData.put("originalState", (Object)"0");
                    invoiceData.put("fileName", (Object)name);
                    try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream((InputStream)FileServiceFactory.getAttachmentFileService().getInputStream(path));){
                        byte[] fileContent = FileUtils.getByte((InputStream)fileInputStream);
                        if (fileContent == null) {
                            invoiceData.put("fileType", (Object)"2");
                            invoiceData.put("imageUrl", (Object)path);
                            invoiceData.put("snapshotUrl", (Object)path);
                            return;
                        }
                        FileUploadAndSignTask fileUploadAndSignTask = new FileUploadAndSignTask(path, fileContent, name, fileType, FileConvertUtils.getSHA256((byte[])fileContent), false, "1", RequestContext.get());
                        JSONObject fileDetail = fileUploadAndSignTask.call();
                        invoiceData.putAll((Map)fileDetail);
                        invoiceData.put("fileHash", (Object)FileConvertUtils.getSHA256((byte[])fileContent));
                    }
                }
                catch (Exception e) {
                    logger.info("\u6d77\u5916\u53d1\u7968\u624b\u5de5\u5f55\u5165-\u5feb\u7167\u751f\u6210\u5931\u8d25\uff1a{}", (Object)e);
                }
            }
        }
    }

    private void enterOverseaInvoice() {
        JSONObject invoiceData = this.getValueObj();
        InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance((String)(InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode() + ""));
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        if (invoiceSaveService != null) {
            ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
            try {
                this.putOverseaInvoiceFile(invoiceData);
                InvoiceSaveResult saveResult = invoiceSaveService.save(invoiceData);
                invoiceData.put("serialNo", (Object)saveResult.getSerialNo());
                invoiceData.put("invoice_info", (Object)saveResult.getInvoiceInfo());
                invoiceIds.add((Long)saveResult.getMainId());
                customParams.put("invoice", invoiceData);
                customParams.put("invoiceIds", invoiceIds);
            }
            catch (Exception e) {
                logger.info("\u6d77\u5916\u53d1\u7968\u624b\u5de5\u5f55\u5165\u4fdd\u5b58\u5931\u8d25:{}", (Object)e);
            }
        }
        if (customParams.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"InvSignByExpensePlugin_110", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        }
    }

    private void enterOverReceiptInvoice() {
        JSONObject invoiceData = this.getOverReceiptValueObj();
        InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance((String)(InputInvoiceTypeEnum.OVERSEA_RECEIPT.getCode() + ""));
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        if (invoiceSaveService != null) {
            ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
            try {
                this.putOverseaInvoiceFile(invoiceData);
                InvoiceSaveResult saveResult = invoiceSaveService.save(invoiceData);
                invoiceData.put("serialNo", (Object)saveResult.getSerialNo());
                invoiceData.put("invoice_info", (Object)saveResult.getInvoiceInfo());
                invoiceIds.add((Long)saveResult.getMainId());
                customParams.put("invoice", invoiceData);
                customParams.put("invoiceIds", invoiceIds);
            }
            catch (Exception e) {
                logger.info("\u6d77\u5916\u6536\u636e\u624b\u5de5\u5f55\u5165\u4fdd\u5b58\u5931\u8d25:{}", (Object)e);
            }
        }
        if (customParams.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"InvSignByExpensePlugin_110", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        }
    }

    private JSONObject getValueObj() {
        JSONObject invoiceData = new JSONObject();
        String invoiceNo = (String)this.getModel().getValue("invoiceno");
        String invoiceDate = "";
        Object invoiceDateValue = this.getModel().getValue("invoicedate");
        if (invoiceDateValue instanceof Date) {
            invoiceDate = DateUtils.format((Date)((Date)invoiceDateValue), (String)"yyyyMMdd");
        }
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
        BigDecimal totalTaxAmount = (BigDecimal)this.getModel().getValue("totaltaxamount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        String buyerName = (String)this.getModel().getValue("buyer_name");
        String salerName = (String)this.getModel().getValue("saler_name");
        String dueDate = "";
        Object dueDateValue = this.getModel().getValue("due_date");
        if (dueDateValue instanceof Date) {
            dueDate = DateUtils.format((Date)((Date)dueDateValue), (String)"yyyyMMdd");
        }
        invoiceData.put("invoiceType", (Object)InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode());
        invoiceData.put("invoiceNo", (Object)invoiceNo);
        invoiceData.put("invoiceDate", (Object)invoiceDate);
        invoiceData.put("totalAmount", (Object)totalAmount);
        invoiceData.put("totalTaxAmount", (Object)totalTaxAmount);
        invoiceData.put("currencyName", (Object)currency.getString("name"));
        invoiceData.put("currencyId", currency.getPkValue());
        invoiceData.put("buyerName", (Object)buyerName);
        invoiceData.put("salerName", (Object)salerName);
        invoiceData.put("dueDate", (Object)dueDate);
        JSONObject businessParam = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("businessParam") != null) {
            businessParam = JSON.parseObject((String)customParams.get("businessParam").toString());
            invoiceData.putAll((Map)businessParam);
        }
        invoiceData.put("serialNo", (Object)UUID.randomUUID());
        return invoiceData;
    }

    private JSONObject getOverReceiptValueObj() {
        JSONObject invoiceData = new JSONObject();
        String invoiceNo = (String)this.getModel().getValue("invoiceno1");
        String invoiceDate = "";
        Object invoiceDateValue = this.getModel().getValue("invoicedate1");
        if (invoiceDateValue instanceof Date) {
            invoiceDate = DateUtils.format((Date)((Date)invoiceDateValue), (String)"yyyyMMdd");
        }
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount1");
        BigDecimal totalTaxAmount = (BigDecimal)this.getModel().getValue("totaltaxamount1");
        BigDecimal invoiceAmount = (BigDecimal)this.getModel().getValue("notaxamount1");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency1");
        String salerTaxNo = (String)this.getModel().getValue("saler_taxno1");
        String salerName = (String)this.getModel().getValue("saler_name1");
        invoiceData.put("invoiceType", (Object)InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode());
        invoiceData.put("invoiceNo", (Object)invoiceNo);
        invoiceData.put("invoiceDate", (Object)invoiceDate);
        invoiceData.put("totalAmount", (Object)totalAmount);
        invoiceData.put("totalTaxAmount", (Object)totalTaxAmount);
        if (!ObjectUtils.isEmpty((Object)currency)) {
            invoiceData.put("currencyName", (Object)currency.getString("name"));
            invoiceData.put("currencyId", currency.getPkValue());
        }
        invoiceData.put("salerName", (Object)salerName);
        invoiceData.put("invoiceAmount", (Object)invoiceAmount);
        invoiceData.put("salerTaxNo", (Object)salerTaxNo);
        JSONObject businessParam = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("businessParam") != null) {
            businessParam = JSON.parseObject((String)customParams.get("businessParam").toString());
            invoiceData.putAll((Map)businessParam);
        }
        invoiceData.put("serialNo", (Object)UUID.randomUUID());
        return invoiceData;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        JSONObject invoice = JSONObject.parseObject((String)this.getPageCache().get("overSeaReceiptAndOverSea"));
        if (invoice == null) {
            invoice = new JSONObject();
        }
        if (StringUtils.equals((CharSequence)"invoicetype_1", (CharSequence)fieldKey)) {
            String newInvoiceType = "";
            String oldInvoiceType = "";
            ChangeData[] changeDatas = e.getChangeSet();
            if (changeDatas.length == 1) {
                newInvoiceType = changeDatas[0].getNewValue().toString();
                oldInvoiceType = changeDatas[0].getOldValue().toString();
                logger.info("\u9009\u62e9\u6d77\u5916\u53d1\u7968\u79cd\u7c7b{}-{}", (Object)fieldKey, (Object)newInvoiceType);
                Map oldInvoiceFieldMap = InvoiceCollectField.getOverSeaAndRecField((Long)Long.parseLong(oldInvoiceType));
                for (Map.Entry invoiceField : oldInvoiceFieldMap.entrySet()) {
                    if (null == this.getControl((String)invoiceField.getValue())) continue;
                    this.getView().setVisible(Boolean.FALSE, new String[]{(String)invoiceField.getValue()});
                }
                Map invoiceFieldMap = InvoiceCollectField.getOverSeaAndRecField((Long)Long.parseLong(newInvoiceType));
                if (!invoice.isEmpty()) {
                    for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                        if (null == this.getControl((String)invoiceField.getValue())) continue;
                        this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
                        this.getModel().setValue((String)invoiceField.getValue(), invoice.get(invoiceField.getKey()));
                    }
                } else {
                    for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                        if (null == this.getControl((String)invoiceField.getValue())) continue;
                        this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
                    }
                }
            }
        } else if (fieldKey.contains("invoiceno")) {
            invoice.put("invoiceNo", this.getModel().getValue(fieldKey));
        } else if (fieldKey.contains("invoicedate")) {
            if (this.getModel().getValue(fieldKey) instanceof Date) {
                invoice.put("invoiceDate", (Object)DateUtils.format((Date)((Date)this.getModel().getValue(fieldKey))));
            }
        } else if (fieldKey.contains("totalamount")) {
            invoice.put("totalAmount", this.getModel().getValue(fieldKey));
        } else if (fieldKey.contains("totaltaxamount")) {
            invoice.put("totalTaxAmount", this.getModel().getValue(fieldKey));
        } else if (fieldKey.contains("currency")) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue(fieldKey);
            invoice.put("currencyName", currency.get("id"));
        } else if (fieldKey.contains("saler_name")) {
            invoice.put("salerName", this.getModel().getValue(fieldKey));
        }
        this.getPageCache().put("overSeaReceiptAndOverSea", JSON.toJSONString((Object)invoice));
    }

    public void afterCreateNewData(EventObject e) {
        this.initHiding();
        Long invoiceType = Long.parseLong((String)this.getModel().getValue("invoicetype_1"));
        logger.info("\u521d\u59cb\u53d1\u7968\u79cd\u7c7b\uff1a{}", (Object)invoiceType);
        Map invoiceFieldMap = InvoiceCollectField.getOverSeaAndRecField((Long)invoiceType);
        if (invoiceFieldMap != null) {
            for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                if (null == this.getControl((String)invoiceField.getValue())) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
            }
        }
    }

    private void initHiding() {
        Set allInvoiceField = InvoiceCollectField.getOverSeaField();
        this.getView().setVisible(Boolean.FALSE, allInvoiceField.toArray(new String[allInvoiceField.size()]));
    }
}

