/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;

public class AutoDeductTaskEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CACHE_KEY = "AutoDeductTaskEditNumber";
    private static final String DYM_ACCOUNTINGORG = "taxpayer_org";
    private static final String TEXT_TAXNO = "taxno";
    private static final String TEXT_TAXNAME = "taxname";
    private static final Collection<String> MULDROP;
    private static final Collection<String> AMOUNT;
    private static final Map<String, String> MUST_INPUT_AMOUNT;

    public void registerListener(EventObject e) {
        BasedataEdit accountingorg = (BasedataEdit)this.getControl(DYM_ACCOUNTINGORG);
        accountingorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initNnmber();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initMulti();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.initNnmber();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            DynamicObjectCollection userorg;
            String deductconfig = (String)this.getModel().getValue("deductconfig");
            ArrayList tipsList = Lists.newArrayListWithExpectedSize((int)MUST_INPUT_AMOUNT.size());
            if (StringUtils.equals((CharSequence)deductconfig, (CharSequence)"1")) {
                for (Map.Entry<String, String> entry : MUST_INPUT_AMOUNT.entrySet()) {
                    BigDecimal value = (BigDecimal)this.getModel().getValue(entry.getKey());
                    if (value != null && value.compareTo(BigDecimal.ZERO) != 0) continue;
                    tipsList.add(entry.getValue());
                }
                if (!tipsList.isEmpty()) {
                    String tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s", (String)"AutoDeductTaskEditPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(String.format(tips, tipsList.stream().collect(Collectors.joining(","))));
                    args.setCancel(true);
                }
            }
            if (!ObjectUtils.isEmpty((Object)(userorg = (DynamicObjectCollection)this.getModel().getValue("userorg")))) {
                StringBuilder resultMessage = new StringBuilder();
                for (DynamicObject dynamicObject : userorg) {
                    String taxNo = dynamicObject.getString("taxpayer_tax_no");
                    if (!TenantUtils.isSmallScaleTaxpayer((String)taxNo)) continue;
                    resultMessage.append(taxNo).append("\uff1a").append(ErrorType.SMALL_SCALE_TAXPAYER_DEDUCT.getName()).append(ViewUtil.LINE_SEPARATOR);
                }
                if (StringUtils.isNotBlank((CharSequence)resultMessage.toString())) {
                    this.getView().showMessage(resultMessage.toString());
                    args.setCancel(true);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.isMulDropDown(key) != null) {
            String mulDropKey = this.isMulDropDown(key);
            String value = key.replace(mulDropKey, "");
            this.refreshMultiOfDropDown(key, mulDropKey, value);
        } else if (StringUtils.equals((CharSequence)DYM_ACCOUNTINGORG, (CharSequence)key)) {
            ChangeData changeDatum = e.getChangeSet()[0];
            int rowIndex = changeDatum.getRowIndex();
            DynamicObject org = (DynamicObject)changeDatum.getNewValue();
            if (org != null) {
                this.setOrgTaxNo(org, rowIndex);
            }
        } else if (AMOUNT.contains(key)) {
            this.refreshAmount();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)DYM_ACCOUNTINGORG)) {
            QFilter filter;
            long userId;
            long orgId = RequestContext.get().getOrgId();
            if (this.getModel().getValue("createorg") != null) {
                orgId = (Long)((DynamicObject)this.getModel().getValue("createorg")).getPkValue();
            }
            if (PermissionServiceHelper.isSuperUser((long)(userId = Long.parseLong(RequestContext.get().getUserId()))) || PermissionServiceHelper.isAdminUser((long)userId)) {
                filter = new QFilter("1", "=", (Object)1);
            } else {
                HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
                filter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            }
            event.getCustomQFilters().add(filter);
        }
    }

    private void initNnmber() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String numberPre = "FPY" + sdf.format(new Date());
        String number = UUID.getNumber((String)numberPre, (String)CACHE_KEY, (String)this.getView().getEntityId());
        this.getModel().setValue("number", (Object)number);
    }

    private void refreshMultiOfDropDown(String optionKey, String key, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String selectedDropDown = (String)this.getModel().getValue(key);
        if (selectedDropDown == null) {
            selectedDropDown = "";
        }
        HashSet selectedSet = Sets.newHashSet((Object[])selectedDropDown.split(","));
        boolean isSelected = (Boolean)this.getModel().getValue(optionKey);
        selectedSet.remove("-1");
        selectedSet.remove("");
        boolean isUnlimited = StringUtils.equals((CharSequence)value, (CharSequence)"000");
        if (isSelected && isUnlimited) {
            this.getModel().setValue(key, (Object)"-1");
            this.getModel().beginInit();
            for (String select : selectedSet) {
                this.getModel().setValue(key + select, (Object)Boolean.FALSE);
            }
            this.initMulti(key);
            this.getModel().endInit();
            for (String select : selectedSet) {
                this.getView().updateView(key + select);
            }
            return;
        }
        if (isSelected) {
            selectedSet.add(value);
        } else {
            selectedSet.remove(value);
        }
        selectedSet.remove("000");
        this.getModel().beginInit();
        if (selectedSet.size() > 0) {
            this.getModel().setValue(key + "000", (Object)Boolean.FALSE);
        } else {
            selectedSet.add("-1");
            this.getModel().setValue(key + "000", (Object)Boolean.TRUE);
        }
        this.getModel().endInit();
        this.getView().updateView(key + "000");
        String newValue = selectedSet.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.joining(","));
        this.getModel().setValue(key, (Object)newValue);
    }

    private void initMulti() {
        for (String key : MULDROP) {
            if (this.getModel().getDataEntity(true).getDynamicObjectType().getProperty(key) == null) continue;
            this.initMulti(key);
        }
    }

    private void initMulti(String key) {
        String value = (String)this.getModel().getValue(key);
        if (value != null) {
            String[] selectedArr;
            for (String selected : selectedArr = value.split(",")) {
                if (StringUtils.equals((CharSequence)selected, (CharSequence)"-1")) {
                    selected = "000";
                }
                if (!StringUtils.isNotBlank((CharSequence)selected)) continue;
                this.getModel().setValue(key + selected, (Object)Boolean.TRUE);
            }
        }
    }

    private String isMulDropDown(String key) {
        String regex = "[0-9]+$";
        if (MULDROP.contains(key = key.replaceAll(regex, ""))) {
            return key;
        }
        return null;
    }

    private void setOrgTaxNo(DynamicObject org, int rowIndex) {
        long orgId = org.getLong("id");
        Map companyNameAndTaxNo = TenantUtils.getCompanyNameAndTaxNoByOrgId((Long)orgId);
        if (companyNameAndTaxNo != null && !StringUtils.isEmpty((CharSequence)((CharSequence)companyNameAndTaxNo.get("taxNo")))) {
            this.getModel().setValue("taxpayer_name", companyNameAndTaxNo.get("name"), rowIndex);
            this.getModel().setValue("taxpayer_tax_no", companyNameAndTaxNo.get("taxNo"), rowIndex);
        } else {
            this.getModel().setValue("taxpayer_name", null, rowIndex);
            this.getModel().setValue("taxpayer_tax_no", null, rowIndex);
        }
    }

    private void refreshAmount() {
        BigDecimal begin_period_amount = (BigDecimal)this.getModel().getValue("begin_period_amount");
        begin_period_amount = begin_period_amount == null ? BigDecimal.ZERO : begin_period_amount;
        BigDecimal current_period_taxamount = (BigDecimal)this.getModel().getValue("current_period_taxamount");
        current_period_taxamount = current_period_taxamount == null ? BigDecimal.ZERO : current_period_taxamount;
        BigDecimal input_out_amount = (BigDecimal)this.getModel().getValue("input_out_amount");
        input_out_amount = input_out_amount == null ? BigDecimal.ZERO : input_out_amount;
        BigDecimal exit_return_taxamount = (BigDecimal)this.getModel().getValue("exit_return_taxamount");
        exit_return_taxamount = exit_return_taxamount == null ? BigDecimal.ZERO : exit_return_taxamount;
        BigDecimal tax_burden_rate = (BigDecimal)this.getModel().getValue("tax_burden_rate");
        tax_burden_rate = tax_burden_rate == null ? BigDecimal.ZERO : tax_burden_rate;
        BigDecimal current_period_amount = (BigDecimal)this.getModel().getValue("current_period_amount");
        current_period_amount = current_period_amount == null ? BigDecimal.ZERO : current_period_amount;
        BigDecimal curentTax = tax_burden_rate.multiply(current_period_amount).divide(new BigDecimal(100));
        BigDecimal realDeducTax = current_period_taxamount.subtract(curentTax);
        BigDecimal input_taxamount = realDeducTax.add(input_out_amount).add(exit_return_taxamount).subtract(begin_period_amount);
        this.getModel().setValue("input_taxamount", (Object)input_taxamount);
    }

    static {
        ArrayList muldrop = Lists.newArrayListWithExpectedSize((int)6);
        muldrop.add("invoiceresouce");
        muldrop.add("invoicetype");
        muldrop.add("receipttype");
        muldrop.add("pretick");
        muldrop.add("invovicestatus");
        muldrop.add("tick");
        muldrop.add("audit_result");
        muldrop.add("check_status");
        muldrop.add("preiod");
        muldrop.add("risk_level");
        MULDROP = Collections.unmodifiableCollection(muldrop);
        ArrayList amount = Lists.newArrayListWithExpectedSize((int)6);
        amount.add("begin_period_amount");
        amount.add("input_out_amount");
        amount.add("exit_return_taxamount");
        amount.add("tax_burden_rate");
        amount.add("current_period_taxamount");
        amount.add("current_period_amount");
        AMOUNT = Collections.unmodifiableCollection(amount);
        HashMap mustInputAmount = Maps.newHashMap();
        mustInputAmount.put("tax_burden_rate", ResManager.loadKDString((String)"\u201c\u7a0e\u8d1f\u7387(%)\u201d", (String)"AutoDeductTaskEditPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        mustInputAmount.put("current_period_taxamount", ResManager.loadKDString((String)"\u201c\u5f53\u671f\u9500\u9879\u7a0e\u989d\u201d", (String)"AutoDeductTaskEditPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        mustInputAmount.put("current_period_amount", ResManager.loadKDString((String)"\u201c\u5f53\u671f\u5e94\u7a0e\u9500\u552e\u6536\u5165\u201d", (String)"AutoDeductTaskEditPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        MUST_INPUT_AMOUNT = Collections.unmodifiableMap(mustInputAmount);
    }
}

