/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.StatisticsStatusEnum;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.StringUtils;

public class BatchDeductService {
    private static Log LOGGER = LogFactory.getLog(BatchDeductService.class);

    public static boolean batchDeduct(Object[] logIdList, AbstractFormPlugin plugin) {
        BatchDeductService.start();
        for (Object logId : logIdList) {
            if (BatchDeductService.deduct(logId, plugin, false)) continue;
            return false;
        }
        return true;
    }

    public static boolean deduct(Object logId, AbstractFormPlugin plugin, boolean isLogin) {
        DynamicObject logObject = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"rim_select_log");
        if (logObject != null) {
            if (BatchDeductService.isStop()) {
                BatchDeductService.setHandleStatus(logObject, "2", ResManager.loadKDString((String)"\u5f3a\u5236\u505c\u6b62", (String)"BatchDeductService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
                return true;
            }
            String taxNo = logObject.getString("tax_no");
            try (DLock dLock = LockUtils.createDLockByMd5((String)("batch_deduct_" + taxNo), (String)"batch_deduct_lock");){
                if (dLock.tryLock()) {
                    String handleStatus = logObject.getString("handle_status");
                    if (!"1".equals(handleStatus)) {
                        if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
                            BatchDeductService.setHandleStatus(logObject, "2", ErrorType.SMALL_SCALE_TAXPAYER_DEDUCT.getName());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
                            boolean bl = true;
                            return bl;
                        }
                        DynamicObject configObject = BatchDeductService.getConfig(logObject.getString("tax_no"));
                        if (configObject == null) {
                            BatchDeductService.setHandleStatus(logObject, "2", ResManager.loadKDString((String)"\u914d\u7f6e\u4e0d\u5b58\u5728", (String)"BatchDeductService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        } else {
                            String dkType = DeductionConstant.getDkType((String)taxNo);
                            LOGGER.info("\u6279\u91cf\u52fe\u9009{}\u6536\u7968\u901a\u9053:{},\u662f\u5426\u767b\u5f55{}", new Object[]{taxNo, dkType, isLogin});
                            if (!isLogin && "4".equals(dkType)) {
                                NewEtaxDeductService service = new NewEtaxDeductService(Long.valueOf(0L));
                                JSONObject loginResult = service.login(taxNo);
                                JSONObject data = loginResult.getJSONObject("data");
                                if (ResultContant.isSuccess((JSONObject)loginResult).booleanValue()) {
                                    if (service.needOpenLoginPage(data)) {
                                        if (plugin != null) {
                                            plugin.getPageCache().put("loginTaxNo", logId.toString());
                                            service.showLoginPage(data, plugin, "deduct_login_batch_deduct");
                                            boolean bl = false;
                                            return bl;
                                        }
                                        BatchDeductService.setHandleStatus(logObject, "2", ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25,\u9700\u8981\u624b\u5de5\u767b\u5f55", (String)"BatchDeductService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                                        boolean bl = true;
                                        return bl;
                                    }
                                    isLogin = true;
                                } else {
                                    BatchDeductService.setHandleStatus(logObject, "2", String.format(ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25%1$s", (String)"BatchDeductService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), loginResult.getString("description")));
                                }
                            } else {
                                isLogin = true;
                            }
                            if (isLogin) {
                                BatchDeductService.deduct(logObject, configObject, dkType);
                            }
                        }
                    } else {
                        LOGGER.info("\u6279\u91cf\u52fe\u9009\u65e5\u5fd7\u8bb0\u5f55{}\u72b6\u6001\u4e3a{}\u4e0d\u9700\u8981\u5904\u7406", logId, (Object)handleStatus);
                        boolean bl = true;
                        return bl;
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObject});
                } else {
                    LOGGER.info("\u6279\u91cf\u52fe\u9009\u83b7\u53d6\u7a0e\u53f7\u9501\u5931\u8d25{}", (Object)taxNo);
                }
            }
        }
        return true;
    }

    private static void deduct(DynamicObject logObject, DynamicObject configObject, String dkType) {
        String taxNo = logObject.getString("tax_no");
        String batchNo = UUID.getBatchNoByTaxNo((String)taxNo);
        JSONObject statisticData = new JSONObject();
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)configObject.get("taxpayer_org"));
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)orgId);
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("batchNo", (Object)batchNo);
        String taxPeriod = "";
        JSONObject statisticTable = deductService.getStatisticTable(param);
        String createTjbbStatus = "";
        if (!ResultContant.isSuccess((JSONObject)statisticTable).booleanValue()) {
            String failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"BatchDeductService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), statisticTable.getString("description"));
            BatchDeductService.setHandleStatus(logObject, "2", failMsg, statisticData);
            return;
        }
        statisticData = statisticTable.getJSONObject("data");
        createTjbbStatus = statisticData.getString("createTjbbStatus");
        taxPeriod = statisticData.getString("taxPeriod");
        if (StatisticsStatusEnum.UN_CREATE.getCode().equals(createTjbbStatus)) {
            param.put("requestId", (Object)UUID.randomUUID());
            statisticTable = deductService.createStatisticTable(param);
            if (ResultContant.isSuccess((JSONObject)statisticTable).booleanValue()) {
                statisticData = statisticTable.getJSONObject("data");
                createTjbbStatus = statisticData.getString("createTjbbStatus");
                taxPeriod = statisticData.getString("taxPeriod");
            } else {
                String failMsg = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"BatchDeductService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), statisticTable.getString("description"));
                BatchDeductService.setHandleStatus(logObject, "2", failMsg, statisticData);
                return;
            }
        }
        if (StatisticsStatusEnum.CREATED_CONFIRM.getCode().equals(createTjbbStatus)) {
            param.put("requestId", (Object)UUID.randomUUID());
            String confirmSecret = configObject.getString("confirm_secret");
            param.put("password", (Object)confirmSecret);
            param.put("confirmSecret", (Object)confirmSecret);
            statisticTable = deductService.confirmStatisticTable(param);
            if (ResultContant.isSuccess((JSONObject)statisticTable).booleanValue()) {
                statisticData.put("createTjbbStatus", (Object)StatisticsStatusEnum.CONFIRMED.getCode());
                statisticData.put("updateTime", (Object)new Date());
                if (StringUtils.isEmpty((CharSequence)taxPeriod)) {
                    taxPeriod = DeductionConstant.getSkssq((String)taxNo);
                }
                DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
                deductInvoiceOperateService.updateAuthenticateFlag("2", taxNo, DateUtils.stringToDate((String)taxPeriod, (String)"yyyyMM"), statisticData.getDate("operateTime"), new String[]{"1", "2"});
                BatchDeductService.setHandleStatus(logObject, "1", "", statisticData);
            } else {
                String failMsg = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u7b7e\u540d\u5931\u8d25:%1$s", (String)"BatchDeductService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), statisticTable.getString("description"));
                BatchDeductService.setHandleStatus(logObject, "2", failMsg, statisticData);
            }
        } else if (StatisticsStatusEnum.CONFIRMED.getCode().equals(createTjbbStatus)) {
            statisticData.put("createTjbbStatus", (Object)StatisticsStatusEnum.CONFIRMED.getCode());
            BatchDeductService.setHandleStatus(logObject, "1", "", statisticData);
        } else {
            String failMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7edf\u8ba1\u8868\u72b6\u6001\u662f[%1$s]\uff0c\u4e0d\u80fd\u786e\u8ba4\u7b7e\u540d", (String)"BatchDeductService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), StatisticsStatusEnum.getNameByCode((String)createTjbbStatus));
            BatchDeductService.setHandleStatus(logObject, "2", failMsg, statisticData);
        }
    }

    public static void setHandleStatus(DynamicObject logObject, String status, String desc) {
        BatchDeductService.setHandleStatus(logObject, status, desc, null);
    }

    public static void setHandleStatus(DynamicObject logObject, String status, String desc, JSONObject statisticData) {
        if (statisticData != null) {
            String skssq = statisticData.getString("taxPeriod");
            String createTjbbStatus = statisticData.getString("createTjbbStatus");
            logObject.set("result_json_tag", (Object)statisticData.toJSONString());
            logObject.set("statistics_status", (Object)createTjbbStatus);
            if (StringUtils.isNotBlank((CharSequence)createTjbbStatus)) {
                DeductionUtils.setStatisticsStatusCahche((String)logObject.getString("tax_no"), (String)createTjbbStatus);
            }
            if (StringUtils.isNotEmpty((CharSequence)skssq)) {
                Date taxPeriod = DateUtils.stringToDate((String)skssq, (String)"yyyyMM");
                logObject.set("tax_period", (Object)taxPeriod);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            logObject.set("handle_status", (Object)status);
        }
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            logObject.set("description", (Object)desc);
        }
        logObject.set("update_time", (Object)new Date());
    }

    private static DynamicObject getConfig(String taxNo) {
        QFilter taxNoFilter = new QFilter("userorg.taxpayer_tax_no", "=", (Object)taxNo);
        DynamicObject collection = QueryServiceHelper.queryOne((String)"rim_batch_deduct", (String)"id,name,userorg.taxpayer_org AS taxpayer_org,userorg.taxpayer_name AS taxpayer_name,userorg.taxpayer_tax_no AS taxpayer_tax_no,userorg.confirm_secret AS confirm_secret", (QFilter[])taxNoFilter.toArray());
        return collection;
    }

    private static boolean isStop() {
        return "1".equals(CacheHelper.get((String)"BatchDeduct_Stop"));
    }

    public static void stop() {
        CacheHelper.put((String)"BatchDeduct_Stop", (String)"1", (int)300);
    }

    private static void start() {
        CacheHelper.remove((String)"BatchDeduct_Stop");
    }
}

