/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxAsyncDeductSelectService;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.license.LicenseListPlugin;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateFactory;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import kd.imc.rim.formplugin.query.operate.impl.ReapplyDownLoginOperateService;
import org.apache.commons.collections.MapUtils;

public class DownLogListPlugin
extends LicenseListPlugin {
    private static Log logger = LogFactory.getLog(DownLogListPlugin.class);
    public static String DISCARD_TASK = "discard_task";
    private static String REAPPLY = "reapply";
    protected static final Set<String> ALLOW_DOWN_STATUS = new HashSet<String>(4){
        private static final long serialVersionUID = -2012333430055776732L;
        {
            this.add("2");
            this.add("6");
            this.add("7");
            this.add("5");
        }
    };

    private static final String TITLE() {
        String async = RimConfigUtils.getConfig((String)"rim_deduction", (String)"batch_down_invoice_sync");
        if ("1".equals(async)) {
            return ResManager.loadKDString((String)"\u5f02\u6b65\u5904\u7406\u540c\u6b65\u65e5\u5fd7", (String)"DownLogListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u624b\u5de5\u5904\u7406\u540c\u6b65\u65e5\u5fd7", (String)"DownLogListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("down".equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.RIM_BATCH_DOWNLOAD, (String)"down");
            this.downLoadInvoice();
        } else if ("export".equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_DERIVE, (String)"export");
        } else if (DISCARD_TASK.equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_DOWN_DISCARD_TASK, (String)DISCARD_TASK);
            this.startDiscardTask();
        } else if (REAPPLY.equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_DOWN_REAPPLY, (String)REAPPLY);
            this.startReapply();
        }
    }

    private void startReapply() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"DownLogListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (selectCollection.size() > 500) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u6700\u5927\u5141\u8bb8\u7684\u624b\u5de5\u91cd\u8bd5\u4efb\u52a1\u6570\u91cf\u4e3a500", (String)"SelectLogListPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        DynamicObjectCollection initCollection = QueryServiceHelper.query((String)"rim_down_log", (String)"id,gov_status,tax_no,inout,batch_no", (QFilter[])new QFilter[]{filter});
        if (!ObjectUtils.isEmpty((Object)initCollection)) {
            StringBuilder message = new StringBuilder();
            ArrayList<DynamicObject> successLogList = new ArrayList<DynamicObject>(initCollection.size());
            ReapplyDownLoginOperateService service = new ReapplyDownLoginOperateService("down_reapply_login", 0L, (AbstractFormPlugin)this);
            for (DynamicObject dynamicObject : initCollection) {
                JSONArray jsonArray;
                Map map;
                String tip;
                String govStatus = dynamicObject.getString("gov_status");
                String taxNo = dynamicObject.getString("tax_no");
                String batchNo = dynamicObject.getString("batch_no");
                String inout = dynamicObject.getString("inout");
                if (StringUtils.isBlank((CharSequence)taxNo)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u7a0e\u53f7\u4e3a\u7a7a", (String)"DownLogListPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    map = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject);
                    jsonArray = new JSONArray(1);
                    jsonArray.add((Object)map);
                    service.setCacheTip(taxNo, ResManager.loadKDString((String)"\u7a0e\u53f7\u4e3a\u7a7a", (String)"DownLogListPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
                    continue;
                }
                if (!InvoiceDownHelper.ALLOW_REAPPLY_TASK.contains(govStatus)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u5f53\u524d\u53ea\u652f\u6301\u5931\u8d25\u7c7b\u578b\u7684\u6570\u636e\u8fdb\u884c\u91cd\u8bd5", (String)"DownLogListPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    map = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject);
                    jsonArray = new JSONArray(1);
                    jsonArray.add((Object)map);
                    service.setCacheTip(taxNo, ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u652f\u6301\u5931\u8d25\u7c7b\u578b\u7684\u6570\u636e\u8fdb\u884c\u91cd\u8bd5", (String)"DownLogListPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
                    continue;
                }
                if (!InvoiceDownHelper.ALLOW_REAPPLY_INOUT_TYPE.contains(inout)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u5f53\u524d\u53ea\u652f\u6301\u8fdb\u3001\u9500\u9879\u5168\u91cf\uff1b\u8fdb\u9879\u8981\u7d20\u3001\u6570\u7535\u6587\u4ef6\u3001\u519c\u4ea7\u54c1\u4e0b\u8f7d", (String)"DownLogListPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    map = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject);
                    jsonArray = new JSONArray(1);
                    jsonArray.add((Object)map);
                    service.setCacheTip(taxNo, ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u652f\u6301\u8fdb\u3001\u9500\u9879\u5168\u91cf\uff1b\u8fdb\u9879\u8981\u7d20\u3001\u6570\u7535\u6587\u4ef6\u548c\u519c\u4ea7\u54c1\u4e0b\u8f7d", (String)"DownLogListPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
                    continue;
                }
                String dkType = DeductionConstant.getDkType((String)taxNo);
                if (!"4".equals(dkType)) {
                    String tip2 = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u7a0e\u53f7\u5bf9\u5e94\u7684\u6536\u7968\u901a\u9053\u975e\u65b0\u7535\u5b50\u5e73\u53f0\uff0c\u6682\u4e0d\u652f\u6301\u91cd\u8bd5\u64cd\u4f5c", (String)"DownLogListPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    Map map2 = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject);
                    JSONArray jsonArray2 = new JSONArray(1);
                    jsonArray2.add((Object)map2);
                    service.setCacheTip(taxNo, ResManager.loadKDString((String)"\u6536\u7968\u901a\u9053\u975e\u65b0\u7535\u5b50\u5e73\u53f0\uff0c\u6682\u4e0d\u652f\u6301\u91cd\u8bd5\u64cd\u4f5c", (String)"DownLogListPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray2, 0);
                    continue;
                }
                successLogList.add(dynamicObject);
            }
            if (CollectionUtils.isEmpty(successLogList)) {
                DeductionConstant.removeLoopLoginCache((IPageCache)this.getPageCache());
                String title = ResManager.loadKDString((String)"\u624b\u5de5\u91cd\u8bd5", (String)"DownLogListPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                ViewUtil.showMessage((AbstractFormPlugin)this, (String)title, (String)message.toString(), (int)0, (int)selectCollection.size());
                return;
            }
            Map<String, List<DynamicObject>> groupMap = successLogList.stream().filter(s -> !kd.bos.orm.util.StringUtils.isEmpty((Object)s.getString("tax_no"))).collect(Collectors.groupingBy(s -> s.getString("tax_no")));
            JSONObject cacheJson = new JSONObject();
            for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
                List<DynamicObject> values = entry.getValue();
                ArrayList<Map> list = new ArrayList<Map>(values.size());
                for (DynamicObject value : values) {
                    list.add(DynamicObjectUtil.dynamicObjectToMap((DynamicObject)value));
                }
                JSONObject data = new JSONObject();
                data.put("data", list);
                cacheJson.put(entry.getKey(), (Object)data);
            }
            this.getPageCache().put("deduct_tax_no", cacheJson.toJSONString());
            this.getPageCache().put("deduct_title", ResManager.loadKDString((String)"\u624b\u5de5\u91cd\u8bd5", (String)"DownLogListPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            service.operate();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5728\u6570\u636e\u5e93\u91cc\u4e0d\u5b58\u5728", (String)"SelectLogListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void startDiscardTask() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"DownLogListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (selectCollection.size() > 500) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u6700\u5927\u5141\u8bb8\u7684\u4f5c\u5e9f\u4efb\u52a1\u6570\u91cf\u4e3a500", (String)"SelectLogListPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        StringBuilder message = new StringBuilder();
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        QFilter filter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        DynamicObjectCollection initCollection = QueryServiceHelper.query((String)"rim_down_log", (String)"id,gov_status,tax_no,inout,taskno,batch_no", (QFilter[])new QFilter[]{filter});
        if (!ObjectUtils.isEmpty((Object)initCollection)) {
            HashMap<String, String> failMap = new HashMap<String, String>(initCollection.size());
            for (DynamicObject dynamicObject : initCollection) {
                String tip;
                String tip2;
                String govStatus = dynamicObject.getString("gov_status");
                String taskNo = dynamicObject.getString("taskno");
                String taxNo = dynamicObject.getString("tax_no");
                String batchNo = dynamicObject.getString("batch_no");
                if (StringUtils.isBlank((CharSequence)taskNo)) {
                    tip2 = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u4efb\u52a1\u53f7\u4e3a\u7a7a", (String)"DownLogListPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    failMap.put(batchNo, tip2);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)taxNo)) {
                    tip2 = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u7a0e\u53f7\u4e3a\u7a7a", (String)"DownLogListPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    failMap.put(batchNo, tip2);
                    continue;
                }
                String dkType = DeductionConstant.getDkType((String)taxNo);
                if (!"4".equals(dkType)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u7a0e\u53f7\u5bf9\u5e94\u7684\u6536\u7968\u901a\u9053\u975e\u65b0\u7535\u5b50\u5e73\u53f0\uff0c\u6682\u4e0d\u652f\u6301\u4f5c\u5e9f\u64cd\u4f5c", (String)"DownLogListPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    failMap.put(batchNo, tip);
                    continue;
                }
                if (!"6".equals(govStatus)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u975e\u5904\u7406\u4e2d\u7684\u72b6\u6001\u4e0d\u652f\u6301\u4f5c\u5e9f", (String)"DownLogListPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    failMap.put(batchNo, tip);
                    continue;
                }
                List batchNoList = param.getOrDefault(taxNo, new ArrayList());
                batchNoList.add(taskNo);
                param.put(taxNo, batchNoList);
            }
            if (MapUtils.isEmpty(param)) {
                failMap.clear();
                String title = ResManager.loadKDString((String)"\u4f5c\u5e9f\u4efb\u52a1", (String)"SelectLogListPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                ViewUtil.showMessage((AbstractFormPlugin)this, (String)title, (String)message.toString(), (int)0, (int)selectCollection.size());
                return;
            }
            this.discardTask(param, failMap);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5728\u6570\u636e\u5e93\u91cc\u4e0d\u5b58\u5728", (String)"SelectLogListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void discardTask(Map<String, List<String>> param, Map<String, String> failMap) {
        if (param == null) {
            logger.info("\u4f5c\u5e9f\u4efb\u52a1-\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        NewEtaxAsyncDeductSelectService newEtaxAsyncDeductSelectService = new NewEtaxAsyncDeductSelectService();
        newEtaxAsyncDeductSelectService.discardTask(param, (AbstractFormPlugin)this, "2", failMap);
    }

    private void downLoadInvoice() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"DownLogListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        DynamicObjectCollection initCollection = QueryServiceHelper.query((String)"rim_down_log", (String)"id,gov_status,tax_no,inout", (QFilter[])new QFilter[]{filte});
        Iterator iterator = initCollection.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            String govStatus = dynamicObject.getString("gov_status");
            if (kd.bos.orm.util.StringUtils.isEmpty((Object)govStatus) || ALLOW_DOWN_STATUS.contains(govStatus)) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty((Collection)initCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u540c\u6b65\u72b6\u6001\u4e3a'\u6570\u636e\u4e0d\u5168'\u6216'\u8fdb\u9500\u9879\u4e0b\u8f7d\u5904\u7406\u4e2d'\u7684\u6570\u636e", (String)"DownLogListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Map<String, List<DynamicObject>> groupMap = initCollection.stream().filter(s -> !kd.bos.orm.util.StringUtils.isEmpty((Object)s.getString("tax_no"))).collect(Collectors.groupingBy(s -> s.getString("tax_no")));
        JSONObject cacheJson = new JSONObject();
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> values = entry.getValue();
            ArrayList<Map> list = new ArrayList<Map>(values.size());
            for (DynamicObject value : values) {
                list.add(DynamicObjectUtil.dynamicObjectToMap((DynamicObject)value));
            }
            JSONObject data = new JSONObject();
            data.put("data", list);
            cacheJson.put(entry.getKey(), (Object)data);
        }
        this.getPageCache().put("deduct_tax_no", cacheJson.toJSONString());
        this.getPageCache().put("deduct_title", DownLogListPlugin.TITLE());
        InvoiceOperateService service = InvoiceOperateFactory.newInstance("deduct_login_down_invoice", 0L, (AbstractFormPlugin)this);
        service.operate();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject logDynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"rim_down_log", (String)"batch_no");
        QFilter batchNoFilter = new QFilter("batch_no", "=", (Object)logDynamicObject.getString("batch_no"));
        DynamicObjectCollection accountCollection = QueryServiceHelper.query((String)"rim_down_account", (String)"id", (QFilter[])new QFilter[]{batchNoFilter});
        if (CollectionUtils.isEmpty((Collection)accountCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6ca1\u6709\u5df2\u4e0b\u8f7d\u7684\u53d1\u7968\u6570\u636e", (String)"DownLogListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            Object[] idList = accountCollection.stream().map(s -> s.get("id")).toArray();
            ListShowParameter showParameter = new ListShowParameter();
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("rim_down_account_layout");
            showParameter.setCustomParam("goupanddown", (Object)"1");
            QFilter filter = new QFilter("id", "in", (Object)idList);
            listFilterParameter.setFilter(filter);
            showParameter.setListFilterParameter(listFilterParameter);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        InvoiceOperateService service;
        if ("deduct_login_down_invoice".equals(closedCallBackEvent.getActionId())) {
            service = InvoiceOperateFactory.newInstance("deduct_login_down_invoice", 0L, (AbstractFormPlugin)this);
            service.closedCallBack(closedCallBackEvent);
        }
        if ("down_reapply_login".equals(closedCallBackEvent.getActionId())) {
            service = InvoiceOperateFactory.newInstance("down_reapply_login", 0L, (AbstractFormPlugin)this);
            service.closedCallBack(closedCallBackEvent);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"DownLogListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if ("reset_status".equals(operateKey)) {
            DynamicObject[] logs;
            QFilter qFilter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"rim_down_log", (String)"id,gov_status,modifytime", (QFilter[])qFilter.toArray())) {
                log.set("gov_status", (Object)"6");
                log.set("modifytime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])logs);
            billList.clearSelection();
            billList.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DownLogListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        QFilter qFilterAwsType = null;
        while (iterator.hasNext()) {
            List qFilterNestList;
            QFilter qFilter = (QFilter)iterator.next();
            if (qFilter == null || !"aws_invoice_type".equals(qFilter.getProperty())) continue;
            String value = (String)qFilter.getValue();
            String newValue = value.replace(",", "");
            List multiValues = CommonUtils.getMultiValues((String)newValue);
            if (!CollectionUtils.isEmpty((Collection)multiValues) && multiValues.size() == 1) {
                if (qFilterAwsType == null) {
                    qFilterAwsType = new QFilter("aws_invoice_type", "like", multiValues.get(0));
                } else {
                    qFilterAwsType.or(new QFilter("aws_invoice_type", "like", multiValues.get(0)));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(qFilterNestList = qFilter.getNests(true)))) {
                for (QFilter.QFilterNest qFilterNest : qFilterNestList) {
                    QFilter filter1 = qFilterNest.getFilter();
                    if ("aws_invoice_type".equals(filter1.getProperty())) {
                        String newValue1;
                        List multiValues1;
                        String value1 = (String)filter1.getValue();
                        if (kd.bos.orm.util.StringUtils.isEmpty((Object)value1) || CollectionUtils.isEmpty((Collection)(multiValues1 = CommonUtils.getMultiValues((String)(newValue1 = value1.replace(",", ""))))) || multiValues1.size() != 1) continue;
                        if (qFilterAwsType == null) {
                            qFilterAwsType = new QFilter("aws_invoice_type", "like", multiValues1.get(0));
                            continue;
                        }
                        qFilterAwsType.or(new QFilter("aws_invoice_type", "like", multiValues1.get(0)));
                        continue;
                    }
                    qFilterAwsType.and(filter1);
                }
            }
            iterator.remove();
        }
        if (qFilterAwsType != null) {
            qFilters.add(qFilterAwsType);
        }
    }
}

