/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.StatisticsStatusEnum;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.DeductStatisticsService;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;

public class DrawbackStatisticsPlugin
extends LicenseFormPlugin
implements BeforeF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(DrawbackStatisticsPlugin.class);
    private static final String CURRENT_STATISTICSE_NTRYENTITY = "entryentity_cur";
    private static final String CURRENT_WIZARDAP = "wizardap";
    private static final String KEY_DATA_FLEX = "flex_current_invoice";
    private static final String BATCH_NO_CREATE_STATISTICS = "batch_no_create_statistics";
    private static final String BATCH_NO_CANCEL_STATISTICS = "batch_no_cancel_statistics";
    private static final String BATCH_NO_CONFIRM_STATISTICS = "batch_no_confirm_statistics";
    private static final String TAX_NO = "tax_no";
    private static final String COMPANY_NAME = "company_name";
    public static final String QUERY_CURRENT_STATISTICS = "query_current_statistics";
    private static final String CONFIRM_STATISTICS = "confirm_statistics";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit base = (BasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap11"});
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        this.setCompanyInfo();
        this.initView();
        String unittestFlag = RimConfigUtils.getConfig((String)"unit_test_flag");
        if ("1".equals(unittestFlag)) {
            this.showInvoiceLists(this.getCurrentOrgId());
        } else {
            this.getView().addClientCallBack("queryInvoice", Integer.valueOf(100));
        }
    }

    private void initView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{CONFIRM_STATISTICS});
        this.setStep(CURRENT_WIZARDAP, 0, "process");
        Label labelCurPeriod = (Label)this.getView().getControl("label_cur_period");
        String taxPeriod = DateUtils.format((Date)new Date(), (String)"yyyyMM");
        labelCurPeriod.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5c5e\u671f:%s", (String)"DrawbackStatisticsPlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxPeriod));
        Label labeCurrentTaxPeriod = (Label)this.getView().getControl("label_curr_tax_period");
        labeCurrentTaxPeriod.setText(taxPeriod);
        this.setStatisticsStatus("");
        this.getModel().deleteEntryData(CURRENT_STATISTICSE_NTRYENTITY);
    }

    private void setCompanyInfo() {
        Map companyInfo = DeductStatisticsService.getCompanyNameAndTaxNo((Long)this.getCurrentOrgId(), (Long)this.getTaxOrgId());
        String taxNo = "";
        String companyName = "";
        if (!CollectionUtils.isEmpty((Map)companyInfo)) {
            taxNo = Optional.ofNullable(companyInfo.get("taxNo")).filter(StringUtils::isNotEmpty).orElse("");
            companyName = Optional.ofNullable(companyInfo.get("name")).filter(StringUtils::isNotEmpty).orElse("");
        }
        Label labeCurrentName = (Label)this.getView().getControl("label_cur_name");
        labeCurrentName.setText(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u540d\u79f0:%s", (String)"DrawbackStatisticsPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]), companyName));
        Label labelCurrentTaxno = (Label)this.getView().getControl("label_cur_taxno");
        labelCurrentTaxno.setText(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:%s", (String)"DrawbackStatisticsPlugin_27", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxNo));
        this.getModel().setValue(TAX_NO, (Object)taxNo);
        this.getModel().setValue(COMPANY_NAME, (Object)companyName);
    }

    private void showInvoiceLists(Long orgId) {
        Long taxOrgId;
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        ListShowParameter showParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        showParameter.setFormId("bos_list");
        Map parameter = this.getView().getFormShowParameter().getCustomParams();
        String formId = "rim_invoice";
        Object mainFormId = parameter.get("mainformid");
        if (StringUtils.isNotBlank(mainFormId)) {
            formId = mainFormId.toString();
        }
        showParameter.setBillFormId(formId);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.putAll(parameter);
        customParams.put("querytype", "drawback_period");
        customParams.put("invoicetype", 0L);
        String skssq = DeductionConstant.getSkssq((String)taxNo);
        Date taxPeriod = DateUtils.getFirstDateOfMonth((Date)new Date());
        JSONObject orgFilter = new JSONObject();
        if (orgId != null) {
            orgFilter.put("org", (Object)orgId);
        }
        if ((taxOrgId = this.getTaxOrgId()) != null) {
            orgFilter.put("tax_org", (Object)taxOrgId);
        }
        orgFilter.put("tax_period", (Object)taxPeriod);
        customParams.put("filters", orgFilter);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        filters.add(new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getVatDrawbackTypes()));
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        QFilter taxNoFilter = new QFilter("buyer_tax_no", "=", (Object)taxNo);
        QFilter deductionPurposeFilter = new QFilter("deduction_purpose", "=", (Object)"3");
        QFilter taxPeriodFilter = new QFilter("tax_period", "=", (Object)taxPeriod);
        QFilter checkFilter = new QFilter("check_status", "in", (Object)CheckContant.getSuccessStatus());
        QFilter authenticateFilter = new QFilter("authenticate_flag", "in", (Object)new String[]{"1", "2", "3"});
        filters.add(tenantFilter);
        filters.add(delFilter);
        filters.add(checkFilter);
        filters.add(taxNoFilter);
        filters.add(authenticateFilter);
        filters.add(taxPeriodFilter);
        filters.add(deductionPurposeFilter);
        listFilterParameter.setQFilters(filters);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f53\u671f\u9000\u7a0e\u52fe\u9009\u53d1\u7968", (String)"DrawbackStatisticsPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        showParameter.setShowTitle(false);
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rim_invoice"));
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_DATA_FLEX);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("org".equals(fieldKey) || "taxorg".equals(fieldKey)) {
            this.setCompanyInfo();
            this.initView();
            this.getView().addClientCallBack("queryInvoice", Integer.valueOf(100));
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String name = e.getName();
        Object batchNo = null;
        if ("queryInvoice".equals(name)) {
            this.showInvoiceLists(this.getCurrentOrgId());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_STATISTICS.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String taxNo = (String)this.getModel().getValue(TAX_NO);
            String dkType = this.getDkType(taxNo);
            DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
            String batchNo = UUID.getBatchNoByTaxNo((String)taxNo);
            JSONObject param = new JSONObject();
            param.put("taxNo", (Object)taxNo);
            param.put("batchNo", (Object)batchNo);
            param.put("userId", (Object)RequestContext.get().getUserId());
            JSONObject createResult = deductService.drawbackStatisticConfirm(param);
            if (ResultContant.isSuccess((JSONObject)createResult).booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u6210\u529f", (String)"DrawbackStatisticsPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.setStep(CURRENT_WIZARDAP, 2, "finish");
                JSONObject data = createResult.getJSONObject("data");
                Date operateTime = null;
                if (data != null) {
                    operateTime = data.getDate("operateTime");
                }
                DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
                deductInvoiceOperateService.updateAuthenticateFlag("2", taxNo, DateUtils.getFirstDateOfMonth((Date)new Date()), operateTime, new String[]{"3"});
                this.inserSelectLog(batchNo, "10");
                this.getView().setVisible(Boolean.FALSE, new String[]{CONFIRM_STATISTICS});
                this.setStatisticsStatus(StatisticsStatusEnum.CONFIRMED.getCode());
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"DrawbackStatisticsPlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0]), createResult != null ? createResult.getString("description") : ""));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate oprate = (FormOperate)args.getSource();
        String operationKey = oprate.getOperateKey();
        if (QUERY_CURRENT_STATISTICS.equals(operationKey) || CONFIRM_STATISTICS.equals(operationKey)) {
            String taxNo = (String)this.getModel().getValue(TAX_NO);
            if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
                this.getView().showErrorNotification(ErrorType.SMALL_SCALE_TAXPAYER_DEDUCT.getName());
                args.setCancel(true);
                return;
            }
            String dkType = DeductionConstant.getDkType((String)taxNo);
            DeductService service = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId());
            JSONObject loginResult = service.login(taxNo, operationKey, (AbstractFormPlugin)this);
            if (!ResultContant.isSuccess((JSONObject)loginResult).booleanValue()) {
                if (!ErrorType.NEED_LOGIN.getCode().equals(loginResult.getString("errcode"))) {
                    this.getView().showErrorNotification(loginResult.getString("description"));
                }
                args.setCancel(true);
            }
        }
    }

    private void queryCurrentStatistics() {
        this.setStep(CURRENT_WIZARDAP, 0, "process");
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        String dkType = this.getDkType(taxNo);
        if ("5".equals(dkType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e50\u4f01\u901a\u9053\u4e0d\u652f\u6301\u9000\u7a0e\u7edf\u8ba1", (String)"DrawbackStatisticsPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        if (deductService == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"DrawbackStatisticsPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        JSONObject queryJson = deductService.getDrawbackStatisticTable(param);
        if (ResultContant.isSuccess((JSONObject)queryJson).booleanValue()) {
            this.addCurrentStatisticsModel(queryJson);
        } else if (queryJson != null) {
            if ("10068".equals(queryJson.getString("errcode"))) {
                this.getView().showTipNotification(queryJson.getString("description"));
                return;
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"DrawbackStatisticsPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]), queryJson.getString("description")));
        }
    }

    private void addCurrentStatisticsModel(JSONObject queryJson) {
        JSONArray tjInfoArr;
        JSONObject data = queryJson.getJSONObject("data");
        Label labelCurrPeriod = (Label)this.getView().getControl("label_cur_period");
        String taxPeriod = data.getString("taxPeriod");
        if (StringUtils.isEmpty((CharSequence)taxPeriod)) {
            taxPeriod = data.getString("skssq");
        }
        taxPeriod = Optional.ofNullable(taxPeriod).orElse("");
        labelCurrPeriod.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5c5e\u671f:%s", (String)"DrawbackStatisticsPlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxPeriod));
        this.setStatisticsStatus(StatisticsStatusEnum.CREATED_CONFIRM.getCode());
        String skssq = data.getString("skssq");
        Boolean show = Boolean.TRUE;
        Boolean hide = Boolean.FALSE;
        this.getView().setVisible(show, new String[]{CONFIRM_STATISTICS});
        this.setStep(CURRENT_WIZARDAP, 1, "finish");
        this.getModel().deleteEntryData(CURRENT_STATISTICSE_NTRYENTITY);
        String zzszp = data.getString("zzszp");
        String hgjks = data.getString("hgjks");
        if (StringUtils.isNotEmpty((CharSequence)zzszp)) {
            this.addStatisticsData("4", zzszp);
        }
        if (StringUtils.isNotEmpty((CharSequence)zzszp)) {
            this.addStatisticsData("21", hgjks);
        }
        if (!CollectionUtils.isEmpty((Collection)(tjInfoArr = data.getJSONArray("tjInfoArr")))) {
            for (int i = 0; i < tjInfoArr.size(); ++i) {
                JSONObject statistic = tjInfoArr.getJSONObject(i);
                String invoiceType = statistic.getString("invoiceType");
                if ("99".equals(invoiceType)) continue;
                int row = this.getModel().createNewEntryRow(CURRENT_STATISTICSE_NTRYENTITY);
                this.getModel().setValue("c_deduct_invoice_type", (Object)invoiceType, row);
                this.getModel().setValue("c_deduct_num", (Object)statistic.getString("deductibleNum"), row);
                this.getModel().setValue("c_deduct_invoice_amount", (Object)BigDecimalUtil.transDecimal((Object)statistic.get((Object)"deductibleAmount")), row);
                this.getModel().setValue("c_deducteffectiveamount", (Object)BigDecimalUtil.transDecimal((Object)statistic.get((Object)"deductibleTax")), row);
            }
        }
    }

    private void addStatisticsData(String invoiceType, String statisticsData) {
        int row = this.getModel().createNewEntryRow(CURRENT_STATISTICSE_NTRYENTITY);
        String[] cells = statisticsData.split("~");
        int size = cells.length;
        this.getModel().setValue("c_deduct_invoice_type", (Object)invoiceType, row);
        this.getModel().setValue("c_deduct_num", (Object)cells[0], row);
        if (size > 1) {
            this.getModel().setValue("c_deduct_invoice_amount", (Object)BigDecimalUtil.transDecimal((Object)cells[1]), row);
        }
        if (size > 2) {
            this.getModel().setValue("c_deducteffectiveamount", (Object)BigDecimalUtil.transDecimal((Object)cells[2]), row);
        }
    }

    private void setStep(String key, int step, String status) {
        Wizard wizard = (Wizard)this.getControl(key);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put("currentStep", step);
        currentStepMap.put("currentStatus", status);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    private Long getCurrentOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = null;
        if (org != null) {
            orgId = org.getLong("id");
        }
        return orgId;
    }

    private Long getTaxOrgId() {
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
        Long taxorgId = null;
        if (taxorg != null) {
            taxorgId = taxorg.getLong("id");
        }
        return taxorgId;
    }

    private void setStatisticsStatus(String status) {
        String statusName = "";
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            statusName = StatisticsStatusEnum.getNameByCode((String)status);
        }
        Label labelStatus = (Label)this.getView().getControl("label_statistics_status");
        labelStatus.setText(String.format(ResManager.loadKDString((String)"\u7edf\u8ba1\u8868\u72b6\u6001:%s", (String)"DrawbackStatisticsPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]), statusName));
        this.getModel().setValue("tjbb_status", (Object)status);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    private void inserSelectLog(String batchNo, String operateType) {
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        Long orgId = this.getCurrentOrgId() != null ? this.getCurrentOrgId() : this.getTaxOrgId();
        DeductStatisticsService.inserSelectLog((String)batchNo, (String)taxNo, (Long)orgId, (String)operateType, (String)DateUtils.format((Date)new Date(), (String)"yyyyMM"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        this.doOperate(operateKey);
    }

    private void doOperate(String operateKey) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
        if (ObjectUtils.isEmpty((Object)org) && ObjectUtils.isEmpty((Object)taxorg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u548c\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"DrawbackStatisticsPlugin_33", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (operateKey) {
            case "query_current_statistics": {
                this.queryCurrentStatistics();
                break;
            }
            case "confirm_statistics": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u786e\u8ba4\u9000\u7a0e\u52fe\u9009\u7edf\u8ba1\u8868\u5417?", (String)"DrawbackStatisticsPlugin_34", (String)"imc-rim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u786e\u8ba4\u7b7e\u540d\u6210\u529f\u4e4b\u540e\uff0c\u65e0\u6cd5\u64a4\u9500\u3002", (String)"DrawbackStatisticsPlugin_35", (String)"imc-rim-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_STATISTICS), null);
                break;
            }
            case "export": {
                break;
            }
        }
    }

    private String getDkType(String taxNo) {
        String cacheKey = "dktype" + taxNo;
        String dkType = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((CharSequence)dkType)) {
            dkType = DeductionConstant.getDkType((String)taxNo);
            this.getPageCache().put(cacheKey, dkType);
        }
        return dkType;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("rim_invoice".equals(actionId) && "close".equals(closedCallBackEvent.getReturnData())) {
            this.getView().close();
        }
    }
}

