/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.DeductStatisticsService;
import kd.imc.rim.common.invoice.deduction.StatisticService;
import kd.imc.rim.common.plugin.ProgressFormPlugin;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;

public class HistoryDeductStatisticsPlugin
extends ProgressFormPlugin
implements BeforeF7SelectListener,
ProgresssListener {
    private static Log LOGGER = LogFactory.getLog(HistoryDeductStatisticsPlugin.class);
    private static final String HISTORY_STATISTICSE_NTRYENTITY = "entryentity_his";
    private static final String HISTORY_INVOICES_NTRYENTITY = "entryentity_his_invoice";
    private static final String HISTORY_EXPORT_NTRYENTITY = "export_history_entry";
    private static final String EXPORT_LIST = "export_list";
    private static final String HISTORY_INVOICES_CACHE = "invoices";
    private static final String BATCH_NO = "batch_no";
    private static final String RESULT_CACHE = "result_cache:";
    private static final String KEY_LOADING_PARAM = "loading_param";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    public static final String BILL_LIST_AP = "billlistap";
    private static final String STOP_FLAG = "stop_flag";
    public static final String QUERY_HISTORY_STATISTICS = "query_history_statistics";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap1"});
        BasedataEdit base = (BasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        this.setCompanyInfo();
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.add(2, -1);
        this.getModel().setValue("his_tax_period", (Object)calendar.getTime());
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PROGRESSBAR});
    }

    private void setCompanyInfo() {
        Map companyInfo = DeductStatisticsService.getCompanyNameAndTaxNo((Long)this.getCurrentOrgId(), (Long)this.getTaxOrgId());
        String taxNo = "";
        String companyName = "";
        if (!CollectionUtils.isEmpty((Map)companyInfo)) {
            taxNo = Optional.ofNullable(companyInfo.get("taxNo")).filter(StringUtils::isNotEmpty).orElse("");
            companyName = Optional.ofNullable(companyInfo.get("name")).filter(StringUtils::isNotEmpty).orElse("");
        }
        Label labelHistoryName = (Label)this.getView().getControl("label_his_name");
        labelHistoryName.setText(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u540d\u79f0:%s", (String)"HistoryDeductStatisticsPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]), companyName));
        Label labelHistoryTaxNo = (Label)this.getView().getControl("label_his_taxno");
        labelHistoryTaxNo.setText(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:%s", (String)"HistoryDeductStatisticsPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxNo));
        this.getModel().setValue("tax_no", (Object)taxNo);
        this.getModel().setValue("company_name", (Object)companyName);
        this.getModel().deleteEntryData(HISTORY_STATISTICSE_NTRYENTITY);
        this.getModel().deleteEntryData(HISTORY_INVOICES_NTRYENTITY);
        this.getPageCache().remove(HISTORY_INVOICES_CACHE);
        this.loadData(false);
        String dkType = DeductionConstant.getDkType((String)taxNo);
        boolean asyncRequest = DeductionConstant.isAsyncRequest((String)dkType);
        if (asyncRequest) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BILL_LIST_AP, EXPORT_LIST});
            this.getView().setVisible(Boolean.FALSE, new String[]{HISTORY_INVOICES_NTRYENTITY, "label_his_invoicenum", "export"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{HISTORY_INVOICES_NTRYENTITY, "label_his_invoicenum", "export"});
            this.getView().setVisible(Boolean.FALSE, new String[]{BILL_LIST_AP, EXPORT_LIST});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("org".equals(fieldKey) || "taxorg".equals(fieldKey)) {
            this.setCompanyInfo();
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    private void downInvoice(Date tax_period, String operateType, String showTip) {
        String taxNo = (String)this.getModel().getValue("tax_no");
        String taxPeriod = DateUtils.format((Date)tax_period, (String)"yyyy-MM");
        String batchNo = UUID.randomUUID();
        this.getPageCache().put(BATCH_NO, batchNo);
        String dkType = DeductionConstant.getDkType((String)taxNo);
        if (DeductionConstant.isAsyncRequest((String)dkType)) {
            this.getPageCache().remove(HISTORY_INVOICES_CACHE);
        }
        this.getPageCache().remove(STOP_FLAG);
        JSONObject param = new JSONObject();
        param.put("operateType", (Object)operateType);
        param.put("batchNo", (Object)batchNo);
        param.put("taxNo", (Object)taxNo);
        String cacheKey = RESULT_CACHE + this.getView().getPageId() + batchNo;
        this.getPageCache().put(KEY_LOADING_PARAM, SerializationUtils.toJsonString((Object)param));
        CacheHelper.remove((String)cacheKey);
        this.startProcess(new String[]{showTip});
        RequestContext requestContext = RequestContext.get();
        ThreadPools.executeOnceIncludeRequestContext((String)"HistoryDeductionRun", () -> {
            RequestContext.copyAndSet((RequestContext)requestContext);
            JSONObject result = null;
            try {
                if (QUERY_HISTORY_STATISTICS.equals(operateType)) {
                    result = this.queryData(taxNo, taxPeriod);
                } else if (HISTORY_EXPORT_NTRYENTITY.equals(operateType)) {
                    result = this.exportData(taxNo, taxPeriod);
                } else if (EXPORT_LIST.equals(operateType)) {
                    result = this.exportListData(taxNo, taxPeriod);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5386\u53f2\u7edf\u8ba1\u8868\u67e5\u8be2\u62a5\u9519" + taxNo, (Throwable)e);
                result = ResultContant.createJSONObject((String)"0001", (String)e.getMessage());
            }
            CacheHelper.put((String)cacheKey, (String)SerializationUtils.toJsonString((Object)result), (int)60);
        });
    }

    private JSONObject queryData(String taxNo, String taxPeriod) {
        String dkType = DeductionConstant.getDkType((String)taxNo);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        JSONObject result = null;
        if ("4".equals(dkType) || "1".equals(dkType)) {
            result = deductService.queryHistoryStatistics(taxNo, taxPeriod, true);
        } else if ("5".equals(dkType) || "3".equals(dkType)) {
            JSONArray statistics = DeductStatisticsService.createStatistics((String)taxPeriod, (String)taxNo);
            result = ResultContant.createSuccessJSONObject();
            result.put("tjxx", (Object)statistics);
        } else {
            result = deductService.queryHistoryStatistics(taxNo, taxPeriod);
        }
        return result;
    }

    private void queryHistoryStatistics(JSONObject queryJson) {
        long start = System.currentTimeMillis();
        Date tax_period = (Date)this.getModel().getValue("his_tax_period");
        String taxPeriod = DateUtils.format((Date)tax_period, (String)"yyyy-MM");
        Label label = (Label)this.getView().getControl("label_his_period");
        label.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5c5e\u671f:%s", (String)"HistoryDeductStatisticsPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxPeriod));
        this.getModel().deleteEntryData(HISTORY_STATISTICSE_NTRYENTITY);
        this.getModel().deleteEntryData(HISTORY_INVOICES_NTRYENTITY);
        this.getModel().setValue("updatetime", null);
        String taxNo = (String)this.getModel().getValue("tax_no");
        String dkType = DeductionConstant.getDkType((String)taxNo);
        boolean asyncRequest = DeductionConstant.isAsyncRequest((String)dkType);
        Label label3 = (Label)this.getView().getControl("label_his_invoicenum");
        if (queryJson != null && ResultContant.isSuccess((JSONObject)queryJson).booleanValue()) {
            JSONArray invoices = queryJson.getJSONArray("data");
            JSONArray statistics = (JSONArray)CommonUtils.getJsonValue((Map)queryJson, JSONArray.class, (String[])new String[]{"tjxx", "tjxx"});
            Map statisticMap = StatisticService.initStatisticMap();
            if (asyncRequest) {
                this.loadData(true);
            }
            if (!CollectionUtils.isEmpty((Collection)invoices)) {
                label3.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u5f20\u53d1\u7968", (String)"HistoryDeductStatisticsPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoices.size() + ""));
                this.getPageCache().put(HISTORY_INVOICES_CACHE, queryJson.toJSONString());
                String updateTime = invoices.getJSONObject(0).getString("selectAuthenticateTime");
                if (StringUtils.isEmpty((CharSequence)updateTime)) {
                    updateTime = invoices.getJSONObject(0).getString("selectTime");
                }
                if (StringUtils.isNotEmpty((CharSequence)updateTime)) {
                    this.getModel().setValue("updatetime", (Object)DateUtils.stringToDate((String)updateTime));
                }
                Label label4 = (Label)this.getView().getControl("label_his_updatetime");
                label4.setText(String.format(ResManager.loadKDString((String)"\u7edf\u8ba1\u8868\u66f4\u65b0\u65f6\u95f4:%s", (String)"HistoryDeductStatisticsPlugin_33", (String)"imc-rim-formplugin", (Object[])new Object[0]), updateTime));
                Long orgId = this.getCurrentOrgId();
                if (orgId == null) {
                    orgId = RequestContext.get().getOrgId();
                }
                String userId = RequestContext.get().getUserId();
                DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
                if (!"0".equals(queryJson.getString("saveFlag"))) {
                    deductInvoiceOperateService.saveDownInvoice(invoices.toJavaList(JSONObject.class), orgId, userId, taxNo);
                }
                for (int i = 0; i < invoices.size(); ++i) {
                    JSONObject item = invoices.getJSONObject(i);
                    String invoiceType = item.getString("invoiceType");
                    if (CollectionUtils.isEmpty((Collection)statistics)) {
                        StatisticService.getStatictMapData((Map)statisticMap, (JSONObject)item, (String)invoiceType);
                    }
                    int row = this.getModel().createNewEntryRow(HISTORY_INVOICES_NTRYENTITY);
                    this.getModel().setValue("invoice_type", (Object)InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType), row);
                    this.getModel().setValue("invoice_code", (Object)item.getString("invoiceCode"), row);
                    this.getModel().setValue("invoice_no", (Object)item.getString("invoiceNo"), row);
                    this.getModel().setValue("invoice_date", item.get((Object)"invoiceDate"), row);
                    this.getModel().setValue("saler_name", item.get((Object)"salerName"), row);
                    this.getModel().setValue("invoice_amount", item.get((Object)"invoiceAmount"), row);
                    this.getModel().setValue("effective_tax_amount", item.get((Object)"effectiveTaxAmount"), row);
                    this.getModel().setValue("invoice_status", item.get((Object)"invoiceStatus"), row);
                    this.getModel().setValue("select_time", item.get((Object)"selectTime"), row);
                    this.getModel().setValue("manage_status", item.get((Object)"manageStatus"), row);
                    String deductionPurpose = item.getString("deductionPurpose");
                    this.getModel().setValue("deduction_purpose", (Object)deductionPurpose, row);
                    if ("2".equals(deductionPurpose)) {
                        this.getModel().setValue("not_deductible_type", item.get((Object)"notDeductibleType"), row);
                    }
                    String authenticateFlag = item.getString("authenticateFlag");
                    this.getModel().setValue("authenticate_flag", (Object)authenticateFlag, row);
                }
            } else {
                label3.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u5f20\u53d1\u7968", (String)"HistoryDeductStatisticsPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]), "0"));
                if ("1".equals(dkType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u76d8\u6a21\u5f0f\u6682\u4e0d\u652f\u6301\u67e5\u8be2\u5df2\u8ba4\u8bc1\u53d1\u7968\u6e05\u5355", (String)"HistoryDeductStatisticsPlugin_34", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
            }
            LOGGER.info("\u66f4\u65b0\u5386\u53f2\u7edf\u8ba1\u8868,taxNo:{}-\u6570\u91cf:{}-\u8017\u65f6:{}", new Object[]{taxNo, this.getModel().getEntryEntity(HISTORY_INVOICES_NTRYENTITY).getRowCount(), System.currentTimeMillis() - start});
            if (!CollectionUtils.isEmpty((Collection)statistics)) {
                for (int i = 0; i < statistics.size(); ++i) {
                    JSONObject item = statistics.getJSONObject(i);
                    if ("99".equals(item.getString("invoiceType"))) continue;
                    int row = this.getModel().createNewEntryRow(HISTORY_STATISTICSE_NTRYENTITY);
                    this.getModel().setValue("c_deduct_invoice_type", (Object)item.getString("invoiceType"), row);
                    this.getModel().setValue("c_deduct_num", item.get((Object)"deductibleNum"), row);
                    this.getModel().setValue("c_deduct_invoice_amount", (Object)BigDecimalUtil.transDecimal((Object)item.get((Object)"deductibleAmount")), row);
                    this.getModel().setValue("c_deducteffectiveamount", (Object)BigDecimalUtil.transDecimal((Object)item.get((Object)"deductibleTax")), row);
                }
                return;
            }
            for (Map.Entry entry : statisticMap.entrySet()) {
                JSONObject itemJson = (JSONObject)entry.getValue();
                int row = this.getModel().createNewEntryRow(HISTORY_STATISTICSE_NTRYENTITY);
                this.getModel().setValue("c_deduct_invoice_type", entry.getKey(), row);
                this.getModel().setValue("c_deduct_num", itemJson.get((Object)"deductibleNum"), row);
                this.getModel().setValue("c_deduct_invoice_amount", itemJson.get((Object)"deductibleAmount"), row);
                this.getModel().setValue("c_deducteffectiveamount", itemJson.get((Object)"deductibleTax"), row);
                this.getModel().setValue("c_undeduct_num", itemJson.get((Object)"unDeductibleNum"), row);
                this.getModel().setValue("c_undeduct_invoice_amount", itemJson.get((Object)"unDeductibleAmount"), row);
                this.getModel().setValue("c_undeducteffectiveamount", itemJson.get((Object)"unDeductibleTax"), row);
            }
        } else if (queryJson != null) {
            if (asyncRequest) {
                this.loadData(false);
                return;
            }
            label3.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u5f20\u53d1\u7968", (String)"HistoryDeductStatisticsPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]), "0"));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"HistoryDeductStatisticsPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]), queryJson.getString("description")));
        }
    }

    private Long getCurrentOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = null;
        if (org != null) {
            orgId = org.getLong("id");
        }
        return orgId;
    }

    private Long getTaxOrgId() {
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
        Long taxorgId = null;
        if (taxorg != null) {
            taxorgId = taxorg.getLong("id");
        }
        return taxorgId;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId != null && actionId.indexOf("loginAfter") == 0 && StringUtils.isNotBlank((Object)closedCallBackEvent.getReturnData())) {
            this.doOperate(actionId.replace("loginAfter", ""));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if (QUERY_HISTORY_STATISTICS.equals(operationKey)) {
            String taxNo = (String)this.getModel().getValue("tax_no");
            if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
                this.getView().showErrorNotification(ErrorType.SMALL_SCALE_TAXPAYER_DEDUCT.getName());
                args.setCancel(true);
                return;
            }
            String dkType = DeductionConstant.getDkType((String)taxNo);
            DeductService service = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId());
            JSONObject loginResult = service.login(taxNo, operationKey, (AbstractFormPlugin)this);
            if (!ResultContant.isSuccess((JSONObject)loginResult).booleanValue()) {
                if (!ErrorType.NEED_LOGIN.getCode().equals(loginResult.getString("errcode")) || !ErrorType.NEED_LOGIN.getName().equals(loginResult.getString("description"))) {
                    this.getView().showErrorNotification(loginResult.getString("description"));
                }
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        this.doOperate(operateKey);
    }

    private void doOperate(String operateKey) {
        Date tax_period = (Date)this.getModel().getValue("his_tax_period");
        if (QUERY_HISTORY_STATISTICS.equals(operateKey)) {
            if (null == tax_period) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u63a7\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"HistoryDeductStatisticsPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
            if (ObjectUtils.isEmpty((Object)org) && ObjectUtils.isEmpty((Object)taxorg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u548c\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"HistoryDeductStatisticsPlugin_37", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.downInvoice(tax_period, operateKey, ResManager.loadKDString((String)"\u67e5\u8be2\u4e2d", (String)"HistoryDeductStatisticsPlugin_35", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else if (HISTORY_EXPORT_NTRYENTITY.equals(operateKey)) {
            this.downInvoice(tax_period, operateKey, ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4e2d", (String)"HistoryDeductStatisticsPlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else if (EXPORT_LIST.equals(operateKey)) {
            this.downInvoice(tax_period, operateKey, ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4e2d", (String)"HistoryDeductStatisticsPlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    private JSONObject exportListData(String taxNo, String taxPeriod) {
        JSONObject queryJson = this.queryList(taxNo, "", taxPeriod);
        if (queryJson == null || !ResultContant.isSuccess((JSONObject)queryJson).booleanValue() || CollectionUtils.isEmpty((Collection)queryJson.getJSONArray("data"))) {
            return ResultContant.createJSONObject((String)"0102", (String)ResManager.loadKDString((String)"\u6682\u65e0\u7edf\u8ba1\u6570\u636e", (String)"HistoryDeductStatisticsPlugin_39", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        queryJson.put("saveFlag", (Object)"0");
        return DeductStatisticsService.exportData(null, (JSONObject)queryJson, (Long)this.getCurrentOrgId(), (String)taxNo, (String)"", null, (String)ResManager.loadKDString((String)"\u5386\u53f2\u5c5e\u671f\u53d1\u7968\u6e05\u5355", (String)"HistoryDeductStatisticsPlugin_42", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)taxPeriod);
    }

    private JSONObject queryList(String taxNo, String dkType, String taxperiod) {
        String invoiceCache = this.getPageCache().get(HISTORY_INVOICES_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)invoiceCache)) {
            return JSONObject.parseObject((String)invoiceCache);
        }
        if (StringUtils.isEmpty((CharSequence)dkType)) {
            dkType = DeductionConstant.getDkType((String)taxNo);
        }
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        JSONObject result = deductService.queryHistoryStatistics(taxNo, taxperiod);
        this.getPageCache().put(HISTORY_INVOICES_CACHE, result.toJSONString());
        return result;
    }

    private JSONObject exportData(String taxNo, String taxperiod) {
        JSONObject queryJson;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(HISTORY_STATISTICSE_NTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return ResultContant.createJSONObject((String)"0102", (String)ResManager.loadKDString((String)"\u6682\u65e0\u7edf\u8ba1\u6570\u636e", (String)"HistoryDeductStatisticsPlugin_39", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        Date updateTime = (Date)this.getModel().getValue("updatetime");
        Long orgId = this.getCurrentOrgId();
        if (orgId == null) {
            orgId = RequestContext.get().getOrgId();
        }
        String companyName = (String)this.getModel().getValue("company_name");
        String dkType = DeductionConstant.getDkType((String)taxNo);
        if (DeductionConstant.isAsyncRequest((String)dkType)) {
            queryJson = this.queryList(taxNo, dkType, taxperiod);
            if (queryJson == null || !ResultContant.isSuccess((JSONObject)queryJson).booleanValue() || CollectionUtils.isEmpty((Collection)queryJson.getJSONArray("data"))) {
                return ResultContant.createJSONObject((String)"0102", (String)ResManager.loadKDString((String)"\u6682\u65e0\u7edf\u8ba1\u6570\u636e", (String)"HistoryDeductStatisticsPlugin_39", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        } else {
            String invoiceCache = this.getPageCache().get(HISTORY_INVOICES_CACHE);
            if (StringUtils.isEmpty((CharSequence)invoiceCache)) {
                return ResultContant.createJSONObject((String)"0102", (String)ResManager.loadKDString((String)"\u6682\u65e0\u7edf\u8ba1\u6570\u636e", (String)"HistoryDeductStatisticsPlugin_39", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            queryJson = JSONObject.parseObject((String)invoiceCache);
        }
        queryJson.put("saveFlag", (Object)"0");
        return DeductStatisticsService.exportData((DynamicObjectCollection)entryEntity, (JSONObject)queryJson, (Long)orgId, (String)taxNo, (String)companyName, (Date)updateTime, (String)ResManager.loadKDString((String)"\u5386\u53f2\u5c5e\u671f\u62b5\u6263\u53d1\u7968\u7edf\u8ba1\u8868", (String)"HistoryDeductStatisticsPlugin_40", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)taxperiod);
    }

    public void onProgress(ProgressEvent progressEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dialogProcess(String eventArgs) {
        String batchNo = this.getPageCache().get(BATCH_NO);
        if (StringUtils.isEmpty((CharSequence)batchNo)) {
            this.stopProcess();
            return;
        }
        String paramStr = this.getPageCache().get(KEY_LOADING_PARAM);
        if (StringUtils.isEmpty((CharSequence)paramStr)) {
            this.stopProcess();
            return;
        }
        JSONObject param = JSONObject.parseObject((String)paramStr);
        if (param == null) {
            this.stopProcess();
            return;
        }
        String operateType = param.getString("operateType");
        if (StringUtils.isEmpty((CharSequence)operateType)) {
            this.stopProcess();
            return;
        }
        try (DLock dLock = DLock.create((String)("his_dialogprocess" + this.getView().getPageId()), (String)"hiddialogProcessLock");){
            String cacheKey;
            block39: {
                if (!dLock.tryLock()) return;
                if ("1".equals(this.getPageCache().get(STOP_FLAG))) {
                    this.stopProcess();
                    return;
                }
                cacheKey = RESULT_CACHE + this.getView().getPageId() + batchNo;
                String resultString = CacheHelper.get((String)cacheKey);
                if (StringUtils.isEmpty((CharSequence)resultString)) return;
                try {
                    JSONObject result = JSONObject.parseObject((String)resultString);
                    if (QUERY_HISTORY_STATISTICS.equals(operateType)) {
                        this.queryHistoryStatistics(result);
                        break block39;
                    }
                    if (HISTORY_EXPORT_NTRYENTITY.equals(operateType)) {
                        if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                            String urls = result.getString("data");
                            if (StringUtils.isEmpty((CharSequence)urls)) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51faExcel\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"HistoryDeductStatisticsPlugin_41", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                                return;
                            }
                            PermissionUtils.addTempFilePermission((String)urls, (String)this.getView().getEntityId(), (String)"1O2SPYDXPUDW", (int)5000);
                            this.getView().openUrl(urls);
                            break block39;
                        } else {
                            this.getView().showTipNotification(result.getString("description"), Integer.valueOf(5000));
                        }
                        break block39;
                    }
                    if (!EXPORT_LIST.equals(operateType)) break block39;
                    if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                        String urls = result.getString("data");
                        if (StringUtils.isEmpty((CharSequence)urls)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51faExcel\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"HistoryDeductStatisticsPlugin_41", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                            return;
                        }
                        PermissionUtils.addTempFilePermission((String)urls, (String)this.getView().getEntityId(), (String)"1O2SPYDXPUDW", (int)5000);
                        this.getView().openUrl(urls);
                    } else {
                        this.getView().showTipNotification(result.getString("description"), Integer.valueOf(5000));
                    }
                }
                finally {
                    this.getPageCache().put(STOP_FLAG, "1");
                    this.stopProcess();
                }
            }
            CacheHelper.remove((String)cacheKey);
            return;
        }
    }

    private void loadData(boolean query) {
        String taxNo = (String)this.getModel().getValue("tax_no");
        QFilter filter = new QFilter("buyer_tax_no", "=", (Object)taxNo);
        if (query) {
            Date taxperiod = (Date)this.getModel().getValue("his_tax_period");
            if (taxperiod == null) {
                return;
            }
            taxperiod = DateUtils.getFirstDateOfMonth((Date)taxperiod);
            filter.and("tax_period", "=", (Object)taxperiod);
            filter.and("authenticate_flag", "in", (Object)new String[]{"1", "2", "3"});
            filter.and("invoice_type", "in", (Object)InputInvoiceTypeEnum.getDeductionAllTypes());
        } else {
            filter.and("id", "=", (Object)-1L);
        }
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.refresh();
    }
}

