/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.downloadcenter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.query.config.ColumnConfig;
import kd.imc.rim.common.invoice.query.config.ListConfig;
import kd.imc.rim.common.invoice.query.config.ListConfigUtil;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CurrencyUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.downloadcenter.DownLoadService;
import org.apache.commons.lang3.StringUtils;

public class InvoiceExportService
extends DownLoadService {
    private static Log LOGGER = LogFactory.getLog(InvoiceExportService.class);
    private static final String lockId = UUID.randomUUIDZero();

    @Override
    public void deal() {
        long time = System.currentTimeMillis();
        LOGGER.info("Export_deal-lockId:{}", (Object)lockId);
        try (DLock lock = DLock.create((String)("export" + lockId));){
            if (lock.tryLock()) {
                LOGGER.info("Export_deal-{}", (Object)time);
                int i = 0;
                block9: while (true) {
                    ++i;
                    QFilter filter1 = new QFilter("handlestate", "=", (Object)"1");
                    QFilter filter2 = new QFilter("file_type", "=", (Object)"1");
                    QFilter filter3 = new QFilter("appid", "=", (Object)"rim");
                    List pklist = QueryServiceHelper.queryPrimaryKeys((String)"bdm_download_center", (QFilter[])new QFilter[]{filter1, filter2, filter3}, (String)"id", (int)100);
                    if (pklist == null || pklist.isEmpty()) break;
                    Iterator iterator = pklist.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block9;
                        Object pk = iterator.next();
                        LOGGER.info("Export_deal-{},{}", (Object)time, pk);
                        this.downloadByTaskId(pk, time);
                    }
                    break;
                }
                LOGGER.info("Export_deal-{},{}", (Object)time, (Object)i);
            } else {
                LOGGER.info("Export_deal-{}\u4e0d\u5904\u7406", (Object)time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadByTaskId(Object pk, long time) {
        block38: {
            try (DLock lock = DLock.create((String)("ExportHelper-" + pk));){
                if (lock.tryLock()) {
                    LOGGER.info("Export_deal-{}-{}down", (Object)time, pk);
                    long start = System.currentTimeMillis();
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bdm_download_center");
                    ArrayList<QFilter> qfilters = null;
                    try {
                        String qfilterCache = obj.getString("qfilter_tag");
                        if (StringUtils.isNotEmpty((CharSequence)qfilterCache)) {
                            List qfilterCacheStrList = SerializationUtils.fromJsonStringToList((String)qfilterCache, String.class);
                            qfilters = new ArrayList<QFilter>(qfilterCacheStrList.size());
                            for (int i = 0; i < qfilterCacheStrList.size(); ++i) {
                                String json = (String)qfilterCacheStrList.get(i);
                                QFilter qFilter = QFilter.fromSerializedString((String)json);
                                qfilters.add(qFilter);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.info("\u6761\u4ef6\u8f6c\u6362\u9519\u8bef" + e.getMessage());
                    }
                    String state = obj.getString("handlestate");
                    Long userId = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("applicant"));
                    int fileNum = 0;
                    if ("1".equals(state)) {
                        ByteArrayOutputStream out = null;
                        DeflaterOutputStream zipOut = null;
                        String zipName = obj.getString("filename");
                        try {
                            zipName = zipName.replace(".zip", "");
                            DynamicObjectCollection serialNos = obj.getDynamicObjectCollection("invoice_detail");
                            ArrayList<Long> pkList = new ArrayList<Long>(8);
                            int row = 0;
                            String queryType = null;
                            String invoiceType = null;
                            String exportType = null;
                            String expParam = obj.getString("exp_param");
                            String[] params = expParam.split("\\|");
                            queryType = params[0];
                            invoiceType = params[1];
                            exportType = params[2];
                            int count = 0;
                            for (DynamicObject entry : serialNos) {
                                String dealresult = entry.getString("deal_result");
                                if (!"0".equals(dealresult)) continue;
                                String serial = entry.getString("serial_no");
                                Long pkId = BigDecimalUtil.transDecimal((Object)serial).longValue();
                                if (pkId > 0L) {
                                    pkList.add(pkId);
                                    ++row;
                                    ++count;
                                }
                                if (row <= 0 || row % 5000 != 0 || pkList.isEmpty()) continue;
                                if (zipOut == null) {
                                    out = new ByteArrayOutputStream();
                                    zipOut = new ZipOutputStream(out);
                                }
                                byte[] excelByte = this.buildXSSFWorkbook(queryType, invoiceType, exportType, pkList.toArray(), qfilters, userId);
                                this.doZip(excelByte, (ZipOutputStream)zipOut, "", ++fileNum + ".xlsx");
                                pkList.clear();
                            }
                            if (!pkList.isEmpty()) {
                                if (zipOut == null) {
                                    out = new ByteArrayOutputStream();
                                    zipOut = new ZipOutputStream(out);
                                }
                                byte[] excelByte = this.buildXSSFWorkbook(queryType, invoiceType, exportType, pkList.toArray(), qfilters, userId);
                                this.doZip(excelByte, (ZipOutputStream)zipOut, "", ++fileNum + ".xlsx");
                                pkList.clear();
                            }
                            if (count == 0) {
                                obj.set("handlestate", (Object)"3");
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                            }
                            if (zipOut != null && out != null) {
                                zipOut.flush();
                                ((ZipOutputStream)zipOut).close();
                                String url = this.upload(zipName + ".zip", out.toByteArray());
                                obj.set("handlestate", (Object)"2");
                                DynamicObjectCollection uploaddetail = obj.getDynamicObjectCollection("file_detail");
                                DynamicObject upDetail = uploaddetail.addNew();
                                upDetail.set("detail_url", (Object)url);
                                upDetail.set("detail_file_name", (Object)(zipName + ".zip"));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Export_deal-" + time + "\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
                            obj.set("handlestate", (Object)"3");
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                        }
                        finally {
                            if (zipOut != null) {
                                try {
                                    zipOut.flush();
                                    ((ZipOutputStream)zipOut).close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    LOGGER.info("Export_deal-{}-{}\u5904\u7406{}\u4e2a\u6587\u4ef6\u8017\u65f6{}ms", new Object[]{time, pk, fileNum, System.currentTimeMillis() - start});
                    break block38;
                }
                LOGGER.info("Export_deal-{}-{}down\u4e0d\u5904\u7406", (Object)time, pk);
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public byte[] buildXSSFWorkbook(String queryType, String invoiceType, String exportType, Object[] pkList, List<QFilter> qfilters, Long userId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ListConfig getListConfig(Object queryType, String item, Long userId) {
        return ListConfigUtil.getListConfig((String)(queryType.toString() + "_export"), (String)item, (Long)userId);
    }

    private String getCellValue(DynamicObject object, String entityId, ColumnConfig column, String invoiceType) {
        Format format;
        String comboValue;
        Object value;
        if (null == object) {
            return "";
        }
        String fieldKey = column.getFieldKey();
        if (StringUtils.isNotEmpty((CharSequence)column.getRefField())) {
            fieldKey = column.getRefField();
        }
        if ((value = object.get(fieldKey)) == null) {
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)column.getRefField()) && StringUtils.isNotEmpty((CharSequence)(comboValue = MetadataUtil.getComboItemName((String)entityId, (String)fieldKey, (String)value.toString())))) {
            return comboValue;
        }
        String dateformat = column.getDisplayFormatString();
        if (StringUtils.isNotEmpty((CharSequence)dateformat)) {
            if (value instanceof Date) {
                return DateUtils.format((Date)((Date)value), (String)dateformat);
            }
            if ("DecimalListColumn".equals(column.getColumnType())) {
                DecimalFormat decimalFormat = new DecimalFormat(dateformat);
                return decimalFormat.format(value);
            }
        }
        if (column.getValueMap() != null) {
            String val = (String)column.getValueMap().get(value.toString());
            if (val != null) {
                return val;
            }
        } else if ("ComboListColumn".equals(column.getColumnType())) {
            return MetadataUtil.getComboItemName((String)entityId, (String)fieldKey, (String)value.toString());
        }
        if ((format = MetadataUtil.getDateFormat((String)entityId, (String)fieldKey)) != null) {
            long currencyId;
            Integer amtPrecision;
            if ((InputInvoiceTypeEnum.ALL_INVOICE.getCode().equals(BigDecimalUtil.transDecimal((Object)invoiceType).longValue()) || InputInvoiceTypeEnum.containCurrencyId((Long)BigDecimalUtil.transDecimal((Object)invoiceType).longValue())) && "DecimalListColumn".equals(column.getColumnType()) && (amtPrecision = CurrencyUtils.getAmtPrecision((Long)(currencyId = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get("currencyid"))))) != null) {
                String formatByPrecision = CurrencyUtils.getFormatByPrecision((int)amtPrecision);
                format = new DecimalFormat(formatByPrecision);
            }
            return format.format(value);
        }
        if (value instanceof Date) {
            return DateUtils.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (column.isEncrypt()) {
            return InvoiceConvertService.encrypt((Object)value).toString();
        }
        return value.toString();
    }
}

