/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.expense;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.formplugin.query.OpenInvoiceDetailService;

public class ExpenseSignDetailPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Long pkId = BigDecimalUtil.transDecimal(map.get("pkId")).longValue();
        if (pkId > 0L) {
            this.loadInvoice(pkId);
        }
    }

    private void loadInvoice(Long expenseId) {
        QFilter filete = new QFilter("id", "=", (Object)expenseId);
        DynamicObject expense = QueryServiceHelper.queryOne((String)"rim_expense", (String)"id,expense_id,expense_num,resource,entityid,invoice_count,sign_count", (QFilter[])filete.toArray());
        if (expense != null) {
            QFilter filete1 = new QFilter("expense_id", "=", expense.get("expense_id"));
            QFilter filete2 = new QFilter("entityid", "=", expense.get("entityid"));
            QFilter filete3 = new QFilter("resource", "=", expense.get("resource"));
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{filete1, filete2, filete3});
            ArrayList list = new ArrayList(collect.size());
            collect.forEach(obj -> list.add(obj.getString("serial_no")));
            if (!list.isEmpty()) {
                List<String> invoiceFieldList = this.getFields();
                QFilter fileteinvoice = new QFilter("serial_no", "in", list);
                String fields = invoiceFieldList.stream().collect(Collectors.joining(","));
                DynamicObjectCollection invoiceList = QueryServiceHelper.query((String)"rim_invoice", (String)fields, (QFilter[])fileteinvoice.toArray());
                this.getModel().deleteEntryData("entryentity");
                int singCount = 0;
                for (DynamicObject obj2 : invoiceList) {
                    int row = this.getModel().createNewEntryRow("entryentity");
                    for (String field : invoiceFieldList) {
                        this.getModel().setValue(field, obj2.get(field), row);
                    }
                    if (!"1".equals(obj2.getString("original_state"))) continue;
                    ++singCount;
                }
                if (expense.getInt("invoice_count") != invoiceList.size() || expense.getInt("sign_count") != singCount) {
                    DynamicObject upate = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense");
                    upate.set("id", (Object)expenseId);
                    upate.set("invoice_count", (Object)invoiceList.size());
                    upate.set("sign_count", (Object)singCount);
                    if (singCount > 0) {
                        if (singCount == invoiceList.size()) {
                            upate.set("original_state", (Object)"1");
                        } else {
                            upate.set("original_state", (Object)"2");
                        }
                    } else {
                        upate.set("original_state", (Object)"0");
                    }
                    SaveServiceHelper.update((DynamicObject)upate);
                }
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        String serialNo = (String)this.getModel().getValue("serial_no", row);
        OpenInvoiceDetailService.openEditViewBySerialNo((AbstractFormPlugin)this, serialNo);
    }

    private List<String> getFields() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        List controlList = grid.getControls();
        ArrayList<String> list = new ArrayList<String>(controlList.size());
        for (Control control : controlList) {
            if (control instanceof OperationColumn) continue;
            list.add(control.getKey());
        }
        return list;
    }
}

