/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.InvoiceInfoLabelService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CurrencyUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConfigUtils;
import kd.imc.rim.formplugin.query.OpenInvoiceDetailService;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang3.StringUtils;

public class FpzsInvoiceLisNewtPlugin
extends AbstractListPlugin
implements Consumer<PackageDataEvent> {
    public static final String BILL_LIST_AP = "billlistap";
    public static final String DELETE_USER_INVOICE_BUTTON = "bardelete";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.addListRowDoubleClickListener((ListRowClickListener)this);
    }

    public void initialize() {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.addPackageDataListener(this::packageData);
    }

    public void afterCreateNewData(EventObject e) {
        InvoiceInfoLabelService service;
        if (!InvoiceConfigUtils.showInvoiceInfo()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_info"});
        }
        if ((service = new InvoiceInfoLabelService()).isShowLabel()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"invoice_info"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"invoice_info_label"});
        }
        this.getModel().beginInit();
        this.getModel().setValue("start_date", (Object)DateUtils.addYear((Date)new Date(), (int)-1));
        this.getModel().setValue("end_date", (Object)new Date());
        this.getModel().endInit();
        this.loadData();
        this.initDeleteOperateColumnVisible();
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
    }

    @SdkDeprecated
    public void itemClick(ItemClickEvent evt) {
        if (StringUtils.equals((CharSequence)"baritemap1", (CharSequence)evt.getItemKey())) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            HashMap<String, ArrayList<Object>> customParams = new HashMap<String, ArrayList<Object>>(8);
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u518d\u6267\u884c\u5bfc\u5165\u64cd\u4f5c", (String)"FpzsInvoiceLisNewtPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> primaryKeys = new ArrayList<Long>(8);
            for (ListSelectedRow selectedRow : selectedRows) {
                if (ObjectUtils.isEmpty((Object)selectedRow)) continue;
                primaryKeys.add((Long)selectedRow.getPrimaryKeyValue());
            }
            if (!CollectionUtils.isEmpty(primaryKeys)) {
                customParams.put("invoiceIds", primaryKeys);
                Map preCustomParams = this.getView().getFormShowParameter().getCustomParams();
                customParams.put("isPerson", (ArrayList<Object>)preCustomParams.get("isPerson"));
            }
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("status".equals(name) || "start_date".equals(name) || "end_date".equals(name) || "search_text".equals(name) || "original_state".equals(name)) {
            this.loadData();
        }
    }

    private void loadData() {
        Date start = (Date)this.getModel().getValue("start_date");
        Date end = (Date)this.getModel().getValue("end_date");
        String status = (String)this.getModel().getValue("status");
        String originalState = (String)this.getModel().getValue("original_state");
        String searchText = (String)this.getModel().getValue("search_text");
        QFilter filter = new QFilter("delete", "=", (Object)"1");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long userId = FpzsMainService.getUserId((Map)customParams);
        if ("operate_company_invoice".equals(customParams.get("listType"))) {
            long orgId = BigDecimalUtil.transDecimal(customParams.get("orgId")).longValue();
            if (orgId < 1L) {
                orgId = RequestContext.get().getOrgId();
            }
            filter = filter.and(new QFilter("collect_org_entry.collect_org", "=", (Object)orgId));
        } else {
            filter = filter.and(new QFilter("collect_user_entry.collect_user", "=", (Object)userId));
            Object rimUser = customParams.get("rim_user");
            if (rimUser != null) {
                filter = filter.and(new QFilter("collect_user_entry.rim_user", "=", rimUser));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)originalState)) {
            filter = filter.and(new QFilter("original_state", "=", (Object)originalState));
        }
        if ("0".equals(status)) {
            filter = filter.and(new QFilter("expense_status", "=", (Object)"1"));
        } else if (!StringUtils.isEmpty((CharSequence)status)) {
            filter = filter.and(new QFilter("expense_status", "!=", (Object)"1"));
        }
        if (start != null) {
            filter = filter.and(new QFilter("createtime", ">=", (Object)DateUtils.trunc((Date)start)));
        }
        if (end != null) {
            filter = filter.and(new QFilter("createtime", "<=", (Object)DateUtils.trunc((Date)DateUtils.addDay((Date)end, (int)1))));
        }
        if (!StringUtils.isEmpty((CharSequence)searchText)) {
            filter = filter.and(new QFilter("saler_name", "like", (Object)("%" + searchText + "%")));
        }
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(filter);
        fp.setOrderBy("createtime desc");
        billList.setFilterParameter(fp);
        billList.refresh();
        this.getPageCache().put("filters", filter.toSerializedString());
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String key = columnDesc.getKey();
        if ("total_amount".equals(key) || "total_tax_amount".equals(key)) {
            DynamicObject rowData = e.getRowData();
            BigDecimal amount = rowData.getBigDecimal(key);
            long currencyId = DynamicObjectUtil.getDynamicObjectLongValue((Object)rowData.get("currencyid"));
            Integer amtPrecision = CurrencyUtils.getAmtPrecision((Long)currencyId);
            if (null != amtPrecision && 2 != amtPrecision) {
                String format = CurrencyUtils.getDeliFormatByPrecision((int)amtPrecision);
                String result = BigDecimalUtil.format((BigDecimal)amount, (String)format);
                e.setFormatValue((Object)result);
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        OpenInvoiceDetailService.openEditViewByMainId((AbstractFormPlugin)this, (Long)currentListSelectedRow.getPrimaryKeyValue());
    }

    private void initDeleteOperateColumnVisible() {
        this.getView().setVisible(Boolean.valueOf(this.isPersonInvoice()), new String[]{"listdeletenap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("donothing".equals(afterDoOperationEventArgs.getOperateKey())) {
            if (!this.isPersonInvoice()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u7968\u5939\u5217\u8868\u4e0d\u652f\u6301\u5220\u9664\u53d1\u7968", (String)"FpzsInvoiceLisNewtPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            ListSelectedRow currentListSelectedRow = billList.getCurrentSelectedRowInfo();
            if (currentListSelectedRow == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"FpzsInvoiceLisNewtPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"FpzsInvoiceLisNewtPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"FpzsInvoiceLisNewtPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u6570\u636e\u65e0\u6cd5\u67e5\u770b\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"FpzsInvoiceLisNewtPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener(DELETE_USER_INVOICE_BUTTON, (IFormPlugin)this), btnNameMaps);
        }
    }

    private boolean isPersonInvoice() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String listType = String.valueOf(customParams.get("listType"));
        return "operate_person_invoice".equals(listType);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (DELETE_USER_INVOICE_BUTTON.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList billlistap = (BillList)this.getView().getControl(BILL_LIST_AP);
            Long primaryKeyValue = (Long)billlistap.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            InvoiceSaveService invoiceSaveService = new InvoiceSaveService();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long userId = FpzsMainService.getUserId((Map)customParams);
            Long rimUser = FpzsMainService.getRimUser((Map)customParams);
            invoiceSaveService.deleteRelation(primaryKeyValue, userId, rimUser);
            billlistap.clearSelection();
            billlistap.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"FpzsInvoiceLisNewtPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    public void beforeBindData(EventObject e) {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        final InvoiceInfoLabelService service = new InvoiceInfoLabelService();
        if (service.isShowLabel()) {
            billList.addPackageDataListener((Consumer)new Consumer<PackageDataEvent>(){

                @Override
                public void accept(PackageDataEvent e) {
                    DynamicTextColumnDesc column;
                    Object col = e.getSource();
                    if (col instanceof DynamicTextColumnDesc && "invoice_info_label".equals((column = (DynamicTextColumnDesc)col).getFieldKey())) {
                        String lable = service.getInvoiceInfoText(e.getRowData().getString("invoice_info"));
                        e.setFormatValue((Object)lable);
                    }
                }
            });
        }
    }

    @Override
    public void accept(PackageDataEvent packageDataEvent) {
    }
}

