/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.aws.ofd.util.analysis.OfdReadUtils;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AesUtil;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.FormFileEntity;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.RimUserService;
import kd.imc.rim.file.model.FileConvertResult;
import kd.imc.rim.file.pdfanalysis.PdfAnalysisService;
import kd.imc.rim.file.utils.FileConvertUtils;
import kd.imc.rim.file.utils.SignatureUtils;
import kd.imc.rim.formplugin.message.service.AwsSyncExpenseOpenService;
import kd.imc.rim.formplugin.message.service.AwsSyncSerialOpenService;
import kd.imc.rim.formplugin.message.service.InvoiceUpdateOpenService;
import kd.imc.rim.upgrade.DownConfigUpgradeService;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class FpzsTestPlugin
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener {
    private static Log LOGGER = LogFactory.getLog(FpzsTestPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        Toolbar toolbarap = (Toolbar)this.getView().getControl("toolbarap");
        toolbarap.addUploadListener((UploadListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("expenseid", (Object)System.currentTimeMillis());
        this.getModel().setValue("expense_num", (Object)System.currentTimeMillis());
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        JSONObject result = new JSONObject();
        for (Object url : urls) {
            String urlStr = String.valueOf(url);
            result.put("file", (Object)urlStr);
            if (!fileService.exists(urlStr)) continue;
            String fileType = FileUtils.getFileType((String)urlStr);
            long start = System.currentTimeMillis();
            byte[] byteArray = FileUtils.getByte((InputStream)fileService.getInputStream(urlStr));
            result.put("getByte", (Object)(System.currentTimeMillis() - start));
            Boolean isOriginal = SignatureUtils.isOriginal((byte[])byteArray, (String)fileType);
            result.put("SignatureUtils", (Object)(System.currentTimeMillis() - start));
            result.put("isOriginal", (Object)isOriginal);
            FileConvertResult convertResult = FileConvertUtils.convert((byte[])byteArray, (String)fileType);
            result.put("convertResult", (Object)convertResult);
            result.put("convert", (Object)(System.currentTimeMillis() - start));
            if ("pdf".equals(fileType)) {
                JSONObject pdfInvoice = PdfAnalysisService.analysis((byte[])byteArray, (boolean)false);
                result.put("invoice", (Object)pdfInvoice);
                continue;
            }
            if (!"ofd".equals(fileType)) continue;
            result.put("invoice", (Object)OfdReadUtils.readData((byte[])byteArray));
        }
        this.getView().showMessage(result.toJSONString());
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("import".equals(key)) {
            this.importInvoice();
        }
        if ("edit".equals(key)) {
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            customParams.put("serialNo", (String)this.getModel().getValue("tax_no", 0));
            customParams.put("editAllow", Boolean.TRUE);
            customParams.put("resource", ResManager.loadKDString((String)"\u53d1\u7968\u52a9\u624b4", (String)"FpzsTestPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            param.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u7f16\u8f91", (String)"FpzsTestPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("rim_inv_collect_edit");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_inv_collect_edit");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
        if ("view".equals(key)) {
            this.viewInvoice();
        }
        if ("savevoucher".equals(key)) {
            this.saveVoucher("");
        }
        if ("delete".equals(key)) {
            this.deleteInvoice();
        }
        if ("save".equals(key)) {
            this.saveInvoice("1");
        }
        if ("submit".equals(key)) {
            this.saveInvoice("30");
        }
        if ("query".equals(key)) {
            this.queryInvoice();
        }
        if ("socket".equals(key)) {
            this.socket();
        }
        if ("operate".equals(key)) {
            this.operate();
        }
        if ("del_attach".equals(key)) {
            this.showAttachDel();
        }
        if ("send_bds".equals(key)) {
            this.sendBds();
        }
        if ("request_aws".equals(key)) {
            this.requestAws();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestAws() {
        ImcConfigUtil.removeCache((String)"dim_imc_config_fpy");
        Map map = ImcConfigUtil.getValue((String)"dim_imc_config_fpy");
        String url = (String)map.get("dim_imc_config_fpy_url") + "/base/oauth/token";
        String clientId = (String)map.get("dim_imc_config_fpy_clientid");
        String proxy = (String)map.get("dim_imc_config_fpy_proxy");
        String clientSecret = (String)map.get("dim_imc_config_fpy_clientsecret");
        CloseableHttpClient client = HttpUtil.getConnection((String)proxy);
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5Hex((String)(clientId + clientSecret + timestamp));
        JSONObject param = new JSONObject();
        param.put("client_id", (Object)clientId);
        param.put("sign", (Object)sign);
        param.put("timestamp", (Object)timestamp);
        String rs = null;
        try {
            post.setHeader("Content-Type", "application/json");
            post.setHeader("Accept", "application/json");
            StringEntity httpEntity = new StringEntity(param.toJSONString(), "UTF-8");
            post.setEntity((HttpEntity)httpEntity);
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                rs = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
            if (statusCode == 200 || statusCode == 500) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u6210\u529f[%1$s]statusCode[%2$s]statusCode[%3$s]", (String)"FpzsTestPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), url, statusCode, rs));
            } else {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25[%1$s]statusCode[%2$s]statusCode[%3$s]", (String)"FpzsTestPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), url, statusCode, rs));
            }
        }
        catch (Exception e) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25[%1$s]error[%2$s]", (String)"FpzsTestPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), url, e.getMessage()));
            return;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
            try {
                post.abort();
                post.releaseConnection();
            }
            catch (Exception exception) {}
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject data = (JSONObject)closedCallBackEvent.getReturnData();
        if (data != null) {
            JSONArray list = data.getJSONArray("invoiceData");
            if (list != null) {
                for (Object obj : list) {
                    Map map = (Map)obj;
                    int index = this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("serial_no", map.get("serialNo"), index);
                    this.getModel().setValue("invoice_code", map.get("invoiceCode"), index);
                    this.getModel().setValue("invoice_no", map.get("invoiceNo"), index);
                    this.getModel().setValue("use_amount", (Object)BigDecimalUtil.transDecimal(map.get("availableAmount")), index);
                }
            }
            this.getView().showMessage(SerializationUtils.toJsonString((Object)data));
        }
    }

    public void importInvoice() {
        DynamicObject typeObject;
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("billId", this.getModel().getValue("expenseid"));
        customParams.put("billNo", this.getModel().getValue("expense_num"));
        customParams.put("showBillData", this.getModel().getValue("showbilldata"));
        String resource = (String)this.getModel().getValue("resource");
        if (StringUtils.isEmpty((CharSequence)resource) && StringUtils.isEmpty((CharSequence)(resource = RimConfigUtils.getConfig((String)"fpzs_test_resource")))) {
            resource = ResManager.loadKDString((String)"\u53d1\u7968\u52a9\u624b4", (String)"FpzsTestPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        customParams.put("resource", resource);
        customParams.put("sourceSys", "fpzsTest");
        customParams.put("viewPage", "fpzsTest");
        String entityId = (String)this.getModel().getValue("entityid");
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            entityId = "fpzsTest";
        }
        customParams.put("entityId", entityId);
        String extenduserId = RimConfigUtils.getConfig((String)"fpzs_test_rim_user");
        if (StringUtils.isNotEmpty((CharSequence)extenduserId)) {
            String openId = RimUserService.getOpenid((RequestContext)RequestContext.get(), (String)resource, (String)extenduserId);
            Long rimUser = RimUserService.createRimUser((String)extenduserId, (String)resource, (String)"third", (String)openId, (String)"");
            customParams.put("rim_user", rimUser);
        }
        if ((typeObject = (DynamicObject)this.getModel().getValue("bill_type")) != null) {
            customParams.put("billType", typeObject.getString("number"));
        }
        customParams.put("orgId", DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("orgid")));
        String show = (String)this.getModel().getValue("show");
        if ("0".equals(show)) {
            customParams.put("delete", "2");
        }
        ArrayList list = new ArrayList(8);
        int total = this.getModel().getEntryRowCount("company_info");
        for (int i = 0; i < total; ++i) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("taxNo", (String)this.getModel().getValue("tax_no", i));
            map.put("name", (String)this.getModel().getValue("company_name", i));
            list.add(map);
        }
        customParams.put("companyInfo", list);
        ArrayList salerList = new ArrayList(8);
        int salerTotal = this.getModel().getEntryRowCount("saler_info");
        for (int i = 0; i < salerTotal; ++i) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("taxNo", (String)this.getModel().getValue("saler_tax_no", i));
            map.put("name", (String)this.getModel().getValue("saler_name", i));
            salerList.add(map);
        }
        customParams.put("salerInfo", salerList);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_fpzs_main");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_fpzs_main");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    public void viewInvoice() {
        FormShowParameter param = new FormShowParameter();
        ArrayList<String> taxNoList = new ArrayList<String>(8);
        DynamicObjectCollection existedInvoices = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)existedInvoices)) {
            for (DynamicObject existedInvoice : existedInvoices) {
                taxNoList.add(existedInvoice.getString("serial_no"));
            }
        }
        ArrayList<String> attachList = null;
        DynamicObjectCollection existedAttaches = this.getModel().getEntryEntity("attachinfo");
        if (!CollectionUtils.isEmpty((Collection)existedAttaches)) {
            attachList = new ArrayList<String>(existedAttaches.size());
            for (DynamicObject attach : existedAttaches) {
                String serialNo = attach.getString("attach_no");
                if (!StringUtils.isNotBlank((CharSequence)serialNo)) continue;
                attachList.add(serialNo);
            }
        }
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("bill_type");
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        if (typeObject != null) {
            customParams.put("billType", typeObject.getString("number"));
        }
        customParams.put("expenseId", this.getModel().getValue("expenseid"));
        customParams.put("sourceSys", "fpzsTest");
        customParams.put("viewPage", "fpzsTest");
        this.setResouceAndEntityid(customParams);
        customParams.put("serialList", taxNoList);
        if (attachList != null && attachList.size() > 0) {
            customParams.put("attachList", attachList);
        }
        if (StringUtils.equals((CharSequence)this.getPageCache().get("relevanceExpenseId"), (CharSequence)"1")) {
            String extParam = (String)this.getModel().getValue("param_text_tag");
            ArrayList relevanceExpenseIds = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)extParam)) {
                String[] split = extParam.split(",");
                relevanceExpenseIds.addAll(Arrays.stream(split).collect(Collectors.toList()));
            }
            customParams.put("relevanceExpenseId", relevanceExpenseIds);
            this.getPageCache().remove("relevanceExpenseId");
        }
        ArrayList list = new ArrayList(8);
        int total = this.getModel().getEntryRowCount("company_info");
        for (int i = 0; i < total; ++i) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("taxNo", (String)this.getModel().getValue("tax_no", i));
            map.put("name", (String)this.getModel().getValue("company_name", i));
            list.add(map);
        }
        customParams.put("companyInfo", list);
        ArrayList salerList = new ArrayList(8);
        int salerTotal = this.getModel().getEntryRowCount("saler_info");
        for (int i = 0; i < salerTotal; ++i) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("taxNo", (String)this.getModel().getValue("saler_tax_no", i));
            map.put("name", (String)this.getModel().getValue("saler_name", i));
            salerList.add(map);
        }
        customParams.put("salerInfo", salerList);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_view_invoice");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_view_invoice");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    public void saveInvoice(String status) {
        int total;
        DynamicObject typeObject;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("billId", this.getModel().getValue("expenseid"));
        map.put("billNo", this.getModel().getValue("expense_num"));
        map.put("sourceSys", "fpzsTest");
        map.put("viewPage", "fpzsTest");
        this.setResouceAndEntityid(map);
        map.put("status", status);
        if (this.getModel().getValue("expenseid") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u9500\u5355id\u4e3a\u7a7a", (String)"FpzsTestPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if ((typeObject = (DynamicObject)this.getModel().getValue("bill_type")) != null) {
            map.put("billType", typeObject.getString("number"));
        }
        if ((total = this.getModel().getEntryRowCount("entryentity")) == 0) {
            total = 2;
        }
        ArrayList list = new ArrayList(2);
        for (int i = 0; i < total; ++i) {
            HashMap<String, Object> map11 = new HashMap<String, Object>();
            map11.put("serialNo", this.getModel().getValue("serial_no", i));
            map11.put("useAmount", this.getModel().getValue("use_amount", i));
            map11.put("deductionFlag", "1");
            map11.put("status", status);
            list.add(map11);
        }
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("orgid"));
        if (orgId > 0L) {
            map.put("orgId", orgId);
        }
        String cove_no = (String)this.getModel().getValue("cover_no");
        String cove_url = (String)this.getModel().getValue("cover_url");
        if (StringUtils.isNotEmpty((CharSequence)cove_no)) {
            JSONObject coverData = new JSONObject();
            coverData.put("coveNo", (Object)cove_no);
            String retStr = Base64.encodeBase64String((byte[])FileUtils.getAttachmentByte((String)cove_url));
            coverData.put("base64", (Object)retStr);
            map.put("coverData", coverData);
        }
        map.put("invoiceData", list);
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"save", (Object[])new Object[]{map});
        if ("0000".equals(result.getString("errcode"))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"FpzsTestPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(result.getString("description"));
        }
    }

    private void setResouceAndEntityid(Map<String, Object> map) {
        String entityId;
        String resource = (String)this.getModel().getValue("resource");
        if (StringUtils.isEmpty((CharSequence)resource) && StringUtils.isEmpty((CharSequence)(resource = RimConfigUtils.getConfig((String)"fpzs_test_resource")))) {
            resource = ResManager.loadKDString((String)"\u53d1\u7968\u52a9\u624b4", (String)"FpzsTestPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)(entityId = (String)this.getModel().getValue("entityid")))) {
            entityId = "fpzsTest";
        }
        map.put("entityId", entityId);
        map.put("resource", resource);
    }

    public void sendBds() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("billId", this.getModel().getValue("expenseid"));
        customParams.put("billNo", this.getModel().getValue("expense_num"));
        customParams.put("entityId", "fpzsTest");
        Object o = DispatchServiceHelper.invokeBizService((String)"imc", (String)"bds", (String)"BillService", (String)"receiveBill", (Object[])new Object[]{customParams});
    }

    public void showAttachDel() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("rim_fpzs_attach_delete");
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("billId", this.getModel().getValue("expenseid"));
        customParams.put("entityId", "fpzsTest");
        customParams.put("resource", ResManager.loadKDString((String)"\u53d1\u7968\u52a9\u624b4", (String)"FpzsTestPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        customParams.put("queryDb", Boolean.TRUE);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_fpzs_attach_delete");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    public void deleteInvoice() {
        DynamicObject typeObject;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("billId", this.getModel().getValue("expenseid"));
        map.put("billNo", this.getModel().getValue("expense_num"));
        map.put("sourceSys", "fpzsTest");
        map.put("viewPage", "fpzsTest");
        map.put("entityId", "fpzsTest");
        if (this.getModel().getValue("expenseid") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u9500\u5355id\u4e3a\u7a7a", (String)"FpzsTestPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if ((typeObject = (DynamicObject)this.getModel().getValue("bill_type")) != null) {
            map.put("billType", typeObject.getString("number"));
        }
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"delete", (Object[])new Object[]{map});
        this.getView().showMessage(SerializationUtils.toJsonString((Object)result));
    }

    public void queryInvoice() {
        ArrayList<String> list = new ArrayList<String>(2);
        int total = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < total; ++i) {
            list.add((String)this.getModel().getValue("serial_no", i));
        }
        ApiResult result = (ApiResult)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"query", (Object[])new Object[]{list});
        this.getView().showMessage(SerializationUtils.toJsonString((Object)result));
    }

    public void socket() {
        String identifytype = (String)this.getModel().getValue("tax_no", 0);
        String msg = (String)this.getModel().getValue("company_name", 0);
        MsgSendFactory.getSender().send(identifytype, msg);
        this.getView().showMessage(identifytype + "  " + msg);
    }

    public void saveVoucher(String status) {
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        HashMap<String, String> voucherInfo = new HashMap<String, String>();
        voucherInfo.put("vouchId", "billId21221");
        voucherInfo.put("vouchNo", "billNo2122");
        voucherInfo.put("accountDate", "2021-02-03");
        ArrayList<String> list = new ArrayList<String>();
        list.add("0cfc56dcca9642e5b6bfa9166c3b734b0");
        list.add("783cd4339dce417eaed769f0ede610af0");
        map.put("serialNoArray", list);
        map.put("voucherInfo", voucherInfo);
        ApiResult result = (ApiResult)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"saveVoucher", (Object[])new Object[]{map});
        if ("0000".equals(result.getErrorCode())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"FpzsTestPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(result.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operate() {
        String method = (String)this.getModel().getValue("method");
        String param = (String)this.getModel().getValue("param_text_tag");
        if (StringUtils.isEmpty((CharSequence)method)) {
            method = this.getPageCache().get("method");
        } else {
            this.getPageCache().put("method", method);
        }
        if ("schedule".equals(method)) {
            try {
                RequestContext context = RequestContext.get();
                AbstractTask task = (AbstractTask)Class.forName(param).newInstance();
                task.execute(context, null);
            }
            catch (Exception e) {
                throw new MsgException((Throwable)e, ResManager.loadKDString((String)"\u9519\u8bef", (String)"FpzsTestPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
        if ("syncExpenseInfo".equals(method)) {
            AwsSyncExpenseOpenService service = new AwsSyncExpenseOpenService();
            JSONArray array = JSONArray.parseArray((String)param);
            ApiResult result = service.doBusiness((Object)array);
            this.getView().showMessage(SerializationUtils.toJsonString((Object)result));
        } else if ("qd".equals(method)) {
            JSONObject json = JSONObject.parseObject((String)param);
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>(8);
            JSONArray array = json.getJSONArray("f");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject fj = array.getJSONObject(i);
                qfilters.add(new QFilter(fj.getString("p"), fj.getString("c"), fj.get((Object)"v")));
            }
            DynamicObjectCollection collection = QueryServiceHelper.query((String)json.getString("t"), (String)json.getString("s"), (QFilter[])qfilters.toArray(new QFilter[0]), null, (int)1000);
            List reulst = DynamicObjectUtil.dynamicObjectslist2ListMap((List)collection);
            this.getView().showMessage(SerializationUtils.toJsonString((Object)reulst));
        } else if ("updateInvoiceMain".equals(method)) {
            ExpenseService service = new ExpenseService();
            JSONArray array = JSONArray.parseArray((String)param);
            ArrayList<String> serial = new ArrayList<String>(8);
            for (int i = 0; i < array.size(); ++i) {
                serial.add(array.getString(i));
            }
            service.updateInvoiceMain(serial, null);
        } else if ("syncSerial".equals(method)) {
            AwsSyncSerialOpenService service = new AwsSyncSerialOpenService();
            JSONObject jsonObj = JSONObject.parseObject((String)param);
            ApiResult result = service.doBusiness((Object)jsonObj);
            this.getView().showMessage(SerializationUtils.toJsonString((Object)result));
        } else if (method.indexOf("FpzsAwsService.") >= 0) {
            JSONObject json = JSONObject.parseObject((String)param);
            Object result = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsAwsService", (String)method.replace("FpzsAwsService.", ""), (Object[])new Object[]{json});
            this.getView().showMessage(SerializationUtils.toJsonString((Object)result));
        } else if (method.indexOf("InputService.") >= 0) {
            JSONObject json = JSONObject.parseObject((String)param);
            Object result = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"InputService", (String)method.replace("InputService.", ""), (Object[])new Object[]{json});
            this.getView().showMessage(SerializationUtils.toJsonString((Object)result));
        } else if ("InvoiceUpdateOpenService".equals(method)) {
            InvoiceUpdateOpenService service = new InvoiceUpdateOpenService();
            ApiResult result = service.doBusiness((Object)param);
            this.getView().showMessage(SerializationUtils.toJsonString((Object)result));
        } else if ("removeCache".equals(method)) {
            ImcConfigUtil.removeCache((String)param);
        } else if ("getCache".equals(method)) {
            Map map = ImcConfigUtil.getValue((String)param);
            this.getView().showMessage(SerializationUtils.toJsonString((Object)map));
        } else if ("getStringCache".equals(method)) {
            String value = CacheHelper.get((String)param);
            this.getView().showMessage(value);
        } else {
            if ("setCache".equals(method)) {
                try {
                    JSONObject paramJson = JSONObject.parseObject((String)param);
                    String data = paramJson.getString("data");
                    String cacheKey = paramJson.getString("cacheKey");
                    if (StringUtils.isEmpty((CharSequence)cacheKey) || StringUtils.isEmpty((CharSequence)data)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"FpzsTestPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String dataTag = AesUtil.base64DecodeToString((String)data);
                    if (StringUtils.isEmpty((CharSequence)dataTag)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u6570data\u9519\u8bef", (String)"FpzsTestPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    }
                    CacheHelper.put((String)cacheKey, (String)dataTag);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"FpzsTestPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("001", String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u5931\u8d25", (String)"FpzsTestPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), param)), new Object[0]);
                }
            }
            if ("updateDownLog".equals(method)) {
                try {
                    String batchNos;
                    JSONObject paramJson = JSONObject.parseObject((String)param);
                    String govStatus = paramJson.getString("govStatus");
                    String queryStatus = paramJson.getString("queryStatus");
                    String totalNum = paramJson.getString("totalNum");
                    String applyDate = paramJson.getString("applyDate");
                    Date startDate = paramJson.getDate("startDate");
                    Date endDate = paramJson.getDate("endDate");
                    String taxNos = paramJson.getString("taxNos");
                    String inout = paramJson.getString("inout");
                    Integer applyStep = paramJson.getInteger("applyStep");
                    if (StringUtils.isEmpty((CharSequence)govStatus)) {
                        govStatus = "6";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(batchNos = paramJson.getString("batchNos"))) || StringUtils.isNotEmpty((CharSequence)taxNos)) {
                        Object[] objects;
                        QFilter batchFilter = null;
                        if (StringUtils.isNotEmpty((CharSequence)batchNos)) {
                            batchNos = batchNos.replaceAll("\\s*|\t|\r|\n", "");
                            batchFilter = new QFilter("batch_no", "in", (Object)CommonUtils.getMultiValues((String)batchNos));
                        }
                        QFilter taxFilter = null;
                        if (StringUtils.isNotEmpty((CharSequence)taxNos)) {
                            taxNos = taxNos.replaceAll("\\s*|\t|\r|\n", "");
                            taxFilter = new QFilter("tax_no", "in", (Object)CommonUtils.getMultiValues((String)taxNos));
                        }
                        QFilter statusFilter = null;
                        if (StringUtils.isNotEmpty((CharSequence)queryStatus)) {
                            statusFilter = new QFilter("gov_status", "in", (Object)CommonUtils.getMultiValues((String)queryStatus));
                        }
                        QFilter inoutFilter = null;
                        if (StringUtils.isNotBlank((CharSequence)inout)) {
                            inoutFilter = new QFilter("inout", "in", (Object)CommonUtils.getMultiValues((String)inout));
                        }
                        QFilter startFilter = null;
                        if (startDate != null) {
                            startFilter = new QFilter("invoice_startdate", ">=", (Object)startDate);
                        }
                        QFilter endFilter = null;
                        if (endDate != null) {
                            endFilter = new QFilter("invoice_startdate", "<=", (Object)endDate);
                        }
                        if (!ObjectUtils.isEmpty((Object[])(objects = BusinessDataServiceHelper.load((String)"rim_down_log", (String)"id,gov_status,total_num,apply_date,modifytime,apply_step", (QFilter[])new QFilter[]{batchFilter, taxFilter, inoutFilter, statusFilter, startFilter, endFilter})))) {
                            for (Object object : objects) {
                                object.set("gov_status", (Object)govStatus);
                                object.set("modifytime", (Object)new Date());
                                if (StringUtils.isNotEmpty((CharSequence)totalNum)) {
                                    object.set("total_num", (Object)Integer.parseInt(totalNum));
                                }
                                if (StringUtils.isNotEmpty((CharSequence)applyDate)) {
                                    object.set("apply_date", (Object)DateUtils.stringToDate((String)applyDate));
                                }
                                if (applyStep == null || applyStep <= 0) continue;
                                object.set("apply_step", (Object)applyStep);
                            }
                            SaveServiceHelper.save((DynamicObject[])objects);
                        }
                    } else {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsTestPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("001", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u5931\u8d25", (String)"FpzsTestPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), param)), new Object[0]);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"FpzsTestPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else if ("againApply".equals(method)) {
                try {
                    JSONObject paramJson = JSONObject.parseObject((String)param);
                    String syncType = paramJson.getString("syncType");
                    Date startTime = paramJson.getDate("startTime");
                    Date endTime = paramJson.getDate("endTime");
                    String downloadErrcode = paramJson.getString("downloadErrcode");
                    String batchNos = paramJson.getString("batchNos");
                    if (StringUtils.isEmpty((CharSequence)batchNos) && startTime == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u548c\u65f6\u95f4\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"FpzsTestPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    QFilter qFilter = new QFilter("inout", "in", (Object)new String[]{"1", "2", "6"});
                    if (StringUtils.isNotEmpty((CharSequence)syncType)) {
                        qFilter.and("sync_type", "=", (Object)syncType);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)batchNos)) {
                        batchNos = batchNos.replaceAll("\\s*|\t|\r|\n", "");
                        qFilter.and("batch_no", "in", (Object)CommonUtils.getMultiValues((String)batchNos));
                    } else {
                        String govStatus = paramJson.getString("govStatus");
                        String taxNos = paramJson.getString("taxNos");
                        if (StringUtils.isEmpty((CharSequence)govStatus)) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsTestPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        Object taxFilter = null;
                        if (StringUtils.isNotEmpty((CharSequence)taxNos)) {
                            taxNos = taxNos.replaceAll("\\s*|\t|\r|\n", "");
                            qFilter.and("tax_no", "in", (Object)CommonUtils.getMultiValues((String)taxNos));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)downloadErrcode)) {
                            qFilter.and("download_errcode", "=", (Object)downloadErrcode);
                        }
                        qFilter.and("gov_status", "=", (Object)govStatus);
                        qFilter.and("createtime", ">=", (Object)startTime);
                        if (endTime != null) {
                            qFilter.and("createtime", "<=", (Object)endTime);
                        }
                    }
                    DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"rim_down_log", (String)"id,tax_no,inout", (QFilter[])qFilter.toArray());
                    if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                        String taxNo = "";
                        long id = 0L;
                        InputOutInvoiceApplyService inputOutInvoiceApplyService = null;
                        for (DynamicObject dynamicObject : dynamicObjects) {
                            id = dynamicObject.getLong("id");
                            taxNo = dynamicObject.getString("tax_no");
                            String inout = dynamicObject.getString("inout");
                            inputOutInvoiceApplyService = "6".equals(inout) ? InvoiceDownServiceFactory.newInstanceForInitApply((String)taxNo) : InvoiceDownServiceFactory.newInstanceForApply((String)taxNo);
                            if (inputOutInvoiceApplyService == null) continue;
                            inputOutInvoiceApplyService.againApply(Long.valueOf(id));
                        }
                    }
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("001", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u5931\u8d25", (String)"FpzsTestPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), param)), new Object[0]);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"FpzsTestPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else if ("updateDownInput".equals(method)) {
                try {
                    Object[] objects;
                    JSONObject paramJson = JSONObject.parseObject((String)param);
                    String serialNos = "";
                    String inout = "";
                    String syncStatus = "";
                    if (paramJson != null) {
                        serialNos = paramJson.getString("serialNos");
                        inout = paramJson.getString("inout");
                        syncStatus = paramJson.getString("syncStatus");
                    }
                    if (StringUtils.isEmpty((CharSequence)syncStatus)) {
                        syncStatus = "0";
                    }
                    QFilter qFilter = new QFilter("sync_status", "=", (Object)syncStatus);
                    if (StringUtils.isNotEmpty((CharSequence)inout)) {
                        qFilter.and("inout", "=", (Object)inout);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)serialNos)) {
                        qFilter.and("serial_no", "in", (Object)CommonUtils.getMultiValues((String)serialNos));
                    }
                    if (!ObjectUtils.isEmpty((Object[])(objects = BusinessDataServiceHelper.load((String)"rim_down_input", (String)"id,handle_num,sync_status,modifytime", (QFilter[])qFilter.toArray())))) {
                        for (Object object : objects) {
                            object.set("sync_status", (Object)"2");
                            object.set("modifytime", (Object)new Date());
                            object.set("handle_num", (Object)0);
                        }
                        SaveServiceHelper.save((DynamicObject[])objects);
                    }
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("001", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u5931\u8d25", (String)"FpzsTestPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), param)), new Object[0]);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"FpzsTestPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else if ("initDownConfig".equals(method)) {
                try {
                    DownConfigUpgradeService downConfigUpgradeService = new DownConfigUpgradeService();
                    downConfigUpgradeService.afterExecuteSqlWithResult("a", "a", "taxc", "s");
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("001", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u5931\u8d25", (String)"FpzsTestPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), param)), new Object[0]);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"FpzsTestPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else if ("updateDownInit".equals(method)) {
                try {
                    QFilter qFilter;
                    Object[] objects;
                    JSONObject paramJson = JSONObject.parseObject((String)param);
                    String numbers = paramJson.getString("numbers");
                    Date startTime = paramJson.getDate("startTime");
                    if (StringUtils.isNotEmpty((CharSequence)numbers) && startTime != null && !ObjectUtils.isEmpty((Object[])(objects = BusinessDataServiceHelper.load((String)"rim_down_init", (String)"id,begin,end,modifydate", (QFilter[])(qFilter = new QFilter("number", "in", (Object)CommonUtils.getMultiValues((String)(numbers = numbers.replaceAll("\\s*|\t|\r|\n", ""))))).toArray())))) {
                        for (Object object : objects) {
                            object.set("modifydate", (Object)new Date());
                            object.set("end", null);
                            object.set("begin", (Object)startTime);
                        }
                        SaveServiceHelper.save((DynamicObject[])objects);
                    }
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("001", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u5931\u8d25", (String)"FpzsTestPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), param)), new Object[0]);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"FpzsTestPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else if ("removeBillCache".equals(method)) {
                BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)param));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"FpzsTestPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else if ("createPdfUrl".equals(method)) {
                try {
                    List serialNoList;
                    JSONObject paramJson = JSONObject.parseObject((String)param);
                    String serialNos = paramJson.getString("serialNos");
                    String invoiceType = paramJson.getString("invoiceType");
                    String downType = paramJson.getString("downType");
                    if (StringUtils.isNotEmpty((CharSequence)serialNos) && !ObjectUtils.isEmpty((Object)(serialNoList = CommonUtils.getMultiValues((String)(serialNos = serialNos.replaceAll("\\s*|\t|\r|\n", "")))))) {
                        for (String serialNo : serialNoList) {
                            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file_aws");
                            dynamicObject.set("serial_no", (Object)serialNo);
                            dynamicObject.set("status", (Object)"0");
                            if (StringUtils.isNotEmpty((CharSequence)invoiceType)) {
                                dynamicObject.set("attachment_name", (Object)invoiceType);
                            }
                            if (StringUtils.isNotEmpty((CharSequence)downType)) {
                                dynamicObject.set("down_type", (Object)downType);
                            } else {
                                dynamicObject.set("down_type", (Object)"gen");
                            }
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                        }
                    }
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("001", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u5931\u8d25", (String)"FpzsTestPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), param)), new Object[0]);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"FpzsTestPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else if ("gdTaxNoConfig".equals(method)) {
                try {
                    JSONObject paramJson = JSONObject.parseObject((String)param);
                    List<Object> taxNos = Lists.newArrayList();
                    if ("1".equals(paramJson.getString("initData"))) {
                        QFilter filter = new QFilter("authtype", "=", (Object)"4");
                        DynamicObjectCollection objs = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)"number", (QFilter[])new QFilter[]{filter});
                        if (!CollectionUtils.isEmpty((Collection)objs)) {
                            taxNos = objs.stream().map(s -> s.getString("number")).collect(Collectors.toList());
                        }
                    } else {
                        taxNos = CommonUtils.getMultiValues((String)paramJson.getString("taxNos"));
                    }
                    if (!CollectionUtils.isEmpty((Collection)taxNos)) {
                        Map map = ImcConfigUtil.getValue((String)"rim_gd_taxno");
                        ArrayList configs = Lists.newArrayList();
                        for (String taxNo : taxNos) {
                            if (!StringUtils.isEmpty((CharSequence)((CharSequence)map.get(taxNo)))) continue;
                            DynamicObject configuration2 = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
                            configuration2.set("config_type", (Object)"rim_gd_taxno");
                            configuration2.set("config_key", (Object)taxNo);
                            configuration2.set("config_value", (Object)"1");
                            configs.add(configuration2);
                        }
                        SaveServiceHelper.save((DynamicObject[])configs.toArray(new DynamicObject[0]));
                        ImcConfigUtil.removeCache((String)"rim_gd_taxno");
                    }
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("001", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u5931\u8d25", (String)"FpzsTestPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), param)), new Object[0]);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"FpzsTestPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else if ("updateCompanySeal".equals(method)) {
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                InputStream stream = null;
                InputStreamReader ibf = null;
                BufferedReader bf = null;
                try {
                    stream = fileService.getInputStream(param);
                    ibf = new InputStreamReader(stream);
                    bf = new BufferedReader(ibf);
                    try {
                        String str;
                        while ((str = bf.readLine()) != null) {
                            this.updateCompanySeal(str);
                        }
                    }
                    catch (IOException taxNo) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                    LOGGER.info("\u6587\u4ef6\u5904\u7406\u5931\u8d25{}", (Object)param);
                }
                finally {
                    try {
                        if (bf != null) {
                            bf.close();
                        }
                    }
                    catch (IOException e) {}
                    try {
                        if (ibf != null) {
                            ibf.close();
                        }
                    }
                    catch (IOException e) {}
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e) {}
                }
            } else if ("viewRepeatInvoie".equals(method)) {
                this.getPageCache().put("relevanceExpenseId", "1");
                this.viewInvoice();
            } else if ("viewInvoice".equalsIgnoreCase(method)) {
                FormShowParameter showparam = new FormShowParameter();
                JSONObject customParams = JSONObject.parseObject((String)param);
                showparam.setCustomParams((Map)customParams);
                showparam.getOpenStyle().setShowType(ShowType.Modal);
                showparam.setFormId("rim_view_invoice");
                this.getView().showForm(showparam);
            } else if ("wxCard".equals(method)) {
                JSONObject paramJson = JSONObject.parseObject((String)param);
                String operate = paramJson.getString("operate");
                if ("getInvoice".equals(operate)) {
                    JSONArray array = paramJson.getJSONArray("invoice");
                    FormShowParameter showParameter = new FormShowParameter();
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("access_token", paramJson.getString("access_token"));
                    if ("1".equals(paramJson.getString("isEncrypt"))) {
                        JSONObject backdata = new JSONObject();
                        backdata.put("cardAry", (Object)array);
                        params.put("backdata", backdata.toJSONString());
                    } else {
                        params.put("cardData", array.toJSONString());
                    }
                    showParameter.setCustomParams(params);
                    showParameter.setFormId("rim_mobile_check_list");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(showParameter);
                }
            } else {
                Object json = JSON.parse((String)param);
                Object result = DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)method, (Object[])new Object[]{json});
                this.getView().showMessage(SerializationUtils.toJsonString((Object)result));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        if ("serial_no".equals(fieldName)) {
            FormShowParameter param = new FormShowParameter();
            ArrayList<String> taxNoList = new ArrayList<String>(8);
            DynamicObject existedInvoice = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(arg0.getRowIndex());
            taxNoList.add(existedInvoice.getString("serial_no"));
            DynamicObject typeObject = (DynamicObject)this.getModel().getValue("bill_type");
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            if (typeObject != null) {
                customParams.put("billType", typeObject.getString("number"));
            }
            customParams.put("expenseId", this.getModel().getValue("expenseid"));
            customParams.put("sourceSys", "fpzsTest");
            customParams.put("viewPage", "fpzsTest");
            customParams.put("entityId", "fpzsTest");
            customParams.put("resource", ResManager.loadKDString((String)"\u53d1\u7968\u52a9\u624b4", (String)"FpzsTestPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            customParams.put("serialList", taxNoList);
            ArrayList list = new ArrayList(8);
            int total = this.getModel().getEntryRowCount("company_info");
            for (int i = 0; i < total; ++i) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("taxNo", (String)this.getModel().getValue("tax_no", i));
                map.put("name", (String)this.getModel().getValue("company_name", i));
                list.add(map);
            }
            customParams.put("companyInfo", list);
            ArrayList salerList = new ArrayList(8);
            int salerTotal = this.getModel().getEntryRowCount("saler_info");
            for (int i = 0; i < salerTotal; ++i) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("taxNo", (String)this.getModel().getValue("saler_tax_no", i));
                map.put("name", (String)this.getModel().getValue("saler_name", i));
                salerList.add(map);
            }
            customParams.put("salerInfo", salerList);
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("rim_view_invoice");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_view_invoice");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
    }

    private void updateCompanySeal(String serialNo) {
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return;
        }
        QFilter filter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject object = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,company_seal", (QFilter[])new QFilter[]{filter});
        if (object != null && !"1".equals(object.get("company_seal"))) {
            DynamicObject fileobject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id,image_url,snapshot_url", (QFilter[])new QFilter[]{filter});
            String fileUrl = fileobject.getString("image_url");
            if (StringUtils.isEmpty((CharSequence)fileUrl)) {
                fileUrl = fileobject.getString("snapshot_url");
            }
            HashMap extMap = new HashMap(8);
            RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
            String fileName = "aaa." + FileUtils.getFileType((String)fileUrl);
            try {
                boolean companySeal;
                FormFileEntity fileEntity = recognitionCheckHelper.getFormFileEntity(fileUrl, fileName, null);
                List recognitionResultList = recognitionCheckHelper.recognitionInvoiceFile(fileEntity, extMap);
                if (!recognitionResultList.isEmpty() && (companySeal = "1".equals(((JSONObject)recognitionResultList.get(0)).getString("companySeal")))) {
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"rim_invoice");
                    invoice.set("company_seal", (Object)"1");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
                }
            }
            catch (Exception e) {
                LOGGER.info("\u4fee\u6539\u7b7e\u7ae0\u6807\u8bc6\u5931\u8d25{}", (Object)serialNo);
            }
        }
    }
}

