/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.license.service.FpzsAnonymousUserService;
import kd.imc.rim.formplugin.fpzs.FpzsAttachService;

public class H5AttachDeletePlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
EntryGridBindDataListener {
    private static Log LOGGER = LogFactory.getLog(H5AttachDeletePlugin.class);
    public static final String ENTRYENTITY = "entryentity";
    private final String[] buttons = new String[]{"del_btn", "cardentryflexpanelap6", "confirm_del", "attach_all_check_btn"};
    public static final String DELETED_ATTACH_CACHE_KEY = "deleted_attach_cache_key";
    private static final String SELECT_STATUS_KEY = "select_key";

    public void registerListener(EventObject event) {
        this.addClickListeners(this.buttons);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LOGGER.info("\u5165\u53c2\u6570\u636e\uff0c[{}]", (Object)customParams);
        this.fillAttachEntryEntity();
    }

    private void fillAttachEntryEntity() {
        this.clearListData(ENTRYENTITY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String expenseId = (String)customParams.get("billId");
        String entityId = (String)customParams.get("entityId");
        if (StringUtils.isBlank((CharSequence)expenseId) && StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        AttachQueryService attachQueryService = new AttachQueryService();
        JSONArray jSONArray = attachQueryService.queryFpzsAttach(expenseId, entityId, null, true);
        List resultList = jSONArray.stream().map(invoiceObj -> {
            JSONObject attach = (JSONObject)invoiceObj;
            LinkedHashMap temMap = Maps.newLinkedHashMap();
            temMap.put("id", attach.getLong("attachId"));
            temMap.put("attach_name", attach.getString("attachName"));
            temMap.put("remark", attach.getString("remark"));
            temMap.put("attach_url", FpzsAttachService.getPreviewIconFullUrl(attach));
            temMap.put("create_time", attach.getString("createTime"));
            return temMap;
        }).collect(Collectors.toList());
        this.getModel().beginInit();
        resultList.stream().forEach(map -> {
            int row = this.getModel().createNewEntryRow(ENTRYENTITY);
            map.entrySet().stream().forEach(modelEntry -> this.getModel().setValue((String)modelEntry.getKey(), modelEntry.getValue(), row));
        });
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
        this.getView().setEnable(Boolean.TRUE, new String[]{"attach_all_check_btn"});
    }

    private void clearListData(String var1) {
        this.getModel().deleteEntryData(var1);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        String cacheKey = RequestContext.get().getUserId();
        switch (key) {
            case "del_btn": {
                int[] rows = cardEntry.getSelectRows();
                if (rows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9644\u4ef6", (String)"H5AttachDeletePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.deleteAttach(rows);
                break;
            }
            case "cardentryflexpanelap6": {
                this.countAttach(cardEntry.getSelectRows());
                break;
            }
            case "confirm_del": {
                this.confirmDelete();
                break;
            }
            case "attach_all_check_btn": {
                this.selectAll();
                break;
            }
            default: {
                this.getView().close();
            }
        }
    }

    private void confirmDelete() {
        String deletedAttachesStr = this.getPageCache().get(DELETED_ATTACH_CACHE_KEY);
        if (StringUtils.isEmpty((CharSequence)deletedAttachesStr)) {
            this.getView().close();
            return;
        }
        JSONArray deletedAttachArray = JSON.parseArray((String)deletedAttachesStr);
        if (deletedAttachArray == null || deletedAttachArray.size() == 0) {
            this.getView().close();
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String expenseId = (String)customParams.get("billId");
        String entityId = (String)customParams.get("entityId");
        AttachQueryService attachQueryService = new AttachQueryService();
        attachQueryService.deleteFpzsAttach(expenseId, entityId, null, deletedAttachArray.toJavaList(String.class));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"H5AttachDeletePlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    private void deleteAttach(int[] delRows) {
        ArrayList attachIds = new ArrayList(delRows.length);
        Arrays.stream(delRows).forEach(c -> {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, c);
            attachIds.add(dynamicObject.getString("id"));
        });
        this.getModel().deleteEntryRows(ENTRYENTITY, delRows);
        this.countAttach(null);
        String deletedAttachIdsStr = this.getPageCache().get(DELETED_ATTACH_CACHE_KEY);
        JSONArray deletedAttachArray = new JSONArray();
        if (!StringUtils.isEmpty((CharSequence)deletedAttachIdsStr)) {
            deletedAttachArray = JSON.parseArray((String)deletedAttachIdsStr);
        }
        deletedAttachArray.addAll(attachIds);
        this.getPageCache().put(DELETED_ATTACH_CACHE_KEY, deletedAttachArray.toJSONString());
        this.getPageCache().remove(SELECT_STATUS_KEY);
    }

    private void countAttach(int[] selectRows) {
        HashMap<String, LocaleString> ctrl = new HashMap<String, LocaleString>();
        if (selectRows != null && selectRows.length > 0) {
            ctrl.put("text", new LocaleString(String.format(ResManager.loadKDString((String)"\u5220\u9664\uff08%s\uff09", (String)"H5AttachDeletePlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), selectRows.length)));
        } else {
            ctrl.put("text", new LocaleString(ResManager.loadKDString((String)"\u5220\u9664", (String)"H5AttachDeletePlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        }
        this.getView().updateControlMetadata("del_btn", ctrl);
    }

    private void selectAll() {
        String selectAll = this.getView().getPageCache().get(SELECT_STATUS_KEY);
        boolean selectAllFlag = false;
        if (StringUtils.isEmpty((CharSequence)selectAll) || "0".equals(selectAll)) {
            selectAllFlag = true;
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        cardEntry.clearEntryState();
        if (selectAllFlag) {
            LinkedList arr = Lists.newLinkedList();
            int endIndex = cardEntry.getEntryData().getEndIndex();
            for (int i = 0; i < endIndex; ++i) {
                arr.add(i);
            }
            int[] arr1 = arr.stream().mapToInt(Integer::valueOf).toArray();
            cardEntry.selectRows(arr1, 1);
            this.getView().getPageCache().put(SELECT_STATUS_KEY, "1");
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("imageKey", "/icons/mobile/other/icon_checkbox1_selected_40_40.png");
            this.getView().updateControlMetadata("attach_all_check_btn", map);
        } else {
            ((FormView)this.getView()).getClientProxy().invokeControlMethod(ENTRYENTITY, "clearSelRows", new Object[0]);
            this.getView().getPageCache().remove(SELECT_STATUS_KEY);
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("imageKey", "/icons/mobile/other/icon_radio_checkbox_default_40_40.png");
            this.getView().updateControlMetadata("attach_all_check_btn", map);
        }
        cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        this.countAttach(cardEntry.getSelectRows());
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry clickCardEntry = (CardEntry)evt.getSource();
        int currentRow = evt.getRow();
        HashMap<String, Constable> value = new HashMap<String, Constable>(4);
        value.put("row", Integer.valueOf(currentRow));
        boolean allowEdit = false;
        value.put("allowEdit", Boolean.valueOf(allowEdit));
        value.put("allowDel", Boolean.valueOf(allowEdit));
        if (StringUtils.equals((CharSequence)ENTRYENTITY, (CharSequence)clickCardEntry.getEntryKey())) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, currentRow);
            value.put("id", Long.valueOf(dynamicObject.getLong("id")));
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("rim_h5_attach_detail");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "abcd"));
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            FpzsAnonymousUserService.addEventCode(value, (String)this.getView().getPageId());
            showParameter.setCustomParams(value);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

