/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.sign.InvoiceSignService;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;
import org.apache.commons.lang3.StringUtils;

public class BillSignService
extends AbstractMessageServie {
    private static final Log LOGGER = LogFactory.getLog(BillSignService.class);
    private static final String BILL_ID_REGEX = "^[a-zA-Z0-9_-]+$";
    Set<String> FILE_TYPE_SET = new HashSet<String>(Arrays.asList("4", "2", "1", "9"));

    @Override
    public ApiResult doBusiness(Object reqObject) {
        String json = SerializationUtils.toJsonString((Object)reqObject);
        LOGGER.info("\u53d1\u7968\u7b7e\u6536\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        ApiResult validateResult = this.validate(jsonObj);
        if (validateResult != null) {
            return validateResult;
        }
        JSONObject result = (JSONObject)new InvoiceSignService().updateSignStatus(jsonObj);
        ApiResult apiResult = new ApiResult();
        apiResult.setErrorCode(result.getString("errcode"));
        apiResult.setSuccess(ResultContant.isSuccess((JSONObject)result).booleanValue());
        apiResult.setMessage(result.getString("description"));
        apiResult.setData((Object)result.getJSONObject("data"));
        return apiResult;
    }

    private ApiResult validate(JSONObject param) {
        String signType;
        String resource;
        String bizSysCode;
        JSONArray invoiceData = param.getJSONArray("invoiceData");
        String billId = param.getString("billId");
        String msg = "";
        String errorCode = ErrorType.PARAM_ERROR.getCode();
        if (StringUtils.isNotBlank((CharSequence)billId) && (billId.length() > 50 || !Pattern.matches(BILL_ID_REGEX, billId))) {
            msg = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e(\u8bf7\u8f93\u5165\u957f\u5ea6\u4e3a\u4e0d\u8d85\u8fc750\u4f4d\u7684\u6570\u5b57\u6216\u5b57\u6bcd)\u3002", (String)"BillSignService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)(bizSysCode = param.getString("bussinSysCode"))) && bizSysCode.length() > 20) {
            msg = ResManager.loadKDString((String)"\u5bf9\u63a5\u7cfb\u7edf\u6570\u636e\u6765\u6e90\u6807\u8bc6\u683c\u5f0f\u4e0d\u6b63\u786e\uff08\u8bf7\u8f93\u5165\u957f\u5ea6\u4e3a\u4e0d\u8d85\u8fc720\u4f4d\u7684\u6570\u5b57\u6216\u5b57\u6bcd\uff09\u3002", (String)"BillSignService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)(resource = param.getString("resource"))) && resource.length() > 20) {
            msg = ResManager.loadKDString((String)"\u5bf9\u63a5\u7cfb\u7edf\u6570\u636e\u6765\u6e90\u6807\u8bc6\u683c\u5f0f\u4e0d\u6b63\u786e\uff08\u8bf7\u8f93\u5165\u957f\u5ea6\u4e3a\u4e0d\u8d85\u8fc720\u4f4d\u7684\u6570\u5b57\u6216\u5b57\u6bcd\uff09\u3002", (String)"BillSignService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)(signType = param.getString("signType"))) || !StringUtils.equals((CharSequence)signType, (CharSequence)"01") && !StringUtils.equals((CharSequence)signType, (CharSequence)"02")) {
            msg = ResManager.loadKDString((String)"\u7b7e\u6536\u7c7b\u578b\u53c2\u6570\u975e\u6cd5\u3002", (String)"BillSignService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if (invoiceData == null || invoiceData.isEmpty()) {
            msg = ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillSignService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            errorCode = ErrorType.PARAM_NULL.getCode();
        }
        assert (invoiceData != null);
        if (invoiceData.size() > 500) {
            msg = ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u8d85\u8fc7 500 \u884c\u3002", (String)"BillSignService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        for (int i = 0; i < invoiceData.size(); ++i) {
            JSONObject invoice = invoiceData.getJSONObject(i);
            String fileDownloadUrl = invoice.getString("fileDownUrl");
            if (!StringUtils.isNotBlank((CharSequence)fileDownloadUrl)) continue;
            if (fileDownloadUrl.isEmpty()) {
                msg = ResManager.loadKDString((String)"\u53d1\u7968\u6587\u4ef6\u5730\u5740\u975e\u6cd5\uff08\u82cd\u7a79\u6587\u4ef6\u670d\u52a1\u5668\u5730\u5740\u6216\u53ef\u4ee5\u76f4\u63a5\u6253\u5f00\u7684http\u5730\u5740\uff09\u3002", (String)"BillSignService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                break;
            }
            String fileType = invoice.getString("fileType");
            if (StringUtils.isBlank((CharSequence)fileType)) {
                msg = ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillSignService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                break;
            }
            if (this.FILE_TYPE_SET.contains(fileType)) continue;
            msg = ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u975e\u6cd5\uff081-pdf\uff0c2-\u56fe\u7247\uff08png/jpg\u7b49\uff09\uff0c4-ofd\uff09\u3002", (String)"BillSignService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return ApiResult.fail((String)msg, (String)errorCode);
        }
        return null;
    }
}

