/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.fpzs.FpzsService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;

public class InvoiceCheckService
extends AbstractMessageServie {
    private static final String LQCHECKSERIVCESTR = "kd.imc.rim.common.invoice.checknew.impl.LqCheckService";

    @Override
    public ApiResult doBusiness(Object reqObject) {
        boolean isElectricInvoice;
        String json = SerializationUtils.toJsonString((Object)reqObject);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        String invoiceCode = jsonObj.getString("invoiceCode");
        String invoiceNo = jsonObj.getString("invoiceNo");
        String invoiceDate = jsonObj.getString("invoiceDate");
        String checkCode = jsonObj.getString("checkCode");
        String invoiceAmount = jsonObj.getString("invoiceAmount");
        String resource = jsonObj.getString("resource");
        if (StringUtils.isEmpty((CharSequence)invoiceNo)) {
            throw new MsgException(ErrorType.PARAM_NULL.getCode(), "invoiceNo" + ErrorType.PARAM_NULL.getName());
        }
        boolean bl = isElectricInvoice = invoiceNo.length() == 20;
        if (!isElectricInvoice && StringUtils.isEmpty((CharSequence)invoiceCode)) {
            throw new MsgException(ErrorType.PARAM_NULL.getCode(), "invoiceCode" + ErrorType.PARAM_NULL.getName());
        }
        if (StringUtils.isEmpty((CharSequence)invoiceDate)) {
            throw new MsgException(ErrorType.PARAM_NULL.getCode(), "invoiceDate" + ErrorType.PARAM_NULL.getName());
        }
        if (invoiceDate.indexOf(45) > 0) {
            invoiceDate = invoiceDate.replace("-", "");
        }
        if (!StringUtils.isEmpty((CharSequence)invoiceAmount)) {
            try {
                new BigDecimal(invoiceAmount);
            }
            catch (Exception e) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), "invoiceAmount" + ErrorType.PARAM_ERROR.getName());
            }
        }
        ApiResult result = new ApiResult();
        Long orgId = TenantUtils.getOrgByNumberOrTaxNo((String)jsonObj.getString("orgNumber"), (String)jsonObj.getString("taxNo"));
        if (orgId <= 0L) {
            orgId = RequestContext.get().getOrgId();
        }
        String taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
        String checkImplStr = RimConfigUtils.getConfig((String)"rim_recog_check", (String)"cimpl");
        String checkType = TenantUtils.getCheckTypeByTaxNo((String)taxNo);
        if ("2".equals(checkType) || LQCHECKSERIVCESTR.equals(checkImplStr)) {
            throw new MsgException("0005", String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u4e50\u4f01\u901a\u9053", (String)"InvoiceCheckService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), CheckContant.getCheckResultDesc((String)"0005")));
        }
        String invoiceType = InvoiceConvertUtils.checkInvoiceType((String)invoiceCode, (String)invoiceNo);
        if (isElectricInvoice) {
            invoiceType = "26";
        }
        Long invoice_type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType);
        BigDecimal checkAmount = BigDecimal.ZERO;
        try {
            checkAmount = new BigDecimal(invoiceAmount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoice_type, invoiceDate, checkAmount, checkCode, null);
        CheckResult checkResult = SimplyCheckService.checkInvoice((CheckParam)checkParam, (Long)orgId, (String)taxNo);
        if (checkResult != null && "0000".equals(checkResult.getErrcode())) {
            Object invoiceEntity = checkResult.getData();
            String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
            JSONObject invoice = JSON.parseObject((String)invoiceCheckStr);
            if (orgId > 0L) {
                invoice.put("org_id", (Object)orgId);
            } else {
                invoice.put("replaceOrg", (Object)"1");
            }
            invoice.put("checkStatus", (Object)"1");
            InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance((String)invoice.getString("invoiceType"));
            invoice.put("collect_type", (Object)CollectTypeEnum.MSG_SERVICE.getCode());
            if (StringUtils.isEmpty((CharSequence)resource)) {
                resource = "\u7b2c\u4e09\u65b9";
            }
            invoice.put("resource", (Object)resource);
            boolean isCollectOwner = SysParamUtil.getSysParamByOrgId((Long)orgId, (String)"is_collectowner");
            if (isCollectOwner) {
                boolean isHit = SysParamUtil.isHitValue((long)orgId, (String)"collectowner_config", (String)"3");
                if (isHit) {
                    DynamicObjectCollection userEntry;
                    DynamicObject mainDynamicObject;
                    QFilter qFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
                    QFilter qFilter1 = new QFilter("invoice_code", "=", (Object)invoiceCode);
                    if (InputInvoiceTypeEnum.isEleInvoice((Long)invoice_type).booleanValue()) {
                        qFilter1 = null;
                    }
                    if ((mainDynamicObject = CommonUtils.loadSingle((String)"rim_invoice", (QFilter[])new QFilter[]{qFilter, qFilter1})) != null && !CollectionUtils.isEmpty((Collection)(userEntry = mainDynamicObject.getDynamicObjectCollection("collect_user_entry")))) {
                        invoice.put("needUserRelation", (Object)"0");
                    }
                } else {
                    invoice.put("needUserRelation", (Object)"0");
                }
            } else {
                invoice.put("needUserRelation", (Object)"0");
            }
            InvoiceSaveResult saveResult = invoiceSaveService.save(invoice);
            String isSaleListInvoice = invoice.getString("isSaleListInvoice");
            if ("1".equals(isSaleListInvoice)) {
                RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                recognitionCheckHelper.dealInvoiceAttachRelation(invoice);
            }
            FpzsService server = new FpzsService();
            ArrayList<String> serailList = new ArrayList<String>(8);
            serailList.add(saveResult.getSerialNo());
            Map queryResult = null;
            if ("1".equals(jsonObj.getString("verifyFlag"))) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("serialNos", serailList);
                param.put("orgId", orgId);
                param.put("billType", jsonObj.getString("billType"));
                param.put("billId", jsonObj.getString("billId"));
                param.put("salerInfo", jsonObj.getJSONArray("salerInfo"));
                Object companyInfo = jsonObj.get((Object)"companyInfo");
                if (companyInfo instanceof List) {
                    param.put("companyInfo", jsonObj.getJSONArray("companyInfo"));
                }
                queryResult = server.queryVerify(param);
            } else {
                queryResult = server.query(serailList);
            }
            result.setErrorCode((String)queryResult.get("errcode"));
            result.setMessage((String)queryResult.get("description"));
            result.setData(queryResult.get("data"));
            return result;
        }
        if (checkResult != null) {
            String errorCode = checkResult.getErrcode();
            throw new MsgException(errorCode, String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25:%1$s", (String)"InvoiceCheckService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), CheckContant.getCheckResultDesc((String)errorCode)));
        }
        throw new MsgException("0005", String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25:%1$s", (String)"InvoiceCheckService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), CheckContant.getCheckResultDesc((String)"0005")));
    }
}

