/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.formplugin.message.InputService;

public class QueryCoverOpenService
implements IBillWebApiPlugin {
    private static Log LOGGER = LogFactory.getLog(QueryCoverOpenService.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        Boolean success = Boolean.TRUE;
        result.setSuccess(success.booleanValue());
        result.setErrorCode("0000");
        try {
            ApiResult busiResult = this.doBusiness(params);
            return busiResult;
        }
        catch (MsgException e) {
            LOGGER.info("\u3010\u53d1\u7968\u4e91API\u3011\u67e5\u8be2\u5c01\u9762\u5931\u8d25\uff1a", (Object)e);
            result.setErrorCode(e.getErrorCode());
            result.setMessage(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u53d1\u7968\u4e91API\u3011\u67e5\u8be2\u5c01\u9762\u5931\u8d25\uff1a", (Throwable)e);
            result.setErrorCode(ErrorType.FAIL.getCode());
            result.setData((Object)e.getMessage());
        }
        return result;
    }

    public ApiResult doBusiness(Object reqObject) {
        JSONObject data = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)reqObject));
        LOGGER.info("\u3010\u53d1\u7968\u4e91API\u3011\u67e5\u8be2\u5c01\u9762\uff0cdata:{}", (Object)data);
        if (data == null) {
            return this.getErrorResult(ErrorType.PARAM_NULL);
        }
        String expenseId = data.getString("billId");
        if (StringUtils.isBlank((CharSequence)expenseId)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"billId\u4e3a\u7a7a", (String)"QueryCoverOpenService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_NULL.getCode());
        }
        String entityId = data.getString("billType");
        String needBillType = data.getString("needBillType");
        if (StringUtils.isBlank((CharSequence)entityId) && !StringUtils.equals((CharSequence)needBillType, (CharSequence)"1")) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"billType\u4e3a\u7a7a", (String)"QueryCoverOpenService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_NULL.getCode());
        }
        JSONObject result = new JSONObject();
        ExpenseRelationService ers = new ExpenseRelationService();
        JSONObject coverAndAttach = ers.queryCoverAndAttach(expenseId, entityId, null, null);
        JSONArray cover = coverAndAttach.getJSONArray("cover");
        result.put("cover", (Object)cover);
        JSONArray attachment = coverAndAttach.getJSONArray("attachment");
        this.tranceAttachment(attachment);
        result.put("attachment", (Object)attachment);
        String fileBagNo = ers.queryFileBagNo(expenseId, entityId);
        if (StringUtils.isNotEmpty((CharSequence)fileBagNo)) {
            result.put("fileBagNo", (Object)fileBagNo);
        }
        InputService inputService = new InputService();
        HashMap param = Maps.newHashMapWithExpectedSize((int)2);
        param.put("expenseId", expenseId);
        param.put("entityId", entityId);
        Map invoiceInfo = inputService.queryInvoiceByExpense((Map)param);
        Object invoiceData = invoiceInfo.get("data");
        if (invoiceData != null) {
            result.put("invoice", invoiceData);
        } else {
            result.put("invoice", (Object)new JSONArray());
        }
        this.otherInfo(result);
        String urlEncode = ImcConfigUtil.getValue((String)"rim_config", (String)"url_encode");
        if (StringUtils.equals((CharSequence)urlEncode, (CharSequence)"1")) {
            try {
                this.extResultHandle(result);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.info("\u3010\u53d1\u7968\u4e91API\u3011\u67e5\u8be2\u5c01\u9762\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e);
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u8f6c\u6362path\u8def\u5f84\u5931\u8d25\u3002", (String)"QueryCoverOpenService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.FAIL.getCode());
            }
        }
        LOGGER.info("\u3010\u53d1\u7968\u4e91API\u3011\u67e5\u8be2\u5c01\u9762\uff0c\u7ed3\u679c\uff1a{}", (Object)result.toJSONString());
        ApiResult apiResult = this.successResult();
        apiResult.setData((Object)result);
        return apiResult;
    }

    private void extResultHandle(JSONObject result) throws UnsupportedEncodingException {
        JSONArray cover = result.getJSONArray("cover");
        this.pathEncode(cover);
        JSONArray attachment = result.getJSONArray("attachment");
        this.pathEncode(attachment);
        JSONArray invoice = result.getJSONArray("invoice");
        this.pathEncode(invoice);
    }

    private void pathEncode(JSONArray infos) throws UnsupportedEncodingException {
        for (int i = 0; i < infos.size(); ++i) {
            String originalGraphUrl;
            String imageUrl;
            String snapshotUrl;
            String kdcloudUrl;
            String downloadUrl;
            String pdfurl;
            JSONObject info = infos.getJSONObject(i);
            String localUrl = info.getString("localUrl");
            if (StringUtils.isNotBlank((CharSequence)localUrl)) {
                info.put("localUrl", (Object)URLEncoder.encode(localUrl, "utf-8"));
            }
            if (StringUtils.isNotBlank((CharSequence)(pdfurl = info.getString("pdfurl")))) {
                info.put("pdfurl", (Object)URLEncoder.encode(pdfurl, "utf-8"));
            }
            if (StringUtils.isNotBlank((CharSequence)(downloadUrl = info.getString("downloadUrl")))) {
                info.put("downloadUrl", (Object)URLEncoder.encode(downloadUrl, "utf-8"));
            }
            if (StringUtils.isNotBlank((CharSequence)(kdcloudUrl = info.getString("kdcloudUrl")))) {
                info.put("kdcloudUrl", (Object)URLEncoder.encode(kdcloudUrl, "utf-8"));
            }
            if (StringUtils.isNotBlank((CharSequence)(snapshotUrl = info.getString("snapshotUrl")))) {
                info.put("snapshotUrl", (Object)URLEncoder.encode(snapshotUrl, "utf-8"));
            }
            if (StringUtils.isNotBlank((CharSequence)(imageUrl = info.getString("imageUrl")))) {
                info.put("imageUrl", (Object)URLEncoder.encode(imageUrl, "utf-8"));
            }
            if (!StringUtils.isNotBlank((CharSequence)(originalGraphUrl = info.getString("originalGraphUrl")))) continue;
            info.put("originalGraphUrl", (Object)URLEncoder.encode(originalGraphUrl, "utf-8"));
        }
    }

    public ApiResult successResult() {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setErrorCode(ErrorType.SUCCESS.getCode());
        result.setMessage(ErrorType.SUCCESS.getName());
        return result;
    }

    private void otherInfo(JSONObject result) {
        JSONArray invoices = result.getJSONArray("invoice");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)invoices)) {
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject invoiceJson = invoices.getJSONObject(i);
                if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("totalAmount"))) {
                    totalAmount = totalAmount.add(invoiceJson.getBigDecimal("totalAmount"));
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("taxAmount"))) {
                    totalTaxAmount = totalTaxAmount.add(invoiceJson.getBigDecimal("taxAmount"));
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("totalTaxAmount"))) continue;
                totalTaxAmount = totalTaxAmount.add(invoiceJson.getBigDecimal("totalTaxAmount"));
            }
        }
        result.put("totalAmount", (Object)totalAmount);
        result.put("totalTaxAmount", (Object)totalTaxAmount);
        result.put("invoiceCount", (Object)invoices.size());
        result.put("attachmentCount", (Object)result.getJSONArray("attachment").size());
    }

    private void tranceAttachment(JSONArray attachment) {
        for (Object object : attachment) {
            JSONObject att = (JSONObject)object;
            att.put("attachmentType", att.get((Object)"fileType"));
            att.remove((Object)"fileType");
            att.put("attachmentName", att.get((Object)"attachName"));
            att.remove((Object)"attachName");
            att.put("gatherTime", att.get((Object)"createTime"));
            att.remove((Object)"createTime");
        }
    }

    private ApiResult getErrorResult(ErrorType error) {
        ApiResult result = ApiResult.fail((String)error.getName(), (String)error.getCode());
        return result;
    }
}

