/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.fpdk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.message.service.RimApiHelper;
import kd.imc.rim.formplugin.message.service.fpdk.AbstractFpdkService;
import kd.imc.rim.formplugin.recorded.TaxRecordedOperateService;
import org.apache.commons.lang3.tuple.Pair;

public class RecordedInvoiceService
extends AbstractFpdkService {
    private static Log LOGGER = LogFactory.getLog(RecordedInvoiceService.class);
    private static final int MAX_SIZE = 500;

    public RecordedInvoiceService(String type) {
        this.type = type;
    }

    @Override
    public ApiResult getResult(JSONObject reqObject) {
        LOGGER.info("\u5165\u8d26\u7533\u8bf7\uff0c\u5165\u53c2\uff1a{}", (Object)reqObject);
        this.checkParam(reqObject);
        String buyTaxNo = reqObject.getString("taxNo");
        String nextEntryMarkStatus = reqObject.getString("nextEntryMarkStatus");
        reqObject.put("asyncFlag", (Object)"1");
        reqObject.put("api", (Object)"1");
        String taskNo = UUID.randomUUID();
        reqObject.put("taskNo", (Object)taskNo);
        this.buildParam(reqObject);
        List invoices = (List)reqObject.get((Object)"convertInvoiceList");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6240\u4f20\u7684\u53d1\u7968\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u5728\u53d1\u7968\u4e91\u67e5\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"RecordedInvoiceService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String operateType = reqObject.getString("operateType");
        String dktype = DeductionConstant.getDkType((String)buyTaxNo);
        reqObject.put("dktype", (Object)dktype);
        DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle((String)dktype);
        if (deductService == null) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u4e0d\u652f\u6301\u7a0e\u5c40\u5165\u8d26\u64cd\u4f5c", (String)"TaxRecordedOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>(1);
        HashMap<String, JSONObject> originalInvoiceMap = new HashMap<String, JSONObject>(1);
        originalInvoiceMap.putAll(invoices.stream().collect(Collectors.toMap(k -> {
            String invoiceCode = k.getString("invoiceCode");
            String invoiceNo = k.getString("invoiceNo");
            return CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
        }, v -> v, (k1, k2) -> k2)));
        RecordedConstant recordedConstant = new RecordedConstant();
        if ("06".equals(nextEntryMarkStatus)) {
            this.startInvokeRecorded(invoices, deductService, reqObject, resultList);
            if (resultList != null && resultList.size() > 0) {
                recordedConstant.saveRecordedLog(resultList, originalInvoiceMap, operateType);
            }
        } else {
            Map<String, List<JSONObject>> hasRecordedMap = invoices.stream().collect(Collectors.groupingBy(t -> t.getString("hasRecorded")));
            for (Map.Entry<String, List<JSONObject>> entry : hasRecordedMap.entrySet()) {
                String hasRecorded = entry.getKey();
                List<JSONObject> inviceList = entry.getValue();
                if ("0".equals(hasRecorded)) {
                    operateType = "recorded_commit";
                    reqObject.put("operateType", (Object)operateType);
                } else {
                    operateType = "recorded_update";
                    reqObject.put("operateType", (Object)operateType);
                }
                this.startInvokeRecorded(entry.getValue(), deductService, reqObject, resultList);
                if (resultList != null && resultList.size() > 0) {
                    recordedConstant.saveRecordedLog(resultList, originalInvoiceMap, operateType);
                }
                resultList.clear();
            }
        }
        JSONObject result = ResultContant.createSuccessJSONObject();
        JSONObject data = new JSONObject();
        data.put("taskNo", (Object)taskNo);
        data.put("asyncFlag", (Object)"1");
        result.put("data", (Object)data);
        return RimApiHelper.convertApiResult((Map)result);
    }

    private void startInvokeRecorded(List<JSONObject> invoices, DeductService deductService, JSONObject reqParam, List<JSONObject> resultList) {
        String operateType = reqParam.getString("operateType");
        ArrayList<JSONObject> invoiceFailList = new ArrayList<JSONObject>(1);
        ArrayList<JSONObject> checkedInvoiceList = new ArrayList<JSONObject>(1);
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.get(i);
            JSONObject checkResult = deductService.checkRecordedInvoiceParam(invoice, operateType);
            if (!ResultContant.isSuccess((JSONObject)checkResult).booleanValue()) {
                invoice.put("errcode", checkResult.get((Object)"errcode"));
                invoice.put("description", checkResult.get((Object)"description"));
                invoiceFailList.add(invoice);
                continue;
            }
            checkedInvoiceList.add(invoice);
        }
        if (!CollectionUtils.isEmpty(invoiceFailList)) {
            JSONObject failResult = new JSONObject();
            failResult.putAll((Map)reqParam);
            JSONObject checkFailResult = new JSONObject();
            checkFailResult.put("errcode", (Object)ErrorType.PARAM_ERROR.getCode());
            checkFailResult.put("description", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u5165\u8d26--\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u770b\u52fe\u9009\u53f0\u8d26\u8bb0\u5f55", (String)"RecordedInvoiceService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            failResult.put("result", (Object)checkFailResult);
            failResult.put("invoices", invoiceFailList);
            resultList.add(failResult);
        }
        if (CollectionUtils.isEmpty(checkedInvoiceList)) {
            LOGGER.info("\u4e0d\u5b58\u5728\u6ee1\u8db3\u8c03\u7528rpa\u5165\u8d26\u63a5\u53e3\u7684\u6570\u636e");
            return;
        }
        String dktype = reqParam.getString("dktype");
        JSONObject param = new JSONObject();
        param.put("taskNo", (Object)reqParam.getString("taskNo"));
        param.put("taxNo", (Object)reqParam.getString("taxNo"));
        param.put("operateType", (Object)operateType);
        param.put("api", (Object)"1");
        TaxRecordedOperateService taxRecordedOperateService = new TaxRecordedOperateService(operateType, null);
        StringBuilder message = new StringBuilder();
        if ("5".equals(dktype)) {
            param.put("dktype", (Object)"5");
            Pair<Integer, Integer> pair = taxRecordedOperateService.invokeRecordSplit(deductService, checkedInvoiceList, param, 0, 0, message, resultList);
        } else if ("4".equals(dktype)) {
            Map<String, List<JSONObject>> taxRecordedPurposeMap = checkedInvoiceList.stream().collect(Collectors.groupingBy(t -> t.getString("nextEntryMarkStatus")));
            for (Map.Entry<String, List<JSONObject>> etaxEntry : taxRecordedPurposeMap.entrySet()) {
                JSONObject paramNewEtax = new JSONObject();
                paramNewEtax.putAll((Map)param);
                paramNewEtax.put("dktype", (Object)"4");
                paramNewEtax.put("nextEntryMarkStatus", (Object)etaxEntry.getKey());
                Pair<Integer, Integer> pair = taxRecordedOperateService.invokeRecordSplit(deductService, etaxEntry.getValue(), paramNewEtax, 0, 0, message, resultList);
            }
        }
    }

    private void buildParam(JSONObject reqObject) {
        String nextEntryMarkStatus = reqObject.getString("nextEntryMarkStatus");
        String operateType = "06".equals(nextEntryMarkStatus) ? "recorded_revoke" : "recorded_update";
        reqObject.put("operateType", (Object)operateType);
        List request = (List)reqObject.get((Object)"invoices");
        ArrayList<JSONObject> invoiceList = new ArrayList<JSONObject>(1);
        Map<String, JSONObject> serialNoMap = request.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getString("serialNo"))).collect(Collectors.toMap(t -> t.getString("serialNo"), t -> t, (k1, k2) -> k1));
        List invoiceNoList = request.stream().filter(t -> StringUtils.isBlank((CharSequence)t.getString("serialNo"))).filter(t -> StringUtils.isNotBlank((CharSequence)t.getString("invoiceNo"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(serialNoMap)) {
            QFilter serialNoFilter = new QFilter("serial_no", "in", serialNoMap.keySet());
            DynamicObject[] invoiceArr = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time,tax_recorded_period,account_date", (QFilter[])new QFilter[]{serialNoFilter});
            for (DynamicObject dynamicObject : invoiceArr) {
                JSONObject requestInvoice = serialNoMap.get(dynamicObject.getString("serial_no"));
                if (requestInvoice == null) continue;
                requestInvoice.put("nextEntryMarkStatus", (Object)nextEntryMarkStatus);
                JSONObject invoice = RecordedConstant.createRecordedSingle((DynamicObject)dynamicObject, (String)operateType, (JSONObject)requestInvoice, null);
                if (invoice == null) continue;
                invoiceList.add(invoice);
            }
        }
        HashSet<String> serialNoSet = new HashSet<String>(1);
        if (!CollectionUtils.isEmpty(serialNoMap.keySet())) {
            serialNoSet.addAll(serialNoMap.keySet());
        }
        if (!CollectionUtils.isEmpty(invoiceNoList)) {
            Map<String, JSONObject> invoiceNoMap = invoiceNoList.stream().collect(Collectors.toMap(t -> CommonUtils.getInvoiceCodeNoGroup((String)t.getString("invoiceCode"), (String)t.getString("invoiceNo")), t -> t, (k1, k2) -> k1));
            for (JSONObject jsonObject : invoiceNoList) {
                JSONObject requestInvoice;
                DynamicObject invoiceObject;
                String invoiceNo = jsonObject.getString("invoiceNo");
                String invoiceCode = jsonObject.getString("invoiceCode");
                QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
                QFilter invoiceCodeFilter = null;
                QFilter notInSerialNoFilter = null;
                if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
                    invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
                }
                if (!CollectionUtils.isEmpty(serialNoSet)) {
                    notInSerialNoFilter = new QFilter("serial_no", "not in", serialNoSet);
                }
                if ((invoiceObject = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time,tax_recorded_period,account_date", (QFilter[])new QFilter[]{invoiceNoFilter, invoiceCodeFilter, notInSerialNoFilter})) == null || (requestInvoice = invoiceNoMap.get(CommonUtils.getInvoiceCodeNoGroup((String)invoiceObject.getString("invoice_code"), (String)invoiceObject.getString("invoice_no")))) == null) continue;
                requestInvoice.put("nextEntryMarkStatus", (Object)nextEntryMarkStatus);
                JSONObject invoice = RecordedConstant.createRecordedSingle((DynamicObject)invoiceObject, (String)operateType, (JSONObject)requestInvoice, null);
                if (StringUtils.isNotBlank((CharSequence)invoice.getString("serialNo"))) {
                    serialNoSet.add(invoice.getString("serialNo"));
                }
                if (invoice == null) continue;
                invoiceList.add(invoice);
            }
        }
        reqObject.put("convertInvoiceList", invoiceList);
    }

    private void checkParam(JSONObject reqObject) {
        if (StringUtils.isBlank((Object)reqObject)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"NewEtaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String nextEntryMarkStatus = reqObject.getString("nextEntryMarkStatus");
        if (StringUtils.isBlank((CharSequence)nextEntryMarkStatus)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5165\u8d26\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewEtaxDeductService_25", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        this.checkValue(nextEntryMarkStatus, "nextEntryMarkStatus", new String[]{"02", "03", "06"});
        JSONArray invoiceArray = reqObject.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"GxInvoiceService_47", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        int size = InvoiceDownloadConstant.getPageSizeFromConfig((int)500, (String)"invoice_recorded_apply_size");
        if (invoiceArray.size() > size) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u6b21\u52fe\u9009\u53d1\u7968\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%s\u5f20", (String)"GxInvoiceService_48", (String)"imc-rim-formplugin", (Object[])new Object[0]), size));
        }
    }
}

