/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.fpdk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.impl.AsyncSelectQueryServiceImpl;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.formplugin.message.service.RimApiHelper;
import kd.imc.rim.formplugin.message.service.fpdk.AbstractFpdkService;

public class RecordedQueryService
extends AbstractFpdkService {
    private static Log LOGGER = LogFactory.getLog(RecordedQueryService.class);
    protected static final String LOCK_KEY = "rim.RecordedQueryService-";

    public RecordedQueryService(String type) {
        this.type = type;
    }

    @Override
    public ApiResult getResult(JSONObject reqJson) {
        LOGGER.info("\u5165\u8d26\u67e5\u8be2\u7ed3\u679c\uff0c\u5165\u53c2\uff1a{}", (Object)reqJson);
        return RimApiHelper.convertApiResult((Map)this.queryRecordedResult(reqJson));
    }

    public JSONObject queryRecordedResult(JSONObject param) {
        AsyncSelectQueryServiceImpl asyncSelectQueryService = new AsyncSelectQueryServiceImpl();
        asyncSelectQueryService.checkParam(param);
        asyncSelectQueryService.checkPageNo(param);
        asyncSelectQueryService.checkPageSize(param);
        String taxNo = param.getString("taxNo");
        String taskNo = param.getString("taskNo");
        String lockKey = LOCK_KEY + taxNo + taskNo;
        try (DLock lock = DLock.create((String)lockKey, (String)"RecordedQueryService.lock");){
            if (lock.tryLock()) {
                JSONObject jSONObject = this.getRecordedResult(param, taxNo, taskNo);
                return jSONObject;
            }
            LOGGER.info("{}\u4efb\u52a1\u53f7\u8bf7\u6c42\u9891\u7e41", (Object)taskNo);
            JSONObject jSONObject = this.getHandlingResult(ResManager.loadKDString((String)"\u4efb\u52a1\u53f7\u8bf7\u6c42\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AsyncSelectQueryServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            return jSONObject;
        }
    }

    private JSONObject getRecordedResult(JSONObject param, String taxNo, String taskNo) {
        QFilter qFilter = new QFilter("task_no", "=", (Object)taskNo).and("tax_no", "=", (Object)taxNo);
        Object[] selectLogs = BusinessDataServiceHelper.load((String)"rim_select_log", (String)"batch_no,tax_period,org,tax_no,total_num,success_num,fail_num,handle_status,create_time,update_time,bill_type,handle_num,description,task_no,async_flag,result_json,result_json_tag,operate_type,select_type,statistics_status,select_opera_type", (QFilter[])qFilter.toArray(), (String)"create_time,id");
        if (ObjectUtils.isEmpty((Object[])selectLogs)) {
            return ResultContant.createJSONObject((String)ErrorType.TAX_NO_NULL.getCode(), (String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u8bf7\u6c42\u7a0e\u53f7\u6216\u4efb\u52a1\u53f7\u662f\u5426\u6b63\u786e", (String)"AsyncSelectQueryServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String operateType = selectLogs[0].getString("operate_type");
        this.checkOperateType(operateType);
        boolean isFinish = true;
        String description = null;
        ArrayList<DynamicObject> handling = new ArrayList<DynamicObject>(selectLogs.length);
        for (Object selectLog : selectLogs) {
            String handleStatus = selectLog.getString("handle_status");
            if ("1".equals(handleStatus) || "2".equals(handleStatus)) continue;
            isFinish = false;
            description = Optional.ofNullable(description).orElseGet(() -> RecordedQueryService.lambda$getRecordedResult$0((DynamicObject)selectLog));
            handling.add((DynamicObject)selectLog);
        }
        if (isFinish) {
            return this.getSuccessResult((DynamicObject[])selectLogs, param.getIntValue("pageNo"), param.getIntValue("pageSize"));
        }
        this.handleRecorded(handling, taxNo);
        return this.getHandlingResult(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getSuccessResult(DynamicObject[] selectLogs, int pageNo, int pageSize) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        JSONArray success = new JSONArray();
        JSONArray fail = new JSONArray();
        ArrayList<String> batchNos = new ArrayList<String>(8);
        int totalElement = 0;
        for (DynamicObject selectLog : selectLogs) {
            batchNos.add(selectLog.getString("batch_no"));
            totalElement += selectLog.getInt("total_num");
        }
        int totalPage = totalElement % pageSize == 0 ? totalElement / pageSize : totalElement / pageSize + 1;
        QFilter batchNoFilter = new QFilter("batch_no", "in", batchNos);
        ORM orm = ORM.create();
        try (DataSet ds = null;){
            int from = (pageNo - 1) * pageSize;
            ds = orm.queryDataSet("rim.common.AsyncSelectQueryServiceImpl", "rim_select_account", "", new QFilter[]{batchNoFilter}, "id", from, pageSize);
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"rim_select_account");
            if (collection != null) {
                this.convertSelectAccount(success, fail, collection);
            }
        }
        data.put("success", (Object)success);
        data.put("fail", (Object)fail);
        data.put("currentElement", (Object)(success.size() + fail.size()));
        data.put("totalElement", (Object)totalElement);
        data.put("totalPage", (Object)totalPage);
        return ResultContant.createSuccessJSONObject((Object)data);
    }

    private void convertSelectAccount(JSONArray success, JSONArray fail, DynamicObjectCollection selectAccounts) {
        if (!CollectionUtils.isEmpty((Collection)selectAccounts)) {
            for (DynamicObject selectAccount : selectAccounts) {
                JSONObject invoice = new JSONObject();
                invoice.put("serialNo", (Object)DynamicObjectUtil.fieldToString((Object)selectAccount.get("serial_no")));
                long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)selectAccount.get("invoice_type.id"));
                invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType((Object)invoiceType));
                invoice.put("invoiceCode", (Object)DynamicObjectUtil.fieldToString((Object)selectAccount.get("invoice_code")));
                invoice.put("invoiceNo", (Object)DynamicObjectUtil.fieldToString((Object)selectAccount.get("invoice_no")));
                if (StringUtils.isNotEmpty((CharSequence)selectAccount.getString("electronic_no"))) {
                    invoice.put("etaxInvoiceNo", (Object)DynamicObjectUtil.fieldToString((Object)selectAccount.get("electronic_no")));
                }
                invoice.put("invoiceDate", (Object)DateUtils.format((Date)selectAccount.getDate("invoice_date"), (String)"yyyyMMdd"));
                String entryMarkStatus = selectAccount.getString("deduction_purpose");
                String preEntryMarkStatus = selectAccount.getString("pre_authenticate_flag");
                String selectResult = DynamicObjectUtil.fieldToString((Object)selectAccount.get("select_result"));
                String description = DynamicObjectUtil.fieldToString((Object)selectAccount.get("description"));
                if (StringUtils.isEmpty((CharSequence)description)) {
                    description = MetadataUtil.getComboItemName((String)"rim_select_account", (String)"select_result", (String)selectResult);
                }
                if ("1".equals(selectResult)) {
                    invoice.put("preEntryMarkStatus", (Object)preEntryMarkStatus);
                    invoice.put("entryMarkStatus", (Object)entryMarkStatus);
                    success.add((Object)invoice);
                    continue;
                }
                invoice.put("description", (Object)description);
                invoice.put("entryMarkStatus", (Object)preEntryMarkStatus);
                fail.add((Object)invoice);
            }
        }
    }

    private void handleRecorded(List<DynamicObject> selectLogs, String taxNo) {
        String dkType = DeductionConstant.getDkType((String)taxNo);
        AsyncDeductSelectService selectService = DeductServiceFactory.newInstanceForAsyncQueryResultRecorded((String)dkType);
        if (selectService == null) {
            LOGGER.info("{}\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (Object)taxNo);
            return;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncSelectResultHandleRun", () -> selectLogs.forEach(arg_0 -> ((AsyncDeductSelectService)selectService).queryRecordedCommitResult(arg_0)));
    }

    public void checkOperateType(String operateType) {
        boolean checkType;
        boolean bl = checkType = "02".equals(operateType) || "03".equals(operateType) || "06".equals(operateType);
        if (!checkType) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53d1\u7968\u5165\u8d26\u76f8\u5173\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u8bf7\u6c42\u4efb\u52a1\u53f7\u6216\u63a5\u53e3\u7c7b\u578b\u662f\u5426\u6b63\u786e", (String)"RecordedQueryService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    protected JSONObject getHandlingResult(String description) {
        description = StringUtils.isNotEmpty((CharSequence)description) ? String.format("%s[%s]", ErrorType.STATUS_HANDLING.getName(), description) : ErrorType.STATUS_HANDLING.getName();
        return ResultContant.createJSONObject((String)ErrorType.STATUS_HANDLING.getCode(), (String)description);
    }

    private static /* synthetic */ String lambda$getRecordedResult$0(DynamicObject selectLog) {
        return selectLog.getString("description");
    }
}

