/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.message.vo.RequestVo;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.message.service.OpenApiService;

public class DownInvoiceServiceImpl
implements OpenApiService {
    public ApiResult doBusiness(RequestVo requestVo) {
        JSONObject param = JSON.parseObject((String)requestVo.getData());
        param.put("jksbz", (Object)"0");
        param.put("synctype", (Object)"04");
        this.checkDownParam(param);
        String taxNo = param.getString("taxNo");
        String authType = Optional.ofNullable(param.getString("dkType")).filter(StringUtils::isNotEmpty).orElseGet(() -> this.getAuthType(taxNo));
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)authType, (Long)RequestContext.get().getOrgId());
        JSONObject result = deductService.queryInvoices(param);
        return this.convertApiResult(result, requestVo);
    }

    public void checkDownParam(JSONObject param) {
        this.checkParam(param);
        String taxNo = param.getString("taxNo");
        if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
            throw new MsgException(ErrorType.SMALL_SCALE_TAXPAYER_DOWN.getCode(), ErrorType.SMALL_SCALE_TAXPAYER_DOWN.getName());
        }
        JSONObject searchOpt = param.getJSONObject("searchOpt");
        if (ObjectUtils.isEmpty((Object)searchOpt)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"DownInvoiceServiceImpl_15", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String startTimeStr = searchOpt.getString("startTime");
        String endTimeStr = searchOpt.getString("endTime");
        String taxPeriodStr = searchOpt.getString("taxPeriod");
        String invoiceType = searchOpt.getString("invoiceType");
        if (StringUtils.isNotEmpty((CharSequence)taxPeriodStr)) {
            Date taxperiod;
            if (!DateUtils.matchyyyyMM((String)taxPeriodStr)) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DownInvoiceServiceImpl_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxPeriodStr, "yyyyMM"));
            }
            try {
                taxperiod = DateUtils.stringToDate((String)taxPeriodStr, (String)"yyyyMM");
            }
            catch (Exception e) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), e.getMessage());
            }
            searchOpt.clear();
            searchOpt.put("taxPeriod", (Object)taxPeriodStr);
            param.put("jksbz", (Object)"1");
            param.put("synctype", (Object)"03");
            param.put("synccondition", (Object)DateUtils.format((Date)taxperiod, (String)"yyyy-MM"));
            return;
        }
        param.put("synctype", (Object)"04");
        if (StringUtils.isEmpty((CharSequence)startTimeStr)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"DownInvoiceServiceImpl_16", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)endTimeStr)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"DownInvoiceServiceImpl_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = searchOpt.getDate("startTime");
            endTime = searchOpt.getDate("endTime");
        }
        catch (Exception e) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5f00\u59cb\u65e5\u671f\u6216\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u975e\u65e5\u671f\u683c\u5f0f,\u8bf7\u68c0\u67e5", (String)"DownInvoiceServiceImpl_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (endTime.compareTo(startTime) < 0) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"DownInvoiceServiceImpl_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        searchOpt.put("startTime", (Object)DateUtils.format((Date)startTime));
        searchOpt.put("endTime", (Object)DateUtils.format((Date)endTime));
        param.put("synccondition", (Object)(DateUtils.format((Date)startTime) + ',' + DateUtils.format((Date)endTime)));
        if (StringUtils.isNotEmpty((CharSequence)invoiceType)) {
            Long typeLong = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType);
            if (!InputInvoiceTypeEnum.canDeduction((Long)typeLong).booleanValue()) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef,\u53d1\u7968\u7c7b\u578b\u975e\u53ef\u62b5\u6263\u53d1\u7968\u7c7b\u578b", (String)"DownInvoiceServiceImpl_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        } else {
            param.put("jksbz", (Object)"1");
        }
        if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType) && StringUtils.isNotEmpty((CharSequence)searchOpt.getString("invoiceNo"))) {
            searchOpt.put("customDeclarationNo", (Object)searchOpt.getString("invoiceNo"));
            param.put("jksbz", (Object)"1");
        }
    }
}

