/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.v2;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.UpdateInvoiceAndAttachTypeEnum;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.fpzs.FpzsCommonService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.formplugin.message.service.v2.BillCreateService;
import org.apache.commons.lang.StringUtils;

public class BillUpdateService
extends BillCreateService {
    private static Log LOGGER = LogFactory.getLog(BillUpdateService.class);

    @Override
    public ApiResult doBusiness(Object reqObject) {
        String json = SerializationUtils.toJsonString((Object)reqObject);
        LOGGER.info("\u66f4\u65b0\u62a5\u9500\u5355\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        this.checkParam(jsonObj);
        jsonObj.put("rim_operate_method", (Object)"billUpdate");
        ExpenseDTO dto = FpzsCommonService.getApiExpenseDTO((Map)jsonObj);
        ExpenseService service = new ExpenseService();
        service.billUpdate(dto);
        ApiResult results = this.pushImage(jsonObj, dto);
        if (results != null) {
            return results;
        }
        return this.successResult();
    }

    @Override
    protected void checkParam(JSONObject param) {
        String invoiceUpdateType = param.getString("invoiceUpdateType");
        if (StringUtils.isBlank((String)invoiceUpdateType)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u66f4\u65b0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillUpdateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (!UpdateInvoiceAndAttachTypeEnum.isUpdateInvoiceType((String)invoiceUpdateType)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u66f4\u65b0\u7c7b\u578b\u53c2\u6570\u9519\u8bef\u3002", (String)"BillUpdateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String attachmentUpdateType = param.getString("attachmentUpdateType");
        if (StringUtils.isBlank((String)attachmentUpdateType)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u9644\u4ef6\u66f4\u65b0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillUpdateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (!UpdateInvoiceAndAttachTypeEnum.isUpdateAttachType((String)attachmentUpdateType)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u9644\u4ef6\u66f4\u65b0\u7c7b\u578b\u53c2\u6570\u9519\u8bef\u3002", (String)"BillUpdateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }
}

