/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.v2;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.RimUserService;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;
import org.apache.commons.lang3.tuple.Pair;

public class PersonalInvoiceDeleteService
extends AbstractMessageServie {
    private static Log LOGGER = LogFactory.getLog(PersonalInvoiceDeleteService.class);

    @Override
    public ApiResult doBusiness(Object reqObject) {
        JSONArray serialNos;
        String json = SerializationUtils.toJsonString((Object)reqObject);
        LOGGER.info("\u5220\u9664\u7528\u6237\u53d1\u7968\u5173\u7cfb\u63a5\u53e3-\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff1a", (Object)json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        jsonObj.put("rim_operate_method", (Object)"personalInvoiceDelete");
        String userIdParam = jsonObj.getString("userId");
        String resource = jsonObj.getString("resource");
        try {
            serialNos = jsonObj.getJSONArray("serialNos");
            if (StringUtils.isEmpty((CharSequence)userIdParam) || serialNos == null || serialNos.isEmpty() || StringUtils.isEmpty((CharSequence)resource)) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef", (String)"RecognitionCheckRemoteService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef", (String)"RecognitionCheckRemoteService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String userType = jsonObj.getString("userType");
        Pair userInfo = FpzsMainService.getUser((String)jsonObj.getString("userId"), (String)userType);
        String userId = null;
        Long rimUser = 0L;
        if (StringUtils.isNotEmpty((CharSequence)userType)) {
            if (userInfo == null) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u4e0d\u5b58\u5728\u3002", (String)"BillCreateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), userIdParam));
            }
            userId = (String)userInfo.getLeft();
        } else {
            String openId = MD5.md5Hex((String)(RequestContext.get().getTenantId() + resource + userIdParam));
            if (!StringUtils.isEmpty((CharSequence)userIdParam)) {
                rimUser = RimUserService.createRimUser((String)userIdParam, (String)resource, (String)"third", (String)openId, (String)"");
            }
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"rim_invoice", (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", (Object)serialNos)});
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e0d\u5b58\u5728", (String)"InvoiceListMobilePlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        Object[] idArray = dynamicObjects.stream().map(s -> s.get("id")).toArray();
        DynamicObject[] mainObjs = BusinessDataServiceHelper.load((Object[])idArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
        ArrayList exists = Lists.newArrayListWithExpectedSize((int)mainObjs.length);
        for (DynamicObject main : mainObjs) {
            exists.add(main.getString("serial_no"));
            DynamicObjectCollection users = main.getDynamicObjectCollection("collect_user_entry");
            if (users.size() == 0) continue;
            for (DynamicObject user : users) {
                DynamicObject collect_user = user.getDynamicObject("collect_user");
                if (userId != null && collect_user != null && userId.equals(collect_user.getPkValue() + "")) {
                    DeleteServiceHelper.delete((IDataEntityType)user.getDynamicObjectType(), (Object[])new Object[]{user.getPkValue()});
                    continue;
                }
                Long rimUserDb = user.getLong("rim_user");
                if (rimUser <= 0L || !rimUserDb.equals(rimUser)) continue;
                DeleteServiceHelper.delete((IDataEntityType)user.getDynamicObjectType(), (Object[])new Object[]{user.getPkValue()});
            }
        }
        SaveServiceHelper.save((DynamicObject[])mainObjs);
        serialNos.removeAll((Collection)exists);
        ApiResult result = this.successResult();
        if (!serialNos.isEmpty()) {
            result.setData((Object)String.format(ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728", (String)"RelayInvoiceOpenService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), serialNos.toString()));
        }
        return result;
    }
}

