/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.collect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCollectFilterMbPlugin
extends AbstractMobFormPlugin {
    private static final String CACHE_CHECK_SORT_KEY_LIST = "check_sort";
    private static final String CACHE_CHECK_DATE_KEY_LIST = "check_date";
    private static final String CACHE_CHECK_STATUS_KEY_LIST = "check_status";
    private static final String CACHE_CHECK_TYPE_KEY_LIST = "check_type";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"item_cancel", "item_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.cacheAllKeyList();
        this.setFindValue(CACHE_CHECK_SORT_KEY_LIST, (String)this.getView().getFormShowParameter().getCustomParam("sort"));
        this.setFindValue(CACHE_CHECK_STATUS_KEY_LIST, (String)this.getView().getFormShowParameter().getCustomParam("status"));
        String date = (String)this.getView().getFormShowParameter().getCustomParam("date");
        if (StringUtils.equals((CharSequence)date, (CharSequence)"7")) {
            String enddate;
            String startdate = (String)this.getView().getFormShowParameter().getCustomParam("startdate");
            if (StringUtils.isNotBlank((CharSequence)startdate)) {
                this.getModel().setValue("startdate", (Object)new Date(Long.parseLong(startdate)));
            }
            if (StringUtils.isNotBlank((CharSequence)(enddate = (String)this.getView().getFormShowParameter().getCustomParam("enddate")))) {
                this.getModel().setValue("enddate", (Object)new Date(Long.parseLong(enddate)));
            }
        } else {
            this.setFindValue(CACHE_CHECK_DATE_KEY_LIST, date);
        }
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        List typeList = Arrays.stream(type.split(",")).filter(v -> StringUtils.isNotBlank((CharSequence)v) && !StringUtils.equals((CharSequence)"0", (CharSequence)v)).collect(Collectors.toList());
        int count = 0;
        for (String typeKey : typeList) {
            InputInvoiceTypeEnum invoiceType = InputInvoiceTypeEnum.getInvoiceType((String)typeKey);
            if (invoiceType == null) continue;
            ++count;
            this.setFindValue(CACHE_CHECK_TYPE_KEY_LIST, invoiceType.getAwsType());
        }
        if (count >= 1) {
            Optional<String> find = this.getCheckKeyList(CACHE_CHECK_TYPE_KEY_LIST).stream().filter(v -> v.endsWith("_0")).findFirst();
            if (find.isPresent()) {
                this.getModel().setValue(find.get(), (Object)false);
            }
        } else {
            this.setFindValue(CACHE_CHECK_TYPE_KEY_LIST, "0");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"startdate", (CharSequence)key)) {
            Date startDate = (Date)e.getChangeSet()[0].getNewValue();
            Date endDate = (Date)this.getModel().getValue("enddate");
            if (startDate != null && endDate != null && endDate.before(startDate)) {
                this.getModel().setValue("endDate", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4\uff0c\u5df2\u6e05\u9664\u7ed3\u675f\u65f6\u95f4\u3002", (String)"InvoiceCollectFilterMbPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
            if (startDate != null) {
                this.setFalse(CACHE_CHECK_DATE_KEY_LIST, "");
            }
        } else if (StringUtils.equals((CharSequence)"enddate", (CharSequence)key)) {
            Date endDate = (Date)e.getChangeSet()[0].getNewValue();
            Date startDate = (Date)this.getModel().getValue("startdate");
            if (startDate != null && endDate != null && endDate.before(startDate)) {
                this.getModel().setValue("startdate", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4\uff0c\u5df2\u6e05\u9664\u5f00\u59cb\u65f6\u95f4\u3002", (String)"InvoiceCollectFilterMbPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
            if (startDate != null) {
                this.setFalse(CACHE_CHECK_DATE_KEY_LIST, "");
            }
        } else if (StringUtils.equals((CharSequence)"check_sort_createtime", (CharSequence)key)) {
            boolean checkSortCreatetime = (Boolean)e.getChangeSet()[0].getNewValue();
            if (checkSortCreatetime) {
                this.getModel().setValue("check_sort_invoice_date", (Object)false);
            } else {
                this.getModel().setValue("check_sort_createtime", (Object)true);
            }
        } else if (StringUtils.equals((CharSequence)"check_sort_invoice_date", (CharSequence)key)) {
            boolean checkSortInvoiceDate = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getModel().beginInit();
            if (checkSortInvoiceDate) {
                this.getModel().setValue("check_sort_createtime", (Object)false);
            } else {
                this.getModel().setValue("check_sort_createtime", (Object)true);
            }
            this.getModel().endInit();
            this.getView().updateView("check_sort_createtime");
        } else if (StringUtils.contains((CharSequence)key, (CharSequence)CACHE_CHECK_STATUS_KEY_LIST)) {
            List<String> falseKeyList = this.getCheckKeyList(CACHE_CHECK_STATUS_KEY_LIST);
            this.getModel().beginInit();
            if (!((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
                String keyAll = falseKeyList.stream().filter(v -> v.endsWith("_0")).findFirst().get();
                falseKeyList.remove(keyAll);
                this.getModel().setValue(keyAll, (Object)true);
            }
            this.getModel().endInit();
            this.setFalse(CACHE_CHECK_STATUS_KEY_LIST, key);
        } else if (StringUtils.contains((CharSequence)key, (CharSequence)CACHE_CHECK_DATE_KEY_LIST)) {
            this.getModel().setValue("endDate", null);
            this.getModel().setValue("startdate", null);
            this.setFalse(CACHE_CHECK_DATE_KEY_LIST, key);
        } else if (StringUtils.contains((CharSequence)key, (CharSequence)CACHE_CHECK_TYPE_KEY_LIST)) {
            boolean newCheckValue = (Boolean)e.getChangeSet()[0].getNewValue();
            boolean isAll = key.endsWith("_0");
            if (newCheckValue) {
                if (isAll) {
                    this.setFalse(CACHE_CHECK_TYPE_KEY_LIST, key);
                } else {
                    Optional<String> find = this.getCheckKeyList(CACHE_CHECK_TYPE_KEY_LIST).stream().filter(v -> v.endsWith("_0")).findFirst();
                    if (find.isPresent()) {
                        this.getModel().setValue(find.get(), (Object)false);
                    }
                }
            }
        }
    }

    private void setFalse(String keyType, String clickKey) {
        List<String> keyList = this.getCheckKeyList(keyType);
        keyList.remove(clickKey);
        this.getModel().beginInit();
        for (String key : keyList) {
            this.getModel().setValue(key, (Object)false);
        }
        this.getModel().endInit();
        for (String key : keyList) {
            this.getView().updateView(key);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"item_cancel")) {
            JSONObject returnData = new JSONObject();
            returnData.put("all_not", (Object)"1");
            this.getView().returnDataToParent((Object)returnData.toJSONString());
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"item_ok")) {
            JSONObject returnData = new JSONObject();
            List<String> typeKeyList = this.getCheckKeyList(CACHE_CHECK_TYPE_KEY_LIST);
            if (((Boolean)this.getModel().getValue("check_sort_invoice_date")).booleanValue()) {
                returnData.put("sort", (Object)"invoice_date");
            } else {
                returnData.put("sort", (Object)"createtime");
            }
            this.getFindValue(returnData, CACHE_CHECK_STATUS_KEY_LIST, "status");
            this.getFindValue(returnData, CACHE_CHECK_DATE_KEY_LIST, "date");
            returnData.put("type", (Object)this.getCheckKeyList(CACHE_CHECK_TYPE_KEY_LIST).stream().filter(v -> (Boolean)this.getModel().getValue(v)).map(v -> InputInvoiceTypeEnum.getInvoiceType((String)v.substring(v.lastIndexOf("_") + 1))).filter(v -> v != null).map(v -> v.getCode().toString()).collect(Collectors.joining(",")));
            if (returnData.get((Object)"date") == null) {
                Date enddate;
                returnData.put("date", (Object)"7");
                Date startdate = (Date)this.getModel().getValue("startdate");
                if (startdate != null) {
                    returnData.put("startdate", (Object)(startdate.getTime() + ""));
                }
                if ((enddate = (Date)this.getModel().getValue("enddate")) != null) {
                    returnData.put("enddate", (Object)(enddate.getTime() + ""));
                }
            }
            this.getView().returnDataToParent((Object)returnData.toJSONString());
            this.getView().close();
        }
    }

    private void cacheAllKeyList() {
        DataEntityPropertyCollection properties = this.getModel().getDataEntity(true).getDynamicObjectType().getProperties();
        ArrayList sortKeyList = Lists.newArrayList();
        ArrayList statusKeyList = Lists.newArrayList();
        ArrayList typeKeyList = Lists.newArrayList();
        ArrayList dateKeyList = Lists.newArrayList();
        for (IDataEntityProperty prop : properties) {
            String propKey = prop.getName();
            if (propKey.contains("check_sort_")) {
                sortKeyList.add(propKey);
                continue;
            }
            if (propKey.contains("check_status_")) {
                statusKeyList.add(propKey);
                continue;
            }
            if (propKey.contains("check_date_")) {
                dateKeyList.add(propKey);
                continue;
            }
            if (!propKey.contains("check_type_")) continue;
            typeKeyList.add(propKey);
        }
        this.getPageCache().put(CACHE_CHECK_SORT_KEY_LIST, JSONObject.toJSONString((Object)sortKeyList));
        this.getPageCache().put(CACHE_CHECK_STATUS_KEY_LIST, JSONObject.toJSONString((Object)statusKeyList));
        this.getPageCache().put(CACHE_CHECK_TYPE_KEY_LIST, JSONObject.toJSONString((Object)typeKeyList));
        this.getPageCache().put(CACHE_CHECK_DATE_KEY_LIST, JSONObject.toJSONString((Object)dateKeyList));
    }

    private List<String> getCheckKeyList(String keyType) {
        String keyListCaceh = this.getPageCache().get(keyType);
        if (StringUtils.isNotBlank((CharSequence)keyListCaceh)) {
            return JSONArray.parseArray((String)keyListCaceh).toJavaList(String.class);
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    private void setFindValue(String qfTypeKey, String key) {
        Optional<String> find = this.getCheckKeyList(qfTypeKey).stream().filter(v -> v.endsWith("_" + key)).findFirst();
        if (find.isPresent()) {
            this.getModel().setValue(find.get(), (Object)true);
        }
    }

    private void getFindValue(JSONObject returnData, String qfTypeKey, String paramKey) {
        Optional<String> find = this.getCheckKeyList(qfTypeKey).stream().filter(v -> (Boolean)this.getModel().getValue(v)).findFirst();
        if (find.isPresent()) {
            int index = find.get().lastIndexOf("_");
            returnData.put(paramKey, (Object)find.get().substring(index + 1));
        }
    }
}

